set feedback off
set define off

-------------------------------------------
-- TABLE STRUCTURE - NO CHANGES
-------------------------------------------

-------------------------------------------
-- SEQUENCES - NO CHANGES
-------------------------------------------

-------------------------------------------
-- FUNCTIONS - NO CHANGES
-------------------------------------------

-------------------------------------------
--TABLE DATA
-------------------------------------------


------------------------------------------------
--MID 4082
------------------------------------------------
insert into TBICDS.INTAKE_MODULE 
(mid, module, active, description, sort_order, 
render_graph, module_alt_lang, description_alt_lang, acronym, module_for, 
identifier, module_type, editable, 
clientside_code, score_logic)
values (4082, 'Interdisciplinary Note', 1, null, 0, 
0, null, null, '(IDN)', 3, 
'IDN', 0, 0, 
null, null);
commit;





------------------------------------------------
--MID 4076
------------------------------------------------
insert into TBICDS.INTAKE_MODULE (mid, module, active, description, sort_order, render_graph, 
module_alt_lang, description_alt_lang, acronym, module_for, identifier, module_type, 
editable, clientside_code, score_logic)
values (4076, 'Agitated Behavior Scale', 1, null, 0, 0, 
null, null, '(ABS)', 3, 'ABS', 0, 
0, null, null);
commit;

update TBICDS.intake_module
set score_logic = 'VAR vQ1 = RScore(r1);' || chr(10) || 'VAR vQ2 = RScore(r2);' || chr(10) || 'VAR vQ3 = RScore(r3);' || chr(10) 
|| 'VAR vQ4 = RScore(r4);' || chr(10) || 'VAR vQ5 = RScore(r5);' || chr(10) || 'VAR vQ6 = RScore(r6);' || chr(10) || 'VAR vQ7 = RScore(r7);' || chr(10) 
|| 'VAR vQ8 = RScore(r8);' || chr(10) || 'VAR vQ9 = RScore(r9);' || chr(10) || 'VAR vQ10 = RScore(r10);' || chr(10) || 'VAR vQ11 = RScore(r11);' || chr(10) 
where mid=4076;
commit;

update TBICDS.intake_module
set score_logic = score_logic || 'VAR vQ12 = RScore(r12);' || chr(10) || 'VAR vQ13 = RScore(r13);' || chr(10) || 'VAR vQ14 = RScore(r14);' || chr(10) || '' || chr(10) 
|| 'VAR vTotalScore = vQ1 + vQ2 + vQ3 + vQ4 + vQ5 + vQ6 + vQ7 + vQ8 + vQ9 + vQ10 + vQ11 + vQ12 + vQ13 + vQ14;' || chr(10) || '' || chr(10) 
|| 'if (vTotalScore < 22) then JScore(0,vTotalScore,Within Normal Limits,Total Score);' || chr(10) 
where mid=4076;
commit;

update TBICDS.intake_module
set score_logic = score_logic || 'if (vTotalScore > 21 and vTotalScore < 29) then JScore(0,vTotalScore,Mild Occurrence,Total Score);' || chr(10) 
|| 'if (vTotalScore > 28 and vTotalScore < 36) then JScore(0,vTotalScore,Moderate Occurrence,Total Score);' || chr(10) 
|| 'if (vTotalScore > 35) then JScore(0,vTotalScore,Severe Occurrence,Total Score' || ');'
where mid=4076;
commit;



------------------------------------------------
--MID 4078
------------------------------------------------
insert into TBICDS.INTAKE_MODULE (mid, module, active, description, sort_order, render_graph, module_alt_lang, description_alt_lang, acronym, module_for, identifier, module_type, editable, clientside_code, score_logic)
values (4078, 'OPTIMAL Instrument - Baseline', 1, 
'Measures difficulty and self-confidence in performing 22 movements that a patient/client needs to accomplish in order to do various functional activities.', 
0, 1, null, null, '(OPT BL)', 3, 'OPT BL', 0, 0, null, null);
commit;

update TBICDS.intake_module
set score_logic = '' || chr(10) || '' || chr(10) || 'VAR vDcount = 0;' || chr(10) || 'VAR vCcount = 0;' || chr(10) || '' || chr(10) || 'VAR vD1 = RScore(r10);' 
|| chr(10) || 'if (vD1 > 0) then Set(vDcount = vDcount + 1);' || chr(10) || 'VAR vD2 = RScore(r20);' || chr(10) || 'if (vD2 > 0) then Set(vDcount = vDcount + 1);' 
|| chr(10) || 'VAR vD3 = RScore(r30);' || chr(10) || 'if (vD3 > 0) then Set(vDcount = vDcount + 1);' || chr(10) || 'VAR vD4 = RScore(r40);' || chr(10) || 'if (vD4 > 0) then Set(vDcount = vDcount + 1);' 
where mid=4078;
commit;

update TBICDS.intake_module
set score_logic = score_logic || chr(10) || 'VAR vD5 = RScore(r50);' || chr(10) || 'if (vD5 > 0) then Set(vDcount = vDcount + 1);' || chr(10) || 'VAR vD6 = RScore(r60);' || chr(10) || 'if (vD6 > 0) then Set(vDcount = vDcount + 1);' 
|| chr(10) || 'VAR vD7 = RScore(r70);' || chr(10) || 'if (vD7 > 0) then Set(vDcount = vDcount + 1);' || chr(10) || 'VAR vD8 = RScore(r80);' || chr(10) || 'if (vD8 > 0) then Set(vDcount = vDcount + 1);' 
|| chr(10) || 'VAR vD9 = RScore(r90);' || chr(10) || 'if (vD9 > 0) then Set(vDcount = vDcount + 1);' || chr(10) || 'VAR vD10 = RScore(r100);' || chr(10) || 'if (vD10 > 0) then Set(vDcount = vDcount + 1);' 
where mid=4078;
commit;

update TBICDS.intake_module
set score_logic = score_logic || chr(10) || 'VAR vD11 = RScore(r110);' || chr(10) || 'if (vD11 > 0) then Set(vDcount = vDcount + 1);' || chr(10) || 'VAR vD12 = RScore(r120);' || chr(10) || 'if (vD12 > 0) then Set(vDcount = vDcount + 1);' 
|| chr(10) || 'VAR vD13 = RScore(r130);' || chr(10) || 'if (vD13 > 0) then Set(vDcount = vDcount + 1);' || chr(10) || 'VAR vD14 = RScore(r140);' || chr(10) || 'if (vD14 > 0) then Set(vDcount = vDcount + 1);' 
|| chr(10) || 'VAR vD15 = RScore(r150);' || chr(10) || 'if (vD15 > 0) then Set(vDcount = vDcount + 1);' || chr(10) || 'VAR vD16 = RScore(r160);' || chr(10) || 'if (vD16 > 0) then Set(vDcount = vDcount + 1);' 
where mid=4078;
commit;

update TBICDS.intake_module
set score_logic = score_logic || chr(10) || 'VAR vD17 = RScore(r170);' || chr(10) || 'if (vD17 > 0) then Set(vDcount = vDcount + 1);' || chr(10) || 'VAR vD18 = RScore(r180);' || chr(10) || 'if (vD18 > 0) then Set(vDcount = vDcount + 1);' 
|| chr(10) || 'VAR vD19 = RScore(r190);' || chr(10) || 'if (vD19 > 0) then Set(vDcount = vDcount + 1);' || chr(10) || 'VAR vD20 = RScore(r200);' || chr(10) || 'if (vD20 > 0) then Set(vDcount = vDcount + 1);' 
|| chr(10) || 'VAR vD21 = RScore(r210);' || chr(10) || 'if (vD21 > 0) then Set(vDcount = vDcount + 1);' || chr(10) || 'VAR vD22 = RScore(r220);' || chr(10) || 'if (vD22 > 0) then Set(vDcount = vDcount + 1);' 
where mid=4078;
commit;

update TBICDS.intake_module
set score_logic = score_logic || chr(10) || '' || chr(10) || 'VAR vC1 = RScore(r480);' || chr(10) || 'if (vC1 > 0) then Set(vCcount = vCcount + 1);' || chr(10) || 'VAR vC2 = RScore(r490);' || chr(10) || 'if (vC2 > 0) then Set(vCcount = vCcount + 1);' 
|| chr(10) || 'VAR vC3 = RScore(r500);' || chr(10) || 'if (vC3 > 0) then Set(vCcount = vCcount + 1);' || chr(10) || 'VAR vC4 = RScore(r510);' || chr(10) || 'if (vC4 > 0) then Set(vCcount = vCcount + 1);' 
|| chr(10) || 'VAR vC5 = RScore(r520);' || chr(10) || 'if (vC5 > 0) then Set(vCcount = vCcount + 1);' || chr(10) || 'VAR vC6 = RScore(r530);' || chr(10) || 'if (vC6 > 0) then Set(vCcount = vCcount + 1);' 
where mid=4078;
commit;

update TBICDS.intake_module
set score_logic = score_logic || chr(10) || 'VAR vC7 = RScore(r540);' || chr(10) || 'if (vC7 > 0) then Set(vCcount = vCcount + 1);' || chr(10) || 'VAR vC8 = RScore(r550);' || chr(10) || 'if (vC8 > 0) then Set(vCcount = vCcount + 1);' 
|| chr(10) || 'VAR vC9 = RScore(r560);' || chr(10) || 'if (vC9 > 0) then Set(vCcount = vCcount + 1);' || chr(10) || 'VAR vC10 = RScore(r570);' || chr(10) || 'if (vC10 > 0) then Set(vCcount = vCcount + 1);' 
|| chr(10) || 'VAR vC11 = RScore(r580);' || chr(10) || 'if (vC11 > 0) then Set(vCcount = vCcount + 1);' || chr(10) || 'VAR vC12 = RScore(r590);' || chr(10) || 'if (vC12 > 0) then Set(vCcount = vCcount + 1);' 
where mid=4078;
commit;

update TBICDS.intake_module
set score_logic = score_logic || chr(10) || 'VAR vC13 = RScore(r600);' || chr(10) || 'if (vC13 > 0) then Set(vCcount = vCcount + 1);' || chr(10) || 'VAR vC14 = RScore(r610);' || chr(10) || 'if (vC14 > 0) then Set(vCcount = vCcount + 1);' 
|| chr(10) || 'VAR vC15 = RScore(r620);' || chr(10) || 'if (vC15 > 0) then Set(vCcount = vCcount + 1);' || chr(10) || 'VAR vC16 = RScore(r630);' || chr(10) || 'if (vC16 > 0) then Set(vCcount = vCcount + 1);' 
|| chr(10) || 'VAR vC17 = RScore(r640);' || chr(10) || 'if (vC17 > 0) then Set(vCcount = vCcount + 1);' || chr(10) || 'VAR vC18 = RScore(r650);' || chr(10) || 'if (vC18 > 0) then Set(vCcount = vCcount + 1);' 
where mid=4078;
commit;

update TBICDS.intake_module
set score_logic = score_logic || chr(10) || 'VAR vC19 = RScore(r660);' || chr(10) || 'if (vC19 > 0) then Set(vCcount = vCcount + 1);' || chr(10) || 'VAR vC20 = RScore(r670);' || chr(10) || 'if (vC20 > 0) then Set(vCcount = vCcount + 1);' 
|| chr(10) || 'VAR vC21 = RScore(r680);' || chr(10) || 'if (vC21 > 0) then Set(vCcount = vCcount + 1);' || chr(10) || 'VAR vC22 = RScore(r690);' || chr(10) || 'if (vC22 > 0) then Set(vCcount = vCcount + 1);' 
|| chr(10) || '' || chr(10) || '' || chr(10) || 'VAR vTotalPossible = 110;' || chr(10) || '' || chr(10) || 'VAR vDifficulty = vD1 + vD2 + vD3 + vD4 + vD5 + vD6 + vD7 + vD8 + vD9 + vD10 + vD11 + vD12 + vD13 + vD14 + vD15 + vD16 + vD17 + vD18 + vD19 + vD20 + vD21 + vD22;' 
where mid=4078;
commit;

update TBICDS.intake_module
set score_logic = score_logic || chr(10) || '' || chr(10) || 'VAR vConfidence = vC1 + vC2 + vC3 + vC4 + vC5 + vC6 + vC7 + vC8 + vC9 + vC10 + vC11 + vC12 + vC13 + vC14 + vC15 + vC16 + vC17 + vC18 + vC19 + vC20 + vC21 + vC22;' 
|| chr(10) || '' || chr(10) || 'VAR vTotal = vDifficulty + vConfidence;' || chr(10) || 'VAR vDifficultyLimitation = 100 * ((vDifficulty - vDcount)/((5*vDcount) - vDcount));' 
|| chr(10) || 'VAR vConfidenceLimitation = 100 * ((vConfidence - vCcount)/((5*vCcount) - vCcount));' || chr(10) || '' || chr(10) || 'JScore(0,vTotal,,Total Score);' || chr(10) || 'JScore(1,vDifficulty,,Difficulty Score);' 
where mid=4078;
commit;

update TBICDS.intake_module
set score_logic = score_logic || chr(10) || 'JScore(2,vDifficultyLimitation,,Difficulty Limitation (%));' || chr(10) || 'JScore(3,vConfidence,,Confidence Score);' || chr(10) || 'JScore(4,vConfidenceLimitation,,Confidence Limitation (%)' || ');'
where mid=4078;
commit;



------------------------------------------------
--MID 4080
------------------------------------------------
insert into TBICDS.INTAKE_MODULE (mid, module, active, description, sort_order, render_graph, module_alt_lang, description_alt_lang, acronym, module_for, identifier, module_type, editable, clientside_code, score_logic)
values (4080, 'OPTIMAL Instrument - Follow-Up', 1, 
'Measures difficulty and self-confidence in performing 22 movements that a patient/client needs to accomplish in order to do various functional activities.', 
0, 1, null, null, '(OPT FU)', 3, 'OPT FU', 0, 0, null, null);
commit;

update TBICDS.intake_module
set score_logic = '' || chr(10) || '' || chr(10) || 'VAR vDcount = 0;' || chr(10) || 'VAR vCcount = 0;' || chr(10) || '' || chr(10) || 'VAR vD1 = RScore(r260);' 
|| chr(10) || 'if (vD1 > 0) then Set(vDcount = vDcount + 1);' || chr(10) || 'VAR vD2 = RScore(r270);' || chr(10) || 'if (vD2 > 0) then Set(vDcount = vDcount + 1);' 
|| chr(10) || 'VAR vD3 = RScore(r280);' || chr(10) || 'if (vD3 > 0) then Set(vDcount = vDcount + 1);' || chr(10) || 'VAR vD4 = RScore(r290);' || chr(10) || 'if (vD4 > 0) then Set(vDcount = vDcount + 1);' 
where mid=4080;
commit;

update TBICDS.intake_module
set score_logic = score_logic || chr(10) || 'VAR vD5 = RScore(r300);' || chr(10) || 'if (vD5 > 0) then Set(vDcount = vDcount + 1);' || chr(10) || 'VAR vD6 = RScore(r310);' || chr(10) || 'if (vD6 > 0) then Set(vDcount = vDcount + 1);' 
|| chr(10) || 'VAR vD7 = RScore(r320);' || chr(10) || 'if (vD7 > 0) then Set(vDcount = vDcount + 1);' || chr(10) || 'VAR vD8 = RScore(r330);' || chr(10) || 'if (vD8 > 0) then Set(vDcount = vDcount + 1);' 
|| chr(10) || 'VAR vD9 = RScore(r340);' || chr(10) || 'if (vD9 > 0) then Set(vDcount = vDcount + 1);' || chr(10) || 'VAR vD10 = RScore(r350);' || chr(10) || 'if (vD10 > 0) then Set(vDcount = vDcount + 1);' 
where mid=4080;
commit;

update TBICDS.intake_module
set score_logic = score_logic || chr(10) || 'VAR vD11 = RScore(r360);' || chr(10) || 'if (vD11 > 0) then Set(vDcount = vDcount + 1);' || chr(10) || 'VAR vD12 = RScore(r370);' || chr(10) || 'if (vD12 > 0) then Set(vDcount = vDcount + 1);' 
|| chr(10) || 'VAR vD13 = RScore(r380);' || chr(10) || 'if (vD13 > 0) then Set(vDcount = vDcount + 1);' || chr(10) || 'VAR vD14 = RScore(r390);' || chr(10) || 'if (vD14 > 0) then Set(vDcount = vDcount + 1);' 
|| chr(10) || 'VAR vD15 = RScore(r400);' || chr(10) || 'if (vD15 > 0) then Set(vDcount = vDcount + 1);' || chr(10) || 'VAR vD16 = RScore(r410);' || chr(10) || 'if (vD16 > 0) then Set(vDcount = vDcount + 1);' 
where mid=4080;
commit;

update TBICDS.intake_module
set score_logic = score_logic || chr(10) || 'VAR vD17 = RScore(r420);' || chr(10) || 'if (vD17 > 0) then Set(vDcount = vDcount + 1);' || chr(10) || 'VAR vD18 = RScore(r430);' || chr(10) || 'if (vD18 > 0) then Set(vDcount = vDcount + 1);' 
|| chr(10) || 'VAR vD19 = RScore(r440);' || chr(10) || 'if (vD19 > 0) then Set(vDcount = vDcount + 1);' || chr(10) || 'VAR vD20 = RScore(r450);' || chr(10) || 'if (vD20 > 0) then Set(vDcount = vDcount + 1);' 
|| chr(10) || 'VAR vD21 = RScore(r460);' || chr(10) || 'if (vD21 > 0) then Set(vDcount = vDcount + 1);' || chr(10) || 'VAR vD22 = RScore(r470);' || chr(10) || 'if (vD22 > 0) then Set(vDcount = vDcount + 1);' 
where mid=4080;
commit;

update TBICDS.intake_module
set score_logic = score_logic || chr(10) || '' || chr(10) || 'VAR vC1 = RScore(r480);' || chr(10) || 'if (vC1 > 0) then Set(vCcount = vCcount + 1);' || chr(10) || 'VAR vC2 = RScore(r490);' || chr(10) || 'if (vC2 > 0) then Set(vCcount = vCcount + 1);' 
|| chr(10) || 'VAR vC3 = RScore(r500);' || chr(10) || 'if (vC3 > 0) then Set(vCcount = vCcount + 1);' || chr(10) || 'VAR vC4 = RScore(r510);' || chr(10) || 'if (vC4 > 0) then Set(vCcount = vCcount + 1);' 
|| chr(10) || 'VAR vC5 = RScore(r520);' || chr(10) || 'if (vC5 > 0) then Set(vCcount = vCcount + 1);' || chr(10) || 'VAR vC6 = RScore(r530);' || chr(10) || 'if (vC6 > 0) then Set(vCcount = vCcount + 1);' 
where mid=4080;
commit;

update TBICDS.intake_module
set score_logic = score_logic || chr(10) || 'VAR vC7 = RScore(r540);' || chr(10) || 'if (vC7 > 0) then Set(vCcount = vCcount + 1);' || chr(10) || 'VAR vC8 = RScore(r550);' || chr(10) || 'if (vC8 > 0) then Set(vCcount = vCcount + 1);' 
|| chr(10) || 'VAR vC9 = RScore(r560);' || chr(10) || 'if (vC9 > 0) then Set(vCcount = vCcount + 1);' || chr(10) || 'VAR vC10 = RScore(r570);' || chr(10) || 'if (vC10 > 0) then Set(vCcount = vCcount + 1);' 
|| chr(10) || 'VAR vC11 = RScore(r580);' || chr(10) || 'if (vC11 > 0) then Set(vCcount = vCcount + 1);' || chr(10) || 'VAR vC12 = RScore(r590);' || chr(10) || 'if (vC12 > 0) then Set(vCcount = vCcount + 1);' 
where mid=4080;
commit;

update TBICDS.intake_module
set score_logic = score_logic || chr(10) || 'VAR vC13 = RScore(r600);' || chr(10) || 'if (vC13 > 0) then Set(vCcount = vCcount + 1);' || chr(10) || 'VAR vC14 = RScore(r610);' || chr(10) || 'if (vC14 > 0) then Set(vCcount = vCcount + 1);' 
|| chr(10) || 'VAR vC15 = RScore(r620);' || chr(10) || 'if (vC15 > 0) then Set(vCcount = vCcount + 1);' || chr(10) || 'VAR vC16 = RScore(r630);' || chr(10) || 'if (vC16 > 0) then Set(vCcount = vCcount + 1);' 
|| chr(10) || 'VAR vC17 = RScore(r640);' || chr(10) || 'if (vC17 > 0) then Set(vCcount = vCcount + 1);' || chr(10) || 'VAR vC18 = RScore(r650);' || chr(10) || 'if (vC18 > 0) then Set(vCcount = vCcount + 1);' 
where mid=4080;
commit;

update TBICDS.intake_module
set score_logic = score_logic || chr(10) || 'VAR vC19 = RScore(r660);' || chr(10) || 'if (vC19 > 0) then Set(vCcount = vCcount + 1);' || chr(10) || 'VAR vC20 = RScore(r670);' || chr(10) || 'if (vC20 > 0) then Set(vCcount = vCcount + 1);' 
|| chr(10) || 'VAR vC21 = RScore(r680);' || chr(10) || 'if (vC21 > 0) then Set(vCcount = vCcount + 1);' || chr(10) || 'VAR vC22 = RScore(r690);' || chr(10) || 'if (vC22 > 0) then Set(vCcount = vCcount + 1);' 
|| chr(10) || '' || chr(10) || '' || chr(10) || 'VAR vTotalPossible = 110;' || chr(10) || '' || chr(10) || 'VAR vDifficulty = vD1 + vD2 + vD3 + vD4 + vD5 + vD6 + vD7 + vD8 + vD9 + vD10 + vD11 + vD12 + vD13 + vD14 + vD15 + vD16 + vD17 + vD18 + vD19 + vD20 + vD21 + vD22;' 
where mid=4080;
commit;

update TBICDS.intake_module
set score_logic = score_logic || chr(10) || '' || chr(10) || 'VAR vConfidence = vC1 + vC2 + vC3 + vC4 + vC5 + vC6 + vC7 + vC8 + vC9 + vC10 + vC11 + vC12 + vC13 + vC14 + vC15 + vC16 + vC17 + vC18 + vC19 + vC20 + vC21 + vC22;' 
|| chr(10) || '' || chr(10) || 'VAR vTotal = vDifficulty + vConfidence;' || chr(10) || 'VAR vDifficultyLimitation = 100 * ((vDifficulty - vDcount)/((5*vDcount) - vDcount));' || chr(10) || 'VAR vConfidenceLimitation = 100 * ((vConfidence - vCcount)/((5*vCcount) - vCcount));' 
|| chr(10) || '' || chr(10) || 'JScore(0,vTotal,,Total Score);' || chr(10) || 'JScore(1,vDifficulty,,Difficulty Score);' || chr(10) || 'JScore(2,vDifficultyLimitation,,Difficulty Limitation (%));' || chr(10) || 'JScore(3,vConfidence,,Confidence Score);' 
where mid=4080;
commit;

update TBICDS.intake_module
set score_logic = score_logic || chr(10) || 'JScore(4,vConfidenceLimitation,,Confidence Limitation (%)' || ');'
where mid=4080;
commit;


-----
--INTAKE_MODULE_DESCRIPTION 
------

insert into TBICDS.INTAKE_MODULE_DESCRIPTION (MID, SCORABLE, MIN_SCORE, MAX_SCORE, DEVISION_SLICE, NUMBER_OF_SLICES)
values (4078, 1, null, null, null, null);
insert into TBICDS.INTAKE_MODULE_DESCRIPTION (MID, SCORABLE, MIN_SCORE, MAX_SCORE, DEVISION_SLICE, NUMBER_OF_SLICES)
values (4080, 1, null, null, null, null);
commit;


---------
--INTAKE_MODULE_GROUP_MID
----------

drop table TBICDS.INTAKE_MODULE_GROUP_MID cascade constraints;
prompt Creating INTAKE_MODULE_GROUP_MID...
create table TBICDS.INTAKE_MODULE_GROUP_MID
(
  MODULE_GROUP_ID NUMBER,
  MID             NUMBER,
  SORT_ORDER      NUMBER
)
;
comment on table TBICDS.INTAKE_MODULE_GROUP_MID
  is 'Contains information related to an Instrument groups instruments';
comment on column TBICDS.INTAKE_MODULE_GROUP_MID.MODULE_GROUP_ID
  is 'Module group id (pk)';
comment on column TBICDS.INTAKE_MODULE_GROUP_MID.MID
  is 'Modle ID (pk)';
comment on column TBICDS.INTAKE_MODULE_GROUP_MID.SORT_ORDER
  is 'Sort order for display';

prompt Loading INTAKE_MODULE_GROUP_MID...
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1030, 4082, 110);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1050, 4082, 110);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1060, 4082, 110);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1070, 4082, 110);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1040, 4082, 120);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1010, 4082, 110);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1090, 4082, 220);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1005, 4082, 110);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1020, 4082, 110);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1080, 4082, 110);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2090, 4082, 110);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2070, 4082, 340);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1090, 4078, 230);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1090, 4080, 240);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2010, 4078, 170);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2010, 4080, 180);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2020, 4078, 100);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2020, 4080, 110);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2030, 4078, 170);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2030, 4080, 180);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2005, 4074, 220);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2070, 4074, 330);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2080, 4074, 180);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1, 4000, 1);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1, 4001, 2);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1, 4002, 3);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1, 4004, 4);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1, 4006, 5);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1, 4008, 6);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1, 4010, 8);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1, 4012, 9);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1, 4014, 10);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1020, 4018, 40);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1030, 4014, 1);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1030, 4024, 2);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1040, 4064, 10);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1040, 4066, 20);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1005, 4002, 10);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1005, 4012, 20);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1005, 4026, 30);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1010, 4008, 1);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1040, 4022, 30);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1040, 4010, 40);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1040, 4000, 50);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1090, 4030, 10);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1090, 4064, 20);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1090, 4066, 30);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1090, 4022, 40);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1090, 4050, 50);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1090, 4052, 60);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1090, 4001, 70);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1090, 4044, 80);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1090, 4018, 90);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2005, 4064, 10);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2005, 4066, 20);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2005, 4022, 30);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2005, 4050, 40);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2005, 4052, 50);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2005, 4001, 60);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2005, 4044, 70);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2005, 4018, 80);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2010, 4002, 10);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2010, 4012, 20);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2010, 4026, 30);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2010, 4014, 40);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2010, 4024, 50);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2010, 4042, 60);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2010, 4030, 70);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2010, 4062, 80);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2020, 4014, 10);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2020, 4024, 20);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2020, 4042, 30);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2030, 4002, 10);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2030, 4012, 20);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2030, 4026, 30);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2030, 4014, 40);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2030, 4024, 50);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2030, 4042, 60);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2030, 4030, 70);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2030, 4062, 80);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2040, 4014, 10);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2040, 4024, 20);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2070, 4014, 10);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2070, 4024, 20);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2070, 4042, 30);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2070, 4068, 40);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2070, 4030, 50);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2070, 4062, 60);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2070, 4064, 70);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2070, 4034, 80);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2070, 4066, 90);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2070, 4022, 100);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2070, 4050, 110);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2070, 4052, 120);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2080, 4064, 10);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2080, 4066, 20);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2080, 4001, 30);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2080, 4044, 40);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2080, 4018, 50);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2080, 4032, 60);
commit;
prompt 100 records committed...
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2090, 4064, 10);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2090, 4066, 20);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2090, 4001, 30);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2095, 4014, 10);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2095, 4008, 20);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1005, 4076, 100);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1010, 4076, 100);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1020, 4076, 100);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1030, 4076, 100);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1040, 4076, 100);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1050, 4076, 100);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1060, 4076, 100);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1070, 4076, 100);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1080, 4076, 100);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1090, 4076, 100);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2080, 4076, 100);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1020, 4062, 20);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1020, 4034, 30);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1020, 4060, 50);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1005, 4042, 40);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1005, 4058, 50);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1020, 4030, 10);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1040, 4056, 60);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1040, 4016, 70);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1040, 4028, 80);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1040, 4036, 90);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1040, 4048, 100);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1050, 4042, 10);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1050, 4068, 20);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1050, 4032, 30);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1050, 4054, 40);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1050, 4036, 50);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1050, 4038, 60);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1050, 4040, 70);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1050, 4046, 80);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1050, 4048, 90);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1060, 4068, 10);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1060, 4032, 20);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1060, 4054, 30);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1060, 4036, 40);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1060, 4038, 50);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1060, 4040, 60);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1060, 4046, 70);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1060, 4048, 80);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1070, 4042, 10);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1070, 4068, 20);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1070, 4054, 30);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1070, 4036, 40);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1070, 4038, 50);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1070, 4040, 60);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1070, 4046, 70);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1070, 4048, 80);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1080, 4042, 10);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1080, 4068, 20);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1080, 4038, 30);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1080, 4040, 40);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1090, 4020, 100);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1090, 4004, 110);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1090, 4032, 120);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1090, 4006, 130);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (9, 4018, 1);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1, 4018, 10);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1090, 4010, 140);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1090, 4056, 150);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1090, 4016, 160);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1090, 4028, 170);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1090, 4036, 180);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1090, 4046, 190);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1090, 4048, 200);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2005, 4020, 90);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2005, 4032, 100);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2005, 4010, 110);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2005, 4000, 120);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2005, 4056, 130);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2005, 4016, 140);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2005, 4054, 150);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2005, 4028, 160);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2005, 4036, 170);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2005, 4038, 180);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2005, 4040, 190);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2005, 4046, 200);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2005, 4048, 210);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2010, 4034, 90);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2010, 4066, 100);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2010, 4020, 110);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2010, 4004, 120);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2010, 4058, 130);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2010, 4060, 140);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2010, 4006, 150);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2020, 4030, 40);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2020, 4062, 50);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2020, 4034, 60);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2020, 4066, 70);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2020, 4006, 80);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2030, 4034, 90);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2030, 4066, 100);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2030, 4020, 110);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2030, 4004, 120);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2030, 4058, 130);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2030, 4060, 140);
commit;
prompt 200 records committed...
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2030, 4006, 150);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2040, 4042, 30);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2050, 4030, 10);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2050, 4062, 20);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2050, 4034, 30);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2070, 4001, 130);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2070, 4044, 140);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2070, 4018, 150);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2070, 4020, 160);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2070, 4004, 170);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2070, 4032, 180);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2070, 4060, 200);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2070, 4006, 210);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2070, 4010, 220);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2070, 4000, 230);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2070, 4056, 240);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2070, 4016, 250);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2070, 4054, 260);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2070, 4028, 270);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2070, 4036, 280);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2070, 4038, 290);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2070, 4040, 300);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2070, 4046, 310);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2070, 4048, 320);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2080, 4010, 70);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2080, 4000, 80);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2080, 4056, 90);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2080, 4016, 100);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2080, 4054, 110);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2080, 4028, 120);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2080, 4036, 130);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2080, 4038, 140);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2080, 4040, 150);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2080, 4046, 160);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2080, 4048, 170);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2090, 4044, 40);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2090, 4010, 50);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2090, 4000, 60);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (2090, 4056, 70);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1040, 4074, 110);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1050, 4074, 100);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1060, 4074, 90);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1070, 4074, 90);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1080, 4074, 50);
insert into TBICDS.INTAKE_MODULE_GROUP_MID (MODULE_GROUP_ID, MID, SORT_ORDER)
values (1090, 4074, 210);
commit;


----
--INTAKE_TOPIC 
--------

insert into TBICDS.INTAKE_TOPIC (MID, TID, TOPIC, DEL_TACTION, ACTIVE, DEL_ALTERNATE_LANGUAGE, DEL_TOPIC_IMAGE)
values (4076, 1, ' ', null, 1, null, null);
insert into TBICDS.INTAKE_TOPIC (MID, TID, TOPIC, DEL_TACTION, ACTIVE, DEL_ALTERNATE_LANGUAGE, DEL_TOPIC_IMAGE)
values (4076, 2, ' At the end of the observation period indicate whether the behavior described in each item was present and, if so, to what degree: slight, moderate or extreme.<br><br>' || chr(10) || 'Score the peak time for each behavior and use the following numerical values and criteria for your ratings.<br><br><ul><li><b>1 = absent:</b> the behavior is not present.</li><li><b>2 = present to a slight degree:</b> the behavior is present but does not prevent the conduct of other, contextually appropriate behavior. (The individual may redirect spontaneously, or the continuation of the agitated behavior does not disrupt appropriate behavior.)</li><li><b>3 = present to a moderate degree:</b> the individual needs to be redirected from an agitated to an appropriate behavior, but benefits from such cueing.</li><li><b>4 = present to an extreme degree:</b> the individual is not able to engage in appropriate behavior due to the interference of the agitated behavior, even when external cueing or redirection is provided.</li></ul>', null, 1, null, null);
insert into TBICDS.INTAKE_TOPIC (MID, TID, TOPIC, DEL_TACTION, ACTIVE, DEL_ALTERNATE_LANGUAGE, DEL_TOPIC_IMAGE)
values (4078, 1, 'Demographic Information', null, 1, null, null);
insert into TBICDS.INTAKE_TOPIC (MID, TID, TOPIC, DEL_TACTION, ACTIVE, DEL_ALTERNATE_LANGUAGE, DEL_TOPIC_IMAGE)
values (4078, 2, 'DifficultyBaseline', null, 1, null, null);
insert into TBICDS.INTAKE_TOPIC (MID, TID, TOPIC, DEL_TACTION, ACTIVE, DEL_ALTERNATE_LANGUAGE, DEL_TOPIC_IMAGE)
values (4078, 3, 'ConfidenceBaseline', null, 1, null, null);
insert into TBICDS.INTAKE_TOPIC (MID, TID, TOPIC, DEL_TACTION, ACTIVE, DEL_ALTERNATE_LANGUAGE, DEL_TOPIC_IMAGE)
values (4078, 4, '<small>Copyright </small>', null, 1, null, null);
insert into TBICDS.INTAKE_TOPIC (MID, TID, TOPIC, DEL_TACTION, ACTIVE, DEL_ALTERNATE_LANGUAGE, DEL_TOPIC_IMAGE)
values (4080, 1, 'DifficultyFollow-Up', null, 1, null, null);
insert into TBICDS.INTAKE_TOPIC (MID, TID, TOPIC, DEL_TACTION, ACTIVE, DEL_ALTERNATE_LANGUAGE, DEL_TOPIC_IMAGE)
values (4080, 2, 'ConfidenceFollow-Up', null, 1, null, null);
insert into TBICDS.INTAKE_TOPIC (MID, TID, TOPIC, DEL_TACTION, ACTIVE, DEL_ALTERNATE_LANGUAGE, DEL_TOPIC_IMAGE)
values (4080, 3, '<small>Copyright </small>', null, 1, null, null);
insert into TBICDS.INTAKE_TOPIC (MID, TID, TOPIC, DEL_TACTION, ACTIVE, DEL_ALTERNATE_LANGUAGE, DEL_TOPIC_IMAGE)
values (4082, 1, ' ', null, 1, null, null);
commit;


------------
--INTAKE_QUESTION 
----

insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4076, 1, 3, 'Period of Observation', 1, 2, 1, null, 1);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4076, 2, 1, '1. Short attention span, easy distractibility, inability to concentrate.', 1, 1, 1, null, 1);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4076, 2, 2, '2. Impulsive, impatient, low tolerance for pain or frustration.', 1, 1, 1, null, 1);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4076, 2, 3, '3. Uncooperative, resistant to care, demanding. ', 1, 1, 1, null, 1);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4076, 2, 4, '4. Violent and/or threatening violence toward people or property.', 1, 1, 1, null, 1);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4076, 2, 5, '5. Explosive and/or unpredictable anger.', 1, 1, 1, null, 1);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4076, 2, 6, '6. Rocking, rubbing, moaning or other self-stimulating behavior.', 1, 1, 1, null, 1);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4076, 2, 7, '7. Pulling at tubes, restraints, etc.', 1, 1, 1, null, 1);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4076, 2, 8, '8. Wandering from treatment areas.', 1, 1, 1, null, 1);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4076, 2, 9, '9. Restlessness, pacing, excessive movement.', 1, 1, 1, null, 1);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4076, 2, 10, '10. Repetitive behaviors, motor and/or verbal.', 1, 1, 1, null, 1);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4076, 2, 11, '11. Rapid, loud or excessive talking.', 1, 1, 1, null, 1);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4076, 2, 12, '12. Sudden changes of mood.', 1, 1, 1, null, 1);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4076, 2, 13, '13. Easily initiated or excessive crying and/or laughter.', 1, 1, 1, null, 1);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4076, 2, 14, '14. Self-abusiveness, physical and/or verbal.', 1, 1, 1, null, 1);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4076, 2, 15, 'Triggers', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4076, 2, 16, 'Interventions', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4076, 2, 17, 'Medication changes', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4076, 1, 1, 'Observation Environment', 1, 1, 1, null, 1);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4080, 1, 1, 'Three (3) activities you would most like to be able to do without any difficulty (identified at baseline assessment):', 1, 1, 1, null, 1);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4080, 1, 2, 'Primary activity you would most like to be able to do without any difficulty (identified at baseline assessment):<br/><br/>Primary Goal:', 1, 1, 1, null, 1);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4080, 1, 3, '<b>Instructions</b>: Please select the level of difficulty you have for each activity today.', 1, 1, 1, null, 1);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4080, 2, 1, '<b>Instructions</b>: Please select the level of confidence you have for doing each activity today.', 1, 1, 1, null, 1);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4080, 3, 1, '<br/><br/><small>The OPTIMAL may be used without permission or restriction per our website, www.apta.org/optimal. Please note, however, that it remains the copyrighted intellectual property of <i>Physical Therapy (PTJ)</i> and the following citation must be included for all uses:' || chr(10) || '<br/><br/>Copyright  2012, 2006, 2005 American Physical Therapy Association. All rights reserved.</small>', 1, 0, 0, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4076, 1, 4, ' ', 1, 2, 1, null, 1);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4078, 1, 1, 'Insurance (Please check all that apply)', 1, 1, 1, null, 1);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4078, 2, 1, '<b>Instructions</b>: Please select the level of difficulty you have for each activity today.', 1, 1, 1, null, 1);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4078, 2, 2, '23. From the above list, choose the 3 activities you would most like to be able to do without any difficulty  (for example, if you would most like to be able to <i>climb stairs</i>, <i>kneel</i>, and <i>hop</i> without any difficulty, you would choose: 1.<u><i> 13 </u></i>, 2.<u><i> 8 </u></i>, 3.<u><i> 14 </u></i> )', 1, 1, 1, null, 1);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4078, 2, 3, '24. From the above list of three activities, choose the primary activity you would most like to be able to do without any difficulty (for example, if you would most like to be able to <i>climb stairs</i> without any difficulty, you would choose: Primary goal.<u><i> 13  </u></i>).<br/><br>Primary Goal:', 1, 1, 1, null, 1);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4078, 3, 1, '<b>Instructions</b>: Please select the level of confidence you have for doing each activity today.', 1, 1, 1, null, 1);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4078, 4, 1, '<small><br/><br/>The OPTIMAL may be used without permission or restriction per our website, www.apta.org/optimal. Please note, however, that it remains the copyrighted intellectual property of <i>Physical Therapy</i> (PTJ) and the following citation must be included for all uses:<br/><br/>Copyright  2012, 2006, 2005 American Physical Therapy Association. All rights reserved.</small>', 1, 0, 0, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4078, 1, 7, 'Where do you live?', 1, 1, 1, null, 1);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4078, 1, 5, 'With whom do you live? (Check all that apply)', 1, 1, 1, null, 1);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4078, 1, 3, 'Do you use a: (Check all that apply)', 1, 1, 1, null, 1);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4078, 1, 2, 'Please check the combined annual income of everyone ' || chr(10) || 'in your house:', 1, 1, 1, null, 1);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4078, 1, 4, 'Other:', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4078, 1, 6, 'Other:', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 1, 'Date: ', 1, 1, 1, null, 1);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 2, 'Date of Admission:  ', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 3, 'Date of Discharge:  ', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 4, 'Length of stay to date: ', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 5, 'Disposition:  ', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 6, 'Type of Note: ', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 7, 'Short Term Goals:', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 8, 'Long Term Goals:', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 9, 'Medical Diagnosis and Update:', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 10, 'Vision:', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 11, 'Hearing:', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 12, 'Physical Therapy:', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 13, 'Assistive Device:', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 14, 'Functional Status:', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 15, 'Equipment, Braces and Compression Garments: ', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 16, 'Mobility restrictions:', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 17, 'Activity recommendations:', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 18, 'Home Exercise Program:', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 19, 'Outpatient therapy recommendations:', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 20, 'Education:', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 21, 'Speech Language Pathology:', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 22, 'Diet orders:  ', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 23, 'Aspiration precautions and compensatory swallow strategies:', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 24, 'Supervision:', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 25, 'Compensatory memory strategies:', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 26, 'Assistance with finances:', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 27, 'Outpatient recommendations:  ', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 28, 'Education:', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 29, 'Thickener packets:', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 30, 'Occupational Therapy:', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 31, 'Functional Status:', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 32, 'Equipment, Braces and Compression Garments: ', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 33, 'Mobility restrictions:', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 34, 'Activity recommendations:', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 35, 'Meal preparation assistance:', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 36, 'Medication management needs:', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 37, 'Driving status: ', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 38, 'Home Exercise Program details:', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 39, 'Outpatient recommendations:', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 40, 'Education:', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 41, 'Recreational Therapy', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 42, 'Community supervision needs:', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 43, 'Community leisure resources: ', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 44, 'Education:', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 45, 'Nutrition', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 46, 'Diet orders:', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 47, 'Outpatient recommendations:', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 48, 'Education:', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 49, 'Rehabilitation Nursing', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 50, 'Blood pressure checks:', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 51, 'Assistance for medication management:', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 52, 'Pharmacy orders:', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 53, 'Education:', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 54, 'Assistive Technology', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 55, 'Prosthetics', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 56, 'Social Work', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 57, 'Psychology', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 58, 'Outpatient follow up:', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 59, 'Recommendations:', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 60, 'Neuropsychology', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 61, 'Outpatient follow up:', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 62, 'Recommendations:', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 63, 'Psychiatry', 1, 1, 1, null, 0);
commit;
prompt 100 records committed...
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 64, 'Outpatient follow up:', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 65, 'Recommendations:', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 66, 'Medication changes:', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 67, 'Vocational Rehabilitation', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 68, 'Equipment (Durable Medical Equipment, Supplies):', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 69, 'Patient/Family Education:', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 70, 'Status of Guardianship:  ', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 71, 'Advanced Directive Decision Maker:', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 72, 'FOLLOW UP:', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 73, 'Primary Care:', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 74, 'TBI:', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 75, 'Neurology:', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 76, 'EEG:', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 77, 'Neurosurgery:', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 78, 'Pain Clinic:', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 79, 'EMG/Botox:', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 80, 'Orthopedics:', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 81, 'Ophthalmology:', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 82, 'Prosthetics:', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 83, 'Imaging:', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 84, 'Labs:', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 85, 'Home Health/ILS/BLS or other Referrals (Nursing, Bath Aide, Homemaker Services):', 1, 1, 1, null, 0);
insert into TBICDS.INTAKE_QUESTION (MID, TID, QID, QUESTION, ACTIVE, RESPONSES_POS, RESPONSE_LAYOUT, CDE_ID, REQUIRED)
values (4082, 1, 86, 'Transportation:', 1, 1, 1, null, 0);
commit;



---------
---INTAKE_RESPONSE
------------

insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (5, 4076, 1, 1, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (15, 4076, 1, 3, 'From', 21, 0, 1, null, null, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (20, 4076, 1, 4, 'To   ', 21, 0, 1, null, null, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (25, 4076, 2, 1, ' ', 4, 5, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4076 and data_item = 1 order by data_item', 'DATA_ID', 'r1', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (30, 4076, 2, 2, ' ', 4, 5, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4076 and data_item = 1 order by data_item', 'DATA_ID', 'r2', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (35, 4076, 2, 3, ' ', 4, 5, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4076 and data_item = 1 order by data_item', 'DATA_ID', 'r3', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (40, 4076, 2, 4, ' ', 4, 5, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4076 and data_item = 1 order by data_item', 'DATA_ID', 'r4', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (45, 4076, 2, 5, ' ', 4, 5, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4076 and data_item = 1 order by data_item', 'DATA_ID', 'r5', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (50, 4076, 2, 6, ' ', 4, 5, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4076 and data_item = 1 order by data_item', 'DATA_ID', 'r6', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (55, 4076, 2, 7, ' ', 4, 5, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4076 and data_item = 1 order by data_item', 'DATA_ID', 'r7', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (60, 4076, 2, 8, ' ', 4, 5, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4076 and data_item = 1 order by data_item', 'DATA_ID', 'r8', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (65, 4076, 2, 9, ' ', 4, 5, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4076 and data_item = 1 order by data_item', 'DATA_ID', 'r9', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (70, 4076, 2, 10, ' ', 4, 5, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4076 and data_item = 1 order by data_item', 'DATA_ID', 'r10', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (75, 4076, 2, 11, ' ', 4, 5, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4076 and data_item = 1 order by data_item', 'DATA_ID', 'r11', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (80, 4076, 2, 12, ' ', 4, 5, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4076 and data_item = 1 order by data_item', 'DATA_ID', 'r12', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (85, 4076, 2, 13, ' ', 4, 5, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4076 and data_item = 1 order by data_item', 'DATA_ID', 'r13', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (90, 4076, 2, 14, ' ', 4, 5, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4076 and data_item = 1 order by data_item', 'DATA_ID', 'r14', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (95, 4076, 2, 15, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (100, 4076, 2, 16, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (105, 4076, 2, 17, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (10, 4080, 1, 1, ' Activity 1:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4078 and data_item=13 order by data_item', 'DATA_ID', 'r10', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (20, 4080, 1, 1, ' Activity 2:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4078 and data_item=13 order by data_item', 'DATA_ID', 'r20', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (30, 4080, 1, 1, ' Activity 3:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4078 and data_item=13 order by data_item', 'DATA_ID', 'r30', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (40, 4080, 1, 2, '1. Lying flat', 1, 1, 1, null, null, null, null, null, 1, 1, null, ' ', ' ', ' ', ' ', 'r40', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (50, 4080, 1, 2, '2. Rolling over', 1, 1, 1, null, null, null, null, null, 1, 1, null, ' ', ' ', ' ', ' ', 'r50', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (60, 4080, 1, 2, '3. Movinglying to sitting', 1, 1, 1, null, null, null, null, null, 1, 1, null, ' ', ' ', ' ', ' ', 'r60', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (70, 4080, 1, 2, '4. Sitting', 1, 1, 1, null, null, null, null, null, 1, 1, null, ' ', ' ', ' ', ' ', 'r70', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (80, 4080, 1, 2, '5. Squatting', 1, 1, 1, null, null, null, null, null, 1, 1, null, ' ', ' ', ' ', ' ', 'r80', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (90, 4080, 1, 2, '6. Bending/stooping', 1, 1, 1, null, null, null, null, null, 1, 1, null, ' ', ' ', ' ', ' ', 'r90', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (100, 4080, 1, 2, '7. Balancing', 1, 1, 1, null, null, null, null, null, 1, 1, null, ' ', ' ', ' ', ' ', 'r100', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (110, 4080, 1, 2, '8. Kneeling', 1, 1, 1, null, null, null, null, null, 1, 1, null, ' ', ' ', ' ', ' ', 'r110', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (120, 4080, 1, 2, '9. Standing', 1, 1, 1, null, null, null, null, null, 1, 1, null, ' ', ' ', ' ', ' ', 'r120', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (130, 4080, 1, 2, '10. Walkingshort distance', 1, 1, 1, null, null, null, null, null, 1, 1, null, ' ', ' ', ' ', ' ', 'r130', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (140, 4080, 1, 2, '11. Walkinglong distance', 1, 1, 1, null, null, null, null, null, 1, 1, null, ' ', ' ', ' ', ' ', 'r140', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (150, 4080, 1, 2, '12. Walkingoutdoors', 1, 1, 1, null, null, null, null, null, 1, 1, null, ' ', ' ', ' ', ' ', 'r150', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (160, 4080, 1, 2, '13. Climbing stairs', 1, 1, 1, null, null, null, null, null, 1, 1, null, ' ', ' ', ' ', ' ', 'r160', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (170, 4080, 1, 2, '14. Hopping', 1, 1, 1, null, null, null, null, null, 1, 1, null, ' ', ' ', ' ', ' ', 'r170', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (180, 4080, 1, 2, '15. Jumping', 1, 1, 1, null, null, null, null, null, 1, 1, null, ' ', ' ', ' ', ' ', 'r180', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (190, 4080, 1, 2, '16. Running', 1, 1, 1, null, null, null, null, null, 1, 1, null, ' ', ' ', ' ', ' ', 'r190', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (200, 4080, 1, 2, '17. Pushing', 1, 1, 1, null, null, null, null, null, 1, 1, null, ' ', ' ', ' ', ' ', 'r200', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (210, 4080, 1, 2, '18. Pulling', 1, 1, 1, null, null, null, null, null, 1, 1, null, ' ', ' ', ' ', ' ', 'r210', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (220, 4080, 1, 2, '19. Reaching', 1, 1, 1, null, null, null, null, null, 1, 1, null, ' ', ' ', ' ', ' ', 'r220', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (230, 4080, 1, 2, '20. Grasping', 1, 1, 1, null, null, null, null, null, 1, 1, null, ' ', ' ', ' ', ' ', 'r230', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (240, 4080, 1, 2, '21. Lifting', 1, 1, 1, null, null, null, null, null, 1, 1, null, ' ', ' ', ' ', ' ', 'r240', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (250, 4080, 1, 2, '22. Carrying', 1, 1, 1, null, null, null, null, null, 1, 1, null, ' ', ' ', ' ', ' ', 'r250', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (260, 4080, 1, 3, '1. Lying flat:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4080 and data_item=12 order by data_item', 'DATA_ID', 'r260', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (270, 4080, 1, 3, '2. Rolling over:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4080 and data_item=12 order by data_item', 'DATA_ID', 'r270', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (280, 4080, 1, 3, '3. Movinglying to sitting:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4080 and data_item=12 order by data_item', 'DATA_ID', 'r280', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (290, 4080, 1, 3, '4. Sitting:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4080 and data_item=12 order by data_item', 'DATA_ID', 'r290', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (300, 4080, 1, 3, '5. Squatting:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4080 and data_item=12 order by data_item', 'DATA_ID', 'r300', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (310, 4080, 1, 3, '6. Bending/stooping:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4080 and data_item=12 order by data_item', 'DATA_ID', 'r310', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (320, 4080, 1, 3, '7. Balancing:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4080 and data_item=12 order by data_item', 'DATA_ID', 'r320', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (335, 4082, 1, 41, 'Education:', 2, 2, 1, null, null, null, '''TID1_QID44''', null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (340, 4082, 1, 42, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (345, 4082, 1, 43, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (350, 4082, 1, 44, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (355, 4082, 1, 45, 'Diet orders:', 2, 2, 1, null, null, null, '''TID1_QID46''', null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (360, 4082, 1, 45, 'Outpatient recommendations:', 2, 2, 1, null, null, null, '''TID1_QID47''', null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (365, 4082, 1, 45, 'Education:', 2, 2, 1, null, null, null, '''TID1_QID48''', null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (370, 4082, 1, 46, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (375, 4082, 1, 47, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (380, 4082, 1, 48, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (385, 4082, 1, 49, 'Blood pressure checks:', 2, 2, 1, null, null, null, '''TID1_QID50''', null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (390, 4082, 1, 49, 'Assistance for medication management:', 2, 2, 1, null, null, null, '''TID1_QID51''', null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (395, 4082, 1, 49, 'Pharmacy orders:', 2, 2, 1, null, null, null, '''TID1_QID52''', null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (400, 4082, 1, 49, 'Education:', 2, 2, 1, null, null, null, '''TID1_QID53''', null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (405, 4082, 1, 50, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (410, 4082, 1, 51, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (415, 4082, 1, 52, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (420, 4082, 1, 53, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (425, 4082, 1, 54, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (430, 4082, 1, 55, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (435, 4082, 1, 56, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (440, 4082, 1, 57, 'Outpatient follow up:', 2, 2, 1, null, null, null, '''TID1_QID58''', null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (445, 4082, 1, 57, 'Recommendations:', 2, 2, 1, null, null, null, '''TID1_QID59''', null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (450, 4082, 1, 58, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (455, 4082, 1, 59, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (460, 4082, 1, 60, 'Outpatient follow up:', 2, 2, 1, null, null, null, '''TID1_QID61''', null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (465, 4082, 1, 60, 'Recommendations:', 2, 2, 1, null, null, null, '''TID1_QID62''', null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (470, 4082, 1, 61, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (475, 4082, 1, 62, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (480, 4082, 1, 63, 'Outpatient follow up:', 2, 2, 1, null, null, null, '''TID1_QID64''', null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (485, 4082, 1, 63, 'Recommendations:', 2, 2, 1, null, null, null, '''TID1_QID65''', null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (490, 4082, 1, 63, 'Medication changes:', 2, 2, 1, null, null, null, '''TID1_QID66''', null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (495, 4082, 1, 64, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (500, 4082, 1, 65, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (505, 4082, 1, 66, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (510, 4082, 1, 67, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (515, 4082, 1, 68, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (520, 4082, 1, 69, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (525, 4082, 1, 70, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (530, 4082, 1, 71, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (535, 4082, 1, 72, 'Primary Care:', 2, 2, 1, null, null, null, '''TID1_QID73''', null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (540, 4082, 1, 72, 'TBI:', 2, 2, 1, null, null, null, '''TID1_QID74''', null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (545, 4082, 1, 72, 'Neurology:', 2, 2, 1, null, null, null, '''TID1_QID75''', null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (550, 4082, 1, 72, 'EEG:', 2, 2, 1, null, null, null, '''TID1_QID76''', null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (555, 4082, 1, 72, 'Neurosurgery:', 2, 2, 1, null, null, null, '''TID1_QID77''', null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (560, 4082, 1, 72, 'Pain Clinic:', 2, 2, 1, null, null, null, '''TID1_QID78''', null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (565, 4082, 1, 72, 'EMG/Botox:', 2, 2, 1, null, null, null, '''TID1_QID79''', null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (570, 4082, 1, 72, 'Orthopedics:', 2, 2, 1, null, null, null, '''TID1_QID80''', null, 1, 1, null, null, null, null, null, null, null);
commit;
prompt 100 records committed...
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (575, 4082, 1, 72, 'Ophthalmology:', 2, 2, 1, null, null, null, '''TID1_QID81''', null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (580, 4082, 1, 72, 'Prosthetics:', 2, 2, 1, null, null, null, '''TID1_QID82''', null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (585, 4082, 1, 72, 'Imaging:', 2, 2, 1, null, null, null, '''TID1_QID83''', null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (590, 4082, 1, 72, 'Labs:', 2, 2, 1, null, null, null, '''TID1_QID84''', null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (595, 4082, 1, 72, 'Home Health/ILS/BLS or other Referrals:', 2, 2, 1, null, null, null, '''TID1_QID85''', null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (600, 4082, 1, 72, 'Transportation:', 2, 2, 1, null, null, null, '''TID1_QID86''', null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (605, 4082, 1, 73, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (610, 4082, 1, 74, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (615, 4082, 1, 75, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (620, 4082, 1, 76, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (625, 4082, 1, 77, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (630, 4082, 1, 78, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (635, 4082, 1, 79, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (640, 4082, 1, 80, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (645, 4082, 1, 81, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (650, 4082, 1, 82, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (655, 4082, 1, 83, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (660, 4082, 1, 84, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (665, 4082, 1, 85, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (670, 4082, 1, 86, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (330, 4080, 1, 3, '8. Kneeling:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4080 and data_item=12 order by data_item', 'DATA_ID', 'r330', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (340, 4080, 1, 3, '9. Standing:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4080 and data_item=12 order by data_item', 'DATA_ID', 'r340', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (350, 4080, 1, 3, '10. Walkingshort distance:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4080 and data_item=12 order by data_item', 'DATA_ID', 'r350', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (360, 4080, 1, 3, '11. Walkinglong distance:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4080 and data_item=12 order by data_item', 'DATA_ID', 'r360', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (370, 4080, 1, 3, '12. Walkingoutdoors:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4080 and data_item=12 order by data_item', 'DATA_ID', 'r370', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (380, 4080, 1, 3, '13. Climbing stairs:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4080 and data_item=12 order by data_item', 'DATA_ID', 'r380', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (390, 4080, 1, 3, '14. Hopping:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4080 and data_item=12 order by data_item', 'DATA_ID', 'r390', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (400, 4080, 1, 3, '15. Jumping:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4080 and data_item=12 order by data_item', 'DATA_ID', 'r400', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (410, 4080, 1, 3, '16. Running:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4080 and data_item=12 order by data_item', 'DATA_ID', 'r410', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (420, 4080, 1, 3, '17. Pushing:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4080 and data_item=12 order by data_item', 'DATA_ID', 'r420', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (430, 4080, 1, 3, '18. Pulling:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4080 and data_item=12 order by data_item', 'DATA_ID', 'r430', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (440, 4080, 1, 3, '19. Reaching:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4080 and data_item=12 order by data_item', 'DATA_ID', 'r440', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (450, 4080, 1, 3, '20. Grasping:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4080 and data_item=12 order by data_item', 'DATA_ID', 'r450', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (460, 4080, 1, 3, '21. Lifting:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4080 and data_item=12 order by data_item', 'DATA_ID', 'r460', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (470, 4080, 1, 3, '22. Carrying:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4080 and data_item=12 order by data_item', 'DATA_ID', 'r470', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (480, 4080, 2, 1, '1. Lying flat:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4080 and data_item=14 order by data_item', 'DATA_ID', 'r480', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (490, 4080, 2, 1, '2. Rolling over:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4080 and data_item=14 order by data_item', 'DATA_ID', 'r490', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (500, 4080, 2, 1, '3. Movinglying to sitting:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4080 and data_item=14 order by data_item', 'DATA_ID', 'r500', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (510, 4080, 2, 1, '4. Sitting:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4080 and data_item=14 order by data_item', 'DATA_ID', 'r510', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (520, 4080, 2, 1, '5. Squatting:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4080 and data_item=14 order by data_item', 'DATA_ID', 'r520', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (530, 4080, 2, 1, '6. Bending/stooping:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4080 and data_item=14 order by data_item', 'DATA_ID', 'r530', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (540, 4080, 2, 1, '7. Balancing:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4080 and data_item=14 order by data_item', 'DATA_ID', 'r540', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (550, 4080, 2, 1, '8. Kneeling:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4080 and data_item=14 order by data_item', 'DATA_ID', 'r550', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (560, 4080, 2, 1, '9. Standing:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4080 and data_item=14 order by data_item', 'DATA_ID', 'r560', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (570, 4080, 2, 1, '10. Walkingshort distance:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4080 and data_item=14 order by data_item', 'DATA_ID', 'r570', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (580, 4080, 2, 1, '11. Walkinglong distance:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4080 and data_item=14 order by data_item', 'DATA_ID', 'r580', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (590, 4080, 2, 1, '12. Walkingoutdoors:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4080 and data_item=14 order by data_item', 'DATA_ID', 'r590', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (600, 4080, 2, 1, '13. Climbing stairs:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4080 and data_item=14 order by data_item', 'DATA_ID', 'r600', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (610, 4080, 2, 1, '14. Hopping:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4080 and data_item=14 order by data_item', 'DATA_ID', 'r610', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (620, 4080, 2, 1, '15. Jumping:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4080 and data_item=14 order by data_item', 'DATA_ID', 'r620', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (630, 4080, 2, 1, '16. Running:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4080 and data_item=14 order by data_item', 'DATA_ID', 'r630', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (640, 4080, 2, 1, '17. Pushing:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4080 and data_item=14 order by data_item', 'DATA_ID', 'r640', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (650, 4080, 2, 1, '18. Pulling:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4080 and data_item=14 order by data_item', 'DATA_ID', 'r650', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (660, 4080, 2, 1, '19. Reaching:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4080 and data_item=14 order by data_item', 'DATA_ID', 'r660', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (670, 4080, 2, 1, '20. Grasping:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4080 and data_item=14 order by data_item', 'DATA_ID', 'r670', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (680, 4080, 2, 1, '21. Lifting:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4080 and data_item=14 order by data_item', 'DATA_ID', 'r680', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (690, 4080, 2, 1, '22. Carrying:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4080 and data_item=14 order by data_item', 'DATA_ID', 'r690', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (120, 4076, 1, 3, ' ', 4, 2, 1, null, null, null, null, null, 2, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4076 and data_item = 4 order by data_item', 'DATA_ID', null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (115, 4076, 1, 3, ':', 4, 2, 1, null, null, null, null, null, 2, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4076 and data_item = 3 order by data_item', 'DATA_ID', null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (110, 4076, 1, 3, 'Time:', 4, 2, 1, null, null, null, null, null, 2, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4076 and data_item = 2 order by data_item', 'DATA_ID', null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (1055, 4078, 1, 4, ' ', 3, 3, 1, null, 100, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (1060, 4078, 1, 6, ' ', 3, 3, 1, null, 100, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (125, 4076, 1, 4, 'Time:', 4, 2, 1, null, null, null, null, null, 2, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4076 and data_item = 2 order by data_item', 'DATA_ID', null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (135, 4076, 1, 4, ' ', 4, 2, 1, null, null, null, null, null, 2, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4076 and data_item = 4 order by data_item', 'DATA_ID', null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (130, 4076, 1, 4, ':', 4, 2, 1, null, null, null, null, null, 2, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4076 and data_item = 3 order by data_item', 'DATA_ID', null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (10, 4078, 1, 1, 'Workers'' compensation', 2, 2, 1, null, null, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (20, 4078, 1, 1, 'Self-pay', 2, 2, 1, null, null, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (30, 4078, 1, 1, 'HMO/PPO/private insurance', 2, 2, 1, null, null, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (40, 4078, 1, 1, 'Medicare', 2, 2, 1, null, null, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (50, 4078, 1, 1, 'Medicaid', 2, 2, 1, null, null, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (60, 4078, 1, 1, 'Auto', 2, 2, 1, null, null, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (70, 4078, 1, 1, 'Other', 2, 2, 1, null, null, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (80, 4078, 1, 2, 'Less than $10,000', 1, 1, 1, null, null, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (90, 4078, 1, 2, '$10,000-$14,999', 1, 1, 1, null, null, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (100, 4078, 1, 2, '$15,000-$24,999', 1, 1, 1, null, null, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (110, 4078, 1, 2, '$25,000-$34,999', 1, 1, 1, null, null, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (120, 4078, 1, 2, '$35,000-$49,999', 1, 1, 1, null, null, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (130, 4078, 1, 2, '$50,000-$74,999', 1, 1, 1, null, null, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (140, 4078, 1, 2, '$75,000-$99,999', 1, 1, 1, null, null, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (150, 4078, 1, 2, '$100,000-$149,999', 1, 1, 1, null, null, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (160, 4078, 1, 2, '$150,000 or more', 1, 1, 1, null, null, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (170, 4078, 1, 3, 'Cane?', 2, 2, 1, null, null, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (180, 4078, 1, 3, 'Walker, rolling walker, or rollator?', 2, 2, 1, null, null, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (190, 4078, 1, 3, 'Manual wheelchair?', 2, 2, 1, null, null, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (200, 4078, 1, 3, 'Motorized wheelchair?', 2, 2, 1, null, null, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (210, 4078, 1, 3, 'Other:', 2, 2, 1, null, null, null, '''TID1_QID4''', null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (220, 4078, 1, 5, 'Alone', 2, 2, 1, null, null, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (230, 4078, 1, 5, 'Spouse/significant other', 2, 2, 1, null, null, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (240, 4078, 1, 5, 'Child/children', 2, 2, 1, null, null, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (250, 4078, 1, 5, 'Other relative(s)', 2, 2, 1, null, null, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (260, 4078, 1, 5, 'Group setting', 2, 2, 1, null, null, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (270, 4078, 1, 5, 'Personal care attendant', 2, 2, 1, null, null, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (280, 4078, 1, 5, 'Other:', 2, 2, 1, null, null, null, '''TID1_QID6''', null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (290, 4078, 1, 7, 'Private home', 1, 1, 1, null, null, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (300, 4078, 1, 7, 'Private apartment', 1, 1, 1, null, null, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (310, 4078, 1, 7, 'Rented room', 1, 1, 1, null, null, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (320, 4078, 1, 7, 'Board and care/assisted living/group home', 1, 1, 1, null, null, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (330, 4078, 1, 7, 'Homeless (with or without shelter)', 1, 1, 1, null, null, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (340, 4078, 1, 7, 'Long-term care facility (nursing home)', 1, 1, 1, null, null, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (350, 4078, 1, 7, 'Hospice', 1, 1, 1, null, null, null, null, null, 1, 1, null, null, null, null, null, null, null);
commit;
prompt 200 records committed...
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (360, 4078, 1, 7, 'Other', 1, 1, 1, null, null, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (370, 4078, 2, 1, '1. Lying flat:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4078 and data_item=12 order by data_item', 'DATA_ID', 'r10', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (380, 4078, 2, 1, '2. Rolling over:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4078 and data_item=12 order by data_item', 'DATA_ID', 'r20', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (390, 4078, 2, 1, '3. Movinglying to sitting:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4078 and data_item=12 order by data_item', 'DATA_ID', 'r30', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (400, 4078, 2, 1, '4. Sitting:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4078 and data_item=12 order by data_item', 'DATA_ID', 'r40', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (410, 4078, 2, 1, '5. Squatting:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4078 and data_item=12 order by data_item', 'DATA_ID', 'r50', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (420, 4078, 2, 1, '6. Bending/stooping:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4078 and data_item=12 order by data_item', 'DATA_ID', 'r60', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (430, 4078, 2, 1, '7. Balancing:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4078 and data_item=12 order by data_item', 'DATA_ID', 'r70', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (440, 4078, 2, 1, '8. Kneeling:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4078 and data_item=12 order by data_item', 'DATA_ID', 'r80', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (450, 4078, 2, 1, '9. Standing:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4078 and data_item=12 order by data_item', 'DATA_ID', 'r90', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (460, 4078, 2, 1, '10. Walkingshort distance:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4078 and data_item=12 order by data_item', 'DATA_ID', 'r100', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (470, 4078, 2, 1, '11. Walkinglong distance:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4078 and data_item=12 order by data_item', 'DATA_ID', 'r110', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (480, 4078, 2, 1, '12. Walkingoutdoors:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4078 and data_item=12 order by data_item', 'DATA_ID', 'r120', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (490, 4078, 2, 1, '13. Climbing stairs:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4078 and data_item=12 order by data_item', 'DATA_ID', 'r130', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (500, 4078, 2, 1, '14. Hopping:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4078 and data_item=12 order by data_item', 'DATA_ID', 'r140', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (510, 4078, 2, 1, '15. Jumping:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4078 and data_item=12 order by data_item', 'DATA_ID', 'r150', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (520, 4078, 2, 1, '16. Running:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4078 and data_item=12 order by data_item', 'DATA_ID', 'r160', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (530, 4078, 2, 1, '17. Pushing:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4078 and data_item=12 order by data_item', 'DATA_ID', 'r170', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (540, 4078, 2, 1, '18. Pulling:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4078 and data_item=12 order by data_item', 'DATA_ID', 'r180', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (550, 4078, 2, 1, '19. Reaching:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4078 and data_item=12 order by data_item', 'DATA_ID', 'r190', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (560, 4078, 2, 1, '20. Grasping:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4078 and data_item=12 order by data_item', 'DATA_ID', 'r200', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (570, 4078, 2, 1, '21. Lifting:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4078 and data_item=12 order by data_item', 'DATA_ID', 'r210', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (580, 4078, 2, 1, '22. Carrying:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4078 and data_item=12 order by data_item', 'DATA_ID', 'r220', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (590, 4078, 2, 2, ' Activity 1:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4078 and data_item=13 order by data_item', 'DATA_ID', 'r230', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (600, 4078, 2, 2, ' Activity 2:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4078 and data_item=13 order by data_item', 'DATA_ID', 'r240', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (610, 4078, 2, 2, ' Activity 3:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4078 and data_item=13 order by data_item', 'DATA_ID', 'r250', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (620, 4078, 2, 3, '1. Lying flat', 1, 1, 1, null, null, null, null, null, 1, 1, null, ' ', ' ', ' ', ' ', 'r260', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (630, 4078, 2, 3, '2. Rolling over', 1, 1, 1, null, null, null, null, null, 1, 1, null, ' ', ' ', ' ', ' ', 'r270', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (640, 4078, 2, 3, '3. Movinglying to sitting', 1, 1, 1, null, null, null, null, null, 1, 1, null, ' ', ' ', ' ', ' ', 'r280', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (650, 4078, 2, 3, '4. Sitting', 1, 1, 1, null, null, null, null, null, 1, 1, null, ' ', ' ', ' ', ' ', 'r290', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (660, 4078, 2, 3, '5. Squatting', 1, 1, 1, null, null, null, null, null, 1, 1, null, ' ', ' ', ' ', ' ', 'r300', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (670, 4078, 2, 3, '6. Bending/stooping', 1, 1, 1, null, null, null, null, null, 1, 1, null, ' ', ' ', ' ', ' ', 'r310', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (680, 4078, 2, 3, '7. Balancing', 1, 1, 1, null, null, null, null, null, 1, 1, null, ' ', ' ', ' ', ' ', 'r320', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (690, 4078, 2, 3, '8. Kneeling', 1, 1, 1, null, null, null, null, null, 1, 1, null, ' ', ' ', ' ', ' ', 'r330', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (700, 4078, 2, 3, '9. Standing', 1, 1, 1, null, null, null, null, null, 1, 1, null, ' ', ' ', ' ', ' ', 'r340', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (710, 4078, 2, 3, '10. Walkingshort distance', 1, 1, 1, null, null, null, null, null, 1, 1, null, ' ', ' ', ' ', ' ', 'r350', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (720, 4078, 2, 3, '11. Walkinglong distance', 1, 1, 1, null, null, null, null, null, 1, 1, null, ' ', ' ', ' ', ' ', 'r360', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (730, 4078, 2, 3, '12. Walkingoutdoors', 1, 1, 1, null, null, null, null, null, 1, 1, null, ' ', ' ', ' ', ' ', 'r370', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (740, 4078, 2, 3, '13. Climbing stairs', 1, 1, 1, null, null, null, null, null, 1, 1, null, ' ', ' ', ' ', ' ', 'r380', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (750, 4078, 2, 3, '14. Hopping', 1, 1, 1, null, null, null, null, null, 1, 1, null, ' ', ' ', ' ', ' ', 'r390', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (760, 4078, 2, 3, '15. Jumping', 1, 1, 1, null, null, null, null, null, 1, 1, null, ' ', ' ', ' ', ' ', 'r400', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (770, 4078, 2, 3, '16. Running', 1, 1, 1, null, null, null, null, null, 1, 1, null, ' ', ' ', ' ', ' ', 'r410', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (780, 4078, 2, 3, '17. Pushing', 1, 1, 1, null, null, null, null, null, 1, 1, null, ' ', ' ', ' ', ' ', 'r420', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (790, 4078, 2, 3, '18. Pulling', 1, 1, 1, null, null, null, null, null, 1, 1, null, ' ', ' ', ' ', ' ', 'r430', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (800, 4078, 2, 3, '19. Reaching', 1, 1, 1, null, null, null, null, null, 1, 1, null, ' ', ' ', ' ', ' ', 'r440', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (810, 4078, 2, 3, '20. Grasping', 1, 1, 1, null, null, null, null, null, 1, 1, null, ' ', ' ', ' ', ' ', 'r450', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (820, 4078, 2, 3, '21. Lifting', 1, 1, 1, null, null, null, null, null, 1, 1, null, ' ', ' ', ' ', ' ', 'r460', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (830, 4078, 2, 3, '22. Carrying', 1, 1, 1, null, null, null, null, null, 1, 1, null, ' ', ' ', ' ', ' ', 'r470', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (840, 4078, 3, 1, '1. Lying flat:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4078 and data_item=14 order by data_item', 'DATA_ID', 'r480', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (850, 4078, 3, 1, '2. Rolling over:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4078 and data_item=14 order by data_item', 'DATA_ID', 'r490', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (860, 4078, 3, 1, '3. Movinglying to sitting:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4078 and data_item=14 order by data_item', 'DATA_ID', 'r500', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (870, 4078, 3, 1, '4. Sitting:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4078 and data_item=14 order by data_item', 'DATA_ID', 'r510', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (880, 4078, 3, 1, '5. Squatting:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4078 and data_item=14 order by data_item', 'DATA_ID', 'r520', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (890, 4078, 3, 1, '6. Bending/stooping:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4078 and data_item=14 order by data_item', 'DATA_ID', 'r530', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (900, 4078, 3, 1, '7. Balancing:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4078 and data_item=14 order by data_item', 'DATA_ID', 'r540', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (910, 4078, 3, 1, '8. Kneeling:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4078 and data_item=14 order by data_item', 'DATA_ID', 'r550', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (920, 4078, 3, 1, '9. Standing:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4078 and data_item=14 order by data_item', 'DATA_ID', 'r560', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (930, 4078, 3, 1, '10. Walkingshort distance:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4078 and data_item=14 order by data_item', 'DATA_ID', 'r570', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (940, 4078, 3, 1, '11. Walkinglong distance:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4078 and data_item=14 order by data_item', 'DATA_ID', 'r580', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (950, 4078, 3, 1, '12. Walkingoutdoors:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4078 and data_item=14 order by data_item', 'DATA_ID', 'r590', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (960, 4078, 3, 1, '13. Climbing stairs:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4078 and data_item=14 order by data_item', 'DATA_ID', 'r600', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (970, 4078, 3, 1, '14. Hopping:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4078 and data_item=14 order by data_item', 'DATA_ID', 'r610', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (980, 4078, 3, 1, '15. Jumping:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4078 and data_item=14 order by data_item', 'DATA_ID', 'r620', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (990, 4078, 3, 1, '16. Running:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4078 and data_item=14 order by data_item', 'DATA_ID', 'r630', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (1000, 4078, 3, 1, '17. Pushing:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4078 and data_item=14 order by data_item', 'DATA_ID', 'r640', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (1010, 4078, 3, 1, '18. Pulling:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4078 and data_item=14 order by data_item', 'DATA_ID', 'r650', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (1020, 4078, 3, 1, '19. Reaching:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4078 and data_item=14 order by data_item', 'DATA_ID', 'r660', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (1030, 4078, 3, 1, '20. Grasping:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4078 and data_item=14 order by data_item', 'DATA_ID', 'r670', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (1040, 4078, 3, 1, '21. Lifting:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4078 and data_item=14 order by data_item', 'DATA_ID', 'r680', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (1050, 4078, 3, 1, '22. Carrying:', 4, 0, 1, null, null, null, null, null, 1, 1, null, 'INTAKE_STATIC_DATA', 'DATA_VALUE', 'mid=4078 and data_item=14 order by data_item', 'DATA_ID', 'r690', null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (5, 4082, 1, 1, ' ', 21, 0, 1, null, null, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (10, 4082, 1, 2, ' ', 21, 0, 1, null, null, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (15, 4082, 1, 3, ' ', 21, 0, 1, null, null, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (20, 4082, 1, 4, 'Number of Days:', 3, 0, 1, null, null, '?dddd', null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (25, 4082, 1, 5, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (30, 4082, 1, 6, 'Initial Interdisciplinary Rehabilitation Treatment Note', 1, 1, 1, null, null, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (35, 4082, 1, 6, 'Interim Interdisciplinary Rehabilitation Treatment Note', 1, 1, 1, null, null, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (40, 4082, 1, 6, 'Interdisciplinary Discharge Note', 1, 1, 1, null, null, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (45, 4082, 1, 7, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (50, 4082, 1, 8, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (55, 4082, 1, 9, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (60, 4082, 1, 10, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (675, 4082, 1, 11, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (65, 4082, 1, 12, 'Assistive Device:  ', 2, 2, 1, null, null, null, '''TID1_QID13''', null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (70, 4082, 1, 12, 'Functional Status:  ', 2, 2, 1, null, null, null, '''TID1_QID14''', null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (75, 4082, 1, 12, 'Equipment, Braces and Compression Garments:  ', 2, 2, 1, null, null, null, '''TID1_QID15''', null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (80, 4082, 1, 12, ' Mobility restrictions:  ', 2, 2, 1, null, null, null, '''TID1_QID16''', null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (85, 4082, 1, 12, 'Activity recommendations:', 2, 2, 1, null, null, null, '''TID1_QID17''', null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (90, 4082, 1, 12, 'Home Exercise Program:', 2, 2, 1, null, null, null, '''TID1_QID18''', null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (95, 4082, 1, 12, 'Outpatient therapy recommendations:', 2, 2, 1, null, null, null, '''TID1_QID19''', null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (100, 4082, 1, 12, 'Education:', 2, 2, 1, null, null, null, '''TID1_QID20''', null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (105, 4082, 1, 13, '  ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (110, 4082, 1, 14, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (115, 4082, 1, 15, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (120, 4082, 1, 16, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (125, 4082, 1, 17, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (130, 4082, 1, 18, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (135, 4082, 1, 19, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (140, 4082, 1, 20, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (145, 4082, 1, 21, 'Diet orders:  ', 2, 2, 1, null, null, null, '''TID1_QID22''', null, 1, 1, null, null, null, null, null, null, null);
commit;
prompt 300 records committed...
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (150, 4082, 1, 21, 'Aspiration precautions and compensatory swallow strategies:', 2, 2, 1, null, null, null, '''TID1_QID23''', null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (155, 4082, 1, 21, 'Supervision:', 2, 2, 1, null, null, null, '''TID1_QID24''', null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (160, 4082, 1, 21, 'Compensatory memory strategies:', 2, 2, 1, null, null, null, '''TID1_QID25''', null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (165, 4082, 1, 21, 'Assistance with finances:', 2, 2, 1, null, null, null, '''TID1_QID26''', null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (170, 4082, 1, 21, 'Outpatient recommendations:  ', 2, 2, 1, null, null, null, '''TID1_QID27''', null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (175, 4082, 1, 21, 'Education:', 2, 2, 1, null, null, null, '''TID1_QID28''', null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (180, 4082, 1, 21, 'Thickener packets:', 2, 2, 1, null, null, null, '''TID1_QID29''', null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (185, 4082, 1, 22, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (190, 4082, 1, 23, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (195, 4082, 1, 24, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (200, 4082, 1, 25, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (205, 4082, 1, 26, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (210, 4082, 1, 27, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (215, 4082, 1, 28, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (220, 4082, 1, 29, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (225, 4082, 1, 30, 'Functional Status:', 2, 2, 1, null, null, null, '''TID1_QID31''', null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (230, 4082, 1, 30, 'Equipment, Braces and Compression Garments: ', 2, 2, 1, null, null, null, '''TID1_QID32''', null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (235, 4082, 1, 30, 'Mobility restrictions:', 2, 2, 1, null, null, null, '''TID1_QID33''', null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (240, 4082, 1, 30, 'Activity recommendations:', 2, 2, 1, null, null, null, '''TID1_QID34''', null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (245, 4082, 1, 30, 'Meal preparation assistance:', 2, 2, 1, null, null, null, '''TID1_QID35''', null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (250, 4082, 1, 30, 'Medication management needs:', 2, 2, 1, null, null, null, '''TID1_QID36''', null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (255, 4082, 1, 30, 'Driving status: ', 2, 2, 1, null, null, null, '''TID1_QID37''', null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (260, 4082, 1, 30, 'Home Exercise Program details:', 2, 2, 1, null, null, null, '''TID1_QID38''', null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (265, 4082, 1, 30, 'Outpatient recommendations:', 2, 2, 1, null, null, null, '''TID1_QID39''', null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (270, 4082, 1, 30, 'Education:', 2, 2, 1, null, null, null, '''TID1_QID40''', null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (275, 4082, 1, 31, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (280, 4082, 1, 32, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (285, 4082, 1, 33, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (290, 4082, 1, 34, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (295, 4082, 1, 35, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (300, 4082, 1, 36, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (305, 4082, 1, 37, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (310, 4082, 1, 38, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (315, 4082, 1, 39, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (320, 4082, 1, 40, ' ', 3, 3, 1, null, 255, null, null, null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (325, 4082, 1, 41, 'Community supervision needs:', 2, 2, 1, null, null, null, '''TID1_QID42''', null, 1, 1, null, null, null, null, null, null, null);
insert into TBICDS.INTAKE_RESPONSE (RID, MID, TID, QID, RESPONSE, DISPLAY_TYPE, RESPONSE_TYPE, ACTIVE, UNIT, MAXLENGTH, MASK, SKIP_SHOW, SKIP_HIDE, LABEL_POS, RESPONSE_GROUP, SCORE_VALUE, STAT_LOAD_TABLE, STAT_LOAD_FIELD, STAT_LOAD_FILTER, STAT_LOAD_TABLE_ID, IDENTIFIER, CDE_ID)
values (330, 4082, 1, 41, 'Community leisure resources: ', 2, 2, 1, null, null, null, '''TID1_QID43''', null, 1, 1, null, null, null, null, null, null, null);
commit;


---------
--INTAKE_STATIC_DATA
-----------

insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (1, 1, 4076, '1 = Absent', 1, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (2, 1, 4076, '2 = Present to a slight degree', 2, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (3, 1, 4076, '3 = Present to a moderate degree', 3, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (4, 1, 4076, '4 = Present to an extreme degree', 4, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (1, 12, 4080, 'Able to do without any difficulty', 1, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (2, 12, 4080, 'Able to do with little difficulty', 2, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (3, 12, 4080, 'Able to do with moderate difficulty', 3, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (4, 12, 4080, 'Able to do with much difficulty', 4, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (5, 12, 4080, 'Unable to do', 5, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (12, 2, 4076, '12', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (11, 2, 4076, '11', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (10, 2, 4076, '10', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (9, 2, 4076, '9', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (8, 2, 4076, '8', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (7, 2, 4076, '7', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (6, 2, 4076, '6', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (5, 2, 4076, '5', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (4, 2, 4076, '4', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (3, 2, 4076, '3', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (2, 2, 4076, '2', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (1, 2, 4076, '1', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (60, 3, 4076, '59', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (59, 3, 4076, '58', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (58, 3, 4076, '57', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (57, 3, 4076, '56', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (56, 3, 4076, '55', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (55, 3, 4076, '54', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (54, 3, 4076, '53', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (53, 3, 4076, '52', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (52, 3, 4076, '51', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (51, 3, 4076, '50', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (50, 3, 4076, '49', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (49, 3, 4076, '48', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (48, 3, 4076, '47', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (47, 3, 4076, '46', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (46, 3, 4076, '45', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (45, 3, 4076, '44', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (44, 3, 4076, '43', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (43, 3, 4076, '42', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (42, 3, 4076, '41', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (41, 3, 4076, '40', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (40, 3, 4076, '39', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (39, 3, 4076, '38', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (38, 3, 4076, '37', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (37, 3, 4076, '36', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (36, 3, 4076, '35', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (35, 3, 4076, '34', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (34, 3, 4076, '33', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (33, 3, 4076, '32', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (32, 3, 4076, '31', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (31, 3, 4076, '30', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (30, 3, 4076, '29', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (29, 3, 4076, '28', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (28, 3, 4076, '27', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (27, 3, 4076, '26', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (26, 3, 4076, '25', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (25, 3, 4076, '24', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (24, 3, 4076, '23', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (23, 3, 4076, '22', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (22, 3, 4076, '21', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (21, 3, 4076, '20', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (20, 3, 4076, '19', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (19, 3, 4076, '18', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (18, 3, 4076, '17', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (17, 3, 4076, '16', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (16, 3, 4076, '15', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (15, 3, 4076, '14', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (14, 3, 4076, '13', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (13, 3, 4076, '12', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (12, 3, 4076, '11', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (11, 3, 4076, '10', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (10, 3, 4076, '09', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (9, 3, 4076, '08', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (8, 3, 4076, '07', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (7, 3, 4076, '06', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (6, 3, 4076, '05', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (5, 3, 4076, '04', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (4, 3, 4076, '03', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (3, 3, 4076, '02', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (2, 3, 4076, '01', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (1, 3, 4076, '00', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (2, 4, 4076, 'PM', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (1, 4, 4076, 'AM', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (6, 12, 4080, 'Not applicable', 0, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (1, 13, 4080, '1. Lying flat', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (2, 13, 4080, '2. Rolling over', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (3, 13, 4080, '3. Movinglying to sitting', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (4, 13, 4080, '4. Sitting', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (5, 13, 4080, '5. Squatting', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (6, 13, 4080, '6. Bending/stooping', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (7, 13, 4080, '7. Balancing', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (8, 13, 4080, '8. Kneeling', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (9, 13, 4080, '9. Standing', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (10, 13, 4080, '10. Walkingshort distance', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (11, 13, 4080, '11. Walkinglong distance', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (12, 13, 4080, '12. Walkingoutdoors', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (13, 13, 4080, '13. Climbing stairs', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (14, 13, 4080, '14. Hopping', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (15, 13, 4080, '15. Jumping', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (16, 13, 4080, '16. Running', null, 1);
commit;
prompt 100 records committed...
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (17, 13, 4080, '17. Pushing', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (18, 13, 4080, '18. Pulling', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (19, 13, 4080, '19. Reaching', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (20, 13, 4080, '20. Grasping', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (21, 13, 4080, '21. Lifting', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (22, 13, 4080, '22. Carrying', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (1, 14, 4080, 'Fully confident in my ability to perform', 1, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (2, 14, 4080, 'Very confident', 2, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (3, 14, 4080, 'Moderate confidence', 3, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (4, 14, 4080, 'Some confidence', 4, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (5, 14, 4080, 'Not confident in my ability to perform', 5, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (6, 14, 4080, 'Not applicable', 0, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (1, 12, 4078, 'Able to do without any difficulty', 1, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (2, 12, 4078, 'Able to do with little difficulty', 2, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (3, 12, 4078, 'Able to do with moderate difficulty', 3, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (4, 12, 4078, 'Able to do with much difficulty', 4, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (5, 12, 4078, 'Unable to do', 5, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (6, 12, 4078, 'Not applicable', 0, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (1, 13, 4078, '1. Lying flat', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (2, 13, 4078, '2. Rolling over', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (3, 13, 4078, '3. Movinglying to sitting', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (4, 13, 4078, '4. Sitting', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (5, 13, 4078, '5. Squatting', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (6, 13, 4078, '6. Bending/stooping', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (7, 13, 4078, '7. Balancing', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (8, 13, 4078, '8. Kneeling', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (9, 13, 4078, '9. Standing', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (10, 13, 4078, '10. Walkingshort distance', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (11, 13, 4078, '11. Walkinglong distance', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (12, 13, 4078, '12. Walkingoutdoors', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (13, 13, 4078, '13. Climbing stairs', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (14, 13, 4078, '14. Hopping', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (15, 13, 4078, '15. Jumping', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (16, 13, 4078, '16. Running', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (17, 13, 4078, '17. Pushing', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (18, 13, 4078, '18. Pulling', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (19, 13, 4078, '19. Reaching', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (20, 13, 4078, '20. Grasping', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (21, 13, 4078, '21. Lifting', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (22, 13, 4078, '22. Carrying', null, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (1, 14, 4078, 'Fully confident in my ability to perform', 1, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (2, 14, 4078, 'Very confident', 2, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (3, 14, 4078, 'Moderate confidence', 3, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (4, 14, 4078, 'Some confidence', 4, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (5, 14, 4078, 'Not confident in my ability to perform', 5, 1);
insert into TBICDS.INTAKE_STATIC_DATA (DATA_ID, DATA_ITEM, MID, DATA_VALUE, SCORE_VALUE, ACTIVE)
values (6, 14, 4078, 'Not applicable', 0, 1);
commit;



-------------------------------------------
-- VIEWS
-------------------------------------------

-----------------------------------------------
--  Changed view vw_utl_rpt_intake_response  --
-----------------------------------------------
create or replace view TBICDS.vw_utl_rpt_intake_response as
select t."MID",t."TID",t."QID",t."RID",t."MODULE_DESC", rownum rn from (
select mid, tid, qid, rid, (select acronym||' '||module from TBICDS.intake_module where mid = t.mid) module_desc
from TBICDS.intake_response t
where mid in (
4000,4001,4002,4004,4006,4008,4010,4012,4014,4016,
4018,4020,4022,4024,4026,4028,4030,4032,4034,4036,
4038,4040,4042,4044,4046,4048,4050,4052,4054,4056,
4058,4060,4062,4064,4066,4068,4070,4072,4074,4076,
4078,4080,4082
)
order by mid, tid, qid, rid
) t
/


---------------------------------------------
-- PACKAGES 
---------------------------------------------


---------------------------------------------
--  Changed package body pck_ap_useradmin  --
---------------------------------------------
create or replace package body tbicds.PCK_AP_USERADMIN is

/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

   /*insert a user into the system*/
   procedure InsertSuatUser (
      pi_vSessionID       in varchar2,
      pi_vSessionClientIP in varchar2,
      pi_nUserID          in number,
      pi_vProviderID      in varchar2,
      pi_nlocked          in number,
      pi_vName            in varchar2,
      pi_vRank            in varchar2,
      pi_nServiceID       in number,
      pi_vTitle           in varchar2,
      pi_vCorps           in varchar2,
      pi_vSquadron        in varchar2,
      pi_vOfficeSymbol    in varchar2,
      pi_vPhone           in varchar2,
      pi_vEmail           in varchar2,
      pi_vDimsID          in varchar2,
      pi_vUIDPWD          in varchar2,
      pi_nMustChgPwd      in number,
      pi_vSupervisorID    in varchar2,
      po_nStatusCode      out number,
      po_vStatusComment   out varchar2
      )
   is
      v_vSql                               varchar2(4000);
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
  
      v_vSql := 'insert into tbicds.app_user ('
                || 'provider_id, locked, name, rank, military_service_id, '
                || 'title, corps, unit, squadron, phone, '
                || 'email, dims_id, uidpwd, must_change_password, entry_date, '
                || 'supervisor_id) '
                || 'values ('
                || ':P0,:P1,:P2,:P3,:P4,:P5,:P6,:P7,:P8,:P9,:P10,:P11,:P12,:P13,:P14,:P15) ';
      execute immediate v_vSql using
         pi_vProviderID, pi_nLocked, pi_vName, pi_vRank, pi_nServiceID,
         pi_vTitle, pi_vCorps, pi_vSquadron, pi_vOfficeSymbol, pi_vPhone,
         pi_vEmail, pi_vDimsID, pi_vUIDPWD, pi_nMustChgPwd, sysdate,
         pi_vSupervisorID;
      commit;
  
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_AP_USERADMIN.InsertSuatUser(): ' || sqlErrm;
   end;
   
   /*update a user*/
   procedure UpdateSuatUser (
      pi_vSessionID       in varchar2,
      pi_vSessionClientIP in varchar2,
      pi_nUserID          in number,
      pi_vProviderID      in varchar2,
      pi_vCurrentDimsID   in varchar2,
      pi_nlocked          in number,
      pi_vName            in varchar2,
      pi_vRank            in varchar2,
      pi_nServiceID       in number,
      pi_vTitle           in varchar2,
      pi_vCorps           in varchar2,
      pi_vSquadron        in varchar2,
      pi_vOfficeSymbol    in varchar2,
      pi_vPhone           in varchar2,
      pi_vEmail           in varchar2,
      pi_vDimsID          in varchar2,
      pi_vUIDPWD          in varchar2,
      pi_nMustChgPwd      in number,
      pi_vSupervisorID    in varchar2,
      po_nStatusCode      out number,
      po_vStatusComment   out varchar2
      )
   is
      v_vSql                               varchar2(4000);
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      v_vSql := 'update tbicds.app_user set '
                || 'locked = :P0, '
                || 'name = :P1, '
                || 'rank = :P2, '
                || 'military_service_id = :P3, '
                || 'title = :P4, '
                || 'corps = :P5, '
                || 'unit = :P6, '
                || 'squadron = :P7, '
                || 'phone = :P8, '
                || 'email = :P9, '
                || 'dims_id = :P10, '
                || 'uidpwd = :P11, '
                || 'must_change_password = :P12, '
                || 'supervisor_id = :P13 '
                || 'where provider_id = :P14';
      execute immediate v_vSql using
         pi_nLocked, pi_vName, pi_vRank, pi_nServiceID, pi_vTitle,
         pi_vCorps, pi_vSquadron, pi_vOfficeSymbol, pi_vPhone, pi_vEmail,
         pi_vDimsID, pi_vUIDPWD, pi_nMustChgPwd, pi_vSupervisorID, pi_vProviderID;
      commit;
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_AP_USERADMIN.UpdateSuatUser(): ' || sqlErrm;
   end;

   /*Get user rights recordset*/
   procedure GetUserRightsRS (
      pi_vSessionID       in varchar2,
      pi_vSessionClientIP in varchar2,
      pi_nUserID          in number,
      po_nStatusCode      out number,
      po_vStatusComment   out varchar2,
      rs                  out sys_refcursor
      )
   is
      v_vSql                               varchar2(4000);
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
  
      --open recordset
      v_vSql := 'select * '
                || 'from tbicds.stat_user_rights '
                || 'where active = 1 '
                || 'and visible = 1 '
                || 'order by sort_order, stat_right_id';
      open rs for v_vSql;
      
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_AP_USERADMIN.GetUserRightsRS(): ' ||sqlErrm;
   end;

  /*Get user types recordset*/
   procedure GetUserTypesRS (
      pi_vSessionID       in varchar2,
      pi_vSessionClientIP in varchar2,
      pi_nUserID          in number,
      po_nStatusCode      out number,
      po_vStatusComment   out varchar2,
      rs                  out sys_refcursor
      )
   is
      v_vSql                               varchar2(4000);
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      --open recordset
      v_vSql := 'select * '
                || 'from tbicds.stat_user_types '
                || 'where active = 1 '
                || 'and visible = 1 '
                || 'order by stat_usertype_id';
      open rs for v_vSql;
   
   exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_AP_USERADMIN.GetUserTypesRS(): ' || sqlErrm;
   end;
   
   /*get suat users recordset*/
   procedure GetSUATUsersRS (
      pi_vSessionID       in varchar2,
      pi_vSessionClientIP in varchar2,
      pi_nUserID          in number,
      po_nStatusCode      out number,
      po_vStatusComment   out varchar2,
      rs                  out sys_refcursor
      )
   is
      v_vSQL varchar2(32767) := '';
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      v_vSQL := 'select t.*, t2.*, t3.user_name, t3.is_locked, t3.is_inactive ';
      v_vSQL := v_vSQL || 'from tbicds.app_user t, tbicds.fx_user_rights t2, tbicds.fx_user t3 ';
      v_vSQL := v_vSQL || 'where t2.fx_user_id = t.fx_user_id ';
      v_vSQL := v_vSQL || 'and t3.fx_user_id = t.fx_user_id ';
      v_vSQL := v_vSQL || 'and t.dims_id in (select dims_id from tbicds.app_user ';
      v_vSQL := v_vSQL || 'where fx_user_id = :USER_ID) ';
      v_vSQL := v_vSQL || 'order by t.name ';
      
      --open recordset
      open rs for v_vSQL using pi_nUserID;
   
   exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_AP_USERADMIN.GetSUATUsersRS(): ' || sqlErrm;
   end;
   
   /*get user specific permissions recordset*/
   procedure GetUserPermissionsRS (
      pi_vSessionID       in varchar2,
      pi_vSessionClientIP in varchar2,
      pi_nUserID          in number,
      pi_nRights          in number,
      po_nStatusCode      out number,
      po_vStatusComment   out varchar2,
      rs                  out sys_refcursor
      )
   is
      v_vSQL         varchar2(32767) := '';
      v_nRightsCount number := 0;
      v_nRights      number := 0;
      v_nReadOnly    number := 0;
      v_nPermissions number := 0;
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
   
      v_vSQL := 'select count(*) '
                || 'from tbicds.fx_user_rights t '
                || 'where t.fx_user_id = :P0 '
                || 'and bitand(t.user_rights, :P1) > 0';
      execute immediate v_vSQL into v_nRightsCount using pi_nUserID, pi_nRights;
      
      if (v_nRightsCount > 0) then
         v_vSQL := 'select t.user_rights, t.read_only '
                   || 'from tbicds.fx_user_rights t '
                   || 'where t.fx_user_id = :P0 '
                   || 'and bitand(t.user_rights, :P1) > 0';
         execute immediate v_vSQL into v_nRights, v_nReadOnly using pi_nUserID, pi_nRights; 
         
         if (bitand(pi_nRights, v_nReadOnly) > 0) then
            v_nPermissions := 1;
         else
            v_nPermissions := 2;
         end if;
      end if;
      
      v_vSQL := 'select :P0 as permissions from dual';
      open rs for v_vSQL using v_nPermissions;

   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_AP_USERADMIN.GetUserPermissionsRS(): ' || sqlErrm;
   end;
   
   /*get supervisors recordset*/
   procedure GetInternSupervisorsRS (
      pi_vSessionID       in varchar2,
      pi_vSessionClientIP in varchar2,
      pi_nUserID          in number,
      po_nStatusCode      out number,
      po_vStatusComment   out varchar2,
      rs                  out sys_refcursor
      )
   is
      v_vSQL varchar2(32767) := '';
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      v_vSQL := 'select * ';
      v_vSQL := v_vSQL || 'from tbicds.fx_user t1, tbicds.fx_user_rights t2, tbicds.app_user t3 ';
      v_vSQL := v_vSQL || 'where t2.fx_user_id = t1.fx_user_id ';
      v_vSQL := v_vSQL || 'and t3.fx_user_id = t1.fx_user_id ';
      v_vSQL := v_vSQL || 'and t2.user_type = 1 ';
      v_vSQL := v_vSQL || 'and t3.dims_id = (select t4.dims_id from tbicds.app_user t4 ';
      v_vSQL := v_vSQL || 'where t4.fx_user_id = :USER_ID) ';
      v_vSQL := v_vSQL || 'order by t3.name ';
      
      --open recordset
      open rs for v_vSQL using pi_nUserID;

   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_AP_USERADMIN.GetInternSupervisorsRS(): ' || sqlErrm;
   end;
   
   /*insert rights template*/
   procedure InsertRightsTemplate (
      pi_vSessionID       in varchar2,
      pi_vSessionClientIP in varchar2,
      pi_nUserID          in number,
      pi_nUserType        in number,
      pi_nUserRights      in number,
      pi_nRightsMode      in number,
      po_nStatusCode      out number,
      po_vStatusComment   out varchar2
      )
   is
      v_vSql                               varchar2(4000);
      v_nCount                             number := 0;
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
   
      v_vSql := 'select count(*) from tbicds.fx_rights_template t where t.user_type = :P0';
      execute immediate v_vSql into v_nCount using pi_nUserType;
   
      if v_nCount > 0 then
         UpdateRightsTemplate(pi_vSessionID => pi_vSessionID,
                              pi_vSessionClientIP => pi_vSessionClientIP, 
                              pi_nUserID => pi_nUserID,
                              pi_nUserType => pi_nUserType,
                              pi_nUserRights => pi_nUserRights,
                              pi_nRightsMode => pi_nRightsMode,
                              po_nStatusCode => po_nStatusCode, 
                              po_vStatusComment => po_vStatusComment);
      else
         v_vSql := 'insert into tbicds.fx_rights_template (user_type, user_rights, read_only) '
                   || 'values (:P0, :P1, :P2)';
         execute immediate v_vSql using pi_nUserType, pi_nUserRights, pi_nRightsMode;
         commit;
      end if;
   
   exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_AP_USERADMIN.InsertRightsTemplate(): ' ||
                           sqlErrm;
   end;
   
   /*update rights template*/
   procedure UpdateRightsTemplate (
      pi_vSessionID       in varchar2,
      pi_vSessionClientIP in varchar2,
      pi_nUserID          in number,
      pi_nUserType        in number,
      pi_nUserRights      in number,
      pi_nRightsMode      in number,
      po_nStatusCode      out number,
      po_vStatusComment   out varchar2
      )
   is
      v_vSql                               varchar2(4000);
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      v_vSql := 'update tbicds.fx_rights_template t set '
                || 't.user_rights = :P0, t.read_only = :P1 '
                || 'where t.user_type = :P2';
      execute immediate v_vSql using pi_nUserRights, pi_nRightsMode, pi_nUserType;
      commit;
      
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_AP_USERADMIN.UpdateRightsTemplate(): ' || sqlErrm;
   end;
   
   /*get rights template recordset*/
   procedure GetRightsTemplateRS (
      pi_vSessionID       in varchar2,
      pi_vSessionClientIP in varchar2,
      pi_nUserID          in number,
      po_nStatusCode      out number,
      po_vStatusComment   out varchar2,
      rs                  out sys_refcursor
      )
   is
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      open rs for 'select * from tbicds.fx_rights_template t';

   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_AP_USERADMIN.GetRightsTemplateRS(): ' || sqlErrm;
   end;

end;
/
---------------------------------------
--  Changed package body pck_common  --
---------------------------------------
create or replace package body tbicds.PCK_COMMON is

  /* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
  /*****
  helper function used to get age given date of birth
  *****/
  function GetAge(pi_dtDOB in date) return number 
  is
    v_nAge number;
  begin
    v_nAge := trunc(months_between(sysdate, pi_dtDOB) / 12);
    return v_nAge;
  end;

  /*
  get a piece of data from a string given the delimeter and position
  */
  function GetPiece(strData      in varchar2,
                    strDelimiter in varchar2,
                    nPosition    in NUMBER) return varchar2 
  is
  
    strWorking varchar2(4000);
    strPiece   varchar2(400);
    pos        number;
    nPos2      number;
    nCount     number;
  begin
    --the piece to return
    strPiece := '';
  
    --set working to data
    strWorking := strData;
  
    --put a delimeter on the front for parsing if needed
    if substr(strWorking, 1, 1) != strDelimiter then
      strWorking := strDelimiter || strWorking;
    end if;
  
    --put a delimeter on the end
    strWorking := strWorking || strDelimiter;
  
    --find the piece between the ~'s ie... "~piece~"
    pos    := -1;
    nCount := -1;
    while (pos != 0) loop
      pos := instr(strWorking, strDelimiter);
      if pos != 0 then
        --increment count
        nCount := nCount + 1;
        --found the piece...
        if nCount = nPosition then
          if (pos + 1 > length(strWorking) - 1) then
            --nothing
            strPiece := '';
          else
            strWorking := substr(strWorking, pos + 1);
            nPos2      := instr(strWorking, strDelimiter);
            if nPos2 = 0 then
              --last piece
              strPiece := strWorking;
              return ltrim(rtrim(strPiece));
            else
              strPiece := substr(strWorking, 0, nPos2 - 1);
              return ltrim(rtrim(strPiece));
            end if;
          end if;
        else
          strWorking := substr(strWorking, pos + 1);
        end if;
      end if;
    end loop;
  
    return ltrim(rtrim(strPiece));
  
  exception
    when others then
      return '';
  end GetPiece;

  /*join data together by delimeter and return*/ 
  function join(p_cursor sys_refcursor, p_del varchar2 := ',')
    return varchar2 
  is
    l_value  varchar2(32767);
    l_result varchar2(32767);
  begin
    loop
      fetch p_cursor into l_value;
      exit when p_cursor%notfound;
      if l_result is not null then
        l_result := l_result || p_del;
      end if;
      l_result := l_result || l_value;
    end loop;
    return l_result;
  end join;

end;
/
------------------------------------
--  Changed package body pck_cpa  --
------------------------------------
create or replace package body tbicds.PCK_CPA is

/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
/******
delete an event
******/  
procedure DeleteEvent (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vPatientID             in varchar2,
      pi_nPatPWEventID          in number,
    
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2
      )
is
    v_nTemp number := 0;
    
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    delete from pat_pw_event_entry t 
    where t.pat_pw_event_id = pi_nPatPWEventID;
    commit;
    
    delete from pat_pw_event_module t 
    where t.pat_pw_event_id = pi_nPatPWEventID;
    commit;
    
    delete from pat_pw_event t 
    where t.pat_pw_event_id = pi_nPatPWEventID;
    commit;
    
    update pat_pw_event set
      plan_pat_pw_event_id = null
    where plan_pat_pw_event_id = pi_nPatPWEventID;
    commit;
    
exception
    when others then
      rollback;
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;



/******
Check if the user can delete the event
******/  
procedure AllowEventDelete (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vPatientID             in varchar2,
      pi_nPatPWEventID          in number,
         
      po_nAllowDelete           out number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2
      )
is
    v_nTemp number := 0;
    
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    po_nAllowDelete := 1;
   
    --check the status 2 = event is closed
    select t.status into v_nTemp 
    from pat_pw_event t
    where t.pat_pw_event_id = pi_nPatPWEventID;
    if v_nTemp = 2 then
       po_nAllowDelete := 0;
       return;  
    end if;
    
    --check if the event has any completed instruments
    select count(*) into v_nTemp  
    from pat_pw_event_module t
    where t.pat_pw_event_id = pi_nPatPWEventID
    and nvl(t.intake_id,0) > 0;
    if v_nTemp > 0 then
       po_nAllowDelete := 0;
       return;  
    end if;

    --check if the event has any note text
    select count(*) into v_nTemp  
    from pat_pw_event t
    where t.pat_pw_event_id = pi_nPatPWEventID
    and t.note_text is not null
    and length( nvl(t.note_text,'') ) > 0;
    if v_nTemp > 0 then
       po_nAllowDelete := 0;
       return;  
    end if;

exception
    when others then
      rollback;
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;

/****
insert a new pat pw event
***/
procedure InsertPatPWEvent (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      
      pi_nRegionID              in number,
      pi_nSiteID                in number,
      
      pi_vPatientID             in varchar2,
      pi_nPatPWID               in number,
   
      pi_vEventTitle            in varchar2,
      pi_dtEventDate            in date,
      pi_nAdjustFuture          in number,
      
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2
      )
is
      v_nPatPWEventID number := 0;
   
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --get a new patient pathway event id
    select SEQPATPWEVENTID.nextval into v_nPatPWEventID from dual;
    
    --insert the event 
    insert into pat_pw_event
                (PATIENT_ID,
                 STATUS,
                 DATE_SCHEDULED,
                 DATE_STARTED,
                 DATE_COMPLETED,
                 REGION_ID,
                 SITE_ID,
                 PAT_PW_ID,
                 EVENT_TITLE,
                 EVENT_DESCR,
                 SORT_ORDER,
                 EVENT_FREQUENCY,
                 PW_EVENT_TYPE_ID,
                 PAT_PW_EVENT_ID,
                 CREATED_BY)
        values(pi_vPatientID,
               0,
               pi_dtEventDate,
               null,
               null,
               pi_nRegionID,
               pi_nSiteID,
               pi_nPatPWID,
               pi_vEventTitle,
               '',
               99,
               null,
               1, --scheduled
               v_nPatPWEventID,
               pi_nUserID);
        
        commit;                  
        
        --update the event just created to allow for adjust
        if pi_nAdjustFuture = 1 then
          
          UpdatePatPWEvent( pi_vSessionID,
                            pi_vSessionClientIP,
                            pi_nUserID,
                            pi_vPatientID,
                            v_nPatPWEventID,
                            
                            pi_vEventTitle,
                            pi_dtEventDate,
                            pi_nAdjustFuture,
                            
                            po_nStatusCode,
                            po_vStatusComment);
          commit;
        
        end if;
        
exception
    when others then
      rollback;
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;

/***
Update the pw event info
****/
procedure UpdatePatPWEvent (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vPatientID             in varchar2,
      pi_nPatPWEventID          in number,
      
      pi_vEventTitle            in varchar2,
      pi_dtEventDate            in date,
      pi_nAdjustFuture          in number,
      
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2
      )
is

      v_nIndex number := 0;
      
      v_dtOldScheduled date := null;
      v_nPatPWID number := 0;
      v_nDays number := 0;
      v_nEventModuleID number := 0;
   
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    v_nEventModuleID := 0;
    
    --keep the original date for calculations
    select date_scheduled, pat_pw_id 
    into v_dtOldScheduled, v_nPatPWID
    from pat_pw_event 
    where pat_pw_event_id = pi_nPatPWEventID
    and patient_id = pi_vPatientID;
    
    --update title and date
    update pat_pw_event 
    set event_title = pi_vEventTitle,
        date_scheduled = pi_dtEventDate
    where pat_pw_event_id = pi_nPatPWEventID
    and patient_id = pi_vPatientID;
    commit;
        
    --get the number of days this date is different    
    if pi_nAdjustFuture = 1 then
       
       --get the date diff 
       SELECT trunc(pi_dtEventDate)- (v_dtOldScheduled) 
         into v_nDays 
         FROM DUAL;
             
       --update all events after this event
       /*update pat_pw_event pe
          set pe.date_scheduled =  pe.date_scheduled + v_nDays
        where patient_id = pi_vPatientID
          --and pe.pat_pw_event_id > pi_nPatPWEventID
          and pe.date_scheduled > pi_dtEventDate 
          and pe.date_completed is null 
          and pe.pat_pw_id = pat_pw_id; */
       update pat_pw_event pe
          set pe.date_scheduled =  pe.date_scheduled + v_nDays
        where patient_id = pi_vPatientID
          and pe.pat_pw_event_id > pi_nPatPWEventID
          and pe.pat_pw_id = pat_pw_id;
       commit;         
      
    end if;
       
    commit;

exception
    when others then
      rollback;
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;



/*delete a scheduled module*/
procedure DeletePatPWEventModules (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      
      pi_vPatientID             in varchar2,
      pi_nPatPWEventID          in number,
      pi_vMIDS                  in varchar2,
     
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2
      )
is

      v_nIndex number := 0;
      v_vMIDPiece varchar2(4000) := ''; 
      v_nMID number := 0;   
      v_nModuleFor number := 2;
      
      v_dtOldScheduled date := null;
      v_nPatPWID number := 0;
      v_nDays number := 0;
      v_nEventModuleID number := 0;
   
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    v_nEventModuleID := 0;
    
     --loop and add modules
     loop
      
      --get one mid   
      v_vMIDPiece := pck_common.GetPiece(pi_vMIDs, ',' , v_nIndex);
      
      EXIT WHEN v_vMIDPiece is null;
            
      begin
        
           --get the mid and bump the index
           v_nMID := to_number(v_vMIDPiece);
           v_nIndex := v_nIndex +1;
           
           --only delete modules that do not have and intake_id
           delete from pat_pw_event_module t
           where t.patient_id = pi_vPatientID 
           and t.pat_pw_event_id = pi_nPatPWEventID 
           and nvl(t.intake_id,0) <= 0 
           and t.mid = v_nMID;
                                    
           commit;                                 
      
      exception
      when others then
           null;
      end;
      
     end loop;
       
    commit;

exception
    when others then
      rollback;
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;

/*****
Gets all pathway event modules associated 
with a specific patient pathway event
******/
procedure GetPWEventModuleRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vPatientID             in varchar2,
      pi_nPatPWEventID             in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is

     v_vSQL varchar2(2000) :=
      'SELECT t.*,
              t3.module, 
              t3.description, 
              t3.module_alt_lang, 
              t3.description_alt_lang, 
              t3.acronym, 
              t3.score_logic,
              
              (select nvl(tt.status,0) from
                pat_pw_event tt
                where tt.pat_pw_event_id = :PAT_PW_EVENT_ID) 
                as event_status     
              
       FROM tbicds.PAT_PW_EVENT_MODULE t,
            tbicds.intake_module t3 
            
       WHERE t.patient_id = :PATIENT_ID 
         and t.PAT_PW_EVENT_ID = :PW_EVENT_ID 
         and t3.mid = t.mid
      
       ORDER BY t.sort_order ASC';
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
     open rs 
      for v_vSQL
    using pi_nPatPWEventID,
          pi_vPatientID,
          pi_nPatPWEventID;
    
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;

/***
insert modules into the pat pw event module list
****/
procedure InsertPatPWEventModules (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      
      pi_vPatientID             in varchar2,
      pi_nPatPWEventID          in number,
      pi_vMIDS                  in varchar2,
      pi_vModuleFors            in varchar2,
     
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2
      )
is

      v_nIndex number := 0;
      v_vMIDPiece varchar2(4000) := ''; 
      v_vFORPiece varchar2(4000) := '';  
      v_nMID number := 0;   
      v_nModuleFor number := 2;
      
      v_dtOldScheduled date := null;
      v_nPatPWID number := 0;
      v_nDays number := 0;
      v_nEventModuleID number := 0;
   
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    v_nEventModuleID := 0;
    
     --loop and add modules
     loop
      
      --get one mid   
      v_vMIDPiece := pck_common.GetPiece(pi_vMIDs, ',' , v_nIndex);
      
      --get one module for
      v_vFORPiece := pck_common.GetPiece(pi_vModuleFors, ',' , v_nIndex);
      
      EXIT WHEN v_vMIDPiece is null;
            
      begin
        
           --get the mid and bump the index
           v_nMID := to_number(v_vMIDPiece);
           v_nModuleFor := to_number(v_vFORPiece);
           v_nIndex := v_nIndex +1;
           
           select SEQPATPWEVENTMODULEID.Nextval 
           into v_nEventModuleID from dual;
           
           insert into 
           pat_pw_event_module(PATIENT_ID,
                               MID,
                               STATUS,
                               REGION_ID,
                               SITE_ID,
                               DATE_STARTED,
                               DATE_COMPLETED,
                               PAT_PW_ID,
                               INTAKE_ID,
                               MODULE_FOR,
                               SORT_ORDER,
                               PAT_PW_EVENT_ID,
                               DATE_SCHEDULED,
                               PW_EVENT_MODULE_ID)
            values(pi_vPatientID,
                   
                   v_nMID,
                   
                   0,--status
                   
                   (select REGION_ID 
                    from pat_pw_event 
                    where pat_pw_event_id = pi_nPatPWEventID),
                   
                    (select SITE_ID 
                    from pat_pw_event 
                    where pat_pw_event_id = pi_nPatPWEventID),
                    
                    null, --date started
                    
                    null, --date completed
                   
                   (select PAT_PW_ID 
                    from pat_pw_event 
                    where pat_pw_event_id = pi_nPatPWEventID),
                   
                    null, --intake_id
                    
                    v_nModuleFor, --module for
                    
                    (select nvl(max(sort_order), 0) + 1 
                       from pat_pw_event_module 
                      where pat_pw_event_id = pi_nPatPWEventID),
                      
                    pi_nPatPWEventID,
                    
                    sysdate,
                    
                    v_nEventModuleID);
                                    
           commit;                                 
           
      
      exception
      when others then
           null;
      end;
      
     end loop;
       
    commit;

exception
    when others then
      rollback;
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;


/*****
Gets all clinical program area types
******/
procedure GetCPATypeRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is

     v_vSQL varchar2(500) :=
      'SELECT t.*
       FROM tbicds.CPA_Type t 
       ORDER BY upper(t.sort_order) ASC';
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
    open rs for v_vSQL;
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;


/*****
Gets all clinical program areas by region/site
******/
procedure GetCPARS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_nRegionID              in number,
      pi_nSiteID                in number,
      
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is

     v_vSQL varchar2(500) :=
      'SELECT t.*
       FROM tbicds.CPA t,
            tbicds.CPA_TYPE t2
       WHERE t.region_id = :REGION_ID
       and t.site_id = :SITE_ID 
       and t.CPA_TYPE_ID = t2.CPA_TYPE_ID 
       ORDER BY t2.sort_order ASC';
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
    open rs 
    for v_vSQL
      using pi_nRegionID, pi_nSiteID;
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;

/*****
Gets all pathways for a clinical program area 
each site has its own list of clinical program areas
******/
procedure GetCPAPWRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_nCPAID                 in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is

     v_vSQL varchar2(500) :=
      'SELECT t.*
       FROM tbicds.CPA_PW t 
       WHERE CPA_ID = :CPA_ID
       ORDER BY upper(t.PW_TITLE) ASC';
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
    open rs 
    for v_vSQL
      using pi_nCPAID;
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;

/*****
Gets all pathway events for a pathway
******/
procedure GetPWEventRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_nPWID                  in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is

     v_vSQL varchar2(500) :=
      'SELECT t.*
       FROM tbicds.CPA_PW_EVENT t 
       WHERE PW_ID = :PW_ID
       ORDER BY t.sort_order ASC';
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
    open rs 
    for v_vSQL
      using pi_nPWID;
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;


/*****
Gets all modules for a pathway event
******/
procedure GetPWEventModuleRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_nPWID                  in number,
      pi_nPWEventID             in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is

     v_vSQL varchar2(500) :=
      'SELECT t.*, 
              t2.module, 
              t2.description, 
              t2.module_alt_lang, 
              t2.description_alt_lang, 
              t2.acronym, 
              t2.score_logic 
       FROM tbicds.CPA_PW_EVENT_MODULE t,
            tbicds.intake_module t2 
       WHERE PW_ID = :PW_ID
       and PW_EVENT_ID = :PW_EVENT_ID
       and t.mid = t2.mid
       ORDER BY t.sort_order ASC';
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
    open rs 
    for v_vSQL
      using pi_nPWID,
            pi_nPWEventID;
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;


/*****
Gets all events and modules for a pathway 
******/
procedure GetPWEventAndModuleRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_nPWID                  in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is

     v_vSQL varchar2(500) :=
      'select * 
        from cpa_pw_event t1,
             cpa_pw_event_module t2,
             intake_module t3
        where t1.cpa_id = t2.cpa_id(+)
          and t1.pw_event_id = t2.pw_event_id(+)
          and t1.pw_id = t2.pw_id(+)
          and t2.mid = t3.mid(+)
          and t1.pw_id = :PW_ID   
        order by t1.sort_order ';
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
    open rs 
    for v_vSQL
      using pi_nPWID;
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;




----USER tables------------------------------------------------------

/*****
update a users default clinical program area
******/
procedure UpdateUserDefaultCPA (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_nCPAID                 in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2
      )
is

     v_vSQL varchar2(500) :=
      'UPDATE tbicds.fx_user 
       set default_cpa_id = :cpa_id
       where fx_user_id = :user_id';
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --execute the sql
    execute immediate v_vSQL 
                using pi_nUserID,
                      pi_nCPAID;
    
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;

/*****
Gets a users clinical program areas
******/
procedure GetUserCPARS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is

     v_vSQL varchar2(1024) :=
      'SELECT t.*,
              
              (select count(*) 
                 from tbicds.fx_user
                where default_cpa_id = t.cpa_id
                and fx_user_id = :FX_USER_ID) as default_cpa_id
                
         FROM tbicds.CPA t
         
        where t.region_id = (select region_id 
                            from tbicds.fx_user 
                            where fx_user_id = :FX_USER_ID)
                             
          and t.site_id = (select site_id 
                            from tbicds.fx_user 
                            where fx_user_id = :FX_USER_ID)
                            
       ORDER BY upper(t.cpa_title) ASC';
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
    open rs 
    for v_vSQL 
    using pi_nUserID,
          pi_nUserID,
          pi_nUserID;
    
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;
 
-------patient tables ----------------------------------------------


/*****
Gets all pathways associated with a patient, 
ordered by region, site and clinical program area
******/
procedure GetPatPWRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vPatientID             in varchar2,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is

     v_vSQL varchar2(500) :=
        'SELECT t.*
       FROM tbicds.PAT_PW t
       WHERE t.patient_id = :PATIENT_ID 
       ORDER BY t.region_id, 
                t.site_id,
                t.date_created DESC';
       
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
     open rs 
      for v_vSQL
    using pi_vPatientID;
    
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;

/*Check if the Event is Read-Only*/
procedure IsPatPWEventReadOnly (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vPatientID             in varchar2,
      pi_nPatPWID               in number,
      pi_nPatPWEventID          in number,
      po_nIsReadOnly            out number, --0 = False = Is Not Read Only; 1 = True = Is Read Only 
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2
      )
is

  v_nIsReadOnly number := 1; --TRUE

begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    begin
      select 
        case nvl(t.status,0) 
          when 2 then 1 --TRUE = Is Read Only
          else 0 --FALSE = Is Not Read Only
        end            
        into v_nIsReadOnly
      from pat_pw_event t
      where t.patient_id = pi_vPatientID
        and t.pat_pw_id = pi_nPatPWID
        and t.pat_pw_event_id = pi_nPatPWEventID;
    exception
      when others then
        v_nIsReadOnly := 1;
    end;
    
    po_nIsReadOnly := v_nIsReadOnly;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;

/*****
Gets all pathway events for a specific patient pathway
******/
procedure GetPatPWEventRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vPatientID             in varchar2,
      pi_nPatPWID                  in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is

     v_vSQL varchar2(4000) :=
      'SELECT  t.PATIENT_ID,	
                t.STATUS,
                t.DATE_SCHEDULED,
                t.DATE_STARTED,
                t.DATE_COMPLETED,
                t.REGION_ID,
                t.SITE_ID,
                t.PAT_PW_ID,
                t.PLAN_TEXT,
                t.PLAN_PAT_PW_EVENT_ID,
               
       decode(trim(event_title),
                                 null,

                decode(t.date_completed,
                       null,
                       '''' || to_char(date_scheduled, ''MM/DD/YYYY'' ), 
                       '''' || to_char(date_completed, ''MM/DD/YYYY'')
                       ),
                       
                decode(t.date_completed,
                       null,
                       '''' || to_char(date_scheduled, ''MM/DD/YYYY'') || '' - ('' || event_title || '')'', 
                       '''' || to_char(date_completed, ''MM/DD/YYYY'') || '' - ('' || event_title || '')''
                       ) ) as event_title,
                       
                t.EVENT_DESCR,
                t.SORT_ORDER,
                t.EVENT_FREQUENCY,
                t.PW_EVENT_TYPE_ID,
                t.PAT_PW_EVENT_ID
       
       FROM tbicds.PAT_PW_EVENT t
       WHERE t.patient_id = :PATIENT_ID 
       and t.pat_pw_id = :PAT_PW_ID
       ORDER BY nvl(t.DATE_COMPLETED,t.DATE_SCHEDULED) ASC';
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
     open rs 
      for v_vSQL
    using pi_vPatientID,
          pi_nPatPWID;
    
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;

/*****
Gets all pathway events associated with a patient
******/
procedure GetPatPWEventRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vPatientID             in varchar2,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is

     v_vSQL varchar2(1500) :=
       
        'SELECT  t.PATIENT_ID,	
                t.STATUS,
                t.DATE_SCHEDULED,
                t.DATE_STARTED,
                t.DATE_COMPLETED,
                t.REGION_ID,
                t.SITE_ID,
                t.PAT_PW_ID,
                t.PLAN_TEXT,
                t.PLAN_PAT_PW_EVENT_ID,
               
                decode(trim(event_title),
                                 null,

                decode(t.date_completed,
                       null,
                       '''' || to_char(date_scheduled, ''MM/DD/YYYY'' ), 
                       '''' || to_char(date_completed, ''MM/DD/YYYY'')
                       ),
                       
                decode(t.date_completed,
                       null,
                       '''' || to_char(date_scheduled, ''MM/DD/YYYY'') || '' - ('' || event_title || '')'', 
                       '''' || to_char(date_completed, ''MM/DD/YYYY'') || '' - ('' || event_title || '')''
                       ) ) as event_title,
       
                t.EVENT_DESCR,
                t.SORT_ORDER,
                t.EVENT_FREQUENCY,
                t.PW_EVENT_TYPE_ID,
                t.PAT_PW_EVENT_ID

       FROM tbicds.PAT_PW_EVENT t
       WHERE t.patient_id = :PATIENT_ID 
         ORDER BY t.DATE_SCHEDULED ASC';
       
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
     open rs 
      for v_vSQL
    using pi_vPatientID;
    
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;

/*****
Gets one pathway event associated with a patient
******/
procedure GetPatPWEventRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vPatientID             in varchar2,
      pi_nPatPWEventID          in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is

     v_vSQL varchar2(1500) :=
       
        'SELECT t.PATIENT_ID,	
                t.STATUS,
                t.DATE_SCHEDULED,
                t.DATE_STARTED,
                t.DATE_COMPLETED,
                t.REGION_ID,
                t.SITE_ID,
                t.PAT_PW_ID,
                t.event_title,
                t.EVENT_DESCR,
                t.SORT_ORDER,
                t.EVENT_FREQUENCY,
                t.PW_EVENT_TYPE_ID,
                t.PAT_PW_EVENT_ID,
                t.PLAN_PAT_PW_EVENT_ID,
                t.PLAN_TEXT,
                t.NOTE_TEXT,
                t.TIU_DFN,
                t.TIU_DUZ,
                t.TIU_ENCOUNTER_ID,
                t.TIU_CONSULT_IEN,
                t.TIU_COSIGNER_DUZ,
                t.TIU_NOTE_TITLE_IEN,
                t.TIU_NOTE,
                t.TIU_CLINIC_ID,
                t.TIU_DATE_SUBMITTED,
                t.TIU_ENCOUNTER_TYPE,
                t.TIU_NOTE_TITLE,
                t.TIU_LOCATION,
                t.TIU_COSIGNER,
                t.TIU_NOTE_ID,
                t.TIU_CONSULT
                
       FROM tbicds.PAT_PW_EVENT t
       WHERE t.patient_id = :PATIENT_ID 
         and t.pat_pw_event_id = :PAT_PW_EVENT_ID 
         ORDER BY t.DATE_SCHEDULED ASC';
       
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
     open rs 
      for v_vSQL
    using pi_vPatientID,
          pi_nPatPWEventID;
    
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;




/*****
Gets all pathway event modules associated 
with a specific patient pathway event
******/
procedure GetPatPWEventModuleRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vPatientID             in varchar2,
      pi_nPatPWID               in number,
      pi_nPatPWEventID             in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is

     v_vSQL varchar2(1000) :=
      'SELECT t.*,
              t3.module, 
              t3.description, 
              t3.module_alt_lang, 
              t3.description_alt_lang, 
              t3.acronym, 
              t3.score_logic,
              
              (select nvl(tt.status,0) from
                pat_pw_event tt
                where tt.pat_pw_event_id = :PAT_PW_EVENT_ID) 
                as event_status     
              
       FROM tbicds.PAT_PW_EVENT_MODULE t,
            tbicds.intake_module t3 
            
       WHERE t.patient_id = :PATIENT_ID 
         and t.PAT_PW_ID  = :PAT_PW_ID 
         and t.PAT_PW_EVENT_ID = :PW_EVENT_ID 
         
         and t3.mid = t.mid
         
       ORDER BY t.sort_order ASC';
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
     open rs 
      for v_vSQL
    using pi_nPatPWEventID,
          pi_vPatientID,
          pi_nPatPWID,
          pi_nPatPWEventID;
    
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;

/*get all modules for a patient pw event*/
procedure GetPatPWEventModuleRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vPatientID             in varchar2,
      pi_nPatPWEventID             in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is

     v_vSQL varchar2(1000) :=
      'SELECT t.*,
              t3.module, 
              t3.description, 
              t3.module_alt_lang, 
              t3.description_alt_lang, 
              t3.acronym, 
              t3.score_logic   
              
       FROM tbicds.PAT_PW_EVENT_MODULE t,
            tbicds.intake_module t3 
            
       WHERE t.patient_id = :PATIENT_ID 
         and t.PAT_PW_EVENT_ID = :PW_EVENT_ID 
         
         and t3.mid = t.mid
         
       ORDER BY t.sort_order ASC';
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
     open rs 
      for v_vSQL
    using pi_vPatientID,
          pi_nPatPWEventID;
    
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;

/*****
Gets all pathway event modules associated with a patient 
******/
procedure GetPatPWEventModuleRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vPatientID             in varchar2,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is

     v_vSQL varchar2(1000) :=
       'SELECT t.*, 
              
              t3.module, 
              t3.description, 
              t3.module_alt_lang, 
              t3.description_alt_lang, 
              t3.acronym, 
              t3.score_logic   
              
       FROM tbicds.PAT_PW_EVENT_MODULE t,
            tbicds.intake_module t3 
            
       WHERE t.patient_id = :PATIENT_ID 
         
         and t3.mid = t.mid
         
       ORDER BY t.pat_pw_id, t.pat_pw_event_id, t.sort_order ASC';
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
     open rs 
      for v_vSQL
    using pi_vPatientID;
    
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;

-------------------------------TODO: operations--------------------------------

procedure ApplyDefaultPathway (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      
      pi_vPatientID             in varchar2,
      pi_nRegionID              in number,
      pi_nSiteID                in number,
      
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2
      )
is
     v_nPatPWID   number := 0;
     v_nPWID      number := 0;
     v_nCPAID      number := 0;
     
     v_vSQL varchar2(4000) := '';

     v_vPWSelectSQL varchar2(1000) :=
        'select t.*
           from CPA_PW t
          where t.PW_ID = :PW_ID';  
          
     v_vPWEventSelectSQL varchar2(1000) :=
        'select t.*
           from CPA_PW_EVENT t 
          where t.PW_ID = :PW_ID
          order by sort_order asc';   
          
      v_vPWEventModuleSelectSQL varchar2(1000) :=
        'select t.*
           from CPA_PW_EVENT_MODULE t 
          where t.PW_ID = :PW_ID
          order by sort_order asc';    
          
      v_rsPWSelect  refCursor;
      v_rsPWEventSelect  refCursor;
      v_rsPWEventModuleSelect  refCursor;    
               
      v_recPWSelect  tbicds.cpa_pw%ROWTYPE;
      v_recPWEventSelect tbicds.cpa_pw_event%ROWTYPE;
      v_recPWEventModuleSelect tbicds.cpa_pw_event_module%ROWTYPE;
               
      v_nPatPWEventID number := 0;
      v_nCount number := 0;
      
      v_dtSched date := null;
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --the the one and only open pathway for this site
    select pw_id, cpa_id into v_nPWID, v_nCPAID from cpa_pw t
    where t.pw_type_id = 3
    and t.region_id = pi_nRegionID
    and t.site_id = pi_nSiteID 
    and rownum = 1;    
    
    --only apply if it doesnt exist!
    select count(*) into v_nCount 
    from pat_pw
    where patient_id = pi_vPatientID;
    
    if v_nCount > 0 then
      return;
    end if;
  
     --open the select recordsets
    open v_rsPWSelect for v_vPWSelectSQL using v_nPWID;
    open v_rsPWEventSelect for v_vPWEventSelectSQL using v_nPWID;
    open v_rsPWEventModuleSelect for v_vPWEventModuleSelectSQL using v_nPWID;
    
    --get a new patient pathway id
    select SEQPATPWID.nextval into v_nPatPWID from dual;
    
    --loop and copy pathway, should only be onw record
    LOOP
         v_recPWSelect := null;
         FETCH v_rsPWSelect INTO v_recPWSelect;
         EXIT WHEN NOT v_rsPWSelect%found;
  
         --add a record to the patient pathway table
         insert into tbicds.pat_pw
                (PATIENT_ID,
                 DATE_CREATED,
                 CREATED_BY,
                 STATUS,
                 PW_TYPE_ID,
                 REGION_ID,
                 SITE_ID,
                 PAT_PW_ID,
                 PW_TITLE,
                 PW_DESCR,
                 PW_ID,
                 CPA_ID)
         values(pi_vPatientID,
                sysdate,
                pi_nUserID,
                1, --1 = open
                v_recPWSelect.pw_type_id,
                v_recPWSelect.region_id,
                v_recPWSelect.site_id,
                v_nPatPWID,
                v_recPWSelect.pw_title,
                v_recPWSelect.pw_descr,
                v_nPWID,
                v_nCPAID);         
         
         commit;                             

    END LOOP;
    CLOSE v_rsPWSelect;
    
    --get a new patient pathway id
    select SEQPATPWEVENTID.nextval into v_nPatPWEventID from dual;
    v_dtSched := sysdate;
          
    --loop and copy pathway event
    LOOP
         v_recPWEventSelect := null;
         FETCH v_rsPWEventSelect INTO v_recPWEventSelect;
         EXIT WHEN NOT v_rsPWEventSelect%found;
         
         
         
         insert into pat_pw_event
                (PATIENT_ID,
                 STATUS,
                 DATE_SCHEDULED,
                 DATE_STARTED,
                 DATE_COMPLETED,
                 REGION_ID,
                 SITE_ID,
                 PAT_PW_ID,
                 EVENT_TITLE,
                 EVENT_DESCR,
                 SORT_ORDER,
                 EVENT_FREQUENCY,
                 PW_EVENT_TYPE_ID,
                 PAT_PW_EVENT_ID,
                 CREATED_BY)
        values(pi_vPatientID,
               0,
               v_dtSched,
               null,
               null,
               v_recPWEventSelect.REGION_ID,
               v_recPWEventSelect.SITE_ID,
               v_nPatPWID,
               --v_recPWEventSelect.EVENT_TITLE,
               --to_char(v_dtSched),
               '', --no title for default pathway
               v_recPWEventSelect.EVENT_DESCR,
               v_recPWEventSelect.SORT_ORDER,
               v_recPWEventSelect.EVENT_FREQUENCY,
               v_recPWEventSelect.PW_EVENT_TYPE_ID,
               v_nPatPWEventID,
               pi_nUserID);
        
        commit;                  

    END LOOP;
    CLOSE v_rsPWEventSelect;
        
    --no modules for open pathway
    
    commit;

exception
    when others then
      rollback;
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;

/*
merge pathway events and modules
*/
procedure MergePathwayEvents (
      pi_vPatientID             in varchar2,
      pi_nPatPWID               in number,
      po_nMerged                out number
      )
is
      v_rsPatPWEvent  refCursor; 
      v_recPatPWEvent tbicds.pat_pw_event%ROWTYPE;
      v_nCount number := 0;
begin

    po_nMerged := 0;
       
    --update the base pathway (the first selected), 
    --move all mids from others matching freq and delete
    --the merged events and modules
    --MERGED = 1 moves to MERGED = 2
    open v_rsPatPWEvent for
    
          select * from PAT_PW_EVENT t 
          where pat_pw_id = pi_nPatPWID
          and MERGED = 1
          and patient_id = pi_vPatientID
          order by event_frequency asc; 
          
     LOOP
         --fetch a record for work   
         v_recPatPWEvent := null;
         FETCH v_rsPatPWEvent INTO v_recPatPWEvent;
         EXIT WHEN NOT v_rsPatPWEvent%found;
         
         begin
           
           insert into pat_pw_event_module
                   (PATIENT_ID,
                    MID,
                    STATUS,
                    REGION_ID,
                    SITE_ID,
                    DATE_STARTED,
                    DATE_COMPLETED,
                    PAT_PW_ID,
                    INTAKE_ID,
                    MODULE_FOR,
                    SORT_ORDER,
                    PAT_PW_EVENT_ID,
                    DATE_SCHEDULED,
                    merged,
                    PW_EVENT_MODULE_ID) 
         
           (select pem.PATIENT_ID,
                   pem.MID,
                   pem.STATUS,
                   pem.REGION_ID,
                   pem.SITE_ID,
                   pem.DATE_STARTED,
                   pem.DATE_COMPLETED,
                   pem.PAT_PW_ID,
                   pem.INTAKE_ID,
                   pem.MODULE_FOR,
                   9999 as SORT_ORDER,
                   v_recPatPWEvent.PAT_PW_EVENT_ID as PAT_PW_EVENT_ID,
                   pem.DATE_SCHEDULED,
                   1 as merged,
                   pem.PW_EVENT_MODULE_ID
                   
              from pat_pw_event_module pem
              
             where pem.pat_pw_id = pi_nPatPWID
             
               and pem.patient_id = pi_vPatientID
               
               and pem.pat_pw_event_id 
                   in (select pat_pw_event_id
                         from pat_pw_event ppe
                        where ppe.pat_pw_id = pi_nPatPWID
                          and ppe.patient_id = pi_vPatientID
                          and ppe.MERGED = 0 
                          and ppe.event_frequency = v_recPatPWEvent.event_frequency
                       ));
             commit;                   
       
           exception
           when others then 
             --dupes wont go but thats ok so press on
             null;
           end;
           
           
           --delete all dupes
           delete 
           from PAT_PW_EVENT_MODULE a
           where pat_pw_id = pi_nPatPWID
             and patient_id = pi_vPatientID
             and PAT_PW_EVENT_ID = v_recPatPWEvent.PAT_PW_EVENT_ID
             and a.rowid > 
             any 
               (select b.rowid from PAT_PW_EVENT_MODULE b
                 where pat_pw_id = pi_nPatPWID
                 and patient_id = pi_vPatientID
                 and PAT_PW_EVENT_ID = v_recPatPWEvent.PAT_PW_EVENT_ID
                 and a.mid = b.mid);
      
     END LOOP;
    
     --first pass done so now delete processed records
     --delete the modules merged
     delete from pat_pw_event_module t
     where t.pat_pw_id = pi_nPatPWID
     and patient_id = pi_vPatientID
     and pat_pw_event_id in 
          (select pat_pw_event_id
            from pat_pw_event
           where pat_pw_id = pi_nPatPWID
             and patient_id = pi_vPatientID
             and MERGED = 0 
             and event_frequency in
             ( select event_frequency
               from pat_pw_event
               where MERGED = 1 
               and pat_pw_id = pi_nPatPWID
               and patient_id = pi_vPatientID));
      commit;
      
      --delete the events merged 
      delete from pat_pw_event t
      where t.pat_pw_id = pi_nPatPWID
      and patient_id = pi_vPatientID
      and pat_pw_event_id in 
          (select pat_pw_event_id
            from pat_pw_event
           where pat_pw_id = pi_nPatPWID
             and patient_id = pi_vPatientID
             and MERGED = 0 
             and event_frequency in
             ( select event_frequency
               from pat_pw_event
               where MERGED = 1 
               and pat_pw_id = pi_nPatPWID
               and patient_id = pi_vPatientID));
       commit;
       
       --now mark the merged base to 2
       --2 means all merged so dont have to process anymore
       update pat_pw_event t
       set t.MERGED = 2
       where t.pat_pw_id = pi_nPatPWID
       and patient_id = pi_vPatientID
       and t.MERGED = 1;
       commit;
       
       --now update for the next set to merge
       update PAT_PW_EVENT pe
       set pe.merged = 1 
       where pe.pat_pw_id = pi_nPatPWID
         and pe.patient_id = pi_vPatientID
          
         and pe.event_frequency in 
             (select t.event_frequency 
                 from PAT_PW_EVENT t 
                where t.pat_pw_id = pi_nPatPWID
                  and t.patient_id = pi_vPatientID
                  and t.merged != 2
                 
                  and (select count(*) 
                         from PAT_PW_EVENT t2 
                        where t2.pat_pw_id = pi_nPatPWID
                          and t2.patient_id = pi_vPatientID
                          and t2.merged != 2
                          and t2.event_frequency = t.event_frequency 
                     group by t2.event_frequency) > 1 )
         
         and rownum = 1;
         commit;
  
       
       --do we still have work to do?
       select count(*) into v_nCount
       from pat_pw_event t 
       where t.pat_pw_id = pi_nPatPWID
       and t.patient_id = pi_vPatientID
       and t.MERGED = 1;
       
       if v_nCount < 1 then
         po_nMerged := 1; --all done
       else
         po_nMerged := 0; --more to do
       end if;
       
exception
    when others then
      rollback;
      po_nMerged := 1;
      
end;

/******
apply a pathway/schedule to a patient
******/  
procedure ApplyPathway (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vPatientID             in varchar2,
      
      pi_vPWIDs                 in varchar2,
      pi_vPWTitle               in varchar2,
      pi_dtBaseline             in date,
      
      po_nPatPWID               out number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2
      )
is
     v_nPatPWID   number := 0;
     
     v_vSQL varchar2(4000) := '';

     v_vPWSelectSQL varchar2(1000) :=
        'select t.*
           from CPA_PW t
          where t.PW_ID = :PW_ID';  
          
     v_vPWEventSelectSQL varchar2(1000) :=
        'select t.*
           from CPA_PW_EVENT t 
          where t.PW_ID = :PW_ID 
          order by sort_order asc';  
       
          
      v_vPWEventModuleSelectSQL varchar2(1000) :=
        'select t.*
           from CPA_PW_EVENT_MODULE t 
          where t.PW_ID = :PW_ID
          order by sort_order asc';    
          
      v_rsPWSelect  refCursor;
      v_rsPWEventSelect  refCursor;
      v_rsPWEventModuleSelect  refCursor;  
      
      v_rsPatPWEvent  refCursor; 
      v_recPatPWEvent tbicds.pat_pw_event%ROWTYPE;
       
      
      v_recPWSelect  tbicds.cpa_pw%ROWTYPE;
      v_recPWEventSelect tbicds.cpa_pw_event%ROWTYPE;
      v_recPWEventModuleSelect tbicds.cpa_pw_event_module%ROWTYPE;
    
      v_nCPAID number := 0;  
      v_nPWID number := 0;       
      v_nPatPWEventID number := 0;  
      
      v_dtScheduled date := null;
      v_nEventFrequency number := 0;
      v_nIndex number := 0;
      v_vPiece varchar2(4000) := '';
      
      v_nPWRecordInserted number := 0;
     
      --fisrt pw_id is always the master for combining
      v_nMaster number := 0;
      v_nMerged number := 0;
      
      v_nEventModuleID number := 0;
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    po_nPatPWID := 0;
    v_nPWID := 0;
    
    
    --get a new patient pathway id
    select SEQPATPWID.nextval into v_nPatPWID from dual;
      
    loop
      
      --get one pathway id   
      v_vPiece := pck_common.GetPiece(pi_vPWIDs, ',' , v_nIndex);
      EXIT WHEN v_vPiece is null;
      
      --bump the index
      v_nIndex := v_nIndex + 1;
    
      --convert the piece to a PW_ID number
      v_nPWID := to_number(v_vPiece);
      
      --get the cpa id
      select cpa_id into v_nCPAID
      from cpa_pw cp
      where cp.pw_id = v_nPWID;      
    
      --open the select recordsets
      open v_rsPWSelect for v_vPWSelectSQL using v_nPWID;
      open v_rsPWEventSelect for v_vPWEventSelectSQL using v_nPWID;
       
      --first record in list is used for pw insert
      v_recPWSelect := null;
      FETCH v_rsPWSelect INTO v_recPWSelect;
      if v_nPWRecordInserted = 0 then 
        
         --add a record to the patient pathway table
         insert into tbicds.pat_pw
                  (PATIENT_ID,
                   DATE_CREATED,
                   CREATED_BY,
                   STATUS,
                   PW_TYPE_ID,
                   REGION_ID,
                   SITE_ID,
                   PAT_PW_ID,
                   PW_TITLE,
                   PW_DESCR,
                   CPA_ID,
                   PW_ID)
           values(pi_vPatientID,
                  sysdate,
                  pi_nUserID,
                  1, --1 = open
                  v_recPWSelect.pw_type_id,
                  v_recPWSelect.region_id,
                  v_recPWSelect.site_id,
                  v_nPatPWID,
                  pi_vPWTitle,
                  v_recPWSelect.pw_descr,
                  v_nCPAID,
                  v_nPWID);         
           
           commit;           
           v_nPWRecordInserted := 1;
           v_nMaster := 1;
      else
           v_nMaster := 0;
      end if;
      CLOSE v_rsPWSelect;
      
      --loop and copy pathway event
      LOOP
           --fetch a record for work   
           v_recPWEventSelect := null;
           FETCH v_rsPWEventSelect INTO v_recPWEventSelect;
           EXIT WHEN NOT v_rsPWEventSelect%found;
           
           --get a new patient pathway id
           select SEQPATPWEVENTID.nextval into v_nPatPWEventID from dual;
           
           --calculate the estimated schedule date based 
           --on the baseline and interval
           v_dtScheduled := null;
           v_nEventFrequency := v_recPWEventSelect.EVENT_FREQUENCY;
           if v_nEventFrequency > 0 then
              v_dtScheduled := pi_dtBaseline + v_nEventFrequency;
           else
              v_dtScheduled := pi_dtBaseline;
           end if;
           
           --insert the event
           insert into pat_pw_event
                  (PATIENT_ID,
                   STATUS,
                   DATE_SCHEDULED,
                   DATE_STARTED,
                   DATE_COMPLETED,
                   REGION_ID,
                   SITE_ID,
                   PAT_PW_ID,
                   EVENT_TITLE,
                   EVENT_DESCR,
                   SORT_ORDER,
                   EVENT_FREQUENCY,
                   PW_EVENT_TYPE_ID,
                   PAT_PW_EVENT_ID,
                   MERGED,
                   CREATED_BY)
          values(pi_vPatientID,
                 0,
                 v_dtScheduled,
                 null,
                 null,
                 v_recPWEventSelect.REGION_ID,
                 v_recPWEventSelect.SITE_ID,
                 v_nPatPWID,
                 v_recPWEventSelect.EVENT_TITLE,
                 v_recPWEventSelect.EVENT_DESCR,
                 v_recPWEventSelect.SORT_ORDER,
                 v_recPWEventSelect.EVENT_FREQUENCY,
                 v_recPWEventSelect.PW_EVENT_TYPE_ID,
                 v_nPatPWEventID,
                 v_nMaster,
                 pi_nUserID);
          
         commit;            
                   
         --loop and copy pathway event module
         open v_rsPWEventModuleSelect for v_vPWEventModuleSelectSQL using v_nPWID;
         LOOP
           v_recPWEventModuleSelect := null;
           FETCH v_rsPWEventModuleSelect INTO v_recPWEventModuleSelect;
           EXIT WHEN NOT v_rsPWEventModuleSelect%found;
    
         if v_recPWEventModuleSelect.PW_ID = v_recPWEventSelect.PW_ID
             and v_recPWEventModuleSelect.PW_EVENT_ID = v_recPWEventSelect.PW_EVENT_ID
         then   
           
           select SEQPATPWEVENTMODULEID.Nextval 
           into v_nEventModuleID from dual;
              
           insert into pat_pw_event_module
                  ( PATIENT_ID,
                    MID,
                    STATUS,
                    REGION_ID,
                    SITE_ID,
                    DATE_STARTED,
                    DATE_COMPLETED,
                    PAT_PW_ID,
                    INTAKE_ID,
                    MODULE_FOR,
                    SORT_ORDER,
                    DATE_SCHEDULED,
                    PAT_PW_EVENT_ID,
                    PW_EVENT_MODULE_ID)
           values( pi_vPatientID,
                  v_recPWEventModuleSelect.MID,
                  0,
                  v_recPWEventModuleSelect.REGION_ID,
                  v_recPWEventModuleSelect.SITE_ID,
                  null,
                  null,
                  v_nPatPWID,
                  null,
                  v_recPWEventModuleSelect.MODULE_FOR,
                  v_recPWEventModuleSelect.SORT_ORDER,
                  v_dtScheduled,
                  v_nPatPWEventID,
                  v_nEventModuleID);

           commit;  
         
         end if;
         
         END LOOP;
         CLOSE v_rsPWEventModuleSelect;
         
     
      END LOOP;
      --CLOSE v_rsPWEventSelect;
    
    END LOOP;   
    
    --merge pathway events
    v_nMerged := 0;
    LOOP
    EXIT WHEN v_nMerged = 1;
    
        MergePathwayEvents(pi_vPatientID, v_nPatPWID, v_nMerged);
    
    END LOOP;
        
    --return the patient pathway id
    po_nPatPWID := v_nPatPWID;
           
    commit;

exception
    when others then
      rollback;
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;

/***
Insert pathway event
***/
procedure InsertPathwayEvent (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vPatientID             in varchar2,
      pi_nPWID                  in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is

     v_vSQL varchar2(1000) :=
       'SELECT t.*, 
              
              t2.module_for, 
              t2.sort_order,
              
              t3.module, 
              t3.description, 
              t3.module_alt_lang, 
              t3.description_alt_lang, 
              t3.acronym, 
              t3.score_logic   
              
       FROM tbicds.PAT_PW_EVENT_MODULE t,
            tbicds.CPA_PW_EVENT_MODULE t2,
            tbicds.intake_module t3 
            
       WHERE t.patient_id = :PATIENT_ID 
         
         and t2.PW_ID = t.PW_ID
         and t2.PW_EVENT_ID = t.PW_EVENT_ID 
         and t2.MID = t.MID
         
         and t3.mid = t.mid
         
       ORDER BY t.cpa_id, t.pw_id, t.pw_event_id, t2.sort_order ASC';
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
     open rs 
      for v_vSQL
    using pi_vPatientID;
    
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;

/***
Insert pat pw event modules
***/
procedure InsertPatPWEventModules (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vPatientID             in varchar2,
      pi_nPatPWEventID          in number,
      pi_vMIDS                  in varchar2,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2
      )
is

      v_nIndex number := 0;
      v_vPiece varchar2(4000) := '';   
      v_nMID number := 0;   
   
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
     loop
      
      --get one mid   
      v_vPiece := pck_common.GetPiece(pi_vMIDs, ',' , v_nIndex);
      EXIT WHEN v_vPiece is null;
            
      begin
        
           --get the mid and bump the index
           v_nMID := to_number(v_vPiece);
           v_nIndex := v_nIndex +1;
           
           insert into 
           pat_pw_event_module(PATIENT_ID,
                                    MID,
                                    STATUS,
                                    REGION_ID,
                                    SITE_ID,
                                    DATE_STARTED,
                                    DATE_COMPLETED,
                                    PAT_PW_ID,
                                    INTAKE_ID,
                                    MODULE_FOR,
                                    SORT_ORDER,
                                    PAT_PW_EVENT_ID,
                                    DATE_SCHEDULED)
            values(pi_vPatientID,
                   
                   v_nMID,
                   
                   0,
                   
                   (select REGION_ID 
                    from pat_pw_event 
                    where pat_pw_event_id = pi_nPatPWEventID),
                   
                    (select SITE_ID 
                    from pat_pw_event 
                    where pat_pw_event_id = pi_nPatPWEventID),
                    
                    null,
                    null,
                   
                   (select PAT_PW_ID 
                    from pat_pw_event 
                    where pat_pw_event_id = pi_nPatPWEventID),
                   
                    null,
                    1,
                    9999999,
                    pi_nPatPWEventID,
                    sysdate);
                                    
           commit;                                 
           
      
      exception
      when others then
           null;
      end;
      
     end loop;
   
    
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;

/***
Update the pw event module list
****/
procedure UpdatePatPWEventModules (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vPatientID             in varchar2,
      pi_nPatPWEventID          in number,
      
      pi_vEventTitle            in varchar2,
      pi_dtEventDate            in date,
      pi_nAdjustFuture          in number,
      
      pi_vMIDS                  in varchar2,
      pi_vModuleFors            in varchar2,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2
      )
is

      v_nIndex number := 0;
      v_vMIDPiece varchar2(4000) := ''; 
      v_vFORPiece varchar2(4000) := '';  
      v_nMID number := 0;   
      v_nModuleFor number := 2;
      
      v_dtOldScheduled date := null;
      v_nPatPWID number := 0;
      v_nDays number := 0;
      v_nEventModuleID number := 0;
   
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    v_nEventModuleID := 0;
    
    --keep the original date for calculations
    select date_scheduled, pat_pw_id 
    into v_dtOldScheduled, v_nPatPWID
    from pat_pw_event 
    where pat_pw_event_id = pi_nPatPWEventID
    and patient_id = pi_vPatientID;
    
    --update title and date
    update pat_pw_event 
    set event_title = pi_vEventTitle,
        date_scheduled = pi_dtEventDate
    where pat_pw_event_id = pi_nPatPWEventID
    and patient_id = pi_vPatientID;
    commit;
        
    --get the number of days this date is different    
    if pi_nAdjustFuture = 1 then
       
       --get the date diff
       SELECT trunc(pi_dtEventDate)- (v_dtOldScheduled) 
         into v_nDays 
         FROM DUAL;
        
       --update all events after this event
       update pat_pw_event pe
          set pe.date_scheduled =  pe.date_scheduled + v_nDays
        where patient_id = pi_vPatientID
          and pe.pat_pw_event_id > pi_nPatPWEventID
          and pe.pat_pw_id = pat_pw_id;
       commit;         
      
    end if;
    
    --remove all the current modules, will update below
    delete from pat_pw_event_module pem 
    where pem.pat_pw_event_id = pi_nPatPWEventID
    and pem.patient_id = pi_vPatientID 
    and pem.intake_id is null;
    
    --loop and add modules
     loop
      
      --get one mid   
      v_vMIDPiece := pck_common.GetPiece(pi_vMIDs, ',' , v_nIndex);
      
      --get one module for
      v_vFORPiece := pck_common.GetPiece(pi_vModuleFors, ',' , v_nIndex);
      
      EXIT WHEN v_vMIDPiece is null;
            
      begin
        
           --get the mid and bump the index
           v_nMID := to_number(v_vMIDPiece);
           v_nModuleFor := to_number(v_vFORPiece);
           v_nIndex := v_nIndex +1;
           
           select SEQPATPWEVENTMODULEID.Nextval 
           into v_nEventModuleID from dual;
           
           insert into 
           pat_pw_event_module(PATIENT_ID,
                               MID,
                               STATUS,
                               REGION_ID,
                               SITE_ID,
                               DATE_STARTED,
                               DATE_COMPLETED,
                               PAT_PW_ID,
                               INTAKE_ID,
                               MODULE_FOR,
                               SORT_ORDER,
                               PAT_PW_EVENT_ID,
                               DATE_SCHEDULED,
                               PW_EVENT_MODULE_ID)
            values(pi_vPatientID,
                   
                   v_nMID,
                   
                   0,--status
                   
                   (select REGION_ID 
                    from pat_pw_event 
                    where pat_pw_event_id = pi_nPatPWEventID),
                   
                    (select SITE_ID 
                    from pat_pw_event 
                    where pat_pw_event_id = pi_nPatPWEventID),
                    
                    null, --date started
                    
                    null, --date completed
                   
                   (select PAT_PW_ID 
                    from pat_pw_event 
                    where pat_pw_event_id = pi_nPatPWEventID),
                   
                    null, --intake_id
                    
                    v_nModuleFor, --module for
                    
                    (select nvl(max(sort_order), 0) + 1 
                       from pat_pw_event_module 
                      where pat_pw_event_id = pi_nPatPWEventID),
                      
                    pi_nPatPWEventID,
                    
                    sysdate,
                    
                    v_nEventModuleID);
                                    
           commit;                                 
           
      
      exception
      when others then
           null;
      end;
      
     end loop;
   
    
    commit;

exception
    when others then
      rollback;
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;

/*update a pathway event module*/
procedure UpdatePathwayEventModule (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vPatientID             in varchar2,
      pi_nPWID                  in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is

     v_vSQL varchar2(1000) :=
       'SELECT t.*, 
              
              t2.module_for, 
              t2.sort_order,
              
              t3.module, 
              t3.description, 
              t3.module_alt_lang, 
              t3.description_alt_lang, 
              t3.acronym, 
              t3.score_logic   
              
       FROM tbicds.PAT_PW_EVENT_MODULE t,
            tbicds.CPA_PW_EVENT_MODULE t2,
            tbicds.intake_module t3 
            
       WHERE t.patient_id = :PATIENT_ID 
         
         and t2.PW_ID = t.PW_ID
         and t2.PW_EVENT_ID = t.PW_EVENT_ID 
         and t2.MID = t.MID
         
         and t3.mid = t.mid
         
       ORDER BY t.cpa_id, t.pw_id, t.pw_event_id, t2.sort_order ASC';
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
     open rs 
      for v_vSQL
    using pi_vPatientID;
    
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;

/*****
Updates Patient Event Module status after a module is completed
*****/
procedure UpdatePatPWEventModule (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vPatientID             in varchar2,
      pi_nPWID                  in number,
      pi_nPatPWEvtID            in number,
      pi_nMID                   in number,
      pi_nIntakeID              in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2
      )
is

     v_vSQL varchar2(1000) := '
        update PAT_PW_EVENT_MODULE t
           set t.status = 1,
               t.intake_id = :INTAKE_ID,
               t.date_started = sysdate,
               t.date_completed = sysdate,
               t.completed_by = :USER_ID
         where t.patient_id = :PATIENT_ID
           and t.pat_pw_id = :PAT_PW_ID
           and t.pat_pw_event_id = :PAT_PW_EVT_ID
           and t.mid = :MID';

begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --execute the SQL
    execute immediate v_vSQL 
    using pi_nIntakeID, 
          pi_nUserID,
          pi_vPatientID,
          pi_nPWID,
          pi_nPatPWEvtID, 
          pi_nMID;
                 
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;

/*update a patient pathway event module*/
procedure UpdatePatPWEventModule (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vPatientID             in varchar2,
      pi_nPWID                  in number,
      pi_nPatPWEvtID            in number,
      pi_nMID                   in number,
      pi_nIntakeID              in number,
      pi_nPwEvtModID              in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2
      )
is

     v_vSQL varchar2(1000) := '
        update PAT_PW_EVENT_MODULE t
           set t.status = 1,
               t.intake_id = :INTAKE_ID,
               t.date_started = sysdate,
               t.date_completed = sysdate,
               t.completed_by = :USER_ID
         where t.patient_id = :PATIENT_ID
           and t.pat_pw_id = :PAT_PW_ID
           and t.pat_pw_event_id = :PAT_PW_EVT_ID
           and t.mid = :MID
           and t.PW_EVENT_MODULE_ID = :PW_EVENT_MODULE_ID';

begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --execute the SQL
    execute immediate v_vSQL 
    using pi_nIntakeID, 
          pi_nUserID,
          pi_vPatientID,
          pi_nPWID,
          pi_nPatPWEvtID, 
          pi_nMID,
          pi_nPwEvtModID;
                 
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;


end PCK_CPA;
/
---------------------------------------------
--  Changed package body pck_demographics  --
---------------------------------------------
create or replace package body tbicds.PCK_DEMOGRAPHICS is

/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

   /*get relationship recordset*/
   procedure GetRelationshipSelfRS(
      pi_vSessionID       in varchar2,
      pi_vSessionClientIP in varchar2,
      pi_nUserID          in number,
      po_nStatusCode      out number,
      po_vStatusComment   out varchar2,
      rs                  out RetRefCursor
      )
   is
      v_vSql                               varchar2(4000);
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      --open recordset
      v_vSql := 'select * '
                || 'from tbicds.stat_relationship t '
                || 'where active = 1 '
                || 'or t.relationship_id = 9 '
                || 'order by active ';
      open rs for v_vSql;
   
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_DEMOGRAPHICS.GetRelationshipSelfRS(): ' || sqlErrm;
   end;
   
   /*get state recordset*/
   procedure GetStateRS(
      pi_vSessionID       in varchar2,
      pi_vSessionClientIP in varchar2,
      pi_nUserID          in number,
      po_nStatusCode      out number,
      po_vStatusComment   out varchar2,
      rs                  out RetRefCursor
      )
   is
      v_vSql                               varchar2(4000);
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      --open recordset
      v_vSql := 'select * from tbicds.stat_states t where active = 1';
      open rs for v_vSql;
   
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_DEMOGRAPHICS.GetStateRS(): ' || sqlErrm;
   end;
   
   /*get gender recordset*/
   procedure GetGenderRS(
      pi_vSessionID       in varchar2,
      pi_vSessionClientIP in varchar2,
      pi_nUserID          in number,
      po_nStatusCode      out number,
      po_vStatusComment   out varchar2,
      rs                  out RetRefCursor
      )
   is
      v_vSql                               varchar2(4000);
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      --open recordset
      v_vSql := 'select * from tbicds.stat_gender t where active = 1';
      open rs for v_vSql;
   
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_DEMOGRAPHICS.GetGenderRS(): ';
   end;
   
   /*get gender description by id recordset*/
   procedure GetGenderDescByIdRS (
      pi_vSessionID              in varchar2,
      pi_vSessionClientIP        in varchar2,
      pi_nUserID                 in number,
      pi_vGenderID               in varchar2,
      po_nStatusCode             out number,
      po_vStatusComment          out varchar2,
      rs                         out RetRefCursor
     )
   is
      v_vSql                               varchar2(4000);
   begin
      po_nStatusCode := 0;--0 = success
      po_vStatusComment := '';
   
      --open recordset
      v_vSql := 'select * from tbicds.stat_gender t where t.gender_id = :P0 and t.active = 1';
      open rs for v_vSql using pi_vGenderID;
   
   exception
      when others
      then
         po_nStatusCode := 1;
         po_vStatusComment := 'PCK_DEMOGRAPHICS.GetGenderDescByIdRS(): ';
   end;

end;
/
-------------------------------------------------
--  Changed package body pck_encounter_intake  --
-------------------------------------------------
create or replace package body tbicds.PCK_ENCOUNTER_INTAKE is

/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

   /*get all the flags for an encounter*/
   procedure GetEncounterFlags(pi_vSessionID       in varchar2,
                              pi_vSessionClientIP in varchar2,
                              pi_nUserID          in number,
                              pi_vEncounterID     in varchar2,
                              po_nStatusCode      out number,
                              po_vStatusComment   out varchar2,
                              rs                  out Pck_Utl_Common.refCursor)
   is
      v_vSql                               varchar2(4000);
   begin
      -- default status to ok
      po_nStatusCode    := Pck_Utl_Common.c_nResultStatus_Success;
      po_vStatusComment := null;
      
      v_vSql := 'select t.*, it.topic, it.alternate_language as topic_alt, it.topic_image '
                || 'from tbicds.encounter_intake_flag t, tbicds.intake_topic it '
                || 'where t.encounter_id = :P0 '
                || 'and t.mid = it.mid '
                || 'and t.tid = it.tid '
                || 'order by t.mid, t.tid, t.flag_id';
      open rs for v_vSql using pi_vEncounterID;
  
   exception
      when others then
         po_nStatusCode    := Pck_Utl_Common.c_nResultStatus_Error;
         po_vStatusComment := 'PCK_ENCOUNTER_INTAKE.GetEncounterFlags(): ';
   end;

  /*
   get all the flags for an encounter intake
  */
   procedure GetEncounterIntakeFlags(pi_vSessionID         in varchar2,
                                    pi_vSessionClientIP   in varchar2,
                                    pi_nUserID            in number,
                                    pi_vEncounterID       in varchar2,
                                    pi_vEncounterIntakeID in number,
                                    po_nStatusCode        out number,
                                    po_vStatusComment     out varchar2,
                                    rs                    out Pck_Utl_Common.refCursor)
   is
      v_vSql                               varchar2(4000);
    v_lSQL long := '';
   begin
      -- default status to ok
      po_nStatusCode    := Pck_Utl_Common.c_nResultStatus_Success;
      po_vStatusComment := null;
      
      v_vSql := 'select t.*, it.topic, it.alternate_language as topic_alt, it.topic_image '
                || 'from tbicds.encounter_intake_flag t, tbicds.intake_topic it '
                || 'where t.encounter_id = :P0 '
                || 'and t.encounter_intake_id = :P1 '
                || 'and t.mid = it.mid '
                || 'and t.tid = it.tid '
                || 'order by t.mid, t.tid, t.flag_id';
      open rs for v_vSql using pi_vEncounterID, pi_vEncounterIntakeID;
  
   exception
      when others then
         po_nStatusCode    := Pck_Utl_Common.c_nResultStatus_Error;
         po_vStatusComment := 'PCK_ENCOUNTER_INTAKE.GetEncounterIntakeFlags(): ';
   end;

   /*
   Get the latest un-complete encounter for this module
   */
   procedure getIntakePatientID(pi_vSessionID         in varchar2,
                               pi_vSessionClientIP   in varchar2,
                               pi_nUserID            in number,
                               pi_vEncounterID       in varchar2,
                               pi_nEncounterIntakeID in number,
                               po_vPatientID         out varchar2,
                               po_nStatusCode        out number,
                               po_vStatusComment     out varchar2)
   is
      v_vSql                               varchar2(4000);
   begin
      po_vPatientID     := '';
      po_nStatusCode    := 0;
      po_vStatusComment := '';
      
      --get the latest un-complete encounter for this module
      begin
         --get the patient id from the
         --portal user id passed in
         v_vSql := 'select t.patient_id from tbicds.encounter t where t.encounter_id = :P0';
         execute immediate v_vSql into po_vPatientID using pi_vEncounterID;
      
      exception
         when others then
            po_vPatientID := '';
      end;
  
   exception
      when others then
         po_nStatusCode    := Pck_Utl_Common.c_nResultStatus_Error;
         po_vStatusComment := 'getIntakeAltLang(): ';
   end;

   /*
   Get alt language for the encounter
   */
   procedure getIntakeAltLang(pi_vSessionID         in varchar2,
                             pi_vSessionClientIP   in varchar2,
                             pi_nUserID            in number,
                             pi_vEncounterID       in varchar2,
                             pi_nEncounterIntakeID in number,
                             po_nOutAltLang        out number,
                             po_nStatusCode        out number,
                             po_vStatusComment     out varchar2)
   is
      v_vSql                               varchar2(4000);
   begin
      po_nOutAltLang    := 0;
      po_nStatusCode    := 0;
      po_vStatusComment := '';
      
      --get the latest un-complete encounter for this module
      begin
         --get the patient id from the
         --portal user id passed in
         v_vSql := 'select alternate_language from tbicds.encounter_intake where encounter_id = :P0 and encounter_intake_id = :P1';
         execute immediate v_vSql into po_nOutAltLang using pi_vEncounterID, pi_nEncounterIntakeID; 
      
      exception
         when others then
            po_nOutAltLang := 0;
      end;

   exception
      when others then
         po_nStatusCode    := Pck_Utl_Common.c_nResultStatus_Error;
         po_vStatusComment := 'getIntakeAltLang(): ';
   end;

   /*
   Tries to retrieve the encounter ID for the passed MID.
    If there is no encounter, it inserts a new encounter
    of type 7 (portal visit)
   */
   procedure GetEncounterIDFromModule(pi_vSessionID       in varchar2,
                                     pi_vSessionClientIP in varchar2,
                                     pi_nUserID          in number,
                                     pi_nModuleID        in number,
                                     pi_vPatientID       in varchar2,
                                     pi_nTreatmentID     in number,
                                     po_vEncounterID     out varchar2,
                                     po_nStatusCode      out number,
                                     po_vStatusComment   out varchar2)
   is
      v_vSql                               varchar2(4000);
      v_nSeq number;
      v_nCnt number;
      null_data EXCEPTION;
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
   
      --get the encounter id for the latest
      --encounter intake matching the
      --mid passed in and that is not completed
      --this is so we can continue an assessment
      v_vSql := 'select max(t.encounter_id) '
                || 'from tbicds.encounter_intake t, tbicds.encounter e '
                || 'where t.encounter_id = e.encounter_id '
                || 'and e.patient_id = :P0 '
                || 'and t.mid = :P1 '
                || 'and nvl(complete, 0) < 1';
      execute immediate v_vSql into po_vEncounterID using pi_vPatientID, pi_nModuleID;
      
      --raise an exception
      if po_vEncounterID is null then
         RAISE null_data;
      end if;
      
   --if any of the above fail then we need to create a new:
   --   1. encounter (encounter type 99 = portal)
   --   2. encounter intake
   --get latest treatment id 
   exception
      when others then
         begin
           --encounter id if none, insert new encounter
         
           --get latest open encounter id, if not signed
           --then use it to create the encounter intake
           --just get the encounter for today if it exists
           v_vSql := 'select max(e.encounter_id) '
                     || 'from tbicds.encounter e '
                     || 'where e.patient_id = :P0 '
                     || 'and e.provider_signature_id is null ';
           execute immediate v_vSql into po_vEncounterID using pi_vPatientID;
         
         exception
            when others then
               po_vEncounterID := null;
         end; --encounter id if none, insert new encounter
 
         if (po_vEncounterID is null) then
            begin
               --does not have an open encounter for today
               --so create a new one based on the patient_id and
               --a sequence
               v_vSql := 'select tbicds.SEQ_ENCOUNTERID.nextval from dual';
               execute immediate v_vSql into v_nSeq;
               
               --new encounter id
               po_vEncounterID := mid(pi_vPatientID, 0, length(pi_vPatientID) - length(to_char(v_nSeq)))
                                  || to_char(v_nSeq);
               
               --insert a new encounter
               v_vSql := 'insert into tbicds.encounter '
                         || '(encounter_id, encounter_date, treatment_id, patient_id, encounter_type_id) '
                         || 'values (:P0, :P1, :P2, :P3, :P4)';
               execute immediate v_vSql using po_vEncounterID, sysdate, pi_nTreatmentID, pi_vPatientID, 99;
               commit;
           
            exception
               when others then
                  po_nStatusCode    := 1;
                  po_vStatusComment := 'PCK_ENCOUNTER_INTAKE.GetEncounterIDFromForModule(): ';
            end;
         end if; --if (v_strEncounterID is null) then
   end;

   /*
   get the the encounter_intake_id.  It checks for the existance
    of a record by checking the COMPLETE field.  If null, then
    there is no record.  In this case it inserts a new record. if
    complete exist and 0 then it returns the current id. 
   
    NOTE: It should never be called for a completed module 
   */
   procedure NewEncounterIntake(pi_vSessionID         in varchar2,
                               pi_vSessionClientIP   in varchar2,
                               pi_nUserID            in number,
                               pi_nModuleID          in number,
                               pi_vEncounterID       in varchar2,
                               pi_nAltLang           in number,
                               po_nEncounterIntakeID out number,
                               po_nStatusCode        out number,
                               po_vStatusComment     out varchar2)
   is
      v_nIncompleteCount number := 0;
      v_nIntakeCount     number := 0;
      v_nEiid            number := 0;
  
      v_vIncompleteCountSql constant varchar(32767) := 'select count(t.encounter_intake_id)
          from tbicds.encounter_intake t
          where t.encounter_id = :EncounterId
          and t.mid = :Mid
          and t.complete = 0';
      
      v_vIntakeCountSql constant varchar(32767) := 'select count(t.encounter_intake_id)
          from tbicds.encounter_intake t
          where t.encounter_id = :EncounterId';
      
      v_vMaxIdSql constant varchar(32767) := 'select max(t.encounter_intake_id)
         from tbicds.encounter_intake t
         where t.encounter_id = :EncounterId';
      
      v_vInsertSql constant varchar(32767) := 'insert into tbicds.encounter_intake t
          (t.encounter_id,
          t.encounter_intake_id,
          t.mid,
          t.intake_type,
          t.score,
          t.read_only,
          t.complete,
          t.alternate_language,
          t.review_encounter_id)
          values
          (:EncounterId,
          :EncounterIntakeId,
          :Mid,
          :IntakeType,
          :Score,
          :ReadOnly,
          :Complete,
          :AlternateLanguage,
          :ReviewEncounterId)';
      
      v_vIncompleteIdSql constant varchar(32767) := 'select t.encounter_intake_id
          from tbicds.encounter_intake t
          where t.encounter_id = :EncounterId
          and t.mid = :Mid
          and t.complete = 0';
   begin
      execute immediate v_vIncompleteCountSql into v_nIncompleteCount using pi_vEncounterID, pi_nModuleID;
  
      if v_nIncompleteCount = 0 then
         execute immediate v_vIntakeCountSql into v_nIntakeCount using pi_vEncounterID;
      
         if v_nIntakeCount = 0 then
            v_nEiid := 1;
         else
            execute immediate v_vMaxIdSql into v_nEiid using pi_vEncounterID;
            v_nEiid := v_nEiid + 1;
         end if;
         
         execute immediate v_vInsertSql using pi_vEncounterID, v_nEiid, pi_nModuleID, 1, 0, 0, 0, pi_nAltLang, '';
         
         po_nEncounterIntakeID := v_nEiid;
      else
         execute immediate v_vIncompleteIdSql into po_nEncounterIntakeID using pi_vEncounterID, pi_nModuleID;
      end if;
  
   exception
      when others then
         po_nEncounterIntakeID := -1;
         po_nStatusCode        := 1;
         po_vStatusComment     := 'PCK_ENCOUNTER_INTAKE.NewEncounterIntakeRS(): ';
   end;

   /*
   get a piece of a string given a delimeter and a position
   */
   function GetPiece(strData      in varchar2,
                    strDelimiter in varchar2,
                    nPosition    in NUMBER) return varchar2
   is
      strWorking varchar2(4000);
      strPiece   varchar2(400);
      pos        number;
      nPos2      number;
      nCount     number;
   begin
      --the piece to return
      strPiece := '';
      
      --set working to data
      strWorking := strData;
      
      --put a delimeter on the front for parsing if needed
      if substr(strWorking, 1, 1) != strDelimiter then
         strWorking := strDelimiter || strWorking;
      end if;

      --find the piece between the ~'s ie... "~piece~"
      pos    := -1;
      nCount := -1;
      
      while (pos != 0) loop
         pos := instr(strWorking, strDelimiter);
         
         if pos != 0 then
            --increment count
            nCount := nCount + 1;
            
            --found the piece...
            if nCount = nPosition then
               if (pos + 1 > length(strWorking) - 1) then
                  --nothing
                  strPiece := '';
               else
                  strWorking := substr(strWorking, pos + 1);
                  nPos2      := instr(strWorking, strDelimiter);
                  
                  if nPos2 = 0 then
                     --last piece
                     strPiece := strWorking;
                     return ltrim(rtrim(strPiece));
                  else
                     strPiece := substr(strWorking, 0, nPos2 - 1);
                     return ltrim(rtrim(strPiece));
                  end if;
               end if;
            else
               strWorking := substr(strWorking, pos + 1);
            end if;
         end if;
      end loop;
      
      return ltrim(rtrim(strPiece));
  
   exception
      when others then
         return '';
   end;

   /*
   get all Encounter Intake Responses count recordset
   */
   procedure GetResponsesCountRS(pi_vSessionID       in varchar2,
                                pi_vSessionClientIP in varchar2,
                                pi_nUserID          in number,
                                pi_vEncounterID     in varchar2,
                                pi_vMIDs            in varchar2,
                                po_nStatusCode      out number,
                                po_vStatusComment   out varchar2,
                                rs                  out RetRefCursor)
   is
      v_vSql                               varchar2(4000);
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      --open recordset
      v_vSql := 'select count(*) as count_resp, t.mid '
                || 'from tbicds.encounter_intake_responses t '
                || 'where t.encounter_id = :P0 '
                || 'and instr(:P1, '',''||t.mid||'','') > 0 '
                || 'group by t.mid '
                || 'order by t.mid ';
      open rs for v_vSql using pi_vEncounterID, ','||pi_vMIDs||',';
  
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_INTAKE.GetResponsesCountRS(): ';
   end;

   ------------------------------------------------------------------
   -- This SP will return a recordset with the data fields necessary
   -- to fill the education encounter list
   ------------------------------------------------------------------
   procedure GetIntakesForEducationRS(pi_vSessionID       in varchar2,
                                     pi_vSessionClientIP in varchar2,
                                     pi_nUserID          in number,
                                     pi_vPatientID       in varchar2,
                                     po_nStatusCode      out number,
                                     po_vStatusComment   out varchar2,
                                     rs                  out RetRefCursor)
   is
      v_vSql                               varchar2(4000);
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      --open recordset
      v_vSql := 'select m.mid, m.module as mid, e.encounter_date as edate '
                || 'from tbicds.intake_module m, tbicds.encounter e, tbicds.encounter_intake ei '
                || 'where e.patient_id = :P0 '
                || 'and ei.encounter_id = e.encounter_id '
                || 'and m.mid = ei.mid '
                || 'order by e.encounter_date ';
      open rs for v_vSql using pi_vPatientID;
  
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_INTAKE.GetIntakesForEducationRS(): ';
   end;
   
   /*get intakes for review recordset*/
   procedure GetIntakesForReviewRS(pi_vSessionID       in varchar2,
                                  pi_vSessionClientIP in varchar2,
                                  pi_nUserID          in number,
                                  pi_vPatientID       in varchar2,
                                  pi_vEncounterID      in varchar2,
                                  po_nStatusCode      out number,
                                  po_vStatusComment   out varchar2,
                                  rs                  out RetRefCursor)
   is
      v_vSql                               varchar2(4000);
      v_vPatientID  varchar2(50);
      v_nModalityID number;
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      v_vPatientID  := pi_vPatientID;
      
      --get modality id from encounter
      begin
         v_vSql := 'select e.encounter_type_id '
                   || 'from tbicds.encounter e '
                   || 'where e.encounter_id = :P0 '
                   || 'and e.patient_id = :P1 ';
         execute immediate v_vSql into v_nModalityID using pi_vEncounterID, v_vPatientID;
      exception
         when others then
            v_nModalityID := -1;
      end;
  
      v_vSql := 'select * from ('
                || 'select img.module_group_descr, m.module, p.*, imgm.sort_order '
                || 'from tbicds.patient_module p, '
                || 'tbicds.intake_module m, '
                || 'tbicds.intake_module_group img, '
                || 'tbicds.intake_module_group_mid imgm '
                || 'where m.mid = p.mid '
                || 'and img.module_group_id = p.module_group_id '
                || 'and imgm.module_group_id = p.module_group_id '
                || 'and imgm.mid = p.mid '
                || 'and p.patient_id = :P0 '
                --and p.status = 1
                || 'and p.module_group_id in (select module_group_id from tbicds.intake_module_group where stat_modality_id = :P1) '
                || ') t1 '
                || 'left join ('
                || 'select e.patient_id, i.* '
                || 'from tbicds.encounter e, tbicds.encounter_intake i '
                || 'where e.encounter_id = i.encounter_id '
                || 'and i.intake_group_id in (select module_group_id from tbicds.intake_module_group where stat_modality_id = :P2) '
                || 'and e.patient_id = :P3 '
                || ') t2 '
                || 'on t2.patient_id = t1.patient_id '
                || 'and t2.mid = t1.mid '
                || 'and t2.intake_group_id = t1.module_group_id '
                || 'order by t1.MODULE_GROUP_ID, t1.sort_order, t1.status desc, t1.date_completed ';
      open rs for v_vSql using v_vPatientID, v_nModalityID, v_nModalityID, v_vPatientID;
  
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_INTAKE.GetIntakesForReviewRS(): ';
   end;

end;
/
-----------------------------------------------------
--  Changed package body pck_instrument_responses  --
-----------------------------------------------------
create or replace package body tbicds.PCK_INSTRUMENT_RESPONSES is

/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

  /*get an export score value given the data and a filter*/
  function fnGetExportScoreValue(pi_vDataValue  in varchar2,
                                 pi_vStatFilter in varchar2) return varchar2
  is
    v_rs              PCK_COMMON.refCursor;
    v_vSQL            varchar2(32767) := '';
    po_vResponseValue varchar2(32767) := '';

  begin
  
    v_vSQL := v_vSQL || ' select t.score_value ';
    v_vSQL := v_vSQL || '   from INTAKE_STATIC_DATA t ';
    v_vSQL := v_vSQL || '  where t.active = 1 ';
    v_vSQL := v_vSQL || '    and t.data_value = ''' || pi_vDataValue || '''';
    v_vSQL := v_vSQL || '    and ';
    v_vSQL := v_vSQL || pi_vStatFilter;
  
    open v_rs for v_vSQL;
    loop
      fetch v_rs
        into  po_vResponseValue;

      exit when v_rs%notfound;
    end loop;
    close v_rs;
    
    
    return po_vResponseValue;
  
  exception
    when others then
      return '';
  end;
  
  /* Write instrument responses to the database. */
  procedure InsertInstrumentResponse(pi_vSessionID       in varchar2,
                                     pi_vSessionClientIP in varchar2,
                                     pi_nUserID          in number,
                                     
                                     pi_vPatientID     in varchar2,
                                     pi_nIntakeID      in number,
                                     pi_nMID           in number,
                                     pi_nTID           in number,
                                     pi_nQID           in number,
                                     pi_nRID           in number,
                                     pi_nScoreValue    in number,
                                     pi_vResponseValue in varchar2,
                                     
                                     po_nStatusCode    out number,
                                     po_vStatusComment out varchar2)
  
   is
    v_vSQL               varchar2(4000);
    v_nResponseType      number := null;
    v_dtResponseDateTime date := sysdate;
    v_vIdentifier        varchar2(24) := null;
  
  begin
    po_nStatusCode    := PCK_COMMON.c_nResultStatus_Success;
    po_vStatusComment := '';
    
    --get identifier for the response
    begin
      select identifier
        into v_vIdentifier
        from intake_response t
       where t.mid = pi_nMID
         and t.tid = pi_nTID
         and t.qid = pi_nQID
         and t.rid = pi_nRID;
    exception 
      when others then
      v_vIdentifier := null;     
    end;
  
    v_vSQL := v_vSQL || ' insert into DATA_INTAKE_RESPONSES ';
    v_vSQL := v_vSQL || '  (PATIENT_ID, ';
    v_vSQL := v_vSQL || '   INTAKE_ID, ';
    v_vSQL := v_vSQL || '   RID, ';
    v_vSQL := v_vSQL || '   MID, ';
    v_vSQL := v_vSQL || '   TID, ';
    v_vSQL := v_vSQL || '   QID, ';
    v_vSQL := v_vSQL || '   RESPONSE_TYPE, ';
    v_vSQL := v_vSQL || '   RESPONSE_VALUE, ';
    v_vSQL := v_vSQL || '   SCORE_VALUE, ';
    v_vSQL := v_vSQL || '   RESPONSE_DATETIME, ';
    v_vSQL := v_vSQL || '   IDENTIFIER) ';
    v_vSQL := v_vSQL || ' values ';
    v_vSQL := v_vSQL || '   (:V_PATIENT_ID, ';
    v_vSQL := v_vSQL || '   :V_INTAKE_ID, ';
    v_vSQL := v_vSQL || '   :V_RID, ';
    v_vSQL := v_vSQL || '   :V_MID, ';
    v_vSQL := v_vSQL || '   :V_TID, ';
    v_vSQL := v_vSQL || '   :V_QID, ';
    v_vSQL := v_vSQL || '   :V_RESPONSE_TYPE, ';
    v_vSQL := v_vSQL || '   :V_RESPONSE_VALUE, ';
    v_vSQL := v_vSQL || '   :V_SCORE_VALUE, ';
    v_vSQL := v_vSQL || '   :V_RESPONSE_DATETIME, ';
    v_vSQL := v_vSQL || '   :v_vIDENTIFIER) ';
  
    --get response type from intake_response table
    begin
      select t.response_type
        into v_nResponseType
        from intake_response t
       where t.mid = pi_nMID
         and t.tid = pi_nTID
         and t.qid = pi_nQID
         and t.rid = pi_nRID;
    exception
      when others then
        v_nResponseType := null;
    end;
  
    execute immediate v_vSQL
      using pi_vPatientID, 
            pi_nIntakeID, 
            pi_nRID, 
            pi_nMID, 
            pi_nTID, 
            pi_nQID, 
            v_nResponseType, 
            pi_vResponseValue, 
            pi_nScoreValue, 
            v_dtResponseDateTime,
            v_vIdentifier;

    --AUDIT TRAIL
    v_vSQL := replace(v_vSQL, 'DATA_INTAKE_RESPONSES', 'DATA_INTAKE_RESPONSES_AUDIT');
    execute immediate v_vSQL
      using pi_vPatientID, 
            pi_nIntakeID, 
            pi_nRID, 
            pi_nMID, 
            pi_nTID, 
            pi_nQID, 
            v_nResponseType, 
            pi_vResponseValue, 
            pi_nScoreValue, 
            v_dtResponseDateTime,
            v_vIdentifier;
              
    commit;
  
  exception
    when others then
      po_nStatusCode    := PCK_COMMON.c_nResultStatus_Error;
      po_vStatusComment := Sqlerrm;
  end;

  /* Get instruments responses by MID */
  procedure GetInstrumentResponsesRS(pi_vSessionID       in varchar2,
                                     pi_vSessionClientIP in varchar2,
                                     pi_nUserID          in number,
                                     
                                     pi_vPatientID      in varchar2,
                                     --pi_nSiteID         in number,
                                     --pi_nClinicalProgID in number,
                                     --pi_nPathwayID      in number,
                                     pi_nMID            in number,
                                     pi_nIntakeID       in number,
                                     
                                     rs                out PCK_COMMON.refCursor,
                                     po_nStatusCode    out number,
                                     po_vStatusComment out varchar2) 
   is
  
    v_vSQL          varchar2(4000);
    v_nLastIntakeID number := 0;
  
  begin
    po_nStatusCode    := 0;
    po_vStatusComment := '';
  
    --v_vSQL := v_vSQL || '		select 	dr.*, ';
    v_vSQL := v_vSQL || 'select dr.PATIENT_ID,dr.INTAKE_ID,dr.RID,dr.MID,dr.TID,dr.QID,';
    v_vSQL := v_vSQL || '       dr.RESPONSE_TYPE,dr.RESPONSE_VALUE,ir.LABEL_POS,';
    v_vSQL := v_vSQL || '       case';
    v_vSQL := v_vSQL || '         when ir.display_type not in(4,22) and dr.SCORE_VALUE=0 and ir.score_value is null then ''''';
    v_vSQL := v_vSQL || '         when ir.display_type in(4,22) and dr.SCORE_VALUE=0 and ir.score_value is null and ir.stat_load_filter is null then ''''';
    v_vSQL := v_vSQL || '         when ir.display_type in(4,22) and dr.SCORE_VALUE=0 and ir.score_value is null and ir.stat_load_filter is not null then';
    v_vSQL := v_vSQL || '           pck_instrument_responses.fnGetExportScoreValue(dr.RESPONSE_VALUE, ir.stat_load_filter)';
    v_vSQL := v_vSQL || '         else to_char(dr.score_value) ';
    v_vSQL := v_vSQL || '       end as SCORE_VALUE,';
    v_vSQL := v_vSQL || '       dr.RESPONSE_DATETIME,dr.RESPONSE_TIME,dr.INTAKE_GROUP_ID,dr.IDENTIFIER,';
    v_vSQL := v_vSQL || '				im.module, ';
    v_vSQL := v_vSQL || '				it.topic, ';
    v_vSQL := v_vSQL || '				iq.question, ';
    v_vSQL := v_vSQL || '				ir.response as static_response, ';
    v_vSQL := v_vSQL || '				ir.display_type, ';
    v_vSQL := v_vSQL || '				ir.unit, ';
    v_vSQL := v_vSQL || '				di.complete_date ';
    v_vSQL := v_vSQL || '		from 	data_intake_responses dr, ';
    v_vSQL := v_vSQL || '				data_intake di, ';
    v_vSQL := v_vSQL || '				intake_module im, ';
    v_vSQL := v_vSQL || '				intake_topic it, ';
    v_vSQL := v_vSQL || '				intake_question iq, ';
    v_vSQL := v_vSQL || '				intake_response ir ';
  
    v_vSQL := v_vSQL || '		where 	dr.patient_id = :PATIENT_ID ';
    v_vSQL := v_vSQL || '		and 	dr.mid = :MID ';
    v_vSQL := v_vSQL || '		and 	dr.intake_id = :INTAKE_ID ';
    
    --data_intake
    v_vSQL := v_vSQL || '		and di.patient_id = dr.patient_id';
    v_vSQL := v_vSQL || '		and di.intake_id = dr.intake_id';
    v_vSQL := v_vSQL || '		and di.mid = dr.mid';
  
    --intake_module
    v_vSQL := v_vSQL || '		and 	dr.mid = im.mid ';
  
    --intake_topic
    v_vSQL := v_vSQL || '		and 	dr.mid = it.mid ';
    v_vSQL := v_vSQL || '		and 	dr.tid = it.tid ';
  
    --intake_question
    v_vSQL := v_vSQL || '		and 	dr.mid = iq.mid ';
    v_vSQL := v_vSQL || '		and 	dr.tid = iq.tid ';
    v_vSQL := v_vSQL || '		and 	dr.qid = iq.qid ';
  
    --intake_response
    v_vSQL := v_vSQL || '		and 	dr.mid = ir.mid ';
    v_vSQL := v_vSQL || '		and 	dr.tid = ir.tid ';
    v_vSQL := v_vSQL || '		and 	dr.qid = ir.qid ';
    v_vSQL := v_vSQL || '		and 	dr.rid = ir.rid ';
  
    v_vSQL := v_vSQL || '		order by dr.mid, ';
    v_vSQL := v_vSQL || '				dr.tid, ';
    v_vSQL := v_vSQL || '				dr.qid, ';
    v_vSQL := v_vSQL || '				dr.rid ';
  
    -- get lats intake_id for the instrument
    begin
    
      select max(t.intake_id)
        into v_nLastIntakeID
        from data_intake_responses t
       where t.patient_id = pi_vPatientID
         and t.mid = pi_nMID;
    
    exception
      when others then
        v_nLastIntakeID := 0;
    end;
  
    --open the cursor
    open rs for v_vSQL
      using pi_vPatientID, pi_nMID, pi_nIntakeID;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
  end;
  
  /* Get merged instruments responses */
  procedure GetMergedInstrumentResponsesRS(pi_vSessionID       in varchar2,
                                     pi_vSessionClientIP in varchar2,
                                     pi_nUserID          in number,
                                     
                                     pi_vPatientID      in varchar2,
                                     pi_nMID            in number,
                                     pi_nIntakeID       in number,
                                     
                                     rs                out PCK_COMMON.refCursor,
                                     po_nStatusCode    out number,
                                     po_vStatusComment out varchar2) 
  is
  
  begin
    po_nStatusCode    := 0;
    po_vStatusComment := '';
  
    --open recordset
    open rs for
    select *
  from (select r.mid,
               r.tid,
               r.qid,
               r.rid,
               r.identifier,
               r.response_value,
               r.score_value,
               r.response_type,
               1 as is_selected
          from data_intake_responses r
         where r.patient_id = pi_vPatientID
           and r.mid = pi_nMID
           and r.intake_id = pi_nIntakeID
        
        union
        
        select ir.mid,
               ir.tid,
               ir.qid,
               ir.rid,
               ir.identifier,
               '' as response_value,
               to_number(ir.score_value),
               ir.response_type,
               0 as is_selected
          from intake_response ir
         where ir.mid = pi_nMID
           and ir.rid not in (select r.rid
                                from data_intake_responses r
                               where r.patient_id = pi_vPatientID
                                 and r.mid = pi_nMID
                                 and r.intake_id = pi_nIntakeID)
        
        ) a
 order by mid, tid, qid, rid;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
  end;

  /* Returns a recordset with the resolved intake logic variables*/
  PROCEDURE GetIntakeLogicVarRS(pi_vSessionID       in varchar2,
                                pi_vSessionClientIP in varchar2,
                                pi_nUserID          in number,
                                pi_vPatientID       in varchar2,
                                pi_vKey             in varchar2,
                                pi_nMID             in number,
                                rs                  out PCK_COMMON.refCursor,
                                po_nStatusCode      out number,
                                po_vStatusComment   out varchar2) 
   is
  
    v_vSQL     VARCHAR2(32767) := '';
    v_vQuery   VARCHAR2(4000);
    v_count    NUMBER := 0;
    v_varvalue VARCHAR2(24);
  
  BEGIN
  
    po_nStatusCode    := PCK_COMMON.c_nResultStatus_Success;
    po_vStatusComment := '';
  
    FOR rec IN (SELECT *
                  FROM INTAKE_LOGICVAR_SQL t
                 where t.var_id in (select var_id
                                      from intake_module_variables v
                                     where v.mid = pi_nMID)) LOOP
      IF v_count > 0 THEN
        v_vSQL := v_vSQL || ' union ';
      END IF;
      v_vQuery := REPLACE(rec.LOAD_SQL,
                          '_PATIENT_ID',
                          '''' || pi_vPatientID || '''');
      v_vQuery := REPLACE(v_vQuery, '_ENCRYPT_KEY', '''' || pi_vKey || '''');
      v_vQuery := REPLACE(v_vQuery, '_MID', pi_nMID);
      BEGIN
        EXECUTE immediate v_vQuery
          INTO v_varvalue;
      EXCEPTION
        WHEN OTHERS THEN
          v_varvalue := '';
      END;
      v_vSQL  := v_vSQL || 'select ''' || rec.VAR_ID || ''' as VAR_ID, ''' ||
                 rec.IDENTIFIER || ''' as IDENTIFIER, ''' || v_varvalue ||
                 ''' as VAR_VALUE from dual';
      v_count := v_count + 1;
    END LOOP;
    OPEN rs FOR v_vSQL;
  
  exception
    when others then
      po_nStatusCode    := PCK_COMMON.c_nResultStatus_Error;
      po_vStatusComment := '';
  end;

  /*Get the score logic for the module*/
  procedure GetScoreLogicRS(pi_vSessionID       in varchar2,
                            pi_vSessionClientIP in varchar2,
                            pi_nUserID          in number,
                            pi_nMID             in number,
                            rs                  out PCK_COMMON.refCursor,
                            po_nStatusCode      out number,
                            po_vStatusComment   out varchar2) 
  is
  
    v_vSQL varchar2(4000);
  
  begin
    po_nStatusCode    := PCK_COMMON.c_nResultStatus_Success;
    po_vStatusComment := '';
  
    v_vSQL := v_vSQL || '  select mid, score_logic ';
    v_vSQL := v_vSQL || '    from intake_module ';
    v_vSQL := v_vSQL || '   where active = 1 ';
    v_vSQL := v_vSQL || '     and mid = :MID ';
  
    --open the cursor
    open rs for v_vSQL
      using pi_nMID;
  
  exception
    when others then
      po_nStatusCode    := PCK_COMMON.c_nResultStatus_Error;
      po_vStatusComment := '';
  end;

  /*get instruments for a patient*/
  PROCEDURE GetPatientInstrumentsRS(pi_vSessionID       IN VARCHAR2,
                                    pi_vSessionClientIP IN VARCHAR2,
                                    pi_nUserID          IN NUMBER,
                                    pi_vPatientID       IN VARCHAR2,
                                    rs                  OUT PCK_COMMON.refCursor,
                                    po_nStatusCode      OUT NUMBER,
                                    po_vStatusComment   OUT VARCHAR2) 
  is
  
  BEGIN
    po_nStatusCode    := 0;
    po_vStatusComment := '';
    --open the cursor
    OPEN rs FOR
    
      SELECT 0 AS status_id,
             'Unknown' AS status,
             t.patient_id,
             t.intake_id,
             t.mid,
             m.module,
             t.complete_date AS date_completed,
             t.score,
             '' AS interpretation,
             DECODE(t.complete, 0, 'No', 1, 'Yes') AS completed
        FROM data_intake t, intake_module m
       WHERE t.mid = m.mid
         AND t.patient_id = pi_vPatientID;
  
  EXCEPTION
    WHEN OTHERS THEN
      po_nStatusCode    := 1;
      po_vStatusComment := '';
  END;
 
 /*****
 Remove ALL responses from previous time submitted 
 *****/
 procedure RemoveAllResponses(pi_vSessionID       in varchar2,
                              pi_vSessionClientIP in varchar2,
                              pi_nUserID          in number,
                              pi_vPatientID       in varchar2,
                              pi_nMID             in number,
                              pi_nIntakeID        in number,
                              po_nStatusCode      out number,
                              po_vStatusComment   out varchar2) 
 is
 
   v_vSQL varchar2(1000) := '';
 
 begin
   po_nStatusCode    := 0;
   po_vStatusComment := '';
   
   v_vSQL := v_vSQL || '  delete from data_intake_responses ';
   v_vSQL := v_vSQL || '    where patient_id = :pi_vPatientID ';
   v_vSQL := v_vSQL || '      and mid = :pi_nMID ';
   v_vSQL := v_vSQL || '      and intake_id = :pi_nIntakeID';
   
   execute immediate v_vSQL using pi_vPatientID, pi_nMID, pi_nIntakeID; 
   commit;
 
 exception
   when others then
     po_nStatusCode    := 1;
     po_vStatusComment := '';
 end;
 
 /*****
 Remove responses from previous time submitted
 not present in a new submittal of the instrument 
 *****/
 procedure RemovePrevResponses(pi_vSessionID       in varchar2,
                               pi_vSessionClientIP in varchar2,
                               pi_nUserID          in number,
                               pi_vPatientID       in varchar2,
                               pi_nMID             in number,
                               pi_nIntakeID        in number,
                               pi_vResponses       in varchar2,
                               po_nStatusCode      out number,
                               po_vStatusComment   out varchar2) 
 is
 
   v_vSQL varchar2(1000) := '';
 
 begin
   po_nStatusCode    := 0;
   po_vStatusComment := '';
   
   v_vSQL := v_vSQL || '  delete from data_intake_responses ';
   v_vSQL := v_vSQL || '    where patient_id = :pi_vPatientID ';
   v_vSQL := v_vSQL || '      and mid = :pi_nMID ';
   v_vSQL := v_vSQL || '      and intake_id = :pi_nIntakeID ';
   v_vSQL := v_vSQL || '      and rid not in (' || pi_vResponses || ') '; 
   
   execute immediate v_vSQL using pi_vPatientID, pi_nMID, pi_nIntakeID; 
   commit;
 
 exception
   when others then
     po_nStatusCode    := 1;
     po_vStatusComment := '';
 end;
 
 /*remove a response from an intake*/
 procedure RemoveResponse(pi_vSessionID       in varchar2,
                         pi_vSessionClientIP in varchar2,
                         pi_nUserID          in number,
                         pi_vPatientID       in varchar2,
                         pi_nMID             in number,
                         pi_nIntakeID        in number,
                         pi_nRID             in number,
                         po_nStatusCode      out number,
                         po_vStatusComment   out varchar2) 
 is
 
   v_vSQL varchar2(1000) := '';
 
 begin
   po_nStatusCode    := 0;
   po_vStatusComment := '';
   
   v_vSQL := v_vSQL || '  delete from data_intake_responses ';
   v_vSQL := v_vSQL || '    where patient_id =  :pi_vPatientID ';
   v_vSQL := v_vSQL || '      and mid = :pi_nMID ';
   v_vSQL := v_vSQL || '      and intake_id = :pi_nIntakeID ';
   v_vSQL := v_vSQL || '      and rid = :pi_nRID'; 
   
   execute immediate v_vSQL using pi_vPatientID, pi_nMID, pi_nIntakeID, pi_nRID; 
   commit;
 
 exception
   when others then
     po_nStatusCode    := 1;
     po_vStatusComment := '';
 end;
 
 /*****  
 Inserts Instruments Scores
 *****/
 procedure InsertInstrumentScore(pi_vSessionID       in varchar2,
                                 pi_vSessionClientIP in varchar2,
                                 pi_nUserID          in number,
                                     
                                 pi_vPatientID       in varchar2,
                                 pi_nIntakeID        in number,
                                 pi_nMID             in number,
                                 pi_nSeriesID        in number,
                                 pi_nScore           in number,
                                 pi_vInterpret       in varchar2,
                                     
                                 po_nStatusCode      out number,
                                 po_vStatusComment   out varchar2)
  
   is
    v_vSQL  varchar2(4000) := '';
  
  begin
    po_nStatusCode    := PCK_COMMON.c_nResultStatus_Success;
    po_vStatusComment := '';
  
    v_vSQL := v_vSQL || '    insert ';
    v_vSQL := v_vSQL || '       into data_intake_score s ';
    v_vSQL := v_vSQL || '         (patient_id, '; 
    v_vSQL := v_vSQL || '         mid, '; 
    v_vSQL := v_vSQL || '         intake_id, '; 
    v_vSQL := v_vSQL || '         series, '; 
    v_vSQL := v_vSQL || '         score, '; 
    v_vSQL := v_vSQL || '         interpretation) ';
    v_vSQL := v_vSQL || '       values ';
    v_vSQL := v_vSQL || '         (:PATIENT_ID, '; 
    v_vSQL := v_vSQL || '         :MID, '; 
    v_vSQL := v_vSQL || '         :INTAKE_ID, '; 
    v_vSQL := v_vSQL || '         :SERIES_ID, '; 
    v_vSQL := v_vSQL || '         :SCORE, '; 
    v_vSQL := v_vSQL || '         :INTERPRETATION) ';
  
    
  execute immediate v_vSQL
      using pi_vPatientID, 
      pi_nMID, 
      pi_nIntakeID, 
      pi_nSeriesID, 
      pi_nScore, 
      pi_vInterpret; 
      
  --AUDIT TRAIL
  v_vSQL := replace(v_vSQL, 'data_intake_score', 'data_intake_score_audit');
  execute immediate v_vSQL
      using pi_vPatientID, 
      pi_nMID, 
      pi_nIntakeID, 
      pi_nSeriesID, 
      pi_nScore, 
      pi_vInterpret;
  
    commit;
  
  exception
    when others then
      po_nStatusCode    := PCK_COMMON.c_nResultStatus_Error;
      po_vStatusComment := '';
  end;
  
  /*Insert instrument score*/
  procedure InsertInstrumentScore(pi_vSessionID       in varchar2,
                                 pi_vSessionClientIP in varchar2,
                                 pi_nUserID          in number,
                                     
                                 pi_vPatientID       in varchar2,
                                 pi_nIntakeID        in number,
                                 pi_nMID             in number,
                                 pi_nSeriesID        in number,
                                 pi_nScore           in number,
                                 pi_vInterpret       in varchar2,
                                 pi_vDescription     in varchar2,
                                     
                                 po_nStatusCode      out number,
                                 po_vStatusComment   out varchar2)
  
   is
    v_vSQL  varchar2(4000) := '';
  
  begin
    po_nStatusCode    := PCK_COMMON.c_nResultStatus_Success;
    po_vStatusComment := '';
  
    v_vSQL := v_vSQL || '    insert ';
    v_vSQL := v_vSQL || '       into data_intake_score s ';
    v_vSQL := v_vSQL || '         (patient_id, '; 
    v_vSQL := v_vSQL || '         mid, '; 
    v_vSQL := v_vSQL || '         intake_id, '; 
    v_vSQL := v_vSQL || '         series, '; 
    v_vSQL := v_vSQL || '         score, '; 
    v_vSQL := v_vSQL || '         interpretation, ';
    v_vSQL := v_vSQL || '         description) ';
    v_vSQL := v_vSQL || '       values ';
    v_vSQL := v_vSQL || '         (:PATIENT_ID, '; 
    v_vSQL := v_vSQL || '         :MID, '; 
    v_vSQL := v_vSQL || '         :INTAKE_ID, '; 
    v_vSQL := v_vSQL || '         :SERIES_ID, '; 
    v_vSQL := v_vSQL || '         :SCORE, '; 
    v_vSQL := v_vSQL || '         :INTERPRETATION, ';
    v_vSQL := v_vSQL || '         :DESCRIPTION) ';
  
    
  execute immediate v_vSQL
      using pi_vPatientID, 
      pi_nMID, 
      pi_nIntakeID, 
      pi_nSeriesID, 
      pi_nScore, 
      pi_vInterpret,
      pi_vDescription; 
  
  --AUDIT TRAIL
  v_vSQL := replace(v_vSQL, 'data_intake_score', 'data_intake_score_audit');
  execute immediate v_vSQL
      using pi_vPatientID, 
      pi_nMID, 
      pi_nIntakeID, 
      pi_nSeriesID, 
      pi_nScore, 
      pi_vInterpret,
      pi_vDescription;
  
    commit;
  
  exception
    when others then
      po_nStatusCode    := PCK_COMMON.c_nResultStatus_Error;
      po_vStatusComment := '';
  end;
  
  /*Insert instrument score*/
  procedure InsertInstrumentScore(pi_vSessionID       in varchar2,
                                 pi_vSessionClientIP in varchar2,
                                 pi_nUserID          in number,
                                     
                                 pi_vPatientID       in varchar2,
                                 pi_nIntakeID        in number,
                                 pi_nMID             in number,
                                 pi_nSeriesID        in number,
                                 pi_nScore           in number,
                                 pi_vInterpret       in varchar2,
                                 pi_vDescription     in varchar2,
                                 pi_nSeverity        in number,
                                     
                                 po_nStatusCode      out number,
                                 po_vStatusComment   out varchar2)
  
   is
    v_vSQL  varchar2(4000) := '';
  
  begin
    po_nStatusCode    := PCK_COMMON.c_nResultStatus_Success;
    po_vStatusComment := '';
  
    v_vSQL := v_vSQL || '    insert ';
    v_vSQL := v_vSQL || '       into data_intake_score s ';
    v_vSQL := v_vSQL || '         (patient_id, '; 
    v_vSQL := v_vSQL || '         mid, '; 
    v_vSQL := v_vSQL || '         intake_id, '; 
    v_vSQL := v_vSQL || '         series, '; 
    v_vSQL := v_vSQL || '         score, '; 
    v_vSQL := v_vSQL || '         interpretation, ';
    v_vSQL := v_vSQL || '         description, ';
    v_vSQL := v_vSQL || '         severity) ';
    v_vSQL := v_vSQL || '       values ';
    v_vSQL := v_vSQL || '         (:PATIENT_ID, '; 
    v_vSQL := v_vSQL || '         :MID, '; 
    v_vSQL := v_vSQL || '         :INTAKE_ID, '; 
    v_vSQL := v_vSQL || '         :SERIES_ID, '; 
    v_vSQL := v_vSQL || '         :SCORE, '; 
    v_vSQL := v_vSQL || '         :INTERPRETATION, ';
    v_vSQL := v_vSQL || '         :DESCRIPTION, ';
    v_vSQL := v_vSQL || '         :SEVERITY) ';
  
    
  execute immediate v_vSQL
      using pi_vPatientID, 
      pi_nMID, 
      pi_nIntakeID, 
      pi_nSeriesID, 
      pi_nScore, 
      pi_vInterpret,
      pi_vDescription,
      pi_nSeverity; 
  
  --AUDIT TRAIL
  v_vSQL := replace(v_vSQL, 'data_intake_score', 'data_intake_score_audit');
  execute immediate v_vSQL
      using pi_vPatientID, 
      pi_nMID, 
      pi_nIntakeID, 
      pi_nSeriesID, 
      pi_nScore, 
      pi_vInterpret,
      pi_vDescription,
      pi_nSeverity; 
  
    commit;
  
  exception
    when others then
      po_nStatusCode    := PCK_COMMON.c_nResultStatus_Error;
      po_vStatusComment := '';
  end;
  
  /*****
  Delete Instrument Scores
  *****/
  procedure DeleteInstrumentScore(pi_vSessionID       in varchar2,
                                 pi_vSessionClientIP  in varchar2,
                                 pi_nUserID           in number,
                                     
                                 pi_vPatientID        in varchar2,
                                 pi_nIntakeID         in number,
                                 pi_nMID              in number,
                                     
                                 po_nStatusCode       out number,
                                 po_vStatusComment    out varchar2)
  
   is
    v_vSQL  varchar2(4000) := '';
  
  begin
    po_nStatusCode    := PCK_COMMON.c_nResultStatus_Success;
    po_vStatusComment := '';
  
    v_vSQL := v_vSQL || ' delete ';
    v_vSQL := v_vSQL || '   from data_intake_score d ';
    v_vSQL := v_vSQL || '  where d.patient_id = :PATIENT_ID ';
    v_vSQL := v_vSQL || '    and d.mid = :MID ';
    v_vSQL := v_vSQL || '    and d.intake_id = :INTAKE_ID ';
  
    
  execute immediate v_vSQL
      using pi_vPatientID, 
      pi_nMID, 
      pi_nIntakeID; 
  
    commit;
  
  exception
    when others then
      po_nStatusCode    := PCK_COMMON.c_nResultStatus_Error;
      po_vStatusComment := '';
  end;

  /*****
  Gets recordset of instrument score and apply filter
  *****/
  procedure GetInstrumentScoresRS(pi_vSessionID       in varchar2,
                                  pi_vSessionClientIP in varchar2,
                                  pi_nUserID          in number,
                                       
                                  pi_vPatientID       in varchar2,
                                  pi_nMID             in number,
                                  pi_nIntakeID        in number,
                                  pi_nFilter          in number,
                                       
                                  rs                  out PCK_COMMON.refCursor,
                                  po_nStatusCode      out number,
                                  po_vStatusComment   out varchar2) 
 is
    v_vSQL          varchar2(4000);
  
  begin
    po_nStatusCode    := 0;
    po_vStatusComment := '';

 
    v_vSQL := v_vSQL || ' select * ';
    v_vSQL := v_vSQL || '   from (select t.*, ';
    v_vSQL := v_vSQL || '                im.module, ';
    v_vSQL := v_vSQL || '                m.date_completed ';
    v_vSQL := v_vSQL || '           from data_intake_score t, '; 
    v_vSQL := v_vSQL || '                pat_pw_event_module m, '; 
    v_vSQL := v_vSQL || '                intake_module im ';
    v_vSQL := v_vSQL || '          where t.patient_id = :PATIENT_ID ';
    v_vSQL := v_vSQL || '            and t.mid = :MID ';
    v_vSQL := v_vSQL || '            and t.patient_id = m.patient_id ';
    v_vSQL := v_vSQL || '            and t.mid = m.mid ';
    v_vSQL := v_vSQL || '            and t.intake_id = m.intake_id ';
    v_vSQL := v_vSQL || '            and t.mid = im.mid(+) ';
    
    --exclude FIM goal scores, they are not real scores!
    if pi_nMID = 4042 then
    
      v_vSQL := v_vSQL || ' and ((select rid ';
      v_vSQL := v_vSQL || '         from data_intake_responses ';
      v_vSQL := v_vSQL || '        where intake_id = t.intake_id ';
      v_vSQL := v_vSQL || '          and tid=1 ';
      v_vSQL := v_vSQL || '          and qid=1 ) != 21) ';
    
    end if;                
    
    --apply filter
    case
      when pi_nFilter = 0 then v_vSQL := v_vSQL || ' ';
      when pi_nFilter = 1 then v_vSQL := v_vSQL || ' and t.intake_id <= ' || pi_nIntakeID;
      when pi_nFilter = 2 then v_vSQL := v_vSQL || ' and t.intake_id = ' || pi_nIntakeID;
      when pi_nFilter = 3 then v_vSQL := v_vSQL || ' and m.status = 2 and t.intake_id <= ' || pi_nIntakeID;
    end case;
    
    v_vSQL := v_vSQL || '            ) a ';
    v_vSQL := v_vSQL || '  order by a.mid, a.series, date_completed, intake_id ';
    
    --open the cursor
    open rs for v_vSQL
      using pi_vPatientID, pi_nMID;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
  end;
  
  /*****
  Gets recordset of instrument score
  *****/
  procedure GetInstrumentScoresRS(pi_vSessionID       in varchar2,
                                 pi_vSessionClientIP in varchar2,
                                 pi_nUserID          in number,
                                     
                                 pi_vPatientID      in varchar2,
                                 pi_nMID            in number,
                                 pi_nIntakeID       in number,
                                     
                                 rs                out PCK_COMMON.refCursor,
                                 po_nStatusCode    out number,
                                 po_vStatusComment out varchar2) 
   is
  
    v_vSQL          varchar2(4000);
    v_nLastIntakeID number := 0;
  
  begin
    po_nStatusCode    := 0;
    po_vStatusComment := '';
  
    v_vSQL := v_vSQL || ' select t.* ';
    v_vSQL := v_vSQL || '   from DATA_INTAKE_SCORE t ';
    v_vSQL := v_vSQL || '    where t.patient_id = :PATIENT_ID ';
    v_vSQL := v_vSQL || '    and t.mid = :MID ';
    v_vSQL := v_vSQL || '    and t.intake_id = :INTAKE_ID ';
    v_vSQL := v_vSQL || '  order by t.series ';
  

    --open the cursor
    open rs for v_vSQL
      using pi_vPatientID, pi_nMID, pi_nIntakeID;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
  end;
  
/*****
 Gets recordset of all instrument score
*****/
  
  procedure GetInstrumentScoresRS(pi_vSessionID       in varchar2,
                                 pi_vSessionClientIP in varchar2,
                                 pi_nUserID          in number,
                                     
                                 pi_vPatientID      in varchar2,
                                 pi_nMID            in number,
                                     
                                 rs                out PCK_COMMON.refCursor,
                                 po_nStatusCode    out number,
                                 po_vStatusComment out varchar2) 
  is
  
    v_vSQL          varchar2(4000);
  
  begin
    po_nStatusCode    := 0;
    po_vStatusComment := '';

 
    v_vSQL := v_vSQL || ' select * ';
    v_vSQL := v_vSQL || '   from (select t.*, ';
    v_vSQL := v_vSQL || '                im.module, ';
    v_vSQL := v_vSQL || '                m.date_completed ';
    v_vSQL := v_vSQL || '           from data_intake_score t, '; 
    v_vSQL := v_vSQL || '                pat_pw_event_module m, '; 
    v_vSQL := v_vSQL || '                intake_module im ';
    v_vSQL := v_vSQL || '          where t.patient_id = :PATIENT_ID ';
    v_vSQL := v_vSQL || '            and t.mid = :MID ';
    v_vSQL := v_vSQL || '            and t.patient_id = m.patient_id ';
    v_vSQL := v_vSQL || '            and t.mid = m.mid ';
    v_vSQL := v_vSQL || '            and t.intake_id = m.intake_id ';
    v_vSQL := v_vSQL || '            and t.mid = im.mid(+)) a ';
    v_vSQL := v_vSQL || '  order by a.mid, a.series, date_completed, intake_id ';
      
    --open the cursor
    open rs for v_vSQL
      using pi_vPatientID, pi_nMID;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
  end;

end PCK_INSTRUMENT_RESPONSES;
/
---------------------------------------
--  Changed package body pck_intake  --
---------------------------------------
create or replace package body tbicds.PCK_INTAKE is

/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

  /*****
  Delete Instrument 
  *****/
  procedure DeleteInstrument(pi_vSessionID       in varchar2,
                             pi_vSessionClientIP  in varchar2,
                             pi_nUserID           in number,
                                     
                             pi_vPatientID        in varchar2,
                             pi_nIntakeID         in number,
                             pi_nMID              in number,
                             pi_nPWEventModuleID  in number,
                                     
                             po_nStatusCode       out number,
                             po_vStatusComment    out varchar2)
  
   is
    v_vSQL  varchar2(4000) := '';
  
  begin
    po_nStatusCode    := PCK_COMMON.c_nResultStatus_Success;
    po_vStatusComment := '';
  
    v_vSQL := v_vSQL || ' delete ';
    v_vSQL := v_vSQL || '   from data_intake d ';
    v_vSQL := v_vSQL || '  where d.patient_id = :PATIENT_ID ';
    v_vSQL := v_vSQL || '    and d.mid = :MID ';
    v_vSQL := v_vSQL || '    and d.intake_id = :INTAKE_ID ';
  
    --delete intake, cascade del will cleanup children
    execute immediate v_vSQL
    using pi_vPatientID, 
          pi_nMID, 
          pi_nIntakeID; 
    commit;
  
    --update the patient_pw_event to reset the tree leaf
    update pat_pw_event_module t 
    set  t.status = 0,
         t.date_started = null,
         t.date_completed = null,
         t.completed_by = null
    where t.patient_id = pi_vPatientID 
    and t.pw_event_module_id = pi_nPWEventModuleID;
    commit;
    
  exception
    when others then
      po_nStatusCode    := PCK_COMMON.c_nResultStatus_Error;
      po_vStatusComment := '';
  end;
  
/*get module type*/
procedure GetModuleType(pi_vSessionID       in varchar2,
                        pi_vSessionClientIP in varchar2,
                        pi_nUserID          in number,
                        pi_nMID             in number,
                        po_nModuleType      out number,
                        po_nStatusCode      out number,
                        po_vStatusComment   out varchar2) 
  is
  
  v_nModuleType number := -1;
  
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
    begin
      select m.module_type
        into v_nModuleType
      from tbicds.intake_module m
      where m.active=1
        and m.mid = pi_nMID;
    exception
      when others then
        v_nModuleType := -1;
    end;
                
    po_nModuleType := v_nModuleType;
    
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_INTAKE.GetModuleType(): ' || sqlErrm;
  end;
  
/*get rs of modules matching search criteria*/
procedure GetAllModuleRS(pi_vSessionID       in varchar2,
                            pi_vSessionClientIP in varchar2,
                            pi_nUserID          in number,
                            po_nStatusCode      out number,
                            po_vStatusComment   out varchar2,
                            rs                  out RetRefCursor) 
  is
  
  v_vSQL varchar2(4000) := '';
  
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
    v_vSQL := 'select s.mid, trim(s.acronym || '' '' || s.module) as module, s.description, s.module_alt_lang, s.module_for from tbicds.intake_module s '
                || 'where s.active=1 '
                || '  and s.module_type=0 '
                || 'order by s.module asc';
                    
    open rs for v_vSQL;
    
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_INTAKE.GetAllModuleRS(): ' || sqlErrm;
  end;


/*get rs of modules that are scoreable*/
procedure GetAllScorableModuleRS(pi_vSessionID       in varchar2,
                            pi_vSessionClientIP in varchar2,
                            pi_nUserID          in number,
                            po_nStatusCode      out number,
                            po_vStatusComment   out varchar2,
                            rs                  out RetRefCursor) 
  is
  
  v_vSQL varchar2(4000) := '';
  
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
    v_vSQL := 'select * from tbicds.intake_module s '
                || 'where s.active=1 '
                || '  and s.module_type=0 '
                || '  and s.mid in (select mid from intake_module_description where scorable =1) '
                || 'order by s.module asc';
    
    open rs for v_vSQL;
    
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_INTAKE.GetAllScorableModuleRS(): ' || sqlErrm;
  end;


/*get rs of modules matching search criteria*/
procedure GetModuleSearchRS(pi_vSessionID       in varchar2,
                            pi_vSessionClientIP in varchar2,
                            pi_nUserID          in number,
                            pi_vSearch          in varchar2,
                            po_nStatusCode      out number,
                            po_vStatusComment   out varchar2,
                            rs                  out RetRefCursor) 
  is
  
  v_vSQL varchar2(4000) := '';
  
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
    v_vSQL := 'select s.mid, trim(s.acronym || '' '' || s.module) as module, s.description, s.module_alt_lang, s.module_for from tbicds.intake_module s '
                || 'where s.active=1 and s.module_type=0 and UPPER(s.acronym) || '' '' || UPPER(s.module) like :P0 '
                || 'order by s.module asc';
    
    open rs for 
    v_vSQL using UPPER('%'||pi_vSearch||'%');
   
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_INTAKE.GetModuleSearchRS(): ' || sqlErrm;
  end;

  /*US:5966
  get intake modules by group id*/
  procedure GetModuleGroupMIDRS(pi_vSessionID       in varchar2,
                                pi_vSessionClientIP in varchar2,
                                pi_nUserID          in number,
                                pi_nModuleGroupID   in number,
                                po_nStatusCode      out number,
                                po_vStatusComment   out varchar2,
                                rs                  out RetRefCursor) 
  is
  
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
    --open recordset
    open rs for
      select t.mid, trim(t.acronym || ' ' || t.module) as module, t.description, t.module_alt_lang, t.module_for, 
             (select count(*) 
              from data_intake_score dis
              where dis.mid = t.mid) as score_count
        from intake_module t, intake_module_group_mid t2
       where t.mid = t2.mid
         and (
                   t2.module_group_id = pi_nModuleGroupID
                   or
                   pi_nModuleGroupID = -1
             )
         
       order by t2.sort_order;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_INTAKE.GetIntakeModulesRS(): ' || sqlErrm;
  end;
  
  /*US:5966
  get intake modules by group id and perform an inner search*/
  procedure GetModuleGroupMIDRS(pi_vSessionID       in varchar2,
                                pi_vSessionClientIP in varchar2,
                                pi_nUserID          in number,
                                pi_nModuleGroupID   in number,
                                pi_vSearch          in varchar2,
                                po_nStatusCode      out number,
                                po_vStatusComment   out varchar2,
                                rs                  out RetRefCursor) 
  is
  
  v_vSQL varchar2(4000) := '';
  
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
    v_vSQL := 'select t.mid, trim(t.acronym || '' '' || t.module) as module, t.description, t.module_alt_lang,' 
              || '(select count(*) from data_intake_score dis where dis.mid = t.mid) as score_count '
              || 'from intake_module t, intake_module_group_mid t2 ' 
              || 'where t.mid = t2.mid and t2.module_group_id = :P0 '
              || 'and t.active = 1 and t.module_type=0 and UPPER(t.acronym) || '' '' || UPPER(t.module) like :P1 '
              || 'order by t2.sort_order';
              
    --open recordset
    open rs for 
      v_vSQL 
    using pi_nModuleGroupID,
          UPPER('%'||pi_vSearch||'%');
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_INTAKE.GetIntakeModulesRS(): ' || sqlErrm;
  end;

  /*get module groups by group type id*/
  procedure GetModuleGroupRS(pi_vSessionID       in varchar2,
                             pi_vSessionClientIP in varchar2,
                             pi_nUserID          in number,
                             pi_nGroupTypeID     in number,
                             po_nStatusCode      out number,
                             po_vStatusComment   out varchar2,
                             rs                  out RetRefCursor) 
  is
  
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
    --open recordset
    if pi_nGroupTypeID != -1 then
    
      open rs for
      select *
        from intake_module_group t
       where t.module_group_type_id = pi_nGroupTypeID
       order by sort_order;
    
    else
    
       open rs for
       select -1 as MODULE_GROUP_ID,
             'All' as MODULE_GROUP_DESCR,
             1 as SORT_ORDER,
             'All' as DESCRIPTION,
             -1 as EVENT_ID,
             1 as ACTIVE,
             0 as STAT_MODALITY_ID,
             -1 as MODULE_GROUP_TYPE_ID
      from dual;
      
      end if;
              
      
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_INTAKE.GetIntakeModulesRS(): ' || sqlErrm;
  end;

  /*get module group types such as domain and clinical setting*/
  procedure GetModuleGroupTypeRS(pi_vSessionID       in varchar2,
                                 pi_vSessionClientIP in varchar2,
                                 pi_nUserID          in number,
                                 po_nStatusCode      out number,
                                 po_vStatusComment   out varchar2,
                                 rs                  out RetRefCursor)
  is
  
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
    --open recordset
    open rs for
    
      select i.*
        from tbicds.intake_module_group_type i
       where i.active = 1
       order by sort_order;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_INTAKE.GetIntakeModulesRS(): ' || sqlErrm;
  end;

  /*get resposne load recordset*/
  procedure GetResponseLoadRS(pi_vSessionID       in varchar2,
                              pi_vSessionClientIP in varchar2,
                              pi_nUserID          in number,
                              pi_vLoadTable       in varchar2,
                              pi_vLoadField       in varchar2,
                              pi_vLoadFilter      in varchar2,
                              po_nStatusCode      out number,
                              po_vStatusComment   out varchar2,
                              rs                  out RetRefCursor) 
  is
  
    strSQL long;
  
  begin
  
    strSQL            := '';
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
    strSQL := strSQL || 'SELECT ' || pi_vLoadField;
    strSQL := strSQL || ' FROM ' || case
                when (lower(pi_vLoadTable) not like 'tbicds.%') then
                 'tbicds.'
              end || pi_vLoadTable;
  
    if length(pi_vLoadFilter) > 2 then
      strSQL := strSQL || ' ' || pi_vLoadFilter;
    end if;
  
    --open recordset
    open rs for strSQL;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_INTAKE.GetResponseLoadRS(): ' || sqlErrm;
  end;

  /*get intake module recordset*/
  procedure GetIntakeModulesRS(pi_vSessionID       in varchar2,
                               pi_vSessionClientIP in varchar2,
                               pi_nUserID          in number,
                               po_nStatusCode      out number,
                               po_vStatusComment   out varchar2,
                               rs                  out RetRefCursor) 
  is
  
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
    --open recordset
    open rs for
    
      select i.*
        from tbicds.intake_module i
       where i.active = 1
      --and i.module_for = 1
        and i.module_type = 0
       order by sort_order;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_INTAKE.GetIntakeModulesRS(): ' || sqlErrm;
  end;

  /*Get module group recordset*/
  procedure GetModuleGroupRS(pi_vSessionID       in varchar2,
                             pi_vSessionClientIP in varchar2,
                             pi_nUserID          in number,
                             po_nStatusCode      out number,
                             po_vStatusComment   out varchar2,
                             rs                  out RetRefCursor) 
  is
  
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
    --open recordset
    open rs for
      select *
        from tbicds.intake_module_group t
       where t.active = 1
       order by t.module_group_id;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_INTAKE.GetModuleGroupRS(): ' || sqlErrm;
  end;

  /*Get module list recordset*/
  procedure GetModulesListRS(pi_vSessionID       in varchar2,
                             pi_vSessionClientIP in varchar2,
                             pi_nUserID          in number,
                             po_nStatusCode      out number,
                             po_vStatusComment   out varchar2,
                             rs                  out RetRefCursor) 
  is
  
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
    --open recordset
    open rs for
      select m.module_group_id,
             m.mid,
             m.sort_order,
             m2.module,
             m2.description
        from (select imgm.*, img.module_group_descr
                from tbicds.intake_module_group_mid imgm,
                     tbicds.intake_module_group     img,
                     tbicds.intake_module           im
               where img.module_group_id = imgm.module_group_id
                 and im.mid = imgm.mid
                 and im.active = 1
                 and im.module_type = 0) m
        left join (select * from tbicds.intake_module im where im.active = 1 and im.module_type = 0) m2
          on m2.mid = m.mid
       order by m.module_group_id, m.sort_order;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_INTAKE.GetModulesListRS(): ' || sqlErrm;
  end;

  /*start the module*/
  procedure StartModule(pi_vSessionID       in varchar2,
                           pi_vSessionClientIP in varchar2,
                           pi_nUserID          in number,
                           
                           pi_vPatientID in varchar2,
                           pi_nMID       in number,
                           pi_nGroupID   in number,
                           pi_nIntakeID  in number,
                           
                           po_nStatusCode    out number,
                           po_vStatusComment out varchar2) 
  is
  
  v_dtSysDate date := null;
  v_nExists   number := 0;
  
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
    
    v_dtSysDate := sysdate;   
    
    begin
      select 1 
        into v_nExists
      from data_intake
      where patient_id = pi_vPatientID
        and intake_id = pi_nIntakeID
        and mid = pi_nMID;
    exception
      when others then
      v_nExists := 0;
    end;
    
    if v_nExists = 0 then
       --insert...    
       insert into data_intake
       (patient_id,
       intake_id,
       mid,
       start_date)
       values
       (pi_vPatientID,
       pi_nIntakeID,
       pi_nMID,
       v_dtSysDate);
       commit;
    else
      --update...
      update data_intake set
       start_date = v_dtSysDate
      where patient_id = pi_vPatientID
        and intake_id = pi_nIntakeID
        and mid = pi_nMID;
      commit;
    end if;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_INTAKE.StartModule(): ' || sqlErrm;
  end;
  
  /*Mark module complete*/
  procedure CompleteModule(pi_vSessionID       in varchar2,
                           pi_vSessionClientIP in varchar2,
                           pi_nUserID          in number,
                           
                           pi_vPatientID in varchar2,
                           pi_nMID       in number,
                           pi_nGroupID   in number,
                           pi_nIntakeID  in number,
                           
                           po_nStatusCode    out number,
                           po_vStatusComment out varchar2) 
  is
  
  v_dtSysDate date := null;
  
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
    
    v_dtSysDate := sysdate;   
      
    --update...
       update data_intake set
         complete = 1,
         complete_date = v_dtSysDate
       where patient_id = pi_vPatientID
         and intake_id = pi_nIntakeID
         and mid = pi_nMID;
       
    --AUDIT TRAIL
    update data_intake_responses_audit set complete_date = v_dtSysDate
    where patient_id = pi_vPatientID
      and mid = pi_nMID
      and intake_id = pi_nIntakeID
      and complete_date is null;
      
    update data_intake_score_audit set complete_date = v_dtSysDate
    where patient_id = pi_vPatientID
      and mid = pi_nMID
      and intake_id = pi_nIntakeID
      and complete_date is null;
       
    commit;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_INTAKE.CompleteModule(): ' || sqlErrm;
  end;


  /*Get score data as a string*/
  PROCEDURE GetScoreDataStringRS(pi_vSessionID       in varchar2,
                                 pi_vSessionClientIP in varchar2,
                                 pi_nUserID          in number,
                                 pi_vPatientID       in varchar2,
                                 po_nStatusCode      out number,
                                 po_vStatusComment   out varchar2,
                                 rs                  out RetRefCursor)
  
   is
  
    v_vPatientID  VARCHAR2(50) := pi_vPatientID;
    v_nEncTypeID  NUMBER := 99;
    v_nMaxSeries  NUMBER := 1;
    v_nCurrSeries NUMBER := 1;
    v_nCurrMID    NUMBER := 0;
    v_dtRespDate  DATE := null;
    v_vLabel      VARCHAR2(32767) := NULL;
    v_vDATA       VARCHAR2(32767) := '';
    curEnc        RetRefCursor;
   -- CURSOR curMID IS
   --   SELECT DISTINCT mid
   --     FROM tbicds.encounter_intake_score s
   --    WHERE s.encounter_id IN
   --          (SELECT encounter_id
   --             FROM tbicds.encounter e
   --            WHERE e.patient_id = v_vPatientID
   --              AND e.encounter_type_id = v_nEncTypeID)
   --    ORDER BY mid;
  BEGIN
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
    -- open the string
    v_vDATA := v_vDATA || '[';
  /*  FOR recMID IN curMID LOOP
      BEGIN
        SELECT MAX(series)
          INTO v_nMaxSeries
          FROM tbicds.encounter_intake_score
         WHERE mid = recMID.mid
           AND encounter_id IN
               (SELECT encounter_id
                  FROM tbicds.encounter e
                 WHERE e.patient_id = v_vPatientID
                   AND e.encounter_type_id = v_nEncTypeID);
      EXCEPTION
        WHEN OTHERS THEN
          v_nMaxSeries := 1;
      END;
      -- write segment: {"mid": ####, "mid_data": [
      v_vDATA := v_vDATA || '{"mid": ' || TO_CHAR(recMID.mid) ||
                 ', "mid_data": [';
      FOR n IN 1 .. v_nMaxSeries LOOP
        v_nCurrSeries := n;
        v_vDATA       := v_vDATA || '{"data": [';
        FOR recEnc IN (SELECT t1.*, t2.encounter_date
                         FROM tbicds.encounter_intake_score t1,
                              tbicds.encounter              t2
                        WHERE t2.encounter_id = t1.encounter_id
                          AND mid = recMID.mid
                          AND series = n
                          AND t2.encounter_id IN
                              (SELECT DISTINCT encounter_id
                                 FROM tbicds.encounter
                                WHERE encounter_type_id = v_nEncTypeID
                                  AND patient_id = v_vPatientID)
                        ORDER BY t2.encounter_date, t1.encounter_intake_id) LOOP
          --get the date of the assessment not the encounter
          begin
            select max(r.response_datetime)
              into v_dtRespDate
              from tbicds.encounter_intake_responses r
             where r.encounter_id = recEnc.Encounter_Id
               and r.mid = recEnc.mid
               and r.encounter_intake_id = recEnc.Encounter_Intake_Id;
          exception
            when others then
              v_dtRespDate := recEnc.Encounter_Date;
          end;
        
          --write the POINT data
          v_vDATA := v_vDATA || '["' || TO_CHAR(v_dtRespDate, 'mm/dd/yyyy') ||
                     '", "' || TO_CHAR(recEnc.score) || '"],';
          IF (recMID.mid IN (3016, 3020)) THEN
            IF recEnc.interpret IS NOT NULL THEN
              v_vLabel := recEnc.interpret;
            END IF;
          END IF;
        END LOOP;
        v_vDATA := SUBSTR(v_vDATA, 1, LENGTH(v_vDATA) - 1);
        v_vDATA := v_vDATA || ']';
        IF (v_vLabel IS NOT NULL OR LENGTH(v_vLabel) > 0) THEN
          v_vDATA  := v_vDATA || ', "label": "' || v_vLabel || '" ';
          v_vLabel := null;
        END IF;
        v_vDATA := v_vDATA || '},';
      END LOOP;
      -- close the string here
      v_vDATA := SUBSTR(v_vDATA, 1, LENGTH(v_vDATA) - 1);
      v_vDATA := v_vDATA || ']},';
    END LOOP;
    -- ******************************
    -- END OF LOOPS
    if LENGTH(v_vDATA) > 1 then
      v_vDATA := SUBSTR(v_vDATA, 1, LENGTH(v_vDATA) - 1);
    end if;
    v_vDATA := v_vDATA || ']';
    --dbms_output.put_line(v_vDATA);
  
    OPEN rs FOR
      SELECT v_vDATA AS mid_data FROM dual;*/
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_INTAKE.GetScoreDataStringRS(): ' || sqlErrm;
  END;
  
  /*****
  Gets next module intake_id
  *****/
  procedure GetNextMIDIntakeIDRS(pi_vSessionID       in varchar2,
                             pi_vSessionClientIP   in varchar2,
                             pi_nUserID            in number,
                             pi_vPatientID          in varchar2,
                             pi_nMID                in number,
                             po_nStatusCode      out number,
                             po_vStatusComment   out varchar2,
                             rs                  out RetRefCursor) 
  is
  v_nIntakeID number;
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
    
    -- v_nIntakeID := fngetlastintakeid(pi_vPatientID, pi_nMID) + 1;
    select seqintakeid.nextval into v_nIntakeID from dual;  
  
    --open recordset
    open rs for
      select v_nIntakeID as intake_id
        from dual;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
  end;

end;
/
-----------------------------------------
--  Changed package body pck_military  --
-----------------------------------------
create or replace package body tbicds.PCK_MILITARY is

/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
   /*Get military service recordset*/
   procedure GetMilitaryServiceRS(pi_vSessionID       in varchar2,
                                 pi_vSessionClientIP in varchar2,
                                 pi_nUserID          in number,
                                 po_nStatusCode      out number,
                                 po_vStatusComment   out varchar2,
                                 rs                  out RetRefCursor)
   is
      v_vSql                               varchar2(4000);
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
   
      --open recordset
      v_vSql := 'select * from tbicds.stat_military_service where active = 1';
      open rs for v_vSql;
   
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_MILITARY.GetMilitaryServiceRS(): ' || sqlErrm;
   end;

   /*Get military duty station recordset*/
   procedure GetMilitaryDutyStationRS(pi_vSessionID       in varchar2,
                                     pi_vSessionClientIP in varchar2,
                                     pi_nUserID          in number,
                                     po_nStatusCode      out number,
                                     po_vStatusComment   out varchar2,
                                     rs                  out RetRefCursor)
   is
      v_vSql                               varchar2(4000);
      v_bMAJCOMRights boolean := false;
      v_bHQRights     boolean := false;
      v_nDIMS_ID      number := 0;
      v_nMAJCOM_ID    number := 0;
   begin
      po_nStatusCode    := 0;
      po_vStatusComment := '';
   
      -- get base id
      begin
         v_vSql := 'select dims_id from tbicds.app_user where fx_user_id = :P0';
         execute immediate v_vSql into v_nDIMS_ID using pi_nUserID;
      exception
         when others then
            null;
      end;
   
      --open recordset
      v_vSql := 'select distinct t.* '
                || 'from tbicds.stat_dims_base t '
                || 'where t.active = 1 '
                || 'order by t.sort_order';
      open rs for v_vSQL;
   
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_MILITARY.GetMilitaryDutyStationRS(): ' || sqlErrm;
   end;

end;
/
-------------------------------------
--  Changed package body pck_note  --
-------------------------------------
create or replace package body tbicds.PCK_NOTE is
/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
/*****
Description: Gets all cosigners for a site/region
******/
procedure GetCosignerRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      
      pi_nRegionID              in number,
      pi_nSiteID                in number,
      pi_vSearch                in varchar2,
      
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is
     --var to hold like search
     v_vSearch varchar2(500) := '';

     --sql select
     v_vSQL varchar2(500) :=
      'SELECT t.*, t2.duz 
         FROM tbicds.app_user t,
              tbicds.fx_user t2
        WHERE t.fx_user_id = t2.fx_user_id 
          AND t2.region_id = :REGION_ID
          AND t2.site_id = :SITE_ID
          AND upper(t.name) 
              like upper(nvl(:SEARCH, t.name))
     ORDER BY upper(t.NAME) asc';
    
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --add % for like 
    v_vSearch := '%' || pi_vSearch || '%';
       
    --open the result set
    open rs for v_vSQL
    using pi_nregionid,
          pi_nSiteID,
          v_vSearch;
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;


/*****
Description: Gets all clinics for a site/region
******/
procedure GetClinicRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      
      pi_nRegionID              in number,
      pi_nSiteID                in number,
      pi_vSearch                in varchar2,
      
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is
     --var to hold like search
     v_vSearch varchar2(500) := '';

     --sql select
     v_vSQL varchar2(500) :=
      'SELECT t.*
         FROM tbicds.utl_Clinic t
        WHERE t.region_id = :region_id
          AND t.site_id = :site_id 
          AND upper(t.clinic_label) 
              like upper(nvl(:SEARCH, t.clinic_label))
     ORDER BY upper(t.Clinic_label) asc';
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --add % for like 
    v_vSearch := '%' || pi_vSearch || '%';
   
    --open the result set
    open rs for v_vSQL
    using pi_nRegionID, 
          pi_nSiteID,
          v_vSearch;
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
     
end;


/*****
Description: Gets all note titles for a site/region
******/
procedure GetNoteTitleRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      
      pi_nRegionID              in number,
      pi_nSiteID                in number,
      pi_vSearch                in varchar2,
      
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is
     --var to hold like search
     v_vSearch varchar2(500) := '';

     --sql select
     v_vSQL varchar2(500) :=
      'SELECT t.*, 
              decode(t.is_consult,1,''Y'',''N'') as consult_yn
         FROM tbicds.utl_note_title t
        WHERE t.region_id = :REGION_ID
          AND t.site_id = :SITE_ID
          AND upper(t.note_title_label) 
              like upper(nvl(:SEARCH, t.note_title_label))
     ORDER BY upper(t.note_title_label) asc';
     
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --add % for like 
    v_vSearch := '%' || pi_vSearch || '%';
    
    --open the result set
    open rs for v_vSQL
    using pi_nregionid,
          pi_nSiteID,
          v_vSearch;
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;

/*****
Description: Gets all patient appointments for a site/region/dfn
******/
procedure GetPatientAppointmentRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      
      pi_nRegionID              in number,
      pi_nSiteID                in number,
      pi_vDFN                   in varchar2,
      pi_dtFrom                 in date,
      pi_dtTo                   in date,
            
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is

     v_vSQL varchar2(500) :=
      'SELECT t.*, 
              t2.clinic_label
         FROM tbicds.patient_appointment t,
              tbicds.utl_clinic t2
        WHERE t.region_id = :REGION_ID
          AND t.appt_clinic_id = t2.clinic_id
          AND t2.region_id = :REGION_ID 
          AND t2.site_id = :SITE_ID  
          AND t.site_id = :SITE_ID
          AND t.dfn = :DFN
          AND (t.appt_datetime > :FROM_DATE 
               AND t.appt_datetime < :TO_DATE)
     ORDER BY t.appt_datetime desc';
     
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
    open rs for v_vSQL
    using pi_nregionid,
          pi_nregionid,
          pi_nSiteID,
          pi_nSiteID,
          pi_vDFN,
          pi_dtFrom - 1,
          pi_dtTo + 1;
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;

/*****
Description: Gets all patient visits for a site/region/dfn
******/
procedure GetPatientVisitRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      
      pi_nRegionID              in number,
      pi_nSiteID                in number,
      pi_vDFN                   in varchar2,
      pi_dtFrom                 in date,
      pi_dtTo                   in date,
      
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is

     v_vSQL varchar2(500) :=
      'SELECT t.* 
        FROM tbicds.patient_visit t
       WHERE region_id = :REGION_ID
         AND site_id = :SITE_ID
         AND dfn = :DFN
         AND (t.visit_datetime > :FROM_DATE 
              AND t.visit_datetime < :TO_DATE)
    ORDER BY t.visit_datetime desc';
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
    open rs for v_vSQL
    using pi_nregionid,
          pi_nSiteID,
          pi_vDFN,
          pi_dtFrom - 1,
          pi_dtTo + 1;
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;

/*****
Description: Gets all patient consults for a site/region/dfn
******/
procedure GetPatientConsultRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      
      pi_nRegionID              in number,
      pi_nSiteID                in number,
      pi_vDFN                   in varchar2,
      pi_dtFrom                 in date,
      pi_dtTo                   in date,
      
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is

     v_vSQL varchar2(500) :=
      'SELECT t.* 
         FROM tbicds.patient_consult t
        WHERE region_id = :REGION_ID
          AND site_id = :SITE_ID
          AND dfn = :DFN
          AND (t.consult_datetime > :FROM_DATE 
              AND t.consult_datetime < :TO_DATE)
     ORDER BY t.consult_datetime desc';
     
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
    open rs for v_vSQL
    using pi_nregionid,
          pi_nSiteID,
          pi_vDFN,
          pi_dtFrom - 1,
          pi_dtTo + 1;
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';

end;

/*****
Description: Gets all patient admissions for a site/region/dfn
******/
procedure GetPatientAdmissionRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      
      pi_nRegionID              in number,
      pi_nSiteID                in number,
      pi_vDFN                   in varchar2,
      pi_dtFrom                 in date,
      pi_dtTo                   in date,
      
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is

     v_vSQL varchar2(500) :=
      'SELECT t.*
         FROM tbicds.patient_admission t 
        WHERE t.region_id = :REGION_ID 
          AND t.site_id = :SITE_ID 
          AND t.dfn = :DFN 
          AND (t.admit_datetime > :FROM_DATE 
              AND t.admit_datetime < :TO_DATE)
     ORDER BY admit_datetime desc';
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
    open rs for v_vSQL
    using pi_nregionid,
          pi_nSiteID,
          pi_vDFN,
          pi_dtFrom - 1,
          pi_dtTo + 1;
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;




end PCK_NOTE;
/
---------------------------------------------
--  Changed package body pck_note_prefill  --
---------------------------------------------
create or replace package body tbicds.PCK_NOTE_PREFILL is
/* Copyright 2015 Intellica Corporation
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

  /*get outcomes reviewed*/
  function fnGetOutcomesReviewedList(pi_vPatientID        in varchar2,
                                     pi_nPatPWEventID     in number) return varchar2
  is

    v_nBreakMID       number := -1;
    v_nBreakIntakeID  number := -1;

    v_vName           varchar2(32767) := '';
    v_vCurrentScore   varchar2(32767) := '';
    v_vPreviousScore  varchar2(32767) := '';
    v_vStatus         varchar2(32767) := '';

    v_vResponse       varchar2(32767) := '';
    po_vResponseValue varchar2(32767) := '';

  begin

    --get all outcomes that are reviewed
    for rec in (
        select
       --t.patient_id,
       --t.pat_pw_id,
       --t.pat_pw_event_id,
       --t.pw_event_module_id,
         t.mid
        ,t.intake_id
        ,t2.acronym
        ,t2.module
        ,(select es.event_status
          from pat_pw_event_entry pe,
               stat_event_status es
          where pe.event_status_id = es.event_status_id
            and pe.patient_id = t.patient_id
            and pe.pw_event_module_id = t.pw_event_module_id
            and pe.event_date =
             (select max(event_date)
                from pat_pw_event_entry pe2
               where pe2.pw_event_module_id = t.pw_event_module_id)
            and rownum=1) as current_status

        ,(select es.event_severity
          from pat_pw_event_entry pe,
               stat_event_severity es
          where pe.event_severity_id = es.event_severity_id
            and pe.patient_id = t.patient_id
            and pe.pw_event_module_id = t.pw_event_module_id
            and pe.event_date =
             (select max(event_date)
                from pat_pw_event_entry pe2
               where pe2.pw_event_module_id = t.pw_event_module_id)
            and rownum=1) as current_severity

          ,scores.description
          ,scores.interpretation
          ,scores.current_score
          ,scores.previous_score
          ,scores.exists_previous_score

          from PAT_PW_EVENT_MODULE t,
               intake_module t2,
               (select
                 t.patient_id
                ,t.mid
                ,t.intake_id
                ,t.series
                ,t.description
                ,t.interpretation
                ,t.score as current_score
                ,nvl((select 1
                  from data_intake_score s
                  where s.patient_id=t.patient_id
                    and s.mid = t.mid
                    and s.intake_id=(select max(s.intake_id)
                                     from data_intake_score s
                                     where s.patient_id = t.patient_id
                                       and s.mid = t.mid
                                       and s.intake_id < t.intake_id
                                       and s.series = t.series)
                    and s.series=t.series),0) as exists_previous_score
                ,(select s.score
                  from data_intake_score s
                  where s.patient_id=t.patient_id
                    and s.mid = t.mid
                    and s.intake_id=(select max(s.intake_id)
                                     from data_intake_score s
                                     where s.patient_id = t.patient_id
                                       and s.mid = t.mid
                                       and s.intake_id < t.intake_id
                                       and s.series = t.series)
                    and s.series=t.series) as previous_score
                from data_intake_score t
                where t.patient_id = pi_vPatientID
                  and lower(t.description) in('total score', 'total score raw', 'total score standard', 'rate')) scores
          where t.patient_id = pi_vPatientID
            and t.pat_pw_event_id = pi_nPatPWEventID
            and t2.mid = t.mid
            and nvl(t.intake_id,-1) > 0
            and t.pw_event_module_id in(select distinct pw_event_module_id
                                        from PAT_PW_EVENT_ENTRY
                                        where patient_id = pi_vPatientID
                                          and pat_pw_event_id = pi_nPatPWEventID)
            and scores.patient_id(+) = t.patient_id
            and scores.mid(+)        = t.mid
            and scores.intake_id(+)  = t.intake_id
       order by t.mid, t.date_scheduled, scores.series
       )
    loop
      -- Format string
      if v_nBreakMID = rec.mid and v_nBreakIntakeID = rec.intake_id then
        --add current score
        if rec.description is not null then
          v_vCurrentScore := v_vCurrentScore || 'Current ' || rec.description || ': ';
          if rec.current_score is null then
            v_vCurrentScore := v_vCurrentScore || '__ ' || rec.interpretation || chr(10);
          else
            v_vCurrentScore := v_vCurrentScore || rec.current_score || ' ' ||rec.interpretation || chr(10);
          end if;
        end if;
        --add previous score
        if rec.description is not null then
          if rec.exists_previous_score = 1 then
            v_vPreviousScore := v_vPreviousScore || 'Previous ' || rec.description || ': ';
            if rec.previous_score is null then
              v_vPreviousScore := v_vPreviousScore || '__ ' || rec.interpretation || chr(10);
            else
              v_vPreviousScore := v_vPreviousScore || rec.previous_score || ' ' || rec.interpretation || chr(10);
            end if;
          end if;
        end if;
      else
        -- check if we need to break...
        if v_nBreakMID != -1 or v_nBreakIntakeID != -1 then
          v_vResponse := v_vResponse || v_vName || v_vCurrentScore || v_vPreviousScore || v_vStatus;
          v_vResponse := v_vResponse || chr(10) || chr(10);

          --reset var
          v_vName := '';
          v_vCurrentScore := '';
          v_vPreviousScore := '';
          v_vStatus := '';

        end if;

        -- hold key to identify when to break
        v_nBreakMID := rec.mid;
        v_nBreakIntakeID := rec.intake_id;

        --set module name
        if rec.acronym is null then
          v_vName := rec.module || chr(10);
        else
          v_vName := rec.acronym || ' ' || rec.module || chr(10);
        end if;
        --set current score
        if rec.description is not null then
          v_vCurrentScore := 'Current ' || rec.description || ': ';
          if rec.current_score is null then
            v_vCurrentScore := v_vCurrentScore || '__ ' || rec.interpretation || chr(10);
          else
            v_vCurrentScore := v_vCurrentScore || rec.current_score || ' ' ||rec.interpretation || chr(10);
          end if;
        end if;
        --set previous score
        if rec.description is not null then
          if rec.exists_previous_score = 1 then
            v_vPreviousScore := 'Previous ' || rec.description || ': ';
            if rec.previous_score is null then
              v_vPreviousScore := v_vPreviousScore || '__ ' || rec.interpretation || chr(10);
            else
              v_vPreviousScore := v_vPreviousScore || rec.previous_score || ' ' || rec.interpretation || chr(10);
            end if;
          end if;
        end if;
        --set status
        v_vStatus := 'Status: ';
        if rec.current_status is null then
          v_vStatus := v_vStatus || '____';
        else
          v_vStatus := v_vStatus || rec.current_status;
        end if;
      end if;
    end loop;

    -- add the last one...
    v_vResponse := v_vResponse || v_vName || v_vCurrentScore || v_vPreviousScore || v_vStatus;


    if v_vResponse is null then
      v_vResponse := '______________';
    else
      v_vResponse := v_vResponse || chr(10) || chr(10);
    end if;

    po_vResponseValue := v_vResponse;
    return po_vResponseValue;

  exception
    when others then
      return po_vResponseValue;
  end;

  /*Get outcomes reviewed*/
  function fnGetOutcomesReviewedList2(pi_vPatientID        in varchar2,
                                      pi_nPatPWEventID     in number) return clob
  is

    v_nBreakMID       number := -1;
    v_nBreakIntakeID  number := -1;

    v_vName           varchar2(32767) := '';
    v_vCurrentScore   varchar2(32767) := '';
    v_vPreviousScore  varchar2(32767) := '';
    v_vStatus         varchar2(32767) := '';

    --v_vResponse       varchar2(32767) := '';
    --po_vResponseValue varchar2(32767) := '';

    v_vResponse       clob := '';
    po_vResponseValue clob := '';

  begin

    --get all outcomes that are reviewed
    for rec in (
        select
       --t.patient_id,
       --t.pat_pw_id,
       --t.pat_pw_event_id,
       --t.pw_event_module_id,
         t.mid
        ,t.intake_id
        ,t2.acronym
        ,t2.module
        ,(select es.event_status
          from pat_pw_event_entry pe,
               stat_event_status es
          where pe.event_status_id = es.event_status_id
            and pe.patient_id = t.patient_id
            and pe.pw_event_module_id = t.pw_event_module_id
            and pe.event_date =
             (select max(event_date)
                from pat_pw_event_entry pe2
               where pe2.pw_event_module_id = t.pw_event_module_id)
            and rownum=1) as current_status

        ,(select es.event_severity
          from pat_pw_event_entry pe,
               stat_event_severity es
          where pe.event_severity_id = es.event_severity_id
            and pe.patient_id = t.patient_id
            and pe.pw_event_module_id = t.pw_event_module_id
            and pe.event_date =
             (select max(event_date)
                from pat_pw_event_entry pe2
               where pe2.pw_event_module_id = t.pw_event_module_id)
            and rownum=1) as current_severity

          ,scores.description
          ,scores.interpretation
          ,scores.current_score
          ,scores.previous_score
          ,scores.exists_previous_score

          from PAT_PW_EVENT_MODULE t,
               intake_module t2,
               (select
                 t.patient_id
                ,t.mid
                ,t.intake_id
                ,t.series
                ,t.description
                ,t.interpretation
                ,t.score as current_score
                ,nvl((select 1
                  from data_intake_score s
                  where s.patient_id=t.patient_id
                    and s.mid = t.mid
                    and s.intake_id=(select max(s.intake_id)
                                     from data_intake_score s
                                     where s.patient_id = t.patient_id
                                       and s.mid = t.mid
                                       and s.intake_id < t.intake_id
                                       and s.series = t.series)
                    and s.series=t.series),0) as exists_previous_score
                ,(select s.score
                  from data_intake_score s
                  where s.patient_id=t.patient_id
                    and s.mid = t.mid
                    and s.intake_id=(select max(s.intake_id)
                                     from data_intake_score s
                                     where s.patient_id = t.patient_id
                                       and s.mid = t.mid
                                       and s.intake_id < t.intake_id
                                       and s.series = t.series)
                    and s.series=t.series) as previous_score
                from data_intake_score t
                where t.patient_id = pi_vPatientID
                  --and (
                  --  lower(t.description) in('total score', 'total score raw', 'total score standard', 'rate') or
                  --  lower(t.description) like '%subscale%'
                  --  )
                 ) scores
          where t.patient_id = pi_vPatientID
            and t.pat_pw_event_id = pi_nPatPWEventID
            and t2.mid = t.mid
            and nvl(t.intake_id,-1) > 0
            and t.pw_event_module_id in(select distinct pw_event_module_id
                                        from PAT_PW_EVENT_ENTRY
                                        where patient_id = pi_vPatientID
                                          and pat_pw_event_id = pi_nPatPWEventID)
            and scores.patient_id(+) = t.patient_id
            and scores.mid(+)        = t.mid
            and scores.intake_id(+)  = t.intake_id
       order by t.mid, t.date_scheduled, scores.series
       )
    loop
      -- Format string
      if v_nBreakMID = rec.mid and v_nBreakIntakeID = rec.intake_id then
        --add current score
        if rec.description is not null then
          v_vCurrentScore := v_vCurrentScore || 'Current ' || rec.description || ': ';
          if rec.current_score is null then
            v_vCurrentScore := v_vCurrentScore || '__ ' || rec.interpretation || chr(10);
          else
            v_vCurrentScore := v_vCurrentScore || rec.current_score || ' ' ||rec.interpretation || chr(10);
          end if;
        end if;
        --add previous score
        if rec.description is not null then
          if rec.exists_previous_score = 1 then
            v_vPreviousScore := v_vPreviousScore || 'Previous ' || rec.description || ': ';
            if rec.previous_score is null then
              v_vPreviousScore := v_vPreviousScore || '__ ' || rec.interpretation || chr(10);
            else
              v_vPreviousScore := v_vPreviousScore || rec.previous_score || ' ' || rec.interpretation || chr(10);
            end if;
          end if;
        end if;
      else
        -- check if we need to break...
        if v_nBreakMID != -1 or v_nBreakIntakeID != -1 then
          v_vResponse := v_vResponse || v_vName || v_vCurrentScore || v_vPreviousScore || v_vStatus;
          v_vResponse := v_vResponse || chr(10) || chr(10);

          --reset var
          v_vName := '';
          v_vCurrentScore := '';
          v_vPreviousScore := '';
          v_vStatus := '';

        end if;

        -- hold key to identify when to break
        v_nBreakMID := rec.mid;
        v_nBreakIntakeID := rec.intake_id;

        --set module name
        if rec.acronym is null then
          v_vName := rec.module || chr(10);
        else
          v_vName := rec.acronym || ' ' || rec.module || chr(10);
        end if;
        --set current score
        if rec.description is not null then
          v_vCurrentScore := 'Current ' || rec.description || ': ';
          if rec.current_score is null then
            v_vCurrentScore := v_vCurrentScore || '__ ' || rec.interpretation || chr(10);
          else
            v_vCurrentScore := v_vCurrentScore || rec.current_score || ' ' ||rec.interpretation || chr(10);
          end if;
        end if;
        --set previous score
        if rec.description is not null then
          if rec.exists_previous_score = 1 then
            v_vPreviousScore := 'Previous ' || rec.description || ': ';
            if rec.previous_score is null then
              v_vPreviousScore := v_vPreviousScore || '__ ' || rec.interpretation || chr(10);
            else
              v_vPreviousScore := v_vPreviousScore || rec.previous_score || ' ' || rec.interpretation || chr(10);
            end if;
          end if;
        end if;
        --set status
        v_vStatus := 'Status: ';
        if rec.current_status is null then
          v_vStatus := v_vStatus || '____';
        else
          v_vStatus := v_vStatus || rec.current_status;
        end if;
      end if;
    end loop;

    -- add the last one...
    v_vResponse := v_vResponse || v_vName || v_vCurrentScore || v_vPreviousScore || v_vStatus;


    if v_vResponse is null then
      v_vResponse := '______________';
    else
      v_vResponse := v_vResponse || chr(10) || chr(10);
    end if;

    po_vResponseValue := v_vResponse;
    return po_vResponseValue;

  exception
    when others then
      return po_vResponseValue;
  end;

  /*Get outcome notes*/
  function fnGetOutcomesNotes(pi_vPatientID              in varchar2,
                              pi_nPatPWEventID           in number) return varchar2 
  is

    v_vResponse       varchar2(32767) := '';
    po_vResponseValue varchar2(32767) := '';

  begin

    --get all outcomes notes
    for rec in (
        select
         TO_CHAR(e.event_date, 'YYYY-DD-MM HH24:MI:SS') || chr(10) || u.name || chr(10) || e.event_comment as note
        from pat_pw_event_entry e,
             app_user u
        where e.fx_user_id = u.fx_user_id
          and e.patient_id = pi_vPatientID
          and e.pat_pw_event_id = pi_nPatPWEventID
        order by e.event_date
       )
    loop
      if rec.note is not null then
          v_vResponse := v_vResponse || chr(10) || rec.note || chr(10);
      end if;
    end loop;

    if v_vResponse is null then
      v_vResponse := '______________';
    else
      v_vResponse := v_vResponse;
    end if;

    po_vResponseValue := v_vResponse;
    return po_vResponseValue;

  exception
    when others then
      return po_vResponseValue;
  end;

  /*Get question response list*/
  function fnGetQuestionResponseList(pi_vPatientID        in varchar2,
                                     pi_nModuleIdentifier in varchar2,
                                     pi_nTID              in number,
                                     pi_nQID              in number) return varchar2 
  is

    v_nIntakeID       number := -1;
    v_vResponse       varchar2(32767) := '';
    po_vResponseValue varchar2(32767) := '';

    rs RetRefCursor;
  begin

    --get the last intake id for the module specified
    begin
      select max(i.intake_id)
        into v_nIntakeID
      from data_intake i,
           intake_module m
      where i.mid = m.mid
        and i.patient_id = pi_vPatientID
        and m.identifier = pi_nModuleIdentifier;
      exception
        when others then
          v_nIntakeID := -1;
    end;

    --get all responses for the question
    for rec in (select
                  trim(
                  case
                    when r.display_type = 3 then
                      r.response || ' ' ||
                      rs.response_value ||
                      nvl(' ' || r.unit, '')
                    when r.display_type in(4,22) then
                      r.response || ' ' ||
                      rs.response_value
                    else
                      rs.response_value
                  end) as response_value
                from data_intake_responses rs,
                     intake_module m,
                     intake_response r
                where m.mid = rs.mid
                  and r.mid = rs.mid
                  and r.rid = rs.rid
                  and rs.patient_id = pi_vPatientID
                  and m.identifier = pi_nModuleIdentifier
                  and rs.tid = pi_nTID
                  and rs.qid = pi_nQID
                  and rs.intake_id = v_nIntakeID)
    loop
      if rec.response_value is not null then
        v_vResponse := v_vResponse || chr(9) || rec.response_value || chr(10);
      end if;
    end loop;

    if v_vResponse is null then
      v_vResponse := '______________';
    end if;

    po_vResponseValue := v_vResponse;
    return po_vResponseValue;

  exception
    when others then
      return po_vResponseValue;
  end;

  /*Get module responses*/
  function fnGetModuleResponses(pi_vPatientID        in varchar2,
                                pi_nModuleIdentifier in varchar2) return clob
  is
    v_nIntakeID       number := -1;
    v_nTID            number := 0;
    v_nQID            number := 0;
    v_vResponse       clob := '';
    po_vResponseValue clob := '';

    rs RetRefCursor;
  begin

    --get the last intake id for the module specified
    begin
      select max(i.intake_id)
        into v_nIntakeID
      from data_intake i,
           intake_module m
      where i.mid = m.mid
        and i.patient_id = pi_vPatientID
        and m.identifier = pi_nModuleIdentifier;
      exception
        when others then
          v_nIntakeID := -1;
    end;

    --get all question & responses for the module
    for rec in (select
                  dr.tid,
                  dr.qid,
                  REGEXP_REPLACE(iq.question, '<[^<>]+>') as question,
                  trim(REGEXP_REPLACE(
                       case
                         when ir.display_type = 3 then ir.response || ' ' || dr.response_value || nvl(' ' || ir.unit, '')
                         when ir.display_type in(4,22) then ir.response || ' ' || dr.response_value
                         else dr.response_value
                       end
                       , '<[^<>]+>')
                  ) as response
                from data_intake_responses dr,
                     intake_module im,
                     intake_topic it,
                     intake_question iq,
                     intake_response ir
                where dr.patient_id = pi_vPatientID
                  and im.identifier = pi_nModuleIdentifier
                  and dr.intake_id = v_nIntakeID

                --intake_module
                    and   dr.mid = im.mid

                --intake_topic
                    and   dr.mid = it.mid
                    and   dr.tid = it.tid

                --intake_question
                    and   dr.mid = iq.mid
                    and   dr.tid = iq.tid
                    and   dr.qid = iq.qid

                --intake_response
                    and   dr.mid = ir.mid
                    and   dr.tid = ir.tid
                    and   dr.qid = ir.qid
                    and   dr.rid = ir.rid

                order by dr.mid,
                    dr.tid,
                    dr.qid,
                    dr.rid )
    loop
      if v_nTID = 0 and v_nQID = 0 then
        v_nTID := rec.tid;
        v_nQID := rec.qid;
        if rec.question is not null then
          v_vResponse := v_vResponse || rec.question || chr(10);
        end if;
      end if;

      if v_nTID != rec.tid or v_nQID != rec.qid then
        v_nTID := rec.tid;
        v_nQID := rec.qid;
        v_vResponse := v_vResponse || chr(10);
        if rec.question is not null then
          v_vResponse := v_vResponse || rec.question || chr(10);
        end if;
      end if;

      if rec.response is not null then
        v_vResponse := v_vResponse || rec.response || chr(10);
      end if;

    end loop;

    if v_vResponse is null then
      v_vResponse := '______________';
    end if;

    po_vResponseValue := v_vResponse;
    return po_vResponseValue;

  exception
    when others then
      return po_vResponseValue;
  end;

  /*Get module responses*/
  function fnGetModuleResponses(pi_vPatientID        in varchar2,
                                pi_nModuleIdentifier in varchar2,
                                pi_nIntakeID         in number) return clob
  is
    v_nTID            number := 0;
    v_nQID            number := 0;
    v_vResponse       clob := '';
    po_vResponseValue clob := '';

    rs RetRefCursor;
  begin

    --get all question & responses for the module
    for rec in (select
                  dr.tid,
                  dr.qid,
                  dr.intake_id,
                  dr.rid,
                  dr.mid,
                  REGEXP_REPLACE(
                    REGEXP_REPLACE(
                      replace(iq.question,chr(38) || 'nbsp;',''),
                      '<br\s{0,}/{0,}>',
                      chr(10)
                    ),
                    '<[^<>]+>'
                  ) as question,
                  trim(REGEXP_REPLACE(
                       case
                         when ir.display_type = 3 then ir.response || ' ' || dr.response_value || nvl(' ' || ir.unit, '')
                         when ir.display_type in(4,22) then ir.response || ' ' || dr.response_value
                         else dr.response_value
                       end
                       , '<[^<>]+>')
                  ) as response
                from data_intake_responses dr,
                     intake_module im,
                     intake_topic it,
                     intake_question iq,
                     intake_response ir
                where dr.patient_id = pi_vPatientID
                  and im.identifier = pi_nModuleIdentifier
                  and dr.intake_id = pi_nIntakeID

                --intake_module
                    and   dr.mid = im.mid

                --intake_topic
                    and   dr.mid = it.mid
                    and   dr.tid = it.tid

                --intake_question
                    and   dr.mid = iq.mid
                    and   dr.tid = iq.tid
                    and   dr.qid = iq.qid

                --intake_response
                    and   dr.mid = ir.mid
                    and   dr.tid = ir.tid
                    and   dr.qid = ir.qid
                    and   dr.rid = ir.rid

                order by dr.mid,
                    dr.tid,
                    dr.qid,
                    dr.rid )
    loop
      if v_nTID = 0 and v_nQID = 0 then
        v_nTID := rec.tid;
        v_nQID := rec.qid;
        if rec.question is not null then
          v_vResponse := v_vResponse || rec.question || chr(10);
        end if;
      end if;

      if v_nTID != rec.tid or v_nQID != rec.qid then
        v_nTID := rec.tid;
        v_nQID := rec.qid;
        v_vResponse := v_vResponse || chr(10);
        if rec.question is not null then
          v_vResponse := v_vResponse || rec.question || chr(10);
        end if;
      end if;

      if rec.response is not null then
        --Put time in one horizontal line
        if rec.mid = 4076 and rec.tid = 1 and rec.qid = 4 and rec.rid = 125 then
           v_vResponse := v_vResponse || rec.response;
        else   
           if rec.mid = 4076 and rec.tid = 1 and rec.qid = 4 and rec.rid = 130 then
              v_vResponse := v_vResponse || REGEXP_REPLACE(rec.response,' ','');
           else
              if rec.mid = 4076 and rec.tid = 1 and rec.qid = 3 and rec.rid = 110 then
                 v_vResponse := v_vResponse || rec.response;
              else   
                 if rec.mid = 4076 and rec.tid = 1 and rec.qid = 3 and rec.rid = 115 then
                    v_vResponse := v_vResponse || REGEXP_REPLACE(rec.response,' ','');
                 else 
                    v_vResponse := v_vResponse || rec.response || chr(10);
                 end if;
              end if;   
           end if;   
        end if;
      end if;

    end loop;

    if v_vResponse is null then
      v_vResponse := '______________';
    end if;

    po_vResponseValue := v_vResponse;
    return po_vResponseValue;

  exception
    when others then
      return po_vResponseValue;
  end;

  /*Get module score*/
  function fnGetModuleScore(pi_vPatientID  in varchar2,
                            pi_nMID        in number,
                            pi_nIntakeID   in number) return clob
  is

    v_nCtr            number := 0;
    v_vResponse       clob := '';
    po_vResponseValue clob := '';

    rs RetRefCursor;
  begin

    --get all scores for the module
    for rec in (select
                 t.series,
                 t.offSet1,
                 t.offSet2,
                 rpad(t.description,t.offSet1 + 2) || lpad(t.score,t.offSet2) || '  ' || t.interpretation as ScoreLine
                from (
                  select
                    series,
                    description,
                    score,
                    interpretation,
                    case
                      when (select max(length(off1.description)) from data_intake_score off1 where off1.patient_id = pi_vPatientID and off1.mid = pi_nMID and off1.intake_id = pi_nIntakeID) <= 11 then 11
                      else (select max(length(off1.description)) from data_intake_score off1 where off1.patient_id = pi_vPatientID and off1.mid = pi_nMID and off1.intake_id = pi_nIntakeID)
                    end as offSet1,
                    case
                      when (select max(length(off2.score)) from data_intake_score off2 where off2.patient_id = pi_vPatientID and off2.mid = pi_nMID and off2.intake_id = pi_nIntakeID) <= 5 then 5
                      else (select max(length(off2.score)) from data_intake_score off2 where off2.patient_id = pi_vPatientID and off2.mid = pi_nMID and off2.intake_id = pi_nIntakeID)
                    end as offSet2
                  from data_intake_score s
                  where patient_id = pi_vPatientID
                    and mid = pi_nMID
                    and intake_id = pi_nIntakeID
                ) t
                order by t.series
                )
    loop
      v_nCtr := v_nCtr + 1;

      if v_nCtr = 1 then
        v_vResponse := rpad('Description',rec.offset1 + 2) || lpad('Score',rec.offset2) || '  ' || 'Interpretation' || chr(10);
      end if;

/*      if rec.description is not null then
        v_vResponse := v_vResponse || rpad(rec.description, rec.offset1 + 2);
      end if;

      if rec.score is not null then
        v_vResponse := v_vResponse || lpad(rec.score, rec.offset2) || '  ';
      end if;

      if rec.interpretation is not null then
        v_vResponse := v_vResponse || rec.interpretation;
      end if;
  */
      v_vResponse := v_vResponse || rec.Scoreline;

      v_vResponse := v_vResponse || chr(10);

    end loop;

    if v_vResponse is null then
      v_vResponse := '______________';
    end if;

    po_vResponseValue := v_vResponse;
    return po_vResponseValue;

  exception
    when others then
      return po_vResponseValue;
  end;

  /*Get all completed modules*/
  function fnGetAllCompletedModules(pi_vPatientID  in varchar2,
                                    pi_nPatPWEventID in number) return clob
  is

    v_nCtr            number := 0;
    v_vResponse       clob := '';
    po_vResponseValue clob := '';

    rs RetRefCursor;

  begin

      for rec in (select
                   m.module as ModuleSection,
                   PCK_NOTE_PREFILL.fnGetModuleScore(em.patient_id, em.mid, em.intake_id) as ScoreSection,
                   PCK_NOTE_PREFILL.fnGetModuleResponses(em.patient_id, m.identifier,em.intake_id) as QASection
                  from pat_pw_event_module em,
                       intake_module m
                  where m.mid = em.mid
                    and em.patient_id = pi_vPatientID
                    and em.pat_pw_event_id = pi_nPatPWEventID
                    and em.status = 1
                    and case
                          when em.mid = 4042 then
                            case
                              when (select c.rid from data_intake_responses c where c.intake_id = em.intake_id and c.tid=1 and qid=1) != 21 then 1
                              else 0
                            end
                          else 1
                        end = 1)
      loop
        if rec.modulesection is not null then
          v_vResponse := v_vResponse || rec.modulesection || chr(10);
          v_vResponse := v_vResponse || '------------------------------------------------------------------------' || chr(10);
        end if;

        if rec.scoresection is not null and rec.scoresection != '______________' then
          v_vResponse := v_vResponse || rec.scoresection || chr(10);
        end if;

        if rec.qasection is not null and rec.qasection != '______________' then
          v_vResponse := v_vResponse || 'Questions & Responses' || chr(10);
          v_vResponse := v_vResponse || rec.qasection || chr(10) || chr(10);
        end if;

      end loop;

      if v_vResponse is null then
        v_vResponse := '______________';
      end if;

      po_vResponseValue := v_vResponse;
      return po_vResponseValue;

 exception
    when others then
      return po_vResponseValue;
  end;


end PCK_NOTE_PREFILL;
/
----------------------------------------
--  Changed package body pck_patient  --
----------------------------------------
create or replace package body tbicds.PCK_PATIENT is

  /* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
  /*
  gets basic patient demographic data given the patients fx_user_id
  */
  procedure GetPatientIDRS(pi_vSessionID       in varchar2,
                           pi_vSessionClientIP in varchar2,
                           pi_nUserID          in number,
                           pi_vKey             in varchar2,
                           po_nStatusCode      out number,
                           po_vStatusComment   out varchar2,
                           rs                  out RetRefCursor) 
  is
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
    open rs for
      select t.PATIENT_ID,
             tbicds.fnc_utl_decstr(t.FIRST_NAME, pi_vKey, t.PATIENT_ID) as first_name,
             tbicds.fnc_utl_decstr(t.MI, pi_vKey, t.PATIENT_ID) as mi,
             tbicds.fnc_utl_decstr(t.LAST_NAME, pi_vKey, t.PATIENT_ID) as last_name,
             tbicds.fnc_utl_decstr(t.SSN, pi_vKey, t.PATIENT_ID) as ssn,
             mid(tbicds.fnc_utl_decstr(t.last_name, pi_vKey, t.PATIENT_ID),
                 1,
                 1) ||
             mid(tbicds.fnc_utl_decstr(t.ssn, pi_vKey, t.PATIENT_ID), 6, 9) as LNSSNLAST4,
             tbicds.fnc_utl_decstr(t.GENDER, pi_vKey, t.PATIENT_ID) as gender,
             t.MARITAL_STATUS_ID,
             to_date(tbicds.fnc_utl_decstr(t.dob, pi_vKey, t.PATIENT_ID),
                     'MM/DD/YYYY') as dob,
             t.EDUCATION_LEVEL_ID,
             t.PROVIDER_ID,
             t.ADDRESS1,
             t.ADDRESS2,
             t.CITY,
             t.POSTAL_CODE,
             t.HOMEPHONE,
             t.CELLPHONE,
             t.WORKPHONE,
             tbicds.fnc_utl_decstr(t.EMAIL, pi_vKey, t.PATIENT_ID) as email,
             t.STATE_ID,
             t.FX_USER_ID,
             t.LAST_UPDATED,
             t.LAST_UPDATED_BY,
             t.PORTAL_USER_ID,
             t.WRK_PHONE_CALL,
             t.HOME_PHONE_CALL,
             t.HOME_PHONE_MSG,
             t.CELL_PHONE_CALL,
             t.EMAIL_MSG,
             trunc(months_between(SYSDATE,
                                  to_date(tbicds.fnc_utl_decstr(t.dob,
                                                                pi_vKey,
                                                                t.PATIENT_ID),
                                          'MM/DD/YYYY')) / 12) as patient_age
        from tbicds.patient_demographics t
       where t.fx_user_id = pi_nUserID;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_PATIENT.GetPatientIDRS(): ' || sqlErrm;
  end;

  /*
  gets dataset to populate Patient Portal Lookup List
  */
  procedure GetPatientPortalListRS(pi_vSessionID       in varchar2,
                                   pi_vSessionClientIP in varchar2,
                                   pi_nUserID          in number,
                                   pi_vKey             in varchar2,
                                   po_nStatusCode      out number,
                                   po_vStatusComment   out varchar2,
                                   rs                  out Pck_Utl_Common.refCursor) 
  is
  begin
  
    --default status to ok
    po_nStatusCode    := Pck_Utl_Common.c_nResultStatus_Success;
    po_vStatusComment := null;
  
    open rs for
      select t.patient_id,
             tbicds.fnc_utl_decstr(t.first_name, pi_vKey, t.patient_id) as first_name,
             tbicds.fnc_utl_decstr(t.mi, pi_vKey, t.patient_id) as mi,
             tbicds.fnc_utl_decstr(t.last_name, pi_vKey, t.patient_id) as last_name,
             tbicds.fnc_utl_decstr(t.last_name, pi_vKey, t.patient_id) || ', ' ||
             tbicds.fnc_utl_decstr(t.first_name, pi_vKey, t.patient_id) || ' ' ||
             tbicds.fnc_utl_decstr(t.mi, pi_vKey, t.patient_id) as name,
             t.homephone as phone,
             tbicds.fnc_utl_decstr(t.email, pi_vKey, t.patient_id) as email,
             t.fx_user_id,
             t2.user_name,
             t2.is_locked,
             t2.is_inactive
        from tbicds.patient_demographics t, tbicds.fx_user t2
       where t.fx_user_id = t2.fx_user_id
         and t.provider_id in
             (select provider_id
                from tbicds.app_user s
               where s.dims_id in
                     (select dims_id
                        from tbicds.app_user
                       where fx_user_id = pi_nUserID))
       order by tbicds.fnc_utl_decstr(t.last_name, pi_vKey, t.patient_id),
                tbicds.fnc_utl_decstr(t.first_name, pi_vKey, t.patient_id);
  
  exception
    when others then
    
      po_nStatusCode    := Pck_Utl_Common.c_nResultStatus_Error;
      po_vStatusComment := 'PCK_PATIENT.GetPatientPortalListDS(): ' ||
                           sqlCode || ': ' || sqlErrm;
    
  end;

  /*
   Updates patient demographics data from the demographics page in the application 
   */
  procedure UpdatePatientDemographics(pi_vSessionID       in varchar2,
                                      pi_vSessionClientIP in varchar2,
                                      pi_nUserID          in number,
                                      pi_vKey             in varchar2,
                                      pi_vPatientID       in varchar2,
                                      pi_vFirstName       in varchar2,
                                      pi_vMI              in varchar2,
                                      pi_vLastName        in varchar2,
                                      pi_vSponsorSSN      in varchar2,
                                      pi_vSSN             in varchar2,
                                      pi_vGender          in varchar2,
                                      pi_vDateOfBirth     in varchar2,
                                      pi_vProviderID      in varchar2,
                                      pi_vAddress1        in varchar2,
                                      pi_vAddress2        in varchar2,
                                      pi_vCity            in varchar2,
                                      pi_vPostal_Code     in varchar2,
                                      pi_vHomePhone       in varchar2,
                                      pi_vCellPhone       in varchar2,
                                      pi_vWorkPhone       in varchar2,
                                      pi_vEmail           in varchar2,
                                      pi_vStateID         in varchar2,
                                      pi_nCellPhoneMsg    in number,
                                      pi_nEmailMsg        in number,
                                      pi_nCallPreference  in number,
                                      pi_nPrefLangID      in number,
                                      pi_vPrefLangOther   in varchar2,
                                      pi_nDutyStatusID    in number,
                                      pi_nHandPrefID      in number,
                                      po_nStatusCode      out number,
                                      po_vStatusComment   out varchar2) 
  is
  
    v_nMAJCOM_ID number := 0;
    v_vPMDSQL    long := '';
  
    v_vDOB      varchar2(50) := '';
    v_nCallPref number := null;
  
    v_nHomeCall number := 0;
    v_nCellCall number := 0;
    v_nWorkCall number := 0;
  
    v_nPrefLangID   number := null;
    v_nDutyStatusID number := null;
    v_nHandPrefID   number := null;
  
    v_vProviderID varchar2(50) := null;
  
  begin
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
    if pi_nCallPreference > 0 then
      if bitand(pi_nCallPreference, 1) > 0 then
        v_nHomeCall := 1;
      end if;
    
      if bitand(pi_nCallPreference, 2) > 0 then
        v_nCellCall := 1;
      end if;
    
      if bitand(pi_nCallPreference, 4) > 0 then
        v_nWorkCall := 1;
      end if;
    end if;
  
    if pi_nPrefLangID > 0 then
      v_nPrefLangID := pi_nPrefLangID;
    end if;
  
    if pi_nDutyStatusID > 0 then
      v_nDutyStatusID := pi_nDutyStatusID;
    end if;
  
    if pi_nHandPrefID > 0 then
      v_nHandPrefID := pi_nHandPrefID;
    end if;
  
    if pi_vDateOfBirth != '-1' then
      v_vDOB := pi_vDateOfBirth;
    end if;
  
    --get provider id
    begin
      select provider_id
        into v_vProviderID
        from app_user t
       where t.fx_user_id = pi_nUserID;
    exception
      when others then
        v_vProviderID := null;
    end;
  
    update tbicds.patient_demographics
       set first_name      = tbicds.fnc_utl_encstr(upper(pi_vFirstName),
                                                   pi_vKey,
                                                   upper(pi_vPatientID)),
           mi              = tbicds.fnc_utl_encstr(upper(pi_vMI),
                                                   pi_vKey,
                                                   upper(pi_vPatientID)),
           last_name       = tbicds.fnc_utl_encstr(upper(pi_vLastName),
                                                   pi_vKey,
                                                   upper(pi_vPatientID)),
           ssn             = tbicds.fnc_utl_encstr(pi_vSSN,
                                                   pi_vKey,
                                                   upper(pi_vPatientID)),
           gender          = tbicds.fnc_utl_encstr(pi_vGender,
                                                   pi_vKey,
                                                   upper(pi_vPatientID)),
           dob             = tbicds.fnc_utl_encstr(v_vDOB,
                                                   pi_vKey,
                                                   upper(pi_vPatientID)),
           provider_id     = pi_vProviderID,
           address1        = pi_vAddress1,
           address2        = pi_vAddress2,
           city            = upper(pi_vCity),
           postal_code     = pi_vPostal_Code,
           homephone       = pi_vHomePhone,
           cellphone       = pi_vCellPhone,
           workphone       = pi_vWorkPhone,
           email           = tbicds.fnc_utl_encstr(pi_vEmail,
                                                   pi_vKey,
                                                   upper(pi_vPatientID)),
           wrk_phone_call  = pi_nCallPreference,
           home_phone_call = pi_nCallPreference,
           cell_phone_call = pi_nCallPreference,
           home_phone_msg  = pi_nCellPhoneMsg,
           email_msg       = pi_nEmailMsg,
           state_id        = pi_vStateID,
           
           preferred_language_id    = v_nPrefLangID,
           preferred_language_other = pi_vPrefLangOther,
           duty_status_id           = v_nDutyStatusID,
           hand_preference_id       = v_nHandPrefID,
           
           last_updated    = sysdate,
           last_updated_by = pi_nUserID
     where patient_id = pi_vPatientID;
    commit;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_PATIENT.UpdatePatientDemographics(): ' ||
                           sqlErrm;
  end;

  /*get a record set of patients back that match criteria*/
  procedure GetPatientLookupRS(pi_vSessionID       in varchar2,
                               pi_vSessionClientIP in varchar2,
                               pi_nUserID          in number,
                               pi_vKey             in varchar2,
                               pi_nSelectedCases   in number,
                               pi_nSearchType      in number,
                               pi_vSearchValue     in varchar2,
                               po_nStatusCode      out number,
                               po_vStatusComment   out varchar2,
                               rs                  out RetRefCursor) 
  is
  
    v_const_search_last_name number := 1;
    v_const_search_fmp_ssn   number := 3;
   
    strSQL       varchar2(4000);
  
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
    strSQL := 'select ';
    strSQL := strSQL || ' p.PATIENT_ID, ';
  
    strSQL := strSQL || ' tbicds.fnc_utl_decstr(p.FIRST_NAME, 
              :pi_vKey, p.PATIENT_ID) as first_name, ';
  
    strSQL := strSQL || ' tbicds.fnc_utl_decstr(p.MI, 
              :pi_vKey, p.PATIENT_ID) as mi, ';
  
    strSQL := strSQL || ' tbicds.fnc_utl_decstr(p.LAST_NAME, 
              :pi_vKey, p.PATIENT_ID) as last_name, ';
  
    strSQL := strSQL || ' tbicds.fnc_utl_decstr(p.SSN,
              :pi_vKey, p.PATIENT_ID) as ssn, ';
  
    strSQL := strSQL || ' mid(tbicds.fnc_utl_decstr(p.last_name, 
              :pi_vKey, p.PATIENT_ID), 1, 1) || 
              mid(tbicds.fnc_utl_decstr(p.ssn, 
              :pi_vKey, p.PATIENT_ID), 6, 9) as LNSSNLAST4, ';
  
    strSQL := strSQL || ' mid(tbicds.fnc_utl_decstr(p.last_name, ''' ||
              pi_vKey ||
              ''', p.PATIENT_ID), 1, 1) || mid(tbicds.fnc_utl_decstr(p.ssn, ''' ||
              pi_vKey || ''', p.PATIENT_ID), 6, 9) as fmpssnlast4, ';
  
    strSQL := strSQL || ' tbicds.fnc_utl_decstr(p.GENDER, ''' || pi_vKey ||
              ''', p.PATIENT_ID) as gender, ';
  
    strSQL := strSQL || ' p.MARITAL_STATUS_ID, ';
  
    strSQL := strSQL || ' to_date(tbicds.fnc_utl_decstr(p.dob, ''' ||
              pi_vKey || ''', p.PATIENT_ID), ''MM/DD/YYYY'') as dob, ';
  
    strSQL := strSQL || ' to_char(to_date(tbicds.fnc_utl_decstr(p.dob, ''' ||
              pi_vKey ||
              ''', p.PATIENT_ID), ''MM/DD/YYYY''), ''MM/DD/YYYY'') as birthdate, ';
  
    strSQL := strSQL || ' p.EDUCATION_LEVEL_ID, ';
    strSQL := strSQL || ' p.PROVIDER_ID, ';
    strSQL := strSQL || ' p.ADDRESS1, ';
    strSQL := strSQL || ' p.ADDRESS2, ';
    strSQL := strSQL || ' p.CITY, ';
    strSQL := strSQL || ' p.POSTAL_CODE, ';
    strSQL := strSQL || ' p.HOMEPHONE, ';
    strSQL := strSQL || ' p.CELLPHONE, ';
    strSQL := strSQL || ' p.WORKPHONE, ';
    
    strSQL := strSQL || ' tbicds.fnc_utl_decstr(p.EMAIL, 
           :pi_vKey, p.PATIENT_ID) as email, ';
    
    strSQL := strSQL || ' p.STATE_ID, ';
    strSQL := strSQL || ' p.FX_USER_ID, ';
    strSQL := strSQL || ' p.LAST_UPDATED, ';
    strSQL := strSQL || ' p.LAST_UPDATED_BY, ';
    strSQL := strSQL || ' p.PORTAL_USER_ID, ';
    strSQL := strSQL || ' p.WRK_PHONE_CALL, ';
    strSQL := strSQL || ' p.HOME_PHONE_CALL, ';
    strSQL := strSQL || ' p.HOME_PHONE_MSG, ';
    strSQL := strSQL || ' p.CELL_PHONE_CALL, ';
    strSQL := strSQL || ' p.EMAIL_MSG, ';
    
    strSQL := strSQL || ' trunc(months_between(SYSDATE, 
           to_date(tbicds.fnc_utl_decstr(p.dob, 
           :pi_vKey, p.PATIENT_ID), ''MM/DD/YYYY'')) / 12) as patient_age, ';
    
    strSQL := strSQL || ' 0 as case_closed ';
    
    strSQL := strSQL || ' from tbicds.patient_demographics p ';
  
    strSQL := strSQL || ' where ';
    
    strSQL := strSQL || ' p.site_id in (';
    
    strSQL := strSQL || 'select site_id ';
    strSQL := strSQL || '  from tbicds.fx_user s ';
    strSQL := strSQL || ' where fx_user_id = :pi_nUserID ) ';
  
    -- is the search by last name?
    if pi_nSearchType = v_const_search_last_name then
  
      strSQL := strSQL || ' and UPPER(';
      
      strSQL := strSQL || 'tbicds.fnc_utl_decstr(p.LAST_NAME, 
                :pi_vKey, p.PATIENT_ID)';
                
      strSQL := strSQL || ') like UPPER(''' || pi_vSearchValue || ''')';
      strSQL := strSQL || ' order by p.last_name, p.first_name asc';
   
    --is the search by lastname initial SS last 4
    elsif pi_nSearchType = v_const_search_fmp_ssn then
  
      strSQL := strSQL || ' and ';
    
      strSQL := strSQL || ' mid(tbicds.fnc_utl_decstr(p.last_name,
                :pi_vKey, p.PATIENT_ID), 1, 1) || 
                mid(tbicds.fnc_utl_decstr(p.ssn, 
                :pi_vKey, p.PATIENT_ID), 6, 9) ';
      strSQL := strSQL || ' = :pi_vSearchValue ';
      strSQL := strSQL || ' order by p.last_name, p.first_name asc';
      
    end if;
  
    if pi_nSearchType = v_const_search_last_name then
  
      open rs for strSQL 
      using pi_vKey,
            pi_vKey,
            pi_vKey,
            pi_vKey,
            pi_vKey,
            pi_vKey,
            pi_vKey,
            pi_vKey,
            pi_nUserID,
            --last name search binds
            pi_vKey;
     
     end if;
    
    if pi_nSearchType = v_const_search_fmp_ssn then
    
      open rs for strSQL 
      using pi_vKey,
            pi_vKey,
            pi_vKey,
            pi_vKey,
            pi_vKey,
            pi_vKey,
            pi_vKey,
            pi_vKey,
            pi_nUserID,
            --LSSN search binds
            pi_vKey,
            pi_vKey,
            pi_vSearchValue;           
    
    end if;
    
         
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_PATIENT.getPatientLookupRS(): ' || sqlErrm;
  end;


  /* Returns the patient demographics recordset  */
  procedure GetPatientDemographicsRS(pi_vSessionID       in varchar2,
                                     pi_vSessionClientIP in varchar2,
                                     pi_nUserID          in number,
                                     pi_vKey             in varchar2,
                                     pi_vPatientID       in varchar2,
                                     po_nStatusCode      out number,
                                     po_vStatusComment   out varchar2,
                                     rs                  out RetRefCursor) 
  is
    --v_nTreatmentID number;
  
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
    --v_nTreatmentID    := 0;
  
   -- select max(treatment_id)
   --   into v_nTreatmentID
   --   from treatment
   --  where patient_id = pi_vPatientID;
  
    open rs for
      select t.PATIENT_ID,
             t.DFN,
             tbicds.fnc_utl_decstr(t.FIRST_NAME, pi_vKey, t.PATIENT_ID) as first_name,
             tbicds.fnc_utl_decstr(t.MI, pi_vKey, t.PATIENT_ID) as mi,
             tbicds.fnc_utl_decstr(t.LAST_NAME, pi_vKey, t.PATIENT_ID) as last_name,
             tbicds.fnc_utl_decstr(t.SSN, pi_vKey, t.PATIENT_ID) as ssn,
             mid(tbicds.fnc_utl_decstr(t.last_name, pi_vKey, t.PATIENT_ID),
                 1,
                 1) ||
             mid(tbicds.fnc_utl_decstr(t.ssn, pi_vKey, t.PATIENT_ID), 6, 9) as LNSSNLAST4,
             tbicds.fnc_utl_decstr(t.GENDER, pi_vKey, t.PATIENT_ID) as gender,
             t.MARITAL_STATUS_ID,
             to_date(tbicds.fnc_utl_decstr(t.dob, pi_vKey, t.PATIENT_ID),
                     'MM/DD/YYYY') as dob,
             t.EDUCATION_LEVEL_ID,
             t.PROVIDER_ID,
             t.ADDRESS1,
             t.ADDRESS2,
             t.CITY,
             t.POSTAL_CODE,
             t.HOMEPHONE,
             t.CELLPHONE,
             t.WORKPHONE,
             tbicds.fnc_utl_decstr(t.EMAIL, pi_vKey, t.PATIENT_ID) as email,
             t.STATE_ID,
             t.FX_USER_ID,
             t.LAST_UPDATED,
             t.LAST_UPDATED_BY,
             t.PORTAL_USER_ID,
             t.WRK_PHONE_CALL,
             t.HOME_PHONE_CALL,
             t.HOME_PHONE_MSG,
             t.CELL_PHONE_CALL,
             t.EMAIL_MSG,
             
             (select s.name
                from tbicds.app_user s
               where s.provider_id = t.PROVIDER_ID) as provider_name,
             trunc(months_between(SYSDATE,
                                  to_date(fnc_utl_decstr(t.dob,
                                                         pi_vKey,
                                                         t.PATIENT_ID),
                                          'MM/DD/YYYY')) / 12) as patient_age,
             '' as MILITARY_STATUS_TITLE,
             '' as MILITARY_SERVICE_TITLE,
             '' as MARITAL_STATUS_TITLE,
             '' as GRADE,
             tbicds.fnc_utl_decstr(t.gender, pi_vKey, pi_vPatientID) as GENDER_DESC,
             '' as BASE,
             0 as referral_count,
             0 as OPENCASE_COUNT,             
             t.wrk_phone_call,
             t.home_phone_call,
             t.home_phone_msg,
             t.email_msg,
             t.preferred_language_id,
             t.preferred_language_other,
             /*tbicds.fnc_utl_decstr(t.preferred_language_other,
                                   pi_vKey,
                                   t.PATIENT_ID) as preferred_language_other,*/
             duty_status_id,
             hand_preference_id
      
        from tbicds.patient_demographics    t
       where t.patient_id = pi_vPatientID;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_PATIENT.GetPatientDemographicsRS(): ' ||
                           sqlErrm;
  end;

  /*
  Insert patient demographics
  */
  procedure InsertPatientDemographics(pi_vSessionID       in varchar2,
                                      pi_vSessionClientIP in varchar2,
                                      pi_nUserID          in number,
                                      --Patient Table
                                      pi_vKey            in varchar2,
                                      pi_vPatientID      in varchar2,
                                      pi_vEncounterID    in varchar2,
                                      pi_vFirstName      in varchar2,
                                      pi_vMI             in varchar2,
                                      pi_vLastName       in varchar2,
                                      pi_vSponsorSSN     in varchar2,
                                      pi_vSSN            in varchar2,
                                      pi_vGender         in varchar2,
                                      pi_vDateOfBirth    in varchar2,
                                      pi_vProviderID     in varchar2,
                                      pi_vAddress1       in varchar2,
                                      pi_vAddress2       in varchar2,
                                      pi_vCity           in varchar2,
                                      pi_vPostal_Code    in varchar2,
                                      pi_vHomePhone      in varchar2,
                                      pi_vCellPhone      in varchar2,
                                      pi_vWorkPhone      in varchar2,
                                      pi_vEmail          in varchar2,
                                      pi_vStateID        in varchar2,
                                      pi_nCellPhoneMsg   in number,
                                      pi_nEmailMsg       in number,
                                      pi_nCallPreference in number,
                                      po_nStatusCode     out number,
                                      po_vStatusComment  out varchar2)
  is
  
    v_nRelationshipID number;
    v_nSSNCount       number;
    v_vDOB            varchar2(50) := '';
    v_nCallPref       number := null;
  
    v_nHomeCall number := 0;
    v_nCellCall number := 0;
    v_nWorkCall number := 0;
  
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
    v_nRelationshipID := 0;
    v_nSSNCount       := 0;
  
    if pi_nCallPreference > 0 then
      if bitand(pi_nCallPreference, 1) > 0 then
        v_nHomeCall := 1;
      end if;
    
      if bitand(pi_nCallPreference, 2) > 0 then
        v_nCellCall := 1;
      end if;
    
      if bitand(pi_nCallPreference, 4) > 0 then
        v_nWorkCall := 1;
      end if;
    end if;
  
    --SSN Check For Duplicate
    select count(ssn)
      into v_nSSNCount
      from tbicds.patient_demographics t
     where tbicds.fnc_utl_decstr(t.SSN, pi_vKey, t.PATIENT_ID) = pi_vSSN;
  
    if (v_nSSNCount > 0) then
      po_nStatusCode    := Pck_Common.c_nResultStatus_Error;
      po_vStatusComment := po_vStatusComment ||
                           'Social Security Number already exists. ';
    end if;
  
    -- return if error
    if po_nStatusCode = Pck_Common.c_nResultStatus_Error then
      po_vStatusComment := 'Error: ' || rtrim(po_vStatusComment, ', ');
      return;
    end if;
  
    if pi_vDateOfBirth != '-1' then
      v_vDOB := pi_vDateOfBirth;
    end if;
  
    insert into tbicds.patient_demographics t
      (patient_id,
       first_name,
       mi,
       last_name,
       ssn,
       gender,
       dob,
       provider_id,
       address1,
       address2,
       city,
       postal_code,
       homephone,
       cellphone,
       workphone,
       email,
       state_id,
       home_phone_call,
       cell_phone_call,
       wrk_phone_call,
       home_phone_msg,
       email_msg,
       last_updated,
       last_updated_by)
    values
      (upper(pi_vPatientID),
       tbicds.fnc_utl_encstr(upper(pi_vFirstName),
                             pi_vKey,
                             upper(pi_vPatientID)),
       tbicds.fnc_utl_encstr(upper(pi_vMI), pi_vKey, upper(pi_vPatientID)),
       tbicds.fnc_utl_encstr(upper(pi_vLastName),
                             pi_vKey,
                             upper(pi_vPatientID)),
       tbicds.fnc_utl_encstr(pi_vSSN, pi_vKey, upper(pi_vPatientID)),
       tbicds.fnc_utl_encstr(pi_vGender, pi_vKey, upper(pi_vPatientID)),
       tbicds.fnc_utl_encstr(v_vDOB, pi_vKey, upper(pi_vPatientID)),
       pi_vProviderID,
       pi_vAddress1,
       pi_vAddress2,
       upper(pi_vCity),
       pi_vPostal_Code,
       pi_vHomePhone,
       pi_vCellPhone,
       pi_vWorkPhone,
       tbicds.fnc_utl_encstr(pi_vEmail, pi_vKey, upper(pi_vPatientID)),
       pi_vStateID,
       v_nHomeCall,
       v_nCellCall,
       v_nWorkCall,
       pi_nCellPhoneMsg,
       pi_nEmailMsg,
       sysdate,
       pi_nUserID);
    commit;
  
    --Create Initial Patient Sponsor Record Needed By Assessments --Assessments can only to Updates
    /*insert into tbicds.patient_sponsor
      (patient_id, relationship_id, last_updated, last_updated_by)
    values
      (pi_vPatientID, v_nRelationshipID, sysdate, pi_nUserID);
    commit;*/
  
    --Create Initial Emergency Contact Record Needed By Assessments --Assessments can only to Updates
    /*insert into tbicds.patient_emergency_contact
      (patient_id, relationship_id, last_updated, last_updated_by)
    values
      (pi_vPatientID, v_nRelationshipID, sysdate, pi_nUserID);
    commit;*/
  
  --  insert into tbicds.treatment
  --    (treatment_id,
  --     patient_id,
  --     initial_visit_date,
  --     last_updated,
  --     last_updated_by)
  --  values
  --    (1, pi_vPatientID, sysdate, sysdate, pi_nUserID);
  --  commit;
  
    --REVAMP 20130219 DS: As requested by VA (Dr Kuna), do not create a default encounter
    --
    --insert into tbicds.encounter
    --   (encounter_id,
    --    treatment_id,
    --    patient_id,
    --    encounter_date,
    --    last_updated,
    --    last_updated_by)
    -- values
    --   (pi_vEncounterID, 1, pi_vPatientID, sysdate, sysdate, pi_nUserID);
    -- commit;
    --
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_PATIENT.InsertPatientDemographics(): ' ||
                           sqlErrm;
    
  end;

  /*
  does the patient only have 1 encounte for the latest treatment
  */
  procedure InitialEncounter(pi_vSessionID       in varchar2,
                             pi_vSessionClientIP in varchar2,
                             pi_nUserID          in number,
                             pi_vPatientID       in varchar2,
                             po_nInitialEnc      out number,
                             po_nStatusCode      out number,
                             po_vStatusComment   out varchar2) 
  is
  
    v_nCount       number;
    v_nTreatmentID number;
  
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
    v_nCount          := 0;
    v_nTreatmentID    := 0;
    po_nInitialEnc    := 0;
  
    --get the number of encounters for the
    --current open treatment
 --   select count(*)
 --     into v_nCount
 --     from tbicds.encounter e
 --    where e.patient_id = pi_vPatientID
 --      and e.encounter_type_id in (0, 6, 8)
 --      and e.treatment_id =
 --          (select max(treatment_id)
 --             from tbicds.treatment t
 --            where t.patient_id = pi_vPatientID
 --              and nvl(t.case_closed, 0) = 0);
  
    if (v_nCount = 1) then
      po_nInitialEnc := 1;
    end if;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_INTAKE.InitialEncounter(): ' || sqlErrm;
  end;

  /*
  Get patient treatment id recordset
  */
  procedure GetPatientTreatmentIdRS(pi_vSessionID       in varchar2,
                                    pi_vSessionClientIP in varchar2,
                                    pi_nUserID          in number,
                                    pi_vPatientID       in varchar2,
                                    po_nStatusCode      out number,
                                    po_vStatusComment   out varchar2,
                                    rs                  out RetRefCursor)
  is
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
    --open recordset
--    open rs for
--      select treatment_id
--        from tbicds.treatment t
--       where patient_id = pi_vPatientID;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_PATIENT.GetPatientTreatmentIdRS(): ' ||
                           sqlErrm;
  end;

  /*
  Remove patient intake assessments
  */
  procedure DelIncPatIntakeAssessments(pi_vSessionID       in varchar2,
                                       pi_vSessionClientIP in varchar2,
                                       pi_nUserID          in number,
                                       pi_vPatientID       in varchar2,
                                       po_nStatusCode      out number,
                                       po_vStatusComment   out varchar2)
  is
    v_nNumOfIncAssessments number := 0;
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
   /* for rec in ( -- select all INCOMPLETE encounter intakes for module for patient
                select ei.*
                  from tbicds.encounter_intake ei
                 where ei.encounter_id in
                       ( -- select all encounters for patient
                        select e.encounter_id
                          from tbicds.encounter e
                         where e.patient_id = pi_vPatientID))
    
     loop
      begin
      
        v_nNumOfIncAssessments := 0;
      
        --select all encounter intakes responses for module for encounter by mid
        select count(eir.encounter_id)
          into v_nNumOfIncAssessments
          from tbicds.encounter_intake_responses eir
         where eir.encounter_id = rec.encounter_id
           and eir.mid = rec.mid;
      
        if v_nNumOfIncAssessments = 0 then
        
          delete from tbicds.encounter_intake ei
           where ei.encounter_id = rec.encounter_id
             and ei.encounter_intake_id = rec.encounter_intake_id
             and ei.mid = rec.mid;
        
          commit;
        
        end if;
      
      exception
        when others then
          rollback;
      end;
    end loop;*/
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_PATIENT.DelIncPatIntakeAssessments(): ' ||
                           sqlErrm;
  end;

  /*
  get incomplete patient assessments
  */
  procedure IncPatIntakeAssessments(pi_vSessionID            in varchar2,
                                    pi_vSessionClientIP      in varchar2,
                                    pi_nUserID               in number,
                                    pi_vPatientID            in varchar2,
                                    po_nHasIncPatAssessments out number,
                                    po_nStatusCode           out number,
                                    po_vStatusComment        out varchar2) 
  is
  
    v_nNumOfIncAssessments number := 0;
  
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
   /* for rec in ( -- select all INCOMPLETE encounter intakes for module for patient
                select ei.*
                  from tbicds.encounter_intake ei
                 where ei.encounter_id in
                       ( -- select all encounters for patient
                        select e.encounter_id
                          from tbicds.encounter e
                         where e.patient_id = pi_vPatientID))
    
     loop
      begin
      
        v_nNumOfIncAssessments := 0;
      
        --select all encounter intakes responses for module for encounter by mid
        select count(eir.encounter_id)
          into v_nNumOfIncAssessments
          from tbicds.encounter_intake_responses eir
         where eir.encounter_id = rec.encounter_id
           and eir.mid = rec.mid;
      
        if v_nNumOfIncAssessments = 0 then
          po_nHasIncPatAssessments := 1;
        end if;
      
      exception
        when others then
          rollback;
      end;
    end loop;
  */
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_PATIENT.IncPatIntakeAssessments(): ' ||
                           sqlErrm;
  end;


  /*
  delete patient assigned modules
  */
  procedure DeletePatientAssignedModule(pi_vPatientID     in varchar2,
                                        nMID              in number,
                                        po_nStatusCode    out number,
                                        po_vStatusComment out varchar2)
   is
    v_vSQL constant varchar2(32767) := 'delete from tbicds.patient_module where patient_id = :pi_vPatientID 
                                                                   and mid = :nMID 
                                                                   and status = 0
                                                                   and date_completed is null';
  begin
    po_nStatusCode    := PCK_COMMON.c_nResultStatus_Success;
    po_vStatusComment := '';
  
    execute immediate v_vSQL
      using pi_vPatientID, nMID;
    commit;
  
  exception
    when others then
      po_nStatusCode    := PCK_COMMON.c_nResultStatus_Error;
      po_vStatusComment := 'PCK_PATIENT.DeletePatientAssignedModule(): ' ||
                           sqlErrm;
  end;

  /*
  Update patient user rights
  */
  procedure updatePatFxUserRights
   is
    curPat pck_common.refCursor;
    recPat tbicds.patient_demographics%rowtype;
  
  begin
  
    open curPat for
      select p.*
        from tbicds.patient_demographics p
       where p.fx_user_id is not null
         and p.fx_user_id not in
             (select fx_user_id from tbicds.fx_user_rights);
  
    loop
      fetch curPat
        into recPat;
      exit when curPat%notfound;
    
      insert into tbicds.fx_user_rights
        (fx_user_id, user_rights, read_only, user_type)
      values
        (recPat.Fx_User_Id, 0, 0, 0);
      commit;
    
    end loop;
    close curPat;
  
  end;

  /*
  Returns patient socioeconomics recordset 
  */
  procedure GetPatientSocioeconomicsRS(pi_vSessionID       in varchar2,
                                       pi_vSessionClientIP in varchar2,
                                       pi_nUserID          in number,
                                       pi_vKey             in varchar2,
                                       pi_vPatientID       in varchar2,
                                       po_nStatusCode      out number,
                                       po_vStatusComment   out varchar2,
                                       rs                  out RetRefCursor)
  is
  begin
    po_nStatusCode    := 0;
    po_vStatusComment := '';
    open rs for
      select patient_id,
             highest_grade_id,
             highest_degree_id,
             marital_status_id,
             employment_status_id,
             job_classification_id,
             last_modified,
             last_modified_by,
             tbicds.fnc_utl_decstr(t.employment_status_other,
                                   pi_vKey,
                                   t.patient_id)
        from patient_socioeconomic t
       where t.patient_id = pi_vPatientID;
  
  exception
    when others then
      po_nStatusCode    := -1;
      po_vStatusComment := 'PCK_PATIENT.GetPatientSocioeconomicsRS(): ' ||
                           sqlCode || ': ' || sqlErrm;
  end;

  /*
  Updates patient socioeconomics data 
  */
  procedure UpdatePatientSocioeconomics(pi_vSessionID             in varchar2,
                                        pi_vSessionClientIP       in varchar2,
                                        pi_nUserID                in number,
                                        pi_vKey                   in varchar2,
                                        pi_vPatientID             in varchar2,
                                        pi_nHighestGradeID        in number,
                                        pi_nHighestDegreeID       in number,
                                        pi_nMaritalStatusID       in number,
                                        pi_nEmploymentStatusID    in number,
                                        pi_nJobClassificationID   in number,
                                        pi_vEmploymentStatusOther in varchar2,
                                        po_nStatusCode            out number,
                                        po_vStatusComment         out varchar2)
  is
  
    v_nHighestGradeID        number := null;
    v_nHighestDegreeID       number := null;
    v_nMaritalStatusID       number := null;
    v_nEmploymentStatusID    number := null;
    v_nJobClassificationID   number := null;
    v_vEmploymentStatusOther varchar2(255) := null;
  
    v_nCount number := 0;
  
  begin
    po_nStatusCode    := 0;
    po_vStatusComment := '';
  
    --check if the patient record exists
    begin
      select count(*)
        into v_nCount
        from patient_socioeconomic t
       where t.patient_id = pi_vPatientID;
    exception
      when others then
        v_nCount := 0;
    end;
  
    if v_nCount < 1 then
      --insert record
      InsertPatientSocioeconomics(pi_vSessionID             => pi_vSessionID,
                                  pi_vSessionClientIP       => pi_vSessionClientIP,
                                  pi_nUserID                => pi_nUserID,
                                  pi_vKey                   => pi_vKey,
                                  pi_vPatientID             => pi_vPatientID,
                                  pi_nHighestGradeID        => pi_nHighestGradeID,
                                  pi_nHighestDegreeID       => pi_nHighestDegreeID,
                                  pi_nMaritalStatusID       => pi_nMaritalStatusID,
                                  pi_nEmploymentStatusID    => pi_nEmploymentStatusID,
                                  pi_nJobClassificationID   => pi_nJobClassificationID,
                                  pi_vEmploymentStatusOther => pi_vEmploymentStatusOther,
                                  po_nStatusCode            => po_nStatusCode,
                                  po_vStatusComment         => po_vStatusComment);
      return;
    end if;
  
    if pi_nHighestGradeID > 0 then
      v_nHighestGradeID := pi_nHighestGradeID;
    end if;
  
    if pi_nHighestDegreeID > 0 then
      v_nHighestDegreeID := pi_nHighestDegreeID;
    end if;
  
    if pi_nMaritalStatusID > 0 then
      v_nMaritalStatusID := pi_nMaritalStatusID;
    end if;
  
    if pi_nEmploymentStatusID > 0 then
      v_nEmploymentStatusID := pi_nEmploymentStatusID;
    end if;
  
    if pi_nJobClassificationID > 0 then
      v_nJobClassificationID := pi_nJobClassificationID;
    end if;
  
    if length(pi_vEmploymentStatusOther) > 0 then
      v_vEmploymentStatusOther := pi_vEmploymentStatusOther;
    end if;
  
    update patient_socioeconomic t
       set t.highest_grade_id        = v_nHighestGradeID,
           t.highest_degree_id       = v_nHighestDegreeID,
           t.marital_status_id       = v_nMaritalStatusID,
           t.employment_status_id    = v_nEmploymentStatusID,
           t.job_classification_id   = v_nJobClassificationID,
           t.employment_status_other = v_vEmploymentStatusOther,
           t.last_modified           = sysdate,
           t.last_modified_by        = pi_nUserID
     where t.patient_id = pi_vPatientID;
  
    commit;
  
  exception
    when others then
      po_nStatusCode    := -1;
      po_vStatusComment := 'PCK_PATIENT.UpdatePatientSocioeconomics(): ' ||
                           sqlCode || ': ' || sqlErrm;
  end;

  /*
  Inserts patient socioeconomics data 
  */
  procedure InsertPatientSocioeconomics(pi_vSessionID             in varchar2,
                                        pi_vSessionClientIP       in varchar2,
                                        pi_nUserID                in number,
                                        pi_vKey                   in varchar2,
                                        pi_vPatientID             in varchar2,
                                        pi_nHighestGradeID        in number,
                                        pi_nHighestDegreeID       in number,
                                        pi_nMaritalStatusID       in number,
                                        pi_nEmploymentStatusID    in number,
                                        pi_nJobClassificationID   in number,
                                        pi_vEmploymentStatusOther in varchar2,
                                        po_nStatusCode            out number,
                                        po_vStatusComment         out varchar2)
  is
  
    v_nHighestGradeID        number := null;
    v_nHighestDegreeID       number := null;
    v_nMaritalStatusID       number := null;
    v_nEmploymentStatusID    number := null;
    v_nJobClassificationID   number := null;
    v_vEmploymentStatusOther varchar2(255) := null;
  
  begin
    po_nStatusCode    := 0;
    po_vStatusComment := '';
  
    if pi_nHighestGradeID > 0 then
      v_nHighestGradeID := pi_nHighestGradeID;
    end if;
  
    if pi_nHighestDegreeID > 0 then
      v_nHighestDegreeID := pi_nHighestDegreeID;
    end if;
  
    if pi_nMaritalStatusID > 0 then
      v_nMaritalStatusID := pi_nMaritalStatusID;
    end if;
  
    if pi_nEmploymentStatusID > 0 then
      v_nEmploymentStatusID := pi_nEmploymentStatusID;
    end if;
  
    if pi_nJobClassificationID > 0 then
      v_nJobClassificationID := pi_nJobClassificationID;
    end if;
  
    if length(pi_vEmploymentStatusOther) > 0 then
      v_vEmploymentStatusOther := pi_vEmploymentStatusOther;
    end if;
  
    insert into patient_socioeconomic
      (patient_id,
       highest_grade_id,
       highest_degree_id,
       marital_status_id,
       employment_status_id,
       job_classification_id,
       last_modified,
       last_modified_by,
       employment_status_other)
    values
      (pi_vPatientID,
       v_nHighestDegreeID,
       v_nHighestDegreeID,
       v_nMaritalStatusID,
       v_nEmploymentStatusID,
       v_nJobClassificationID,
       sysdate,
       pi_nUserID,
       v_vEmploymentStatusOther);
  
    commit;
  
  exception
    when others then
      po_nStatusCode    := -1;
      po_vStatusComment := 'PCK_PATIENT.InsertPatientSocioeconomics(): ' ||
                           sqlCode || ': ' || sqlErrm;
  end;

end;
/
------------------------------------------------
--  Changed package body pck_patient_tx_step  --
------------------------------------------------
create or replace package body tbicds.PCK_PATIENT_TX_STEP is
/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

/*
Insert patient step
*/
   procedure InsertPatientStep(pi_vSessionID       in varchar2,
                              pi_vSessionClientIP in varchar2,
                              pi_nUserID          in number,
                              
                              pi_vPatientID in varchar2,
                              pi_nStep      in number,
                              
                              po_nStatusCode    out number,
                              po_vStatusComment out varchar2)
   is
      v_vSql                               varchar2(4000);
      v_nProfile                number := 1;
      v_nStartedBaseline        number := 2;
      v_nBaselineQuestionnaires number := 4;
      v_nStartedVideos          number := 8;
      v_nVideos                 number := 16;
      v_nCPAPData               number := 32;
      v_nStep number := 0;
      v_nCount       number;
      v_nRecCount    number := 0;
      v_nCurrentStep number := 0;
   begin
      v_vSql := 'select count(*) from tbicds.patient_treatment_step where patient_id = :P0';
      execute immediate v_vSql into v_nRecCount using pi_vPatientID;
   
      if v_nRecCount > 0 then
         v_vSql := 'select treatment_step from tbicds.patient_treatment_step where patient_id = :P0';
         execute immediate v_vSql into v_nCurrentStep using pi_vPatientID;
      end if;
   
      if (bitand(v_nCurrentStep, v_nProfile) = 0) then
         -- set step value for complete patient profile (from the portal)
         -- only if this step was not set before
         if (bitand(pi_nStep, v_nProfile) = v_nProfile) then
            v_nStep := v_nStep + v_nProfile;
         end if;
      elsif (bitand(v_nCurrentStep, v_nProfile) = v_nProfile) then
         v_nStep := v_nStep + v_nProfile;
      end if;
   
      --insert step other than PROFILE
      if (bitand(pi_nStep, v_nProfile) = 0) then
         v_nStep := v_nStep + pi_nStep;
      end if;
   
      --check status of Baseline questionnaires
      v_nCount := 0;
      v_vSql := 'select count(*) '
                || 'from tbicds.patient_module t '
                || 'where t.patient_id = :P0 '
                || 'and (t.module_group_id = 2 and t.status = 1) ';
      execute immediate v_vSql into v_nCount using pi_vPatientID;
   
      if v_nCount > 0 then
         v_nStep := v_nStep + v_nStartedBaseline;
      end if;
   
      v_nCount := 0;
      v_vSql := 'select count(*) '
                || 'from tbicds.patient_event t '
                || 'where t.patient_id = :P0 '
                || 'and (t.status = 1 and t.event_id = 5) ';
      execute immediate v_vSql into v_nCount using pi_vPatientID;
   
      if v_nCount > 0 then
         v_nStep := v_nStep + v_nBaselineQuestionnaires;
      end if;
   
      --check status of video events
      v_nCount := 0;
      v_vSql := 'select count(*) '
                || 'from tbicds.patient_event t '
                || 'where t.patient_id = :P0 '
                || 'and (t.status = 1 and t.event_id in (3, 4)) ';
      execute immediate v_vSql into v_nCount using pi_vPatientID;
      
      if v_nCount = 1 then
         v_nStep := v_nStep + v_nStartedVideos;
      elsif v_nCount = 2 then
         v_nStep := v_nStep + v_nStartedVideos + v_nVideos;
      end if;
   
      --check status of CPAP Data
      v_nCount := 0;
      v_vSql := 'select count(*) from tbicds.patient_cpap t where t.patient_id = :P0 ';
      execute immediate v_vSql into v_nCount using pi_vPatientID;
      
      if v_nCount > 0 then
         v_nStep := v_nStep + v_nCPAPData;
      end if;
   
      --insert or update
      if v_nRecCount > 0 then
         v_vSql := 'update tbicds.patient_treatment_step t '
                   || 'set t.treatment_step = :P0 '
                   || 'where t.patient_id = :P1 ';
         execute immediate v_vSql using v_nStep, pi_vPatientID;
      else
         v_vSql := 'insert into tbicds.patient_treatment_step (patient_id, treatment_step) '
                   || 'values (:P0, :P1) ';
         execute immediate v_vSql using pi_vPatientID, v_nStep;
      end if;
      commit;
   
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_PATIENT_TX_STEP.InsertPatientStep(): ' || sqlErrm;
   end;

   /*
   Update patient steps
   */
   procedure UpdatePatientSteps(pi_vSessionID       in varchar2,
                               pi_vSessionClientIP in varchar2,
                               pi_nUserID          in number,
                               pi_vPatientID in varchar2,
                               po_nStatusCode    out number,
                               po_vStatusComment out varchar2)
   is
      v_vSql                               varchar2(4000);
      v_nProfile                number := 1;
      v_nStartedBaseline        number := 2;
      v_nBaselineQuestionnaires number := 4;
      v_nStartedVideos          number := 8;
      v_nVideos                 number := 16;
      v_nCPAPData               number := 32;
      v_nStep number := 0;
      v_nCount       number;
      v_nRecCount    number := 0;
      v_nCurrentStep number := 0;
   begin
      v_vSql := 'select count(*) from tbicds.patient_treatment_step where patient_id = :P0';
      execute immediate v_vSql into v_nRecCount using pi_vPatientID;
   
      if v_nRecCount > 0 then
         v_vSql := 'select treatment_step from tbicds.patient_treatment_step where patient_id = :P0';
         execute immediate v_vSql into v_nCurrentStep using pi_vPatientID;
      end if;
   
      if (bitand(v_nCurrentStep, v_nProfile) = v_nProfile) then
         v_nStep := v_nStep + v_nProfile;
      end if;
   
      --check status of Baseline questionnaires
      v_nCount := 0;
      v_vSql := 'select count(*) '
                || 'from tbicds.patient_module '
                || 'where patient_id = :P0 '
                || 'and (module_group_id = 2 and status = 1) ';
      execute immediate v_vSql into v_nCount using pi_vPatientID;
   
      if v_nCount > 0 then
         v_nStep := v_nStep + v_nStartedBaseline;
      end if;
   
      v_nCount := 0;
      v_vSql := 'select count(*) '
                || 'from tbicds.patient_event t '
                || 'where t.patient_id = :P0 '
                || 'and (t.status = 1 and t.event_id = 5) ';
      execute immediate v_vSql into v_nCount using pi_vPatientID;
   
      if v_nCount > 0 then
         v_nStep := v_nStep + v_nBaselineQuestionnaires;
      end if;
   
      --check status of video events
      v_nCount := 0;
      v_vSql := 'select count(*) '
                || 'from tbicds.patient_event t '
                || 'where t.patient_id = :P0 '
                || 'and (t.status = 1 and t.event_id in (3, 4)) ';
      execute immediate v_vSql into v_nCount using pi_vPatientID;

      if v_nCount = 1 then
         v_nStep := v_nStep + v_nStartedVideos;
      elsif v_nCount = 2 then
         v_nStep := v_nStep + v_nStartedVideos + v_nVideos;
      end if;
   
      --check status of CPAP Data
      v_nCount := 0;
      v_vSql := 'select count(*) from tbicds.patient_cpap t where t.patient_id = :P0 ';
      execute immediate v_vSql into v_nCount using pi_vPatientID;
   
      if v_nCount > 0 then
         v_nStep := v_nStep + v_nCPAPData;
      end if;
   
      --insert or update
      if v_nRecCount > 0 then
         v_vSql := 'update tbicds.patient_treatment_step t '
                   || 'set t.treatment_step = :P0 '
                   || 'where t.patient_id = :P1 ';
         execute immediate v_vSql using v_nStep, pi_vPatientID;
      else
         v_vSql := 'insert into tbicds.patient_treatment_step (patient_id, treatment_step) '
                   || 'values (:P0, :P1) ';
         execute immediate v_vSql using pi_vPatientID, v_nStep;
      end if;
      commit;
   
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_PATIENT_TX_STEP.UpdatePatientSteps(): ' || sqlErrm;
   end;

   /*
   remove patient step
   */
   procedure DeletePatientStep(pi_vSessionID       in varchar2,
                              pi_vSessionClientIP in varchar2,
                              pi_nUserID          in number,
                              pi_vPatientID in varchar2,
                              pi_nStep      in number,
                              po_nStatusCode    out number,
                              po_vStatusComment out varchar2)
   is
      v_vSql                               varchar2(4000);
      v_nStep        number;
      v_nRecCount    number := 0;
      v_nCurrentStep number := 0;
   begin
      v_vSql := 'select count(*) from tbicds.patient_treatment_step where patient_id = :P0';
      execute immediate v_vSql into v_nRecCount using pi_vPatientID;
   
      if v_nRecCount > 0 then
         v_vSql := 'select treatment_step from tbicds.patient_treatment_step where patient_id = :P0';
         execute immediate v_vSql into v_nCurrentStep using pi_vPatientID;
      
         if (bitand(v_nCurrentStep, pi_nStep) = pi_nStep) then
            v_nStep := v_nCurrentStep - pi_nStep;
         end if;
         
         v_vSql := 'update tbicds.patient_treatment_step set treatment_step = :P0 where patient_id = :P1';
         execute immediate v_vSql using v_nStep, pi_vPatientID;
         commit;
      end if;
   
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_PATIENT_TX_STEP.DeletePatientStep(): ' || sqlErrm;
   end;

   /*
   Get patient step recordset
   */
   procedure GetPatientStepRS(pi_vSessionID       in varchar2,
                             pi_vSessionClientIP in varchar2,
                             pi_nUserID          in number,
                             pi_vPatientID in varchar2,
                             po_nStatusCode    out number,
                             po_vStatusComment out varchar2,
                             rs                out RetRefCursor)
   is
      v_vSql                               varchar2(4000);
   begin
      v_vSql := 'select nvl(t.treatment_step, 0) as step, '
                || 'nvl(t.notification_step, 0) as notification_step '
                || 'from tbicds.patient_treatment_step t '
                || 'where t.patient_id = :P0 ';
      open rs for v_vSql using pi_vPatientID;
   
   exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_PATIENT_TX_STEP.GetPatientStepRS(): ' || sqlErrm;
   end;

   /*
   Update notification step
   */
   procedure UpdateNotificationStep(pi_vSessionID       in varchar2,
                                   pi_vSessionClientIP in varchar2,
                                   pi_nUserID          in number,
                                   pi_vPatientID        in varchar2,
                                   pi_nNotificationStep in number,
                                   po_nStatusCode    out number,
                                   po_vStatusComment out varchar2)
   is
      v_vSql                               varchar2(4000);
      v_nNotificationStep number := 0;
   begin
      v_vSql := 'select notification_step from tbicds.patient_treatment_step where patient_id = :P0';
      execute immediate v_vSql into v_nNotificationStep using pi_vPatientID;
   
      if bitand(v_nNotificationStep, pi_nNotificationStep) = 0 then
         v_nNotificationStep := v_nNotificationStep + pi_nNotificationStep;
         
         v_vSql := 'update tbicds.patient_treatment_step set notification_step = :P0 where patient_id = :P1';
         execute immediate v_vSql using v_nNotificationStep, pi_vPatientID;
         commit;
      end if;
   
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_PATIENT_TX_STEP.UpdateNotificationStep(): ' || sqlErrm;
   end;

end;
/
---------------------------------------------------
--  Changed package body pck_pat_ethnicity_race  --
---------------------------------------------------
create or replace package body tbicds.PCK_PAT_ETHNICITY_RACE is
/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
  /*
  insert patient ethnicity
  */
  procedure InsertPatientEthnicity(pi_vSessionID       in varchar2,
                                   pi_vSessionClientIP in varchar2,
                                   pi_nUserID          in number,
                                   pi_vPatientID       in varchar2,
                                   pi_nEthnicityID     in number,
                                   po_nStatusCode      out number,
                                   po_vStatusComment   out varchar2) 
  is
    v_vSQL constant varchar2(32767) := 'insert into tbicds.patient_ethnicity
       (patient_id,
        ethnicity_id)
        values
       (:PatientID,
        :EthnicityID)';
  begin
    po_nStatusCode    := PCK_COMMON.c_nResultStatus_Success;
    po_vStatusComment := '';
  
    execute immediate v_vSQL
      using pi_vPatientID, pi_nEthnicityID;
    commit;
  exception
    when others then
      po_nStatusCode    := PCK_COMMON.c_nResultStatus_Error;
      po_vStatusComment := 'PCK_PAT_ETHNICITY_RACE.InsertPatientEthnicity(): ' ||
                           sqlErrm;
  end;

  /*
  insert patient race
  */
  procedure InsertPatientRace(pi_vSessionID       in varchar2,
                              pi_vSessionClientIP in varchar2,
                              pi_nUserID          in number,
                              pi_vPatientID       in varchar2,
                              pi_nRaceID          in number,
                              po_nStatusCode      out number,
                              po_vStatusComment   out varchar2)
  is
    v_vSQL constant varchar2(32767) := 'insert into tbicds.patient_race
       (patient_id,
        race_id)
        values
       (:PatientID,
        :RaceID)';
  begin
    po_nStatusCode    := PCK_COMMON.c_nResultStatus_Success;
    po_vStatusComment := '';
  
    execute immediate v_vSQL
      using pi_vPatientID, pi_nRaceID;
    commit;
  exception
    when others then
      po_nStatusCode    := PCK_COMMON.c_nResultStatus_Error;
      po_vStatusComment := 'PCK_PAT_ETHNICITY_RACE.InsertPatientRace(): ' ||
                           sqlErrm;
  end;

  /*
  Insert patient ethnicity race source
  */
  procedure InsertPatEthRaceSource(pi_vSessionID       in varchar2,
                                   pi_vSessionClientIP in varchar2,
                                   pi_nUserID          in number,
                                   pi_vPatientID       in varchar2,
                                   pi_nSourceID        in number,
                                   po_nStatusCode      out number,
                                   po_vStatusComment   out varchar2)
  is
    v_vSQL constant varchar2(32767) := 'insert into tbicds.pat_eth_race_source
       (patient_id,
        eth_race_source_id)
        values
       (:PatientID,
        :EthRaceSourceID)';
  begin
    po_nStatusCode    := PCK_COMMON.c_nResultStatus_Success;
    po_vStatusComment := '';
  
    execute immediate v_vSQL
      using pi_vPatientID, pi_nSourceID;
    commit;
  exception
    when others then
      po_nStatusCode    := PCK_COMMON.c_nResultStatus_Error;
      po_vStatusComment := 'PCK_PAT_ETHNICITY_RACE.InsertPatEthRaceSource(): ' ||
                           sqlErrm;
  end;

  /*
  Get ethnicity recordset
  */
  procedure GetEthnicityRS(pi_vSessionID       in varchar2,
                           pi_vSessionClientIP in varchar2,
                           pi_nUserID          in number,
                           po_nStatusCode      out number,
                           po_vStatusComment   out varchar2,
                           rs                  out RetRefCursor)
  is
    v_vSQL varchar2(32767) := 'select t.*
       from tbicds.stat_ethnicity t
       order by t.sort_order';
  begin
    po_nStatusCode    := PCK_COMMON.c_nResultStatus_Success;
    po_vStatusComment := '';
  
    open rs for v_vSQL;
  exception
    when others then
      po_nStatusCode    := PCK_COMMON.c_nResultStatus_Error;
      po_vStatusComment := 'PCK_PAT_ETHNICITY_RACE.GetEthnicityRS(): ' ||
                           sqlErrm;
  end;

  /*
  Get race recordset
  */
  procedure GetRaceRS(pi_vSessionID       in varchar2,
                      pi_vSessionClientIP in varchar2,
                      pi_nUserID          in number,
                      po_nStatusCode      out number,
                      po_vStatusComment   out varchar2,
                      rs                  out RetRefCursor)
  is
    v_vSQL varchar2(32767) := 'select t.*
       from tbicds.stat_race t
       order by t.sort_order';
  begin
    po_nStatusCode    := PCK_COMMON.c_nResultStatus_Success;
    po_vStatusComment := '';
  
    open rs for v_vSQL;
  exception
    when others then
      po_nStatusCode    := PCK_COMMON.c_nResultStatus_Error;
      po_vStatusComment := 'PCK_PAT_ETHNICITY_RACE.GetRaceRS(): ' ||
                           sqlErrm;
  end;

  /*
  Get ethnicity race source recordset
  */
  procedure GetEthRaceSourceRS(pi_vSessionID       in varchar2,
                               pi_vSessionClientIP in varchar2,
                               pi_nUserID          in number,
                               po_nStatusCode      out number,
                               po_vStatusComment   out varchar2,
                               rs                  out RetRefCursor)
  is
    v_vSQL varchar2(32767) := 'select t.*
       from tbicds.stat_eth_race_source t';
  begin
    po_nStatusCode    := PCK_COMMON.c_nResultStatus_Success;
    po_vStatusComment := '';
  
    open rs for v_vSQL;
  exception
    when others then
      po_nStatusCode    := PCK_COMMON.c_nResultStatus_Error;
      po_vStatusComment := 'PCK_PAT_ETHNICITY_RACE.GetEthRaceSourceRS(): ' ||
                           sqlErrm;
  end;

  /*
  Returns patient ethnicity recordset 
  */
  procedure GetPatientEthnicityRS(pi_vSessionID       in varchar2,
                                  pi_vSessionClientIP in varchar2,
                                  pi_nUserID          in number,
                                  pi_vPatientID       in varchar2,
                                  po_nStatusCode      out number,
                                  po_vStatusComment   out varchar2,
                                  rs                  out RetRefCursor)
  is
    v_vSQL varchar2(32767) := 'select p.*, 
                                      c.item
                                 from tbicds.patient_ethnicity p, 
                                      tbicds.stat_data_collection c
                                where p.patient_id = :PATIENT_ID
                                  and c.collection_type = ''_ETHNICITY''
                                  and p.ethnicity_id = c.collection_item_id(+)';
  begin
    po_nStatusCode    := PCK_COMMON.c_nResultStatus_Success;
    po_vStatusComment := '';
  
    open rs for v_vSQL
      using pi_vPatientID;
      
  exception
    when others then
      po_nStatusCode    := PCK_COMMON.c_nResultStatus_Error;
      po_vStatusComment := 'PCK_PAT_ETHNICITY_RACE.GetPatientEthnicityRS(): ' ||
                           sqlErrm;
  end;

  /*
  Returns patient race recordset 
  */
  procedure GetPatientRaceRS(pi_vSessionID       in varchar2,
                             pi_vSessionClientIP in varchar2,
                             pi_nUserID          in number,
                             pi_vPatientID       in varchar2,
                             po_nStatusCode      out number,
                             po_vStatusComment   out varchar2,
                             rs                  out RetRefCursor)
  is
    v_vSQL varchar2(32767) := 'select race_id from patient_race where patient_id= :PatientID';
    
  begin
    po_nStatusCode    := PCK_COMMON.c_nResultStatus_Success;
    po_vStatusComment := '';
  
    open rs for v_vSQL
      using pi_vPatientID;
  exception
    when others then
      po_nStatusCode    := PCK_COMMON.c_nResultStatus_Error;
      po_vStatusComment := 'PCK_PAT_ETHNICITY_RACE.GetPatientRaceRS(): ' ||
                           sqlErrm;
  end;

  /*
  Get patient race lsit as a string
  */
  function GetPatientRaceListString(pi_vPatientID in varchar2) return varchar2
    is
       
    v_vSQL varchar(32767) := 'select t.item as race_title
       from stat_data_collection t
       where t.collection_type = ''_RACE''
         and t.collection_item_id in(select race_id from patient_race where patient_id= :PatientID)
         and t.active = 1
       order by t.collection_item_id';
  
    curPatientRaces pck_common.refCursor;
  
    v_vRace varchar2(32767) := '';
  
    v_vRaceList varchar2(32767) := '';
  begin
    open curPatientRaces for v_vSQL
      using pi_vPatientID;
  
    fetch curPatientRaces
      into v_vRace;
  
    v_vRaceList := v_vRace;
  
    loop
    
      fetch curPatientRaces
        into v_vRace;
      exit when not curPatientRaces%found;
    
      v_vRaceList := v_vRaceList || ', ' || v_vRace;
    
    end loop;
  
    return replace(v_vRaceList, ', ' || v_vRace, ' and ' || v_vRace);
  exception
    when others then
      return null;
  end;

  /*
  Get patient ethnicity race source recordset
  */
  procedure GetPatEthRaceSourceRS(pi_vSessionID       in varchar2,
                                  pi_vSessionClientIP in varchar2,
                                  pi_nUserID          in number,
                                  pi_vPatientID       in varchar2,
                                  po_nStatusCode      out number,
                                  po_vStatusComment   out varchar2,
                                  rs                  out RetRefCursor)
  is
    v_vSQL varchar2(32767) := 'select p.*, s.eth_race_source_name
       from tbicds.pat_eth_race_source p, tbicds.stat_eth_race_source s
       where p.patient_id = :PatientID
       and p.eth_race_source_id = s.eth_race_source_id';
  begin
    po_nStatusCode    := PCK_COMMON.c_nResultStatus_Success;
    po_vStatusComment := '';
  
    open rs for v_vSQL
      using pi_vPatientID;
  exception
    when others then
      po_nStatusCode    := PCK_COMMON.c_nResultStatus_Error;
      po_vStatusComment := 'PCK_PAT_ETHNICITY_RACE.GetPatientRaceRS(): ' ||
                           sqlErrm;
  end;

  /*
  Remove patient ethnicity
  */
  procedure DeletePatientEthnicity(pi_vSessionID       in varchar2,
                                   pi_vSessionClientIP in varchar2,
                                   pi_nUserID          in number,
                                   pi_vPatientID       in varchar2,
                                   po_nStatusCode      out number,
                                   po_vStatusComment   out varchar2)
   is
    v_vSQL constant varchar2(32767) := 'delete from tbicds.patient_ethnicity p
       where p.patient_id = :PatientID';
  begin
    po_nStatusCode    := PCK_COMMON.c_nResultStatus_Success;
    po_vStatusComment := '';
  
    execute immediate v_vSQL
      using pi_vPatientID;
    commit;
  exception
    when others then
      po_nStatusCode    := PCK_COMMON.c_nResultStatus_Error;
      po_vStatusComment := 'PCK_PAT_ETHNICITY_RACE.DeletePatientEthnicity(): ' ||
                           sqlErrm;
  end;

  /*
  Remove patient race
  */
  procedure DeletePatientRace(pi_vSessionID       in varchar2,
                              pi_vSessionClientIP in varchar2,
                              pi_nUserID          in number,
                              pi_vPatientID       in varchar2,
                              po_nStatusCode      out number,
                              po_vStatusComment   out varchar2)
  is
    v_vSQL constant varchar2(32767) := 'delete from tbicds.patient_race p
       where p.patient_id = :PatientID';
  begin
    po_nStatusCode    := PCK_COMMON.c_nResultStatus_Success;
    po_vStatusComment := '';
  
    execute immediate v_vSQL
      using pi_vPatientID;
    commit;
  exception
    when others then
      po_nStatusCode    := PCK_COMMON.c_nResultStatus_Error;
      po_vStatusComment := 'PCK_PAT_ETHNICITY_RACE.DeletePatientRace(): ' ||
                           sqlErrm;
  end;

  /*
  Remove patient ethnicity race source
  */
  procedure DeletePatEthRaceSource(pi_vSessionID       in varchar2,
                                   pi_vSessionClientIP in varchar2,
                                   pi_nUserID          in number,
                                   pi_vPatientID       in varchar2,
                                   po_nStatusCode      out number,
                                   po_vStatusComment   out varchar2)
  is
    v_vSQL constant varchar2(32767) := 'delete from tbicds.pat_eth_race_source p
       where p.patient_id = :PatientID';
  begin
    po_nStatusCode    := PCK_COMMON.c_nResultStatus_Success;
    po_vStatusComment := '';
  
    execute immediate v_vSQL
      using pi_vPatientID;
    commit;
  exception
    when others then
      po_nStatusCode    := PCK_COMMON.c_nResultStatus_Error;
      po_vStatusComment := 'PCK_PAT_ETHNICITY_RACE.DeletePatEthRaceSource(): ' ||
                           sqlErrm;
  end;

  /*
  Updates patient race selected values 
  */  
  procedure UpdatePatientRace(pi_vSessionID       in varchar2,
                              pi_vSessionClientIP in varchar2,
                              pi_nUserID          in number,
                              
                              pi_vPatientID in varchar2,
                              pi_vValues    in varchar2,
                              
                              po_nStatusCode    out number,
                              po_vStatusComment out varchar2)
  is
  
    v_vRecDelim   varchar2(1) := ',';
    v_vColDelim   varchar2(1) := ';';
    v_nRecPos     number := 0;
    v_nColPos     number := 0;
    v_nPrevRecPos number := 0;
    v_nPrevColPos number := 0;
    v_vRecord     varchar2(32767) := '';
    v_vColumn     varchar2(32767) := '';
    v_nColIndex   number := 0;
  
    --
    v_vValue varchar2(4000);
  
  begin
  
    po_nStatusCode    := 0;
    po_vStatusComment := '';
  
    if ((pi_vValues is null) or (LENGTH(pi_vValues) < 1)) then
      return;
    else
      delete from patient_race t where t.patient_id = pi_vPatientID;
    end if;
  
    --split records
    loop
      v_nRecPos := INSTR(pi_vValues, v_vRecDelim, v_nRecPos + 1);
      exit when v_nRecPos = 0;
      v_vRecord     := substr(pi_vValues,
                              v_nPrevRecPos + 1,
                              v_nRecPos - v_nPrevRecPos - 1);
      v_nPrevRecPos := v_nRecPos;
    
      --split columns from record
      --v_nColPos     := 0;
      --v_nPrevColPos := 0;
      --v_vColumn     := '';
      --v_nColIndex   := 0;
    
      --loop
      --  v_nColPos := INSTR(v_vRecord, v_vColDelim, v_nColPos + 1);
      --  exit when v_nColPos = 0;
      --  v_vColumn     := substr(v_vRecord,
      --                          v_nPrevColPos + 1,
      --                          v_nColPos - v_nPrevColPos - 1);
      --  v_nPrevColPos := v_nColPos;
    
      --  --loop columns
      --  if v_nColIndex = 0 then
      --    v_vValue := v_vColumn;
      --  end if;
    
      --  v_nColIndex := v_nColIndex + 1;
      --end loop;
    
      --do something here
      insert into patient_race
        (patient_id, race_id)
      values
        (pi_vPatientID, to_number(v_vRecord));
    
    end loop;
  
    commit;
  
  exception
    when others then
    
      po_nStatusCode    := 1;
      po_vStatusComment := '';
    
  end;

  /*
  Updates patient ethnicity 
  */ 
  procedure UpdatePatientEthnicity(pi_vSessionID       in varchar2,
                                   pi_vSessionClientIP in varchar2,
                                   pi_nUserID          in number,
                                   pi_vPatientID       in varchar2,
                                   pi_nEthnicityID     in number,
                                   po_nStatusCode      out number,
                                   po_vStatusComment   out varchar2)
  is
    v_vSQL constant varchar2(32767) := 'insert into tbicds.patient_ethnicity
       (patient_id,
        ethnicity_id)
        values
       (:PatientID,
        :EthnicityID)';
  
    v_vSQL2 constant varchar2(32767) := 'delete from tbicds.patient_ethnicity t
        where t.patient_id = :PatientID';
  begin
    po_nStatusCode    := PCK_COMMON.c_nResultStatus_Success;
    po_vStatusComment := '';
  
    execute immediate v_vSQL2
      using pi_vPatientID;
  
    execute immediate v_vSQL
      using pi_vPatientID, pi_nEthnicityID;
    commit;
  exception
    when others then
      po_nStatusCode    := PCK_COMMON.c_nResultStatus_Error;
      po_vStatusComment := 'PCK_PAT_ETHNICITY_RACE.UpdatePatientEthnicity(): ' ||
                           sqlErrm;
  end;

end;
/
----------------------------------------------
--  Changed package body pck_pat_treatment  --
----------------------------------------------
create or replace package body tbicds.PCK_PAT_TREATMENT is

/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
/*delete a treatment program*/
procedure DeleteTreatmentProgram( pi_vSessionID           in varchar2,
                           pi_vSessionClientIP     in varchar2,
                           pi_nUserID              in number,
                                
                           pi_nRegionID            in number,
                           pi_nSiteID              in number,
                           pi_vPatientID           in varchar2,
                           pi_nProgramID          in number,
                          
                           po_nStatusCode         out number,
                           po_vStatusComment      out varchar2
                          )
is
    v_nPatTreatmentID number := 0;
   
begin
  
    po_nStatusCode    := 0;
    po_vStatusComment := '';
   
    delete from tbicds.pat_treatment_program t 
    where t.program_id = pi_nProgramID;
    commit;


exception
    when others then
      rollback;
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;

/*delete a treatment*/
procedure DeleteTreatment( pi_vSessionID           in varchar2,
                           pi_vSessionClientIP     in varchar2,
                           pi_nUserID              in number,
                                
                           pi_nRegionID            in number,
                           pi_nSiteID              in number,
                           pi_vPatientID           in varchar2,
                           pi_nTreatmentID         in number,
                          
                           po_nStatusCode         out number,
                           po_vStatusComment      out varchar2
                          )
is
    v_nPatTreatmentID number := 0;
   
begin
  
    po_nStatusCode    := 0;
    po_vStatusComment := '';
   
    delete from tbicds.pat_treatment_program t 
    where t.treatment_id = pi_nTreatmentID;
    commit;
    
    delete from tbicds.pat_treatment t 
    where t.treatment_id = pi_nTreatmentID;
    commit;


exception
    when others then
      rollback;
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;


/*update patient treatment program record*/
procedure UpdateTreatmentProgram( pi_vSessionID           in varchar2,
                           pi_vSessionClientIP     in varchar2,
                           pi_nUserID              in number,
                           pi_vPatientID           in varchar2,
                           pi_nTreatmentID         in number,
                           pi_nProgramID           in number,
                           
                           pi_nCPAID               in number, 
                           pi_dtInitialDate        in date,
                           pi_dtEndDate            in date,
                                
                           po_nStatusCode         out number,
                           po_vStatusComment      out varchar2
                          )
is
    v_nPatTreatmentID number := 0;
    
    v_vSQL long :=

        'update tbicds.pat_treatment_program
         set  INITIAL_DATE = :INITIAL_DATE,
              END_DATE = :END_DATE,
              CPA_ID = :CPA_ID
        where TREATMENT_ID = :TREATMENT_ID
          and PROGRAM_ID = :PROGRAM_ID 
          and PATIENT_ID = :PATEINT_ID
          ';
begin
  
    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    
    --execute the SQL
    execute immediate v_vSQL
    using pi_dtInitialDate,
          pi_dtEndDate,
          pi_nCPAID, 
          pi_nTreatmentID,
          pi_nProgramID,
          pi_vPatientID;  
           
    commit;


exception
    when others then
      rollback;
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;


/*update patient treatment record*/
procedure UpdateTreatment( pi_vSessionID           in varchar2,
                           pi_vSessionClientIP     in varchar2,
                           pi_nUserID              in number,
                           pi_vPatientID           in varchar2,
                           pi_nTreatmentID         in number,
                           
                           pi_nTreatmentType       in number, 
                           pi_vTreatmentTitle      in varchar2,
                           
                           pi_dtInitialDate        in date,
                           pi_dtEndDate            in date,
                                
                           po_nStatusCode         out number,
                           po_vStatusComment      out varchar2
                          )
is
    v_nPatTreatmentID number := 0;
    
    v_vSQL long :=

        'update tbicds.pat_treatment
         set  INITIAL_DATE = :INITIAL_DATE,
              END_DATE = :END_DATE,
              TREATMENT_TYPE_ID = :TREAT_TYPE,
              TREATMENT_TITLE = :TREAT_TITLE
        where TREATMENT_ID = :TREATMENT_ID
          and PATIENT_ID = :PATEINT_ID
          ';
begin
  
    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    
    --execute the SQL
    execute immediate v_vSQL
    using pi_dtInitialDate,
          pi_dtEndDate,
          pi_nTreatmentType,
          pi_vTreatmentTitle,
          pi_nTreatmentID,
          pi_vPatientID;  
           
    commit;


exception
    when others then
      rollback;
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;


/*get treatment rs by id*/
procedure GetTreatmentRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vPatientID             in varchar2,
      pi_nTreatmentID           in long,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is

     v_vSQL varchar2(4000) :=
      'SELECT  t.PATIENT_ID,
               t.TREATMENT_ID,
               t.REGION_ID,
               t.SITE_ID,
               t.INITIAL_DATE,
               t.END_DATE,
               t.TREATMENT_TITLE,
               t.TREATMENT_TYPE_ID,
               decode(t.TREATMENT_TYPE_ID, 
                      1, ''Outpatient'', 
                      2, ''Inpatient'', 
                      ''Unknown'') as TREATMENT_TYPE 
         FROM tbicds.PAT_TREATMENT t
        WHERE t.patient_id = :PATIENT_ID 
          AND t.treatment_id = :TREATMENT_ID ';
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
     open rs 
      for v_vSQL
    using pi_vPatientID,
          pi_nTreatmentID;
    
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;

/*get treatment program rs by program id*/
procedure GetTreatmentProgramRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vPatientID             in varchar2,
      pi_nTreatmentID           in long,
      pi_nProgramID             in long,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is

     v_vSQL varchar2(4000) :=
      'SELECT  t.PATIENT_ID,
               t.TREATMENT_ID,
               t.CPA_ID,
               t.REGION_ID,
               t.SITE_ID,
               t.INITIAL_DATE,
               t.END_DATE,
               t.PROGRAM_ID,
               t2.CPA_TITLE
         FROM tbicds.PAT_TREATMENT_PROGRAM t,
              tbicds.CPA t2
        WHERE t.patient_id = :PATIENT_ID 
          AND t.treatment_id = :TREATMENT_ID 
          AND t.program_id = :PROGRAM_ID 
          AND t2.CPA_ID = t.CPA_ID      
        ORDER BY t.INITIAL_DATE DESC';
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
     open rs 
      for v_vSQL
    using pi_vPatientID,
          pi_nTreatmentID,
          pi_nProgramID;
    
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;


/*get treatment program rs by treatment id*/
procedure GetTreatmentProgramRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vPatientID             in varchar2,
      pi_nTreatmentID           in long,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is

     v_vSQL varchar2(4000) :=
      'SELECT  t.PATIENT_ID,
               t.TREATMENT_ID,
               t.CPA_ID,
               t.REGION_ID,
               t.SITE_ID,
               t.INITIAL_DATE,
               t.END_DATE,
               t.PROGRAM_ID,
               t2.CPA_TITLE
         FROM tbicds.PAT_TREATMENT_PROGRAM t,
              tbicds.CPA t2
        WHERE t.patient_id = :PATIENT_ID 
          AND t.treatment_id = :TREATMENT_ID 
          AND t2.CPA_ID = t.CPA_ID      
        ORDER BY t.INITIAL_DATE DESC';
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
     open rs 
      for v_vSQL
    using pi_vPatientID,
          pi_nTreatmentID;
    
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;

/*
gets a recordset of all treatments for this patient
*/
procedure GetTreatmentRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vPatientID             in varchar2,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is

     v_vSQL varchar2(4000) :=
      'SELECT  t.PATIENT_ID,
               t.TREATMENT_ID,
               t.TREATMENT_TYPE_ID,
               t.INITIAL_DATE,
               t.END_DATE,
               t.TREATMENT_TITLE,
               t.REGION_ID,
               t.SITE_ID,
               decode(t.TREATMENT_TYPE_ID, 
                      1, ''Outpatient'', 
                      2, ''Inpatient'', 
                      ''Unknown'') as TREATMENT_TYPE 
         FROM tbicds.PAT_TREATMENT t
        WHERE t.patient_id = :PATIENT_ID 
        ORDER BY t.INITIAL_DATE DESC';
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
     open rs 
      for v_vSQL
    using pi_vPatientID;
    
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;

/*
insert a new patient treatment
*/
procedure InsertTreatment( pi_vSessionID           in varchar2,
                           pi_vSessionClientIP     in varchar2,
                           pi_nUserID              in number,
                                
                           pi_nRegionID            in number,
                           pi_nSiteID              in number,
                           pi_vPatientID           in varchar2,
                          
                           pi_nTreatmentTypeID     in number,
                           pi_dtInitialDate        in date,
                           pi_dtEndDate            in date,
                           pi_vTreatmentTitle      in varchar2,
                                
                           po_nPatTreatmentID     out number,
                           po_nStatusCode         out number,
                           po_vStatusComment      out varchar2
                          )
is
    v_nPatTreatmentID number := 0;
    
    v_vSQL long :=

        'insert into tbicds.pat_treatment( PATIENT_ID,
                                           TREATMENT_ID,
                                           TREATMENT_TYPE_ID,
                                           INITIAL_DATE,
                                           END_DATE,
                                           TREATMENT_TITLE,
                                           REGION_ID,
                                           SITE_ID
                                         )
          values(:PATEINT_ID,
                 :TREATMENT_ID,
                 :TREATMENT_TYPE_ID,
                 :INITIAL_DATE,
                 :END_DATE,
                 :TREATMENT_TITLE,   
                 :REGION_ID,
                 :SITE_ID   
                 )';
begin
  
    po_nStatusCode    := 0;
    po_vStatusComment := '';
    po_nPatTreatmentID := 0;
    
    --get a new id
    select SEQ_PATTREATMENTID.nextval into v_nPatTreatmentID from dual;
    
    --execute the SQL
    execute immediate v_vSQL
    using pi_vPatientID,
          v_nPatTreatmentID,
          pi_nTreatmentTypeID,
          pi_dtInitialDate,
          pi_dtEndDate,
          pi_vTreatmentTitle,
          pi_nRegionID,
          pi_nSiteID
          ;  
           
    commit;

    --return the id
    po_nPatTreatmentID := v_nPatTreatmentID;
   

exception
    when others then
      rollback;
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;


/*
insert a new patient treatment program
*/
procedure InsertTreatmentProgram( pi_vSessionID           in varchar2,
                           pi_vSessionClientIP     in varchar2,
                           pi_nUserID              in number,
                                
                           pi_nRegionID            in number,
                           pi_nSiteID              in number,
                           
                           pi_vPatientID           in varchar2,
                           pi_nPatTreatmentID      in number,
                           pi_nCPAID               in number,
                                                      
                           pi_dtInitialDate        in date,
                           pi_dtEndDate            in date,
                          
                           po_nPatTreatProgID     out number,
                           po_nStatusCode         out number,
                           po_vStatusComment      out varchar2
                          )
is
    v_nPatTreatProgID number := 0;
    
    v_vSQL long :=

        'insert into tbicds.pat_treatment_program( PATIENT_ID,
                                                   TREATMENT_ID,
                                                   PROGRAM_ID,
                                                   CPA_ID,
                                                   INITIAL_DATE,
                                                   END_DATE,
                                                   REGION_ID,
                                                   SITE_ID
                                         )
          values(:PATEINT_ID,
                 :TREATMENT_ID,
                 :PROGRAM_ID,
                 :CPA_ID,
                 :INITIAL_DATE,
                 :END_DATE,
                 :REGION_ID,
                 :SITE_ID   
                 )';
begin
  
    po_nStatusCode    := 0;
    po_vStatusComment := '';
    po_nPatTreatProgID := 0;    
    
    --get a new id
    select SEQ_PATTREATPROGID.nextval into v_nPatTreatProgID from dual;
   
    --execute the SQL
    execute immediate v_vSQL
    using pi_vPatientID,
          pi_nPatTreatmentID,
          v_nPatTreatProgID,
          pi_nCPAID,
          pi_dtInitialDate,
          pi_dtEndDate,
          pi_nRegionID,
          pi_nSiteID
          ;  
           
    commit;

    --return the id
    po_nPatTreatProgID := v_nPatTreatProgID;
   

exception
    when others then
      rollback;
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;

end PCK_PAT_TREATMENT;
/
-----------------------------------------
--  Changed package body pck_provider  --
-----------------------------------------
create or replace package body tbicds.PCK_PROVIDER is
/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

/*
Get provider recordset
*/
   procedure GetProviderRS(pi_vSessionID       in varchar2,
                        pi_vSessionClientIP in varchar2,
                        pi_nUserID          in number,
                        pi_vDIMSID          in varchar2,
                        po_nStatusCode      out number,
                        po_vStatusComment   out varchar2,
                        rs                  out RetRefCursor)
   is
      v_vSQL varchar2(32767) := '';
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      v_vSQL := 'select t.provider_id, t.name '
                || 'from tbicds.app_user t, tbicds.fx_user_rights r '
                || 'where t.dims_id = :P0 '
                || 'and r.fx_user_id = t.fx_user_id '
                || 'and r.user_type in (1,2) '
                || 'order by t.name ';
      --open recordset
      open rs for v_vSQL using pi_vDIMSID;
   
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_PROVIDER.GetProviderRS(): ' || sqlErrm;
   end;

end;
/
----------------------------------------
--  Changed package body pck_pwevent  --
----------------------------------------
create or replace package body tbicds.PCK_PWEVENT is
/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

/*gets recent clinics used for events*/
procedure GetRecentClinicRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_nRegionID              in number,
      pi_nSiteID                in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is

     v_vSQL varchar2(1500) :=
       
        ' select * 
        from utl_clinic nt
        where nt.clinic_id
        in
        (select distinct(TIU_CLINIC_ID) 
        from pat_pw_event t 
        where t.TIU_CLINIC_ID is not null
        and t.region_id = :REGION_ID
        and t.site_id = :SITE_ID)
        and nt.region_id = :REGION_ID2 and nt.site_id = :SITE_ID2
        order by xfer_date desc';
       
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
     open rs 
      for v_vSQL
    using pi_nRegionID,
          pi_nSiteID,
          pi_nRegionID,
          pi_nSiteID;
    
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;



/*gets recent note titles used for events*/
procedure GetRecentNoteTitleRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_nRegionID              in number,
      pi_nSiteID                in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is

     v_vSQL varchar2(1500) :=
       
        ' select nt.*,
          decode(nt.is_consult,1,''Y'',''N'') as consult_yn 
          from utl_note_title nt
          where nt.note_title_tag
          in
          (select distinct(TIU_NOTE_TITLE_IEN) 
          from pat_pw_event t 
          where t.tiu_note_id is not null
          and t.region_id = :REGION_ID
          and t.site_id = :SITE_ID)
          and nt.region_id = :REGION_ID2 and nt.site_id = :SITE_ID2
          order by xfer_date desc';
       
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
     open rs 
      for v_vSQL
    using pi_nRegionID,
          pi_nSiteID,
          pi_nRegionID,
          pi_nSiteID;
    
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;

/***
insert modules into the pat pw event module list
****/
procedure InsertPatPWEventModule (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      
      pi_vPatientID             in varchar2,
      pi_nPatPWEventID          in number,
      pi_nMID                   in number,
      
      po_nEventModuleID         out number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2
      )
is

      v_nIndex number := 0;
      v_vMIDPiece varchar2(4000) := ''; 
      v_vFORPiece varchar2(4000) := '';  
      v_nMID number := 0;   
      v_nModuleFor number := 2;
      
      v_dtOldScheduled date := null;
      v_nPatPWID number := 0;
      v_nDays number := 0;
      v_nEventModuleID number := 0;
   
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    v_nEventModuleID := 0;
    
        
           --get the mid and bump the index
           v_nMID := pi_nMID;
           v_nModuleFor := 3;
           v_nIndex := v_nIndex +1;
           
           select SEQPATPWEVENTMODULEID.Nextval 
           into v_nEventModuleID from dual;
           
           insert into 
           pat_pw_event_module(PATIENT_ID,
                               MID,
                               STATUS,
                               REGION_ID,
                               SITE_ID,
                               DATE_STARTED,
                               DATE_COMPLETED,
                               PAT_PW_ID,
                               INTAKE_ID,
                               MODULE_FOR,
                               SORT_ORDER,
                               PAT_PW_EVENT_ID,
                               DATE_SCHEDULED,
                               PW_EVENT_MODULE_ID)
            values(pi_vPatientID,
                   
                   v_nMID,
                   
                   0,--status
                   
                   (select REGION_ID 
                    from pat_pw_event 
                    where pat_pw_event_id = pi_nPatPWEventID),
                   
                    (select SITE_ID 
                    from pat_pw_event 
                    where pat_pw_event_id = pi_nPatPWEventID),
                    
                    null, --date started
                    
                    null, --date completed
                   
                   (select PAT_PW_ID 
                    from pat_pw_event 
                    where pat_pw_event_id = pi_nPatPWEventID),
                   
                    null, --intake_id
                    
                    v_nModuleFor, --module for
                    
                    (select nvl(max(sort_order), 0) + 1 
                       from pat_pw_event_module 
                      where pat_pw_event_id = pi_nPatPWEventID),
                      
                    pi_nPatPWEventID,
                    
                    sysdate,
                    
                    v_nEventModuleID);
                                    
           commit;    
           
           po_nEventModuleID :=  v_nEventModuleID;                          
 
exception
    when others then
      rollback;
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;

/*
Insert patient pathway event
*/
procedure InsertPatPWEvent (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      
      pi_nRegionID              in number,
      pi_nSiteID                in number,
      
      pi_vPatientID             in varchar2,
      pi_nPatPWID               in number,
   
      pi_vEventTitle            in varchar2,
      pi_dtEventDate            in date,
      
      po_nPatPWEventID          out number,
      
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2
      )
is
      v_nPatPWEventID number := 0;
   
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    po_nPatPWEventID := 0;
    
    --get a new patient pathway event id
    select SEQPATPWEVENTID.nextval into v_nPatPWEventID from dual;
    
    --insert the event 
    insert into pat_pw_event
                (PATIENT_ID,
                 STATUS,
                 DATE_SCHEDULED,
                 DATE_STARTED,
                 DATE_COMPLETED,
                 REGION_ID,
                 SITE_ID,
                 PAT_PW_ID,
                 EVENT_TITLE,
                 EVENT_DESCR,
                 SORT_ORDER,
                 EVENT_FREQUENCY,
                 PW_EVENT_TYPE_ID,
                 PAT_PW_EVENT_ID,
                 CREATED_BY)
        values(pi_vPatientID,
               0,
               pi_dtEventDate,
               null,
               null,
               pi_nRegionID,
               pi_nSiteID,
               pi_nPatPWID,
               pi_vEventTitle,
               '',
               99,
               null,
               1, --scheduled
               v_nPatPWEventID,
               pi_nUserID);
        
        commit;                  
        
        --return the patpweventid
        po_nPatPWEventID := v_nPatPWEventID;
        
exception
    when others then
      rollback;
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;

/*****
Gets todays pathway events associated with a patient
******/
procedure GetTodaysPatPWEventRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vPatientID             in varchar2,
      pi_nPatPWID               in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is

     v_vSQL varchar2(1500) :=
       
        'SELECT t.PATIENT_ID,  
                t.STATUS,
                t.DATE_SCHEDULED,
                t.DATE_STARTED,
                t.DATE_COMPLETED,
                t.REGION_ID,
                t.SITE_ID,
                t.PAT_PW_ID,
                t.event_title,
                t.EVENT_DESCR,
                t.SORT_ORDER,
                t.EVENT_FREQUENCY,
                t.PW_EVENT_TYPE_ID,
                t.PAT_PW_EVENT_ID,
                t.PLAN_PAT_PW_EVENT_ID,
                t.PLAN_TEXT,
                t.NOTE_TEXT,
                t.TIU_DFN,
                t.TIU_DUZ,
                t.TIU_ENCOUNTER_ID,
                t.TIU_CONSULT_IEN,
                t.TIU_COSIGNER_DUZ,
                t.TIU_NOTE_TITLE_IEN,
                t.TIU_NOTE,
                t.TIU_CLINIC_ID,
                t.TIU_DATE_SUBMITTED,
                t.TIU_ENCOUNTER_TYPE,
                t.TIU_NOTE_TITLE,
                t.TIU_LOCATION,
                t.TIU_COSIGNER,
                t.TIU_NOTE_ID,
                t.TIU_CONSULT
                
       FROM tbicds.PAT_PW_EVENT t
       WHERE t.patient_id = :PATIENT_ID 
         and t.pat_pw_id = :PAT_PWID 
         and trunc(t.date_scheduled) = trunc(sysdate) 
         ORDER BY t.DATE_SCHEDULED DESC';
       
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
     open rs 
      for v_vSQL
    using pi_vPatientID,
          pi_nPatPWID;
    
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;

/*gets the no pathway for a patient*/
procedure GetNoPathwayRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vPatientID             in varchar2,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is

     v_vSQL varchar2(1024) :=
      'select t.* 
         from PAT_PW t 
        where t.patient_id = :PATIENT_ID 
              and t.PW_TYPE_ID = 3';

begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
    open rs 
    for v_vSQL 
      using pi_vPatientID;
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;


/*gets all open encounters for a patient*/
procedure GetOpenEncountersRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vPatientID             in varchar2,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is

     v_vSQL varchar2(2048) :=
      'select to_char(t.date_scheduled,''mm/dd/yyyy HH:MI:SS'') as event_date,
              t.date_completed, t.patient_id, t.tiu_note_title,
              t.pat_pw_event_id,
              t.status,
              t.date_scheduled,
              t.pat_pw_id,
              (select name 
                 from app_user u
              where u.fx_user_id = t.created_by)  as PROVIDER_NAME
              
         from PAT_PW_EVENT t, PAT_PW p
        where t.pat_pw_id = p.pat_pw_id 
              and t.date_completed is null 
              and t.patient_id = :PATIENT_ID 
              and trunc(t.date_scheduled) <= trunc(sysdate) 
              and (( (t.tiu_note_title is not null)
                 or (t.pat_pw_event_id in (select pat_pw_event_id 
                                          from pat_pw_event_module t2 
                                          where t2.date_completed is not null))
                 or (t.note_text is not null))
                 
                 or (t.status = 0 and p.pw_type_id = 3)
                 )
                 
              order by t.date_scheduled desc';

begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
    open rs 
    for v_vSQL 
      using pi_vPatientID;
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;


/*updates the intrument date*/
procedure UpdateInstrumentDate (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      
      pi_vPatientID             in varchar2,
      pi_nIntakeID              in number,
      pi_dtDate                 in date,
                      
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2
      )
is

     v_vSQL long :=
      'UPDATE tbicds.PAT_PW_EVENT_MODULE  
       set DATE_STARTED = :DATE_STARTED,
           DATE_COMPLETED = :DATE_COMPLETED 
       where PATIENT_ID = :PATIENT_ID
       and INTAKE_ID = :INTAKE_ID';
       
     v_vSQL2 long :=
      'UPDATE tbicds.DATA_INTAKE  
       set START_DATE = :DATE_STARTED,
           COMPLETE_DATE = :DATE_COMPLETED 
       where PATIENT_ID = :PATIENT_ID
       and INTAKE_ID = :INTAKE_ID';
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --execute the sql
    execute immediate v_vSQL 
                using pi_dtDate,
                      pi_dtDate,
                      pi_vPatientID,
                      pi_nIntakeID
                      ;
    
    commit;
    
    --execute the sql setting the modules to completed
    execute immediate v_vSQL2 
                using pi_dtDate,
                      pi_dtDate,
                      pi_vPatientID,
                      pi_nIntakeID
                      ;
    
    commit;
    
exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;

/*get the most recent medical history record*/
procedure GetMedicalHxRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vPatientID             in varchar2,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is

     v_vSQL varchar2(4000) :=
      'select t.patient_id,
              t.region_id,
              t.site_id,
              t.pat_pw_id,
              t.pat_pw_event_id,
              t.med_hx_date,
              t.fx_user_id
         from patient_medical_hx t
        where t.patient_id = :PATIENT_ID
          and t.med_hx_date = (select max(med_hx_date) 
                                 from patient_medical_hx 
                                where patient_id = :PATIENT_ID)';

begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
     open rs 
      for v_vSQL
    using pi_vPatientID,
          pi_vPatientID;
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;


/*insert a new medical history record*/
procedure InsertMedicalHx ( pi_vSessionID           in varchar2,
                            pi_vSessionClientIP     in varchar2,
                            pi_nUserID              in number,
                                
                            pi_nRegionID            in number,
                            pi_nSiteID              in number,
                            pi_vPatientID           in varchar2,
                            pi_nPatPWID             in number,
                            pi_nPatPWEventID        in number,
                            
                            po_nStatusCode           out number,
                            po_vStatusComment        out varchar2
                          )
is
    v_nPWEventTypeID number := 0;
    v_nPatPWEventID number := 0;
    v_nSortOrder number := 0;
    
    v_vSQL long :=

        'insert into tbicds.patient_medical_hx( PATIENT_ID,
                                                REGION_ID,
                                                SITE_ID,
                                                PAT_PW_ID,
                                                PAT_PW_EVENT_ID,
                                                MED_HX_DATE,
                                                FX_USER_ID
                                               )
          values(:PATEINT_ID,
                 :REGION_ID,
                 :SITE_ID,
                 :PAT_PW_ID,
                 :PAT_PW_EVENT_ID,
                 :MED_HX_DATE,
                 :FX_USER_ID             
                 )';
begin
  
    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --get a new id
    --select SEQPATPWEVENTID.nextval into v_nPatPWEventID from dual;
    
    --execute the SQL
    execute immediate v_vSQL
    using pi_vPatientID,
          pi_nRegionID,
          pi_nSiteID,
          pi_nPatPWID,
          pi_nPatPWEventID,
          sysdate,
          pi_nUserID;  
           
    commit;

exception
    when others then
      rollback;
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;

/*get the most recent medical history intake_id*/ 
procedure GetMedicalHxIntakeID( pi_vSessionID       in varchar2,
                                pi_vSessionClientIP in varchar2,
                                pi_nUserID          in number,   
                                pi_vPatientID       in varchar2,
                                po_nIntakeID        out number,   
                                po_nStatusCode      out number,
                                po_vStatusComment   out varchar2
                              )
is

  v_nIntakeID number := 0;

begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    -- get the latest intake_id for the Past Medical History module instrument
    begin
      select max(intake_id)
        into v_nIntakeID
        from data_intake_responses
       where patient_id = pi_vPatientID
         and mid = 3000; -- Past Medical History module instrument
    exception
      when others then
        v_nIntakeID := 0;
    end;
    
    --Return the Intake ID
    po_nIntakeID := v_nIntakeID;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;
                               
/*write note details to tbi cds after commited to MDWS*/
procedure WriteNote (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      
      pi_vPatientID             in varchar2,
      pi_nPatPWEventID          in number,
      
      pi_vDFN                   in varchar2,
      pi_vDUZ                   in varchar2,
      pi_vEncounterID           in varchar2,
      pi_vConsultIEN            in varchar2,
      pi_vCosignerDUZ           in varchar2,
      pi_vNoteTitleIEN          in varchar2,
      pi_vTIUNoteID             in varchar2,
      pi_vTIUNote               in clob,
      pi_nClinicID              in number,
      pi_nEncounterType         in number,
      pi_vNoteTitle             in varchar2,
      pi_vLocation              in varchar2,
      pi_vCosigner              in varchar2,
      pi_vConsult               in varchar2,
      pi_vTBINote               in clob,
                      
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2
      )
is

     v_vSQL long :=
      'UPDATE tbicds.pat_pw_event  
       set TIU_DFN = :TIU_DFN,
           TIU_DUZ = :TIU_DUZ,
           TIU_ENCOUNTER_ID = :TIU_ENCOUNTER_ID,
           TIU_CONSULT_IEN = :TIU_CONSULT_IEN,
           TIU_COSIGNER_DUZ = :TIU_COSIGNER_DUZ,
           TIU_NOTE_TITLE_IEN = :TIU_NOTE_TITLE_IEN,
           TIU_NOTE_ID = :TIU_NOTE_ID, 
           TIU_NOTE = :TIU_NOTE,
           TIU_CLINIC_ID = :TIU_CLINIC_ID,
           TIU_DATE_SUBMITTED = :TIU_DATE_SUBMITTED,
           TIU_ENCOUNTER_TYPE = :TIU_ENCOUNTER_TYPE,
           TIU_NOTE_TITLE = :TIU_NOTE_TITLE,
           TIU_LOCATION = :TIU_LOCATION,
           TIU_COSIGNER = :TIU_COSIGNER,
           TIU_CONSULT = :TIU_CONSULT,
           NOTE_TEXT = :NOTE_TEXT,
           STATUS = 2,
           DATE_COMPLETED = :DATE_COMPLETED 
       where PATIENT_ID = :PATIENT_ID
       and PAT_PW_EVENT_ID = :PAT_PW_EVENT_ID';
       
     v_vSQL2 long :=
      'UPDATE tbicds.PAT_PW_EVENT_MODULE  
       set STATUS = 2
       where STATUS = 1  
       AND PATIENT_ID = :PATIENT_ID
       AND PAT_PW_EVENT_ID = :PAT_PW_EVENT_ID';
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --execute the sql
    execute immediate v_vSQL 
                using pi_vDFN,
                      pi_vDUZ,
                      pi_vEncounterID,
                      pi_vConsultIEN,
                      pi_vCosignerDUZ,
                      pi_vNoteTitleIEN,
                      pi_vTIUNoteID,
                      pi_vTIUNote,
                      pi_nClinicID,
                      sysdate,
                      pi_nEncounterType,
                      pi_vNoteTitle,
                      pi_vLocation,
                      pi_vCosigner,
                      pi_vConsult,
                      pi_vTBINote,
                      sysdate,
                      pi_vPatientID,
                      pi_nPatPWEventID
                      ;
    
    commit;
    
    --execute the sql setting the modules to completed
    execute immediate v_vSQL2 
                using pi_vPatientID,
                      pi_nPatPWEventID;
    
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;

/*save note progress, used while the note is being written but before 
it is commited*/
procedure SaveNoteProgress (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      
      pi_vPatientID             in varchar2,
      pi_nPatPWEventID          in number,
      
      pi_nEncounterType         in number,
      pi_vNoteTitle             in varchar2,
      pi_vLocation              in varchar2,
      pi_vCosigner              in varchar2,
      pi_vConsult               in varchar2,
      pi_vNote                  in clob,
                      
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2
      )
is

     v_vSQL long :=
      'UPDATE tbicds.pat_pw_event  
       set TIU_ENCOUNTER_TYPE = :TIU_ENCOUNTER_TYPE,
           TIU_NOTE_TITLE = :TIU_NOTE_TITLE,
           TIU_LOCATION = :TIU_LOCATION,
           TIU_COSIGNER = :TIU_COSIGNER,
           TIU_CONSULT = :TIU_CONSULT,
           NOTE_TEXT = :NOTE_TEXT
       where PATIENT_ID = :PATIENT_ID
       and PAT_PW_EVENT_ID = :PAT_PW_EVENT_ID';
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --execute the sql
    execute immediate v_vSQL 
                using pi_nEncounterType,
                      pi_vNoteTitle,
                      pi_vLocation,
                      pi_vCosigner,
                      pi_vConsult,
                      pi_vNote,
                      pi_vPatientID,
                      pi_nPatPWEventID
                      ;
    
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;

/***
Get all outcome measures associated with an event
***/
procedure GetOutcomeMeasuresRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vPatientID             in varchar2,
      pi_nPatPWEventID          in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is

     v_vSQL long :=
      'select t.patient_id, 
       t.pat_pw_id, 
       t.pat_pw_event_id, 
       t.pw_event_module_id, 
       t.mid,
       t.intake_id,
       t2.module,
              
       (select count(*)  
          from data_intake_responses
         where intake_id = t.intake_id
           and mid = 4042 
           and tid=1
           and qid=1
           and rid=21) as is_goal,
                                       
       (select tdi.complete_date  
          from data_intake tdi
          where tdi.patient_id = t.patient_id
          and tdi.intake_id = t.intake_id
          and tdi.patient_id = t.patient_id 
          and tdi.mid = t.mid 
          and rownum=1) as current_score_date,
          
       (select tds.score   
          from data_intake_score tds
          where tds.patient_id = t.patient_id
          and tds.intake_id = t.intake_id
          and tds.patient_id = t.patient_id
          and tds.mid = t.mid 
          and tds.series = 0
          and rownum=1) as current_score,
          
         (select tds.interpretation   
          from data_intake_score tds
          where tds.patient_id = t.patient_id
          and tds.intake_id = t.intake_id
          and tds.patient_id = t.patient_id 
          and tds.mid = t.mid 
          and tds.series = 0
          and rownum=1) as current_interpretation,
          
         (select pe.event_entry_type_id 
          from pat_pw_event_entry pe,
               stat_event_status es
          where pe.event_status_id = es.event_status_id
            and pe.patient_id = t.patient_id
            and pe.pw_event_module_id = t.pw_event_module_id
            and pe.event_date = 
             (select max(event_date) 
                from pat_pw_event_entry pe2
               where pe2.pw_event_module_id = t.pw_event_module_id)
            and rownum=1) as event_entry_type_id,
            
         (select es.event_status 
          from pat_pw_event_entry pe,
               stat_event_status es
          where pe.event_status_id = es.event_status_id
            and pe.patient_id = t.patient_id
            and pe.pw_event_module_id = t.pw_event_module_id
            and pe.event_date = 
             (select max(event_date) 
                from pat_pw_event_entry pe2
               where pe2.pw_event_module_id = t.pw_event_module_id)
            and rownum=1) as current_status,
            
          (select pe.event_status_id  
          from pat_pw_event_entry pe,
               stat_event_status es
          where pe.event_status_id = es.event_status_id
            and pe.patient_id = t.patient_id
            and pe.pw_event_module_id = t.pw_event_module_id
            and pe.event_date = 
             (select max(event_date) 
                from pat_pw_event_entry pe2
               where pe2.pw_event_module_id = t.pw_event_module_id)
            and rownum=1) as current_status_id,
            
          (select es.event_severity  
          from pat_pw_event_entry pe,
               stat_event_severity es
          where pe.event_severity_id = es.event_severity_id 
            and pe.patient_id = t.patient_id
            and pe.pw_event_module_id = t.pw_event_module_id
            and pe.event_date = 
             (select max(event_date) 
                from pat_pw_event_entry pe2
               where pe2.pw_event_module_id = t.pw_event_module_id)
            and rownum=1) as current_severity,
            
          (select es.event_severity_id  
          from pat_pw_event_entry pe,
               stat_event_severity es
          where pe.event_severity_id = es.event_severity_id 
            and pe.patient_id = t.patient_id
            and pe.pw_event_module_id = t.pw_event_module_id
            and pe.event_date = 
             (select max(event_date) 
                from pat_pw_event_entry pe2
               where pe2.pw_event_module_id = t.pw_event_module_id)
            and rownum=1) as current_severity_id,
                             
         (select count(*) 
          from pat_pw_event_entry pe,
                stat_event_status es
          where pe.event_status_id = es.event_status_id
            and pe.patient_id = t.patient_id
            and pe.pw_event_module_id = t.pw_event_module_id
            and rownum = 1) as current_reviewed,
            
       (select tdi.complete_date - 10  
          from data_intake tdi
          where tdi.patient_id = t.patient_id
          and tdi.intake_id = t.intake_id
          and tdi.patient_id = t.patient_id 
          and tdi.mid = t.mid 
          and rownum=1) as prev_score_date,
          
          PCK_PWEVENT.GetPrevIntakeScore(t.mid, t.patient_id, t.intake_id) as prev_score,
          
         (select tds.interpretation || ''PREV''   
          from data_intake_score tds
          where tds.patient_id = t.patient_id
          and tds.intake_id = t.intake_id 
          and tds.patient_id = t.patient_id 
          and tds.mid = t.mid 
          and tds.series = 0
          and rownum=1) as prev_interpretation,
          
          (select nvl(tt.status, 0) 
             from pat_pw_event tt 
           where tt.pat_pw_event_id = :PAT_PW_EVENT_ID) 
           as event_status
          
          from PAT_PW_EVENT_MODULE t,
               intake_module t2
          where t.patient_id = :PATIENT_ID
            and t.pat_pw_event_id = :PAT_PW_EVENT_ID
            and t2.mid = t.mid 
            and nvl(t.intake_id,-1) > 0 
       order by t2.module, t.date_scheduled';

begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
     open rs 
      for v_vSQL
    using pi_nPatPWEventID,
          pi_vPatientID,
          pi_nPatPWEventID;
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;

/***
Get all scores for an intake
***/
procedure GetIntakeScoreRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vPatientID             in varchar2,
      pi_nIntakeID              in number,
      pi_nMID                   in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is

     v_vSQL varchar2(4000) :=
      'select t.patient_id,
              t.mid,
              t.intake_id,
              t.series,
              t.score,
              PCK_PWEVENT.GetPrevIntakeSubscaleScore(t.mid, t.patient_id, t.intake_id, t.series) as PREV_SCORE,
              t.interpretation,
              t.description
         from data_intake_score t
        where t.patient_id = :PATIENT_ID
          and t.intake_id = :INTAKE_ID
          and t.MID = :MID 
     order by t.series asc';

begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
     open rs 
      for v_vSQL
    using pi_vPatientID,
          pi_nIntakeID,
          pi_nMID;
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;

/******
get all event entries for an event
******/  
procedure GetEventEntryRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vPatientID             in varchar2,
      pi_nPatPWEventID          in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is

     v_vSQL varchar2(4000) :=
      'SELECT t.PAT_PW_EVENT_ENTRY_ID,
              t.PATIENT_ID,
              t.PAT_PW_ID,
              t.PAT_PW_EVENT_ID,
              t.EVENT_ENTRY_TYPE_ID,
              t.EVENT_COMMENT,
              t.FX_USER_ID,
              t.EVENT_DATE,
              t.EVENT_STATUS_ID,
              t.EVENT_SEVERITY_ID,
              t.PW_EVENT_MODULE_ID,
              t2.NAME as USER_NAME,
              t2.TITLE as USER_TITLE,
              t3.EVENT_ENTRY_TYPE,
              
              (select tim.module from 
               intake_module tim,
               pat_pw_event_module tpe 
               where tpe.PW_EVENT_MODULE_ID = t.PW_EVENT_MODULE_ID 
               and tim.mid = tpe.mid) as module, 
              
              (select count(*) from
                tbicds.pat_pw_event_entry
                where PAT_PW_EVENT_ENTRY_ID = t.PAT_PW_EVENT_ENTRY_ID
                and fx_user_id = :FX_USER_ID) as allow_edit,
              (select nvl(tt.status,0) from
                pat_pw_event tt
                where tt.pat_pw_event_id = :PAT_PW_EVENT_ID) as event_status
                
       FROM tbicds.pat_pw_event_entry t,
            tbicds.app_user t2,
            tbicds.stat_event_entry_type t3
       where t.pat_pw_event_id = :PAT_PW_EVENT_ID 
       and t.patient_id = :PATIENT_ID
       and t2.fx_user_id = t.fx_user_id 
       and t3.event_entry_type_id = t.event_entry_type_id 
       order by event_date desc';
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
     open rs 
      for v_vSQL
    using pi_nUserID,
          pi_nPatPWEventID, 
          pi_nPatPWEventID,
          pi_vPatientID;
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;


/******
get event entry types Subjective, Objective, Assessment, Plan etc...
******/  
procedure GetEventEntryTypeRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is

     v_vSQL varchar2(500) :=
      'SELECT t.*
       FROM tbicds.STAT_EVENT_ENTRY_TYPE t 
       order by sort_order asc';
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
    open rs 
    for v_vSQL;
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;

/******
get event statuses Better, Same, Worse etc...
******/  
procedure GetEventStatusRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is

     v_vSQL varchar2(500) :=
      'SELECT t.*
       FROM tbicds.stat_event_status t 
       order by sort_order asc';
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
    open rs 
    for v_vSQL;
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;

/******
get event severities: mild, moderate, severe etc...
******/  
procedure GetEventSeverityRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is

     v_vSQL varchar2(500) :=
      'SELECT t.*
       FROM tbicds.stat_event_severity t 
       order by sort_order asc';
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
    open rs 
    for v_vSQL;
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;

/*
insert a new pathway event
*/
procedure InsertPWEvent ( pi_vSessionID           in varchar2,
                          pi_vSessionClientIP     in varchar2,
                          pi_nUserID              in number,
                                
                          pi_nRegionID            in number,
                          pi_nSiteID              in number,
                          pi_vPatientID           in varchar2,
                          pi_nPatPWID             in number,
                          pi_vEventTitle          in varchar2,
                          pi_dtEventDate          in varchar2,
                          pi_nRelatedEventID      in number,
                                
                          po_nPatPWEventID           out number,
                          po_nStatusCode           out number,
                          po_vStatusComment        out varchar2
                          )
is
    v_nPWEventTypeID number := 0;
    v_nPatPWEventID number := 0;
    v_nSortOrder number := 0;
    
    v_vSQL long :=

        'insert into tbicds.pat_pw_event( PATIENT_ID,
                                          STATUS,
                                          DATE_SCHEDULED,
                                          REGION_ID,
                                          SITE_ID,
                                          PAT_PW_ID,
                                          EVENT_TITLE,
                                          SORT_ORDER,
                                          EVENT_FREQUENCY,
                                          PW_EVENT_TYPE_ID,
                                          PAT_PW_EVENT_ID,
                                          MERGED
                                         )
          values(:PATEINT_ID,
                 :STATUS,
                 :DATE_SCHEDULED,
                 :REGION_ID,
                 :SITE_ID,
                 :PAT_PW_ID,
                 :EVENT_TITLE,
                 :SORT_ORDER,
                 :EVENT_FREQUENCY,
                 :PW_EVENT_TYPE_ID,
                 :PAT_PW_EVENT_ID,
                 :MERGED                 
                 )';
begin
  
    po_nStatusCode    := 0;
    po_vStatusComment := '';
    po_nPatPWEventID := 0;
    
    --get a new id
    select SEQPATPWEVENTID.nextval into v_nPatPWEventID from dual;
    
    --get event type
    select t.pw_event_type_id, 
           t.sort_order into 
           v_nPWEventTypeID, v_nSortOrder 
    from pat_pw_event t
    where t.pat_pw_event_id = pi_nRelatedEventID
    and t.patient_id = pi_vPatientID;
  
    --bump sort order for all records after related record
    update pat_pw_event tt
    set tt.sort_order = sort_order + 1
    where tt.patient_id = pi_vPatientID 
    and tt.pat_pw_event_id = pi_nRelatedEventID
    and tt.sort_order > v_nSortOrder;
    
    --execute the SQL
    execute immediate v_vSQL
    using pi_vPatientID,
          0,
          pi_dtEventDate,
          pi_nRegionID,
          pi_nSiteID,
          pi_nPatPWID,
          pi_vEventTitle,
          v_nSortOrder + 1,
          0,
          v_nPWEventTypeID,
          v_nPatPWEventID,
          0;  
           
    commit;

    --return the id
    po_nPatPWEventID := v_nPatPWEventID;
   

exception
    when others then
      rollback;
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;

/******
insert an event entry 
******/  
procedure InsertPWEventEntry (  pi_vSessionID             in varchar2,
                                pi_vSessionClientIP       in varchar2,
                                pi_nUserID                in number,
                                
                                pi_vPatientID             in varchar2,
                                pi_nPatPWEventID          in number,
                                pi_nPWEventModuleID       in number,
                                pi_nEventEntryTypeID      in number,
                                pi_dtEventDate            in date,
                                pi_vEventEntryComment     in varchar2,
                                pi_nEventStatusID         in number,
                                pi_nEventSeverityID       in number,
                                
                                po_nEventEntryID          out number,
                                
                                po_nStatusCode           out number,
                                po_vStatusComment        out varchar2
                             )
is

     v_vSQL long :=

        'insert into tbicds.pat_pw_event_entry(PAT_PW_EVENT_ENTRY_ID,
                                              PATIENT_ID,
                                              PAT_PW_ID,
                                              PAT_PW_EVENT_ID,
                                              EVENT_ENTRY_TYPE_ID,
                                              EVENT_COMMENT,
                                              FX_USER_ID,
                                              EVENT_DATE,
                                              EVENT_STATUS_ID,
                                              EVENT_SEVERITY_ID,
                                              PW_EVENT_MODULE_ID)
          values(:PAT_PW_EVENT_ENTRY_ID,
                 :PATIENT_ID,
                 :PAT_PW_ID,
                 :PAT_PW_EVENT_ID,
                 :EVENT_ENTRY_TYPE_ID,
                 :EVENT_COMMENT,
                 :FX_USER_ID,
                 :EVENT_DATE,
                 :EVENT_STATUS_ID,
                 :EVENT_SEVERITY_ID,
                 :PW_EVENT_MODULE_ID
                 )';
                 
     
      v_nEntryID number := 0;
      v_nPatPWID number := 0;
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
  
    po_nEventEntryID := 0;
    v_nEntryID := 0;
    
    --get a new id
    select seqpatpwentryid.nextval into v_nEntryID from dual;
    
    --get pat pw id
    select t.pat_pw_id into v_nPatPWID 
    from pat_pw_event t
    where t.pat_pw_event_id = pi_nPatPWEventID;
  
    --execute the SQL
    execute immediate v_vSQL 
    using v_nEntryID,
          pi_vPatientID,
          v_nPatPWID,
          pi_nPatPWEventID,
          pi_nEventEntryTypeID,
          pi_vEventEntryComment,
          pi_nUserID,
          pi_dtEventDate,
          pi_nEventStatusID,
          pi_nEventSeverityID,
          pi_nPWEventModuleID;
           
    commit;

    --return the id
    po_nEventEntryID := v_nEntryID;
   

exception
    when others then
      rollback;
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;


/******
update an event entry 
******/  
procedure UpdatePWEventEntry (  pi_vSessionID             in varchar2,
                                pi_vSessionClientIP       in varchar2,
                                pi_nUserID                in number,
                                
                                pi_nEventEntryID          in number,
                                pi_nPWEventModuleID       in number,
                                pi_dtEventDate            in date,
                                pi_vEventEntryComment     in varchar2,
                                pi_nEventStatusID         in number,
                                pi_nEventSeverityID       in number,
                             
                                po_nStatusCode           out number,
                                po_vStatusComment        out varchar2
                             )
is

     v_vSQL long :=

        'update tbicds.pat_pw_event_entry
         set event_comment = :EVENT_COMMENT,
         event_date = :EVENT_DATE,
         event_status_id = :EVENT_STATUS_ID,
         event_severity_ID = :EVENT_SEVERITY_ID
         where PAT_PW_EVENT_ENTRY_ID = :PAT_PW_EVENT_ENTRY_ID
         ';
     
      v_nEventEntryTypeID number := 0;
      v_nEventID number :=0;
     
 begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';  
  
    --get the type of entry
    select t.event_entry_type_id into v_nEventEntryTypeID
    from tbicds.pat_pw_event_entry t
    where t.pat_pw_event_entry_id = pi_nEventEntryID;
    
    --get the event id
    select t.pat_pw_event_id into v_nEventID
    from tbicds.pat_pw_event_entry t
    where t.pat_pw_event_entry_id = pi_nEventEntryID;    
 
    --execute the SQL
    execute immediate v_vSQL 
    using pi_vEventEntryComment,
          pi_dtEventDate,
          pi_nEventStatusID,
          pi_nEventSeverityID,
          pi_nEventEntryID;
           
    commit;
    
exception
    when others then
      rollback;
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;

/*
update the plan portion of the event
*/
procedure UpdatePWEventPlan (  pi_vSessionID             in varchar2,
                               pi_vSessionClientIP       in varchar2,
                               pi_nUserID                in number,
                               
                               pi_nPatPWEventID          in number,
                               pi_nPatPWPlanEventID      in number,
                               pi_vPlanText              in clob,
                               
                               po_nStatusCode           out number,
                               po_vStatusComment        out varchar2
                             )
is

     v_vSQL long :=

        'update tbicds.pat_pw_event
         set plan_text = :PLAN_TEXT,
         PLAN_PAT_PW_EVENT_ID = :PLAN_PAT_PW_EVENT_ID
         where PAT_PW_EVENT_ID = :PAT_PW_EVENT_ID
         ';
     
 begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';  
  
    --execute the SQL
    execute immediate v_vSQL 
    using pi_vPlanText,
          pi_nPatPWPlanEventID,
          pi_nPatPWEventID;
           
    commit;
    
exception
    when others then
      rollback;
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;

/***
delete an event entry
***/
procedure DeletePWEventEntry (  pi_vSessionID             in varchar2,
                                pi_vSessionClientIP       in varchar2,
                                pi_nUserID                in number,
                                
                                pi_nEventEntryID          in number,
                                po_nStatusCode           out number,
                                po_vStatusComment        out varchar2
                             )
is

     v_vSQL long :=

        'delete from tbicds.pat_pw_event_entry
         where PAT_PW_EVENT_ENTRY_ID = :PAT_PW_EVENT_ENTRY_ID
         ';
     
 begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';  
  
    --execute the SQL
    execute immediate v_vSQL 
    using pi_nEventEntryID;
           
    commit;
    
exception
    when others then
      rollback;
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;

/***
Gets the previous score value for a mid
***/
function GetPrevIntakeScore(pi_nMID in number,
                            pi_vPatientID in varchar2,
                            pi_nIntakeID in number)
  
 return number
 
 is
 
   v_nScore number := 0;
   
 begin
   
 if pi_nMID != 4042 then
   
   select score into v_nScore 
   from 
      (select s1.score   
         from data_intake_score s1,
              data_intake s2
        where s2.patient_id = s1.patient_id
          and s2.intake_id = s1.intake_id
          and s2.mid = s2.mid
            
          and s1.mid = pi_nMID
          and s1.patient_id = pi_vPatientID 
          and s1.series = 0 
            
          and s2.complete_date < 
                     
          (select complete_date   
            from data_intake
           where patient_id = pi_vPatientID
             and intake_id = pi_nIntakeID
             and mid = pi_nMID 
             and rownum = 1 ) 
      order by s2.complete_date desc
      )where rownum = 1; 

else
  
 select score into v_nScore 
   from 
      (select s1.score   
         from data_intake_score s1,
              data_intake s2
        where s2.patient_id = s1.patient_id
          and s2.intake_id = s1.intake_id
          and s2.mid = s2.mid
            
          and s1.mid = pi_nMID
          and s1.patient_id = pi_vPatientID 
          and s1.series = 0 
          
            and ((select rid 
              from data_intake_responses 
             where intake_id = s1.intake_id 
               and tid=1 
               and qid=1 ) != 21)
            
          and s2.complete_date < 
                     
          (select complete_date   
            from data_intake
           where patient_id = pi_vPatientID
             and intake_id = pi_nIntakeID
             and mid = pi_nMID 
             and rownum = 1 ) 
      order by s2.complete_date desc
      )where rownum = 1; 

  end if;

    
    return v_nScore;

exception
    when others then
    return null;  
end;

 /***
 Gets the previous score value for the subscale of a mid
 ***/
 function GetPrevIntakeSubscaleScore(pi_nMID in number,
                                     pi_vPatientID in varchar2,
                                     pi_nIntakeID in number,
                                     pi_nSeries in number)
  
 return number
 
 is
 
   v_nScore number := 0;
   
 begin
   
 if pi_nMID != 4042 then
   
   select s.score into v_nScore
    from data_intake_score s
   where s.patient_id = pi_vPatientID
     and s.mid = pi_nMID
     and s.series = pi_nSeries
     and s.intake_id =
          (select t.intake_id
             from
               (select l.intake_id
                  from data_intake l
                 where l.mid = pi_nMID
                   and l.patient_id = pi_vPatientID 
                   and l.complete_date <              
                         (select complete_date   
                           from data_intake
                          where patient_id = pi_vPatientID
                            and intake_id = pi_nIntakeID
                            and mid = pi_nMID 
                            and rownum = 1) 
                 order by l.complete_date desc) t
           where rownum = 1);
 else
   
 select s.score into v_nScore
    from data_intake_score s
   where s.patient_id = pi_vPatientID
     and s.mid = pi_nMID
     and s.series = pi_nSeries
     and s.intake_id =
          (select t.intake_id
             from
               (select l.intake_id
                  from data_intake l
                 where l.mid = pi_nMID
                   and l.patient_id = pi_vPatientID 
                   
                   and ((select rid 
                  from data_intake_responses 
                 where intake_id = l.intake_id 
                   and tid=1 
                   and qid=1 ) != 21)
               
                   and l.complete_date <              
                         (select complete_date   
                           from data_intake
                          where patient_id = pi_vPatientID
                            and intake_id = pi_nIntakeID
                            and mid = pi_nMID 
                            and rownum = 1) 
                 order by l.complete_date desc) t
           where rownum = 1);
 
 end if;
    
    return v_nScore;

exception
    when others then
    return null;  
end;

/***
 Gets the next event id after an event
***/
function GetNextPatPWEventID(pi_nPatPWEventID in number,
                             pi_vPatientID in varchar2)
  
 return number
 
 is
 
   v_nPatPWID number := 0;
   v_nPatPWEventID number := 0;
   
 begin
   
   --get the patient pathway id
   select pat_pw_id into v_nPatPWID
     from pat_pw_event
    where pat_pw_event_id = pi_nPatPWEventID 
      and patient_id = pi_vPatientID;
   
   --get the next event id after this event id
   --exclude closed events
   select pat_pw_event_id into v_nPatPWEventID 
   from 
      (select t.pat_pw_event_id   
         from pat_pw_event t
        where t.patient_id = pi_vPatientID
          and t.pat_pw_id = v_nPatPWID
          and nvl(t.status,0) != 2  
          and t.date_scheduled > (select date_scheduled 
                                     from pat_pw_event 
                                    where pat_pw_id = v_nPatPWID
                                      and patient_id = pi_vPatientID 
                                      and pat_pw_event_id = pi_nPatPWEventID )
      order by t.date_scheduled asc
      )where rownum = 1; 

    
    return v_nPatPWEventID;

exception
    when others then
    return null;  
end;

/*****
Gets next pathway event associated with a patient
******/
procedure GetNextPatPWEventRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vPatientID             in varchar2,
      pi_nPatPWEventID          in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is

     v_vSQL varchar2(1500) :=
       
        'SELECT t.PATIENT_ID,	
                t.STATUS,
                t.DATE_SCHEDULED,
                t.DATE_STARTED,
                t.DATE_COMPLETED,
                t.REGION_ID,
                t.SITE_ID,
                t.PAT_PW_ID,
                t.event_title,
                t.EVENT_DESCR,
                t.SORT_ORDER,
                t.EVENT_FREQUENCY,
                t.PW_EVENT_TYPE_ID,
                t.PAT_PW_EVENT_ID

       FROM tbicds.PAT_PW_EVENT t
       WHERE t.patient_id = :PATIENT_ID 
         and t.pat_pw_event_id = :PAT_PW_EVENT_ID 
         ORDER BY t.DATE_SCHEDULED ASC';
         
    v_nNextEventID number := 0;
       
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    v_nNextEventID := PCK_PWEVENT.GetNextPatPWEventID(pi_nPatPWEventID,
                                                      pi_vPatientID);
    
    --open the result set
     open rs 
      for v_vSQL
    using pi_vPatientID,
          v_nNextEventID;
    
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;


end PCK_PWEVENT;
/
------------------------------------------------
--  Changed package body pck_referral_clinic  --
------------------------------------------------
create or replace package body tbicds.PCK_REFERRAL_CLINIC is
/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
   /*
   get referral clinic recordset
   */
   procedure GetReferralClinicRS(pi_vSessionID       in varchar2,
                                pi_vSessionClientIP in varchar2,
                                pi_nUserID          in number,
                                pi_nStatReferralID  in number,
                                po_nStatusCode      out number,
                                po_vStatusComment   out varchar2,
                                rs                  out RetRefCursor)
   is
      v_vSql                               varchar2(4000);
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      --open recordset
      v_vSql := 'select * from tbicds.stat_referral where stat_referral_id = :P0 ';
      open rs for v_vSql using pi_nStatReferralID;
      
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_REFERRAL_CLINIC.GetReferralClinicRS(): ' || sqlErrm;
   end;

   /*
   Get referral clinic lookup recordset
   */
   procedure GetReferralClinicLookUpRS(pi_vSessionID       in varchar2,
                                      pi_vSessionClientIP in varchar2,
                                      pi_nUserID          in number,
                                      po_nStatusCode      out number,
                                      po_vStatusComment   out varchar2,
                                      rs                  out RetRefCursor) 
   is
      strSQL varchar2(4000);
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      --open recordset
      strSQL := 'select t.* from tbicds.stat_referral t where t.active = 1';
      open rs for strSQL;
   
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_REFERRAL_CLINIC.GetReferralClinicLookUpRS(): ' || sqlErrm;
   end;

   /*
   Insert a referral clinic
   */
   procedure InsertReferralClinic(pi_vSessionID       in varchar2,
                                 pi_vSessionClientIP in varchar2,
                                 pi_nUserID          in number,
                                 pi_vReferralDesc    in varchar2,
                                 pi_vReferralText    in varchar2,
                                 pi_vProviderName in varchar2,
                                 pi_vAddress      in varchar2,
                                 pi_vCity         in varchar2,
                                 pi_nStateID      in number,
                                 pi_vPostalCode   in varchar2,
                                 pi_vPhone        in varchar2,
                                 pi_vFax          in varchar2,
                                 po_nReferralID    out number,
                                 po_nStatusCode    out number,
                                 po_vStatusComment out varchar2)
   is
      v_vSql                               varchar2(4000);
      v_nReferralID number;
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      po_nReferralID    := -1;
   
      --get a new encounter_intake_id
      v_vSql := 'select tbicds.SEQREFERRALID.Nextval from dual';
      execute immediate v_vSql into v_nReferralID;
      
      v_vSql := 'insert into tbicds.stat_referral ('
                || 'stat_referral_id, stat_referral_desc, stat_referral_text, provider_name, street_address, '
                || 'city, state, postal_code, phone, fax) '
                || 'values ('
                || ':P0, :P1, :P2, :P3, :P4, :P5, :P6, :P7, :P8, :P9) ';
      execute immediate v_vSql using 
         v_nReferralID, pi_vReferralDesc, pi_vReferralText, pi_vProviderName, pi_vAddress,
         pi_vCity, pi_nStateID, pi_vPostalCode, pi_vPhone, pi_vFax;
      commit;
      
      po_nReferralID := v_nReferralID;
   
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_REFERRAL_CLINIC.InsertReferralClinic(): ' || sqlErrm;
   end;

   /*
   Update a referral clinic
   */
   procedure UpdateReferralClinic(pi_vSessionID       in varchar2,
                                 pi_vSessionClientIP in varchar2,
                                 pi_nUserID          in number,
                                 pi_nReferralID      in number,
                                 pi_vReferralDesc    in varchar2,
                                 pi_vReferralText    in varchar2,
                                 pi_vProviderName in varchar2,
                                 pi_vAddress      in varchar2,
                                 pi_vCity         in varchar2,
                                 pi_nStateID      in number,
                                 pi_vPostalCode   in varchar2,
                                 pi_vPhone        in varchar2,
                                 pi_vFax          in varchar2,
                                 po_nStatusCode    out number,
                                 po_vStatusComment out varchar2)
   is
      v_vSql                               varchar2(4000);
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      v_vSql := 'update tbicds.stat_referral set '
                || 'stat_referral_desc = :P0, '
                || 'stat_referral_text = :P1, '
                || 'provider_name = :P2, '
                || 'street_address = :P3, '
                || 'city = :P4, '
                || 'state = :P5, '
                || 'postal_code = :P6, '
                || 'phone = :P7, '
                || 'fax = :P8 '
                || 'where stat_referral_id = :P9 ';
      execute immediate v_vSql using
         pi_vReferralDesc, pi_vReferralText, pi_vProviderName, pi_vAddress, pi_vCity,
         pi_nStateID, pi_vPostalCode, pi_vPhone, pi_vFax, pi_nReferralID;
      commit;
   
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_REFERRAL_CLINIC.UpdateReferralClinic(): ' || sqlErrm;
   end;

   /*
   Discontinue a referral clinic
   */
   procedure DiscontinueReferralClinic(pi_vSessionID       in varchar2,
                                      pi_vSessionClientIP in varchar2,
                                      pi_nUserID          in number,
                                      pi_nReferralID      in number,
                                      po_nStatusCode      out number,
                                      po_vStatusComment   out varchar2)
   is
      v_vSql                               varchar2(4000);
   begin
      po_nStatusCode    := PCK_COMMON.c_nResultStatus_Success;
      po_vStatusComment := '';
      
      v_vSql := 'update tbicds.stat_referral set active = 0 where stat_referral_id = :P0 ';
      execute immediate v_vSql using pi_nReferralID;
      commit;
      
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_REFERRAL_CLINIC.DiscontinueReferralClinic(): ' || sqlErrm;
   end;

end;
/
--------------------------------------------
--  Changed package body pck_region_site  --
--------------------------------------------
CREATE OR REPLACE PACKAGE BODY tbicds.PCK_REGION_SITE is
/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
/*****
Description: Gets regions
******/
procedure GetRegionRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out refCursor
      )
is

     v_vSQL varchar2(500) :=
      'SELECT t.*
       FROM utl_region t
       order by upper(t.region_name) asc';
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
    open rs for v_vSQL;
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;

/*****
Description: Gets region sites
******/
procedure GetSiteRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_nRegionID              in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out refCursor
      )
is

     v_vSQL varchar2(500) :=
      'SELECT t.*
       FROM utl_site t
       WHERE t.region_id = :region_id
       order by upper(t.site_name) asc';
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
    open rs for v_vSQL using pi_nregionid;
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
 
end;

/*****
Description: gets the site and region matching the server 
and port passed in used when accessing the site from the CPRS tools menu
******/
procedure GetSiteRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vSRV                   in varchar2,
      pi_vPORT                  in varchar2,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out refCursor
      )
is

     v_vSQL varchar2(500) :=
      'SELECT t.*, t2.region_name 
       FROM utl_site t, utl_region t2 
       WHERE lower(t.srv) = lower(:SRV)
       and lower(t.port) = lower(:PORT)
       and t.region_id = t2.region_id
       order by upper(t.site_name) asc';
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
    open rs for v_vSQL using pi_vSRV, pi_vPORT;
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
 
end;

/*gets all sites*/
procedure GetSiteRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out refCursor
      )
is

     v_vSQL varchar2(500) :=
      'SELECT t.*, t2.region_name 
       FROM utl_site t, utl_region t2 
       WHERE t.region_id = t2.region_id
       order by upper(t.site_name) asc';
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
    open rs for v_vSQL;
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
 
end;

END;
/
----------------------------------------
--  Changed package body pck_reports  --
----------------------------------------
create or replace package body tbicds.PCK_REPORTS is
/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
/*gets the admission intake id, 
only include intakes that have been reviewed*/
function GetAdmissionIntakeID(pi_nMID in number,
                              pi_vPatientID in varchar2,
                              pi_dtStart in date,
                              pi_dtEnd in date)
  
 return number
 
 is
 
   v_nID number := null;
   
 begin
   
   --mid is not FIM, FIM is handled slightly different
   if pi_nMID != 4042 then 
     
     select intake_id into v_nID 
     from 
          (select di.intake_id 
             from data_intake di
            where di.patient_id = pi_vPatientID 
              and mid = pi_nMID 
              and trunc(di.complete_date) >= pi_dtStart
              and trunc(di.complete_date) <= pi_dtEnd
              
              --intake must be reviewed
              and di.intake_id in (select intake_id 
                                   from pat_pw_event_module em 
                                   where em.patient_id = pi_vPatientID 
                                     and em.pw_event_module_id 
                                     in (select pw_event_module_id 
                                          from pat_pw_event_entry)
                                        )
              
         order by di.complete_date asc
           )
     where rownum = 1; 
   
   else
     
      --FIM MID 4042 intake cannot be FIM goal 
      select intake_id into v_nID 
       from 
            (select di.intake_id 
               from data_intake di
              where di.patient_id = pi_vPatientID 
                and mid = pi_nMID 
                and trunc(di.complete_date) >= pi_dtStart
                and trunc(di.complete_date) <= pi_dtEnd
                
                --intake must be reviewed
                and di.intake_id in (select intake_id 
                                     from pat_pw_event_module em 
                                     where em.patient_id = pi_vPatientID 
                                       and em.pw_event_module_id 
                                       in (select pw_event_module_id 
                                            from pat_pw_event_entry)
                                          )
                
                --FIM MID 4042 intake cannot be FIM goal rid 21
                and ((select rid 
                        from data_intake_responses
                       where intake_id = di.intake_id
                         and tid=1
                         and qid=1) != 21)                     
                
           order by di.complete_date asc
             )
       where rownum = 1; 
    
    end if;
    
    return v_nID;

exception
    when others then
    return null;  
end;

/*gets the value of the most recently answerd impairment q 
within the date range*/                   
function GetImpairmentRID(pi_vPatientID in varchar2,
                          pi_dtEnd in date)
  
 return number
 
 is
 
   v_nID number := null;
   
 begin
   
   select rid into v_nID
    from 
        ( select dir.rid 
           from data_intake_responses_audit dir 
           where dir.mid = 3000 
           and dir.tid=1
           and dir.qid=1
           and dir.patient_id = pi_vPatientID    
           and trunc(dir.complete_date) <= trunc(pi_dtEnd)
           order by dir.complete_date desc
         )
    where rownum=1;

    
    return v_nID;

exception
    when others then
    return null;  
end;

/*gets the value of the most recently answerd injury q 
within the date range*/
function GetInjuryRID(pi_vPatientID in varchar2,
                          pi_dtEnd in date)
  
 return number
 
 is
 
   v_nID number := null;
   
 begin
   
   select rid into v_nID
    from 
        ( select dir.rid 
           from data_intake_responses_audit dir 
           where dir.mid = 3000
           and dir.tid=1
           and dir.qid=4
           and dir.patient_id = pi_vPatientID    
           and trunc(dir.complete_date) <= trunc(pi_dtEnd)
           order by dir.complete_date desc
         )
    where rownum=1;
    
    return v_nID;

exception
    when others then
    return null;  
end;
                       

/*gets the discharge intake id,
only include intakes that have been reviewed*/
function GetDischargeIntakeID(pi_nMID in number,
                              pi_vPatientID in varchar2,
                              pi_dtStart in date,
                              pi_dtEnd in date)
  
 return number
 
 is
 
   v_nID number := null;
   
 begin
   
  --mid is not FIM, FIM is handled slightly different
   if pi_nMID != 4042 then 
  
     select intake_id into v_nID 
     from 
          (select di.intake_id 
             from data_intake di
            where di.patient_id = pi_vPatientID 
              and mid = pi_nMID 
              and trunc(di.complete_date) >= pi_dtStart
              and trunc(di.complete_date) <= pi_dtEnd
              
              --intake must be reviewed
              and di.intake_id in (select intake_id 
                                   from pat_pw_event_module em 
                                   where em.patient_id = pi_vPatientID 
                                     and em.pw_event_module_id 
                                     in (select pw_event_module_id 
                                          from pat_pw_event_entry)
                                        )
                                        
              and (select count(*) 
                   from data_intake di
                  where di.patient_id = pi_vPatientID 
                    and mid = pi_nMID 
                    and trunc(di.complete_date) >= pi_dtStart
                    and trunc(di.complete_date) <= pi_dtEnd 
                    
                    and di.intake_id in (select intake_id 
                                   from pat_pw_event_module em 
                                   where em.patient_id = pi_vPatientID 
                                     and em.pw_event_module_id 
                                     in (select pw_event_module_id 
                                          from pat_pw_event_entry)
                                        )
                    
                    ) > 1
               
         order by di.complete_date desc
           )
     where rownum = 1; 
     
    else
      
      select intake_id into v_nID 
     from 
          (select di.intake_id 
             from data_intake di
            where di.patient_id = pi_vPatientID 
              and mid = pi_nMID 
              and trunc(di.complete_date) >= pi_dtStart
              and trunc(di.complete_date) <= pi_dtEnd
              
              --intake must be reviewed
              and di.intake_id in (select intake_id 
                                   from pat_pw_event_module em 
                                   where em.patient_id = pi_vPatientID 
                                     and em.pw_event_module_id 
                                     in (select pw_event_module_id 
                                          from pat_pw_event_entry)
                                        )
                                        
              --FIM MID 4042 intake cannot be FIM goal rid 21
              and ((select rid 
                        from data_intake_responses
                       where intake_id = di.intake_id
                         and tid=1
                         and qid=1) != 21)   
              
              and (select count(*) 
                   from data_intake di
                  where di.patient_id = pi_vPatientID 
                    and mid = pi_nMID 
                    and trunc(di.complete_date) >= pi_dtStart
                    and trunc(di.complete_date) <= pi_dtEnd 
                    
                    and di.intake_id in (select intake_id 
                                   from pat_pw_event_module em 
                                   where em.patient_id = pi_vPatientID 
                                     and em.pw_event_module_id 
                                     in (select pw_event_module_id 
                                          from pat_pw_event_entry)
                                        )
                    
                    ) > 1
               
         order by di.complete_date desc
           )
     where rownum = 1; 
    
      
    end if;
    
    return v_nID;

exception
    when others then
    return null;  
end;

/*get the followup instrument id,
only include intakes that have been reviewed*/
function GetFollowupIntakeID(pi_nMID in number,
                             pi_vPatientID in varchar2,
                             pi_nDischargeID in number)
  
 return number
 
 is
 
   v_nID number := null;
   v_dtDischarge date := null;
   
 begin
   
   --get the discharge date
   select trunc(d.complete_date) into v_dtDischarge
   from data_intake d  
   where d.patient_id = pi_vPatientID
   and d.intake_id = pi_nDischargeID;
   
   --mid is not FIM, FIM is handled slightly different
   if pi_nMID != 4042 then 
  
     --get the first intake_id after the discharge date
     --call that followup
     select intake_id into v_nID 
     from 
          (select di.intake_id 
             from data_intake di
            where di.patient_id = pi_vPatientID 
              and mid = pi_nMID 
              and trunc(di.complete_date) > v_dtDischarge
              
              --FIM MID 4042 intake cannot be FIM goal rid 21
              and ((select rid 
                        from data_intake_responses
                       where intake_id = di.intake_id
                         and tid=1
                         and qid=1) != 21)  
                         
              --intake must be reviewed
              and di.intake_id in (select intake_id 
                                   from pat_pw_event_module em 
                                   where em.patient_id = pi_vPatientID 
                                     and em.pw_event_module_id 
                                     in (select pw_event_module_id 
                                          from pat_pw_event_entry)
                                        )
                                        
         order by di.complete_date asc
           )
     where rownum = 1; 
  
   else
     
     --get the first intake_id after the discharge date
     --call that followup
     select intake_id into v_nID 
     from 
          (select di.intake_id 
             from data_intake di
            where di.patient_id = pi_vPatientID 
              and mid = pi_nMID 
              and trunc(di.complete_date) > v_dtDischarge
              
              --intake cannot be FIM goal
              --FIM MID 4042 intake cannot be FIM goal rid 21
              and ((select rid 
                        from data_intake_responses
                       where intake_id = di.intake_id
                         and tid=1
                         and qid=1) != 21)  
                         
              --intake must be reviewed
              and di.intake_id in (select intake_id 
                                   from pat_pw_event_module em 
                                   where em.patient_id = pi_vPatientID 
                                     and em.pw_event_module_id 
                                     in (select pw_event_module_id 
                                          from pat_pw_event_entry)
                                        )
                                        
         order by di.complete_date asc
           )
     where rownum = 1; 
  
      
   end if;
    
   return v_nID;

exception
    when others then
    return null;  
end;

/*loads a temp table with population matching criteria*/
procedure LoadPopulation (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      
      pi_dtFrom                 in date,      
      pi_dtTo                   in date,
      pi_nClinicalSetting       in number,
     
      pi_nRegionID              in number,
      pi_nSiteID                in number,
      pi_nCPAID                 in number,
      
      pi_nImpairmentID          in number,
      pi_nInjuryID              in number,
      pi_nGender                in number,
      pi_nMilStatusID           in number,
      
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2
      )
is

     v_vSQL varchar2(4000) :=
      'insert into report_population(fx_user_id,
                                     patient_id,
                                     initial_date,
                                     end_date)
       select :UserID as fx_user_id,
              t.patient_id,
              t2.initial_date,
              t2.end_date
       from patient_demographics t,
            pat_treatment_program t2
       where t2.patient_id = t.patient_id
       
       and t2.end_date is not null
       and (      trunc(t2.end_date) >= trunc(:DTFROM)
              and trunc(t2.end_date) <= trunc(:DTEND)
            ) 
             
       ';
        
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --delete current cached records for this user
    delete 
    from report_population t 
    where t.fx_user_id = pi_nUserID;
    commit;
    
    --execute the SQL
    EXECUTE IMMEDIATE v_vSQL
    USING pi_nUserID,
          pi_dtFrom,
          pi_dtTo;
         
    
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;

/*get aggregate report given the module group id and mid
population:

pi_dtFrom, pi_dtTo - patients that 
have a pat_treatment initial_date and end_date
within this range (todo: need to look 
at pat_treatmet_programs?)

pi_nClinicalSetting - 1=outpatient, 2=inpatient
patients that have a pat_treatment, treatment_type_id 
matching the clinical setting passed in

region, site, cpa - pat_treatment_program

impairment - data_intake_responses mid 3000 qid 1

injury - data_intake_responses mid 3000 qid 4

gender - patient_demographics

duty status - patient_demographice

*/
procedure GetAggReportRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      
      pi_nModuleGroupID         in number,
      pi_nMID                   in number,
      
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is

     v_vSQL varchar2(4000) :=
      'select distinct MID,
                       SERIES,
                       DESCRIPTION,
                       null as ADMISSION,
                       null as DISCHARGE,
                       null as CHANGE1,
                       null as FOLLOWUP,
                       null as CHANGE2
                        
         from DATA_INTAKE_SCORE t
        where t.mid = :MID
         order by t.mid, t.series';
        
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
    open rs 
      for v_vSQL
    using pi_nMID;
    commit;

    --clear any old data in the population module table
    --from this module
    delete from report_population_module t 
    where t.mid = pi_nMID
    and t.fx_user_id = pi_nUserID;
    commit;
    
    --create records for the mid
    insert into report_population_module(patient_id,
                                         fx_user_id,
                                         initial_date,
                                         end_date,
                                         mid,
                                         admission_intake_id,
                                         discharge_intake_id,
                                         followup_intake_id,
                                         los) 
    select patient_id,
           fx_user_id,
           initial_date,
           end_date,
           pi_nMID,
           null,
           null,
           null,
           null                  
    from report_population pp
    where pp.fx_user_id = pi_nUserID;
    
    commit;   

 --update report_population t 
    --  set t.mid = pi_nMID
    --where t.fx_user_id = pi_nUserID;
    --commit;
    
    --set the admission intake id
    update report_population_module ta
    set ta.admission_intake_id = GetAdmissionIntakeID(ta.mid,
                                                      ta.patient_id,
                                                      ta.initial_date,
                                                      ta.end_date)
         
    where ta.fx_user_id = pi_nUserID
      and ta.mid = pi_nMID;
    commit;                                                     
                      
    --set the discharge intake id
    update report_population_module td 
       set  td.discharge_intake_id = GetDischargeIntakeID(td.mid,
                                                          td.patient_id,
                                                          td.initial_date,
                                                          td.end_date)                                            
                                                     
                                                     
    where td.fx_user_id = pi_nUserID
    and td.mid = pi_nMID;
    commit;                           
        
    
    --set the followup intake id
    update report_population_module tf 
       set  tf.followup_intake_id = GetFollowupIntakeID(tf.mid,
                                                        tf.patient_id,
                                                        tf.discharge_intake_id)                                            
                                                     
                                                     
    where tf.fx_user_id = pi_nUserID
    and tf.mid = pi_nMID;
    commit;   
                               
            
    --now loop and do something to report_population
    --FOR rec IN (SELECT *
    --              FROM report_population t
    --             where t.fx_user_id = pi_nUserID) 
    --LOOP
    --
    --         null;
    --
    --
    --END LOOP;
    

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;


/*get rs of injuries*/
procedure GetInjuryRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is

     v_vSQL varchar2(4000) :=
      'select * from intake_response 
       where mid = 3000 and tid=1 and qid=4 
       order by mid,tid,qid,rid';
        
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
    open rs 
      for v_vSQL;
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;

/*get rs of impairments*/
procedure GetImpairmentRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is

     v_vSQL varchar2(4000) :=
      'select * from intake_response 
       where mid = 3000 and tid=1 and qid=1 
       order by mid,tid,qid,rid';
        
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
    open rs 
      for v_vSQL;
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;



end PCK_REPORTS;
/
--------------------------------------------
--  Changed package body pck_reports_pat  --
--------------------------------------------
create or replace package body tbicds.PCK_REPORTS_PAT is
/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
/*Get previous intake score*/
function GetPrevIntakeScore(pi_nMID in number,
                            pi_vPatientID in varchar2,
                            pi_nIntakeID in number)
  
 return number
 
 is
 
   v_nScore number := 0;
   
 begin
   
   select score into v_nScore 
   from 
      (select s1.score   
         from data_intake_score s1,
              data_intake s2
        where s2.patient_id = s1.patient_id
          and s2.intake_id = s1.intake_id
          and s2.mid = s2.mid
            
          and s1.mid = pi_nMID
          and s1.patient_id = pi_vPatientID 
          and s1.series = 0 
          
          and s2.intake_id in (select intake_id 
                               from pat_pw_event_module aa,
                               pat_pw_event aaa
                               where aa.pat_pw_event_id = aaa.pat_pw_event_id
                               and aaa.status = 2
                               and ((select count(*)  
                                      from data_intake_responses
                                     where intake_id = aa.intake_id
                                       and mid = 4042 
                                       and tid=1
                                       and qid=1
                                       and rid=21) = 0) 
                               ) 
     
            
          and s2.complete_date < 
                     
          (select complete_date   
            from data_intake
           where patient_id = pi_vPatientID
             and intake_id = pi_nIntakeID
             and mid = pi_nMID 
             and rownum = 1 ) 
      order by s2.complete_date desc
      )where rownum = 1; 

    
    return v_nScore;

exception
    when others then
    return null;  
end;

/*Get current intake score*/
function GetCurrentIntakeScore(pi_vPatientID in varchar2,
                               pi_nMID in number)
  
 return number
 
 is
 
   v_nScore number := 0;
   
 begin
   
   select score into v_nScore 
   from 
       ( select score from (
        select tds.mid, di.complete_date, tds.score   
         from data_intake_score tds,
              data_intake di
        where tds.patient_id = pi_vPatientID
          and tds.mid = pi_nMID
          and tds.intake_id = di.intake_id
          and tds.series = 0 
          and di.intake_id in (select intake_id 
                               from pat_pw_event_module aa,
                               pat_pw_event aaa
                               where aa.pat_pw_event_id = aaa.pat_pw_event_id
                               and aaa.status = 2
                               
                               and ((select count(*)  
                                      from data_intake_responses
                                     where intake_id = aa.intake_id
                                       and mid = 4042 
                                       and tid=1
                                       and qid=1
                                       and rid=21) = 0) 
                               ) 
                               
        order by di.complete_date desc ))
        where rownum = 1;

    
    return v_nScore;

exception
    when others then
    return null;  
end;

/*Get note dates RS*/
procedure GetNoteDatesRS( pi_vSessionID       in varchar2,
                          pi_vSessionClientIP in varchar2,
                          pi_nUserID          in number,
                          pi_vPatientID       in varchar2,
                          pi_dtFrom           in date,
                          pi_dtTo             in date,
                          po_nStatusCode      out number,
                          po_vStatusComment   out varchar2,
                          rs                  out RetRefCursor) 
is

strSQL       varchar2(4000) := '';

begin  
  

strSQL := 'select t.patient_id, 
                  t.pat_pw_event_id, 
                  t.tiu_date_submitted 
             from pat_pw_event t 
            where t.patient_id = :PATIENT_ID
              and t.status = 2 
              and (trunc(t.tiu_date_submitted) >= :FROM_DATE 
                   AND trunc(t.tiu_date_submitted) <= :TO_DATE)
         order by t.tiu_date_submitted desc';
  
    open rs 
    for strSQL
    using pi_vPatientID,
          pi_dtFrom,
          pi_dtTo;
    
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'Error retrieving notes';
  end;

/*Get note teext RS*/
procedure GetNoteTextRS( pi_vSessionID       in varchar2,
                          pi_vSessionClientIP in varchar2,
                          pi_nUserID          in number,
                          pi_vPatientID       in varchar2,
                          pi_nPatPWEventID    in number,
                          pi_dtFrom           in date,
                          pi_dtTo             in date,
                          po_nStatusCode      out number,
                          po_vStatusComment   out varchar2,
                          rs                  out RetRefCursor) 
is

strSQL       varchar2(4000) := '';

begin  
  

strSQL := 'select t.note_text 
             from pat_pw_event t
            where t.patient_id = :PATIENT_ID
              and t.pat_pw_event_id = :PAT_PW_EVENT_ID 
              and t.status = 2 
              and (trunc(t.tiu_date_submitted) >= :FROM_DATE 
                   AND trunc(t.tiu_date_submitted) <= :TO_DATE)';
  
    open rs 
    for strSQL
    using pi_vPatientID,
          pi_nPatPWEventID,
          pi_dtFrom,
          pi_dtTo;
    
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'Error retrieving notes';
  end;

/*Get instrument score recordset*/
procedure GetInstrumentScoreRS( pi_vSessionID       in varchar2,
                                pi_vSessionClientIP in varchar2,
                                pi_nUserID          in number,
                                pi_vPatientID       in varchar2,
                                pi_nMID             in number,
                                pi_dtFrom           in date,
                                pi_dtTo             in date,
                                po_nStatusCode      out number,
                                po_vStatusComment   out varchar2,
                                rs                  out RetRefCursor) 
is

--strSQL       varchar2(4000) := '';

begin  
  

/*strSQL := 'select t.patient_id, t.complete_date, 
          t.intake_id, t.mid, t3.module, t3.acronym, t2.score, 
          t2.interpretation 
  from data_intake t, data_intake_score t2, intake_module t3 
 where t.intake_id = t2.intake_id
   and t.mid = t3.mid 
   and t2.mid = t3.mid
   and t2.series = 0
   
   and t.intake_id in (select intake_id 
                         from pat_pw_event_module aa,
                              pat_pw_event aaa
                        where aa.pat_pw_event_id = aaa.pat_pw_event_id
                          and aaa.status = 2) 
       
   and t.intake_id in (select intake_id 
                       from data_intake_score 
                       where series=0)
   and t.mid = :MID
   and t.patient_id = :PATIENT_ID
   and (trunc(t.complete_date) >= :FROM_DATE 
              AND trunc(t.complete_date) <= :TO_DATE)
   order by t.complete_date desc';
  
    open rs 
    for strSQL
    using pi_nMID,
          pi_vPatientID,
          pi_dtFrom,
          pi_dtTo;
    */
   
    
 
 if pi_nMID != 4042 then 
   
   open rs for
    
    select t.patient_id, 
           t.intake_id, 
           t.mid, 
           t3.module,
           t3.acronym,
           t2.score, 
           t2.interpretation,
           evm.date_completed as complete_date,
           appu.name,
         
         --if mid = 4042 and rid=21 then this is a goal           
         (select count(*)  
            from data_intake_responses
           where intake_id = t.intake_id
             and mid = 4042 
             and tid=1
             and qid=1
             and rid=21) as is_goal
           
      from data_intake t, 
           data_intake_score t2, 
           intake_module t3,
           pat_pw_event_module evm,
           pat_pw_event ev, 
           fx_user fxu,
           app_user appu
           
     where t.intake_id = t2.intake_id
       and t.mid = t3.mid 
       and t2.mid = t3.mid
       and t2.series = 0 --SCORE
       and t.intake_id = evm.intake_id
       and evm.pat_pw_event_id = ev.pat_pw_event_id
       and ev.status = 2 --EVENT CLOSED
       and fxu.site_id = evm.site_id
       and fxu.fx_user_id = evm.completed_by
       and appu.fx_user_id = fxu.fx_user_id
       and t.mid = pi_nMID
       and t.patient_id = pi_vPatientID
       and (trunc(t.complete_date) >= pi_dtFrom 
                  AND trunc(t.complete_date) <= pi_dtTo)
       order by t.complete_date desc;
  
 else
   
   --EXCLUDE FIM GOAL from MID 4042
   open rs for
    select t.patient_id, 
           t.intake_id, 
           t.mid, 
           t3.module,
           t3.acronym,
           t2.score, 
           t2.interpretation,
           evm.date_completed as complete_date,
           appu.name,
       
       --if mid 4042 and rid=21 then this is a goal             
       (select count(*)  
          from data_intake_responses
         where intake_id = t.intake_id
           and mid = 4042 
           and tid=1
           and qid=1
           and rid=21) as is_goal
           
      from data_intake t, 
           data_intake_score t2, 
           intake_module t3,
           pat_pw_event_module evm,
           pat_pw_event ev, 
           fx_user fxu,
           app_user appu
           
     where t.intake_id = t2.intake_id
       and t.mid = t3.mid 
       and t2.mid = t3.mid
       and t2.series = 0 --SCORE
       and t.intake_id = evm.intake_id
       and evm.pat_pw_event_id = ev.pat_pw_event_id
       and ev.status = 2 --EVENT CLOSED
       and fxu.site_id = evm.site_id
       and fxu.fx_user_id = evm.completed_by
       and appu.fx_user_id = fxu.fx_user_id
       and t.mid = pi_nMID
       and t.patient_id = pi_vPatientID
       and (trunc(t.complete_date) >= pi_dtFrom 
                  AND trunc(t.complete_date) <= pi_dtTo)
       
       --exclude mid 4042 rid 21           
       and ( (select count(*)   
                from data_intake_responses 
               where intake_id = t.intake_id 
                 and mid=4042 
                 and tid=1 
                 and qid=1
                 and rid=21 ) < 1)
               
       order by t.complete_date desc;
  
  end if;
                 
    
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'Error retrieving scored instruments';
  end;
 
 /*Get trend base recordset*/  
 procedure GetTrendBaseRS( pi_vSessionID       in varchar2,
                           pi_vSessionClientIP in varchar2,
                           pi_nUserID          in number,
                           pi_vPatientID       in varchar2,
                           po_nStatusCode      out number,
                           po_vStatusComment   out varchar2,
                           rs                  out RetRefCursor) 
is

strSQL       long := '';

begin  

strSQL := ' select t.patient_id, 
       t.pat_pw_id, 
       t.pat_pw_event_id, 
       t.pw_event_module_id, 
       t.mid,
       t.intake_id,
       t.date_completed,
       t2.module,
       
       (select count(*)  
            from data_intake_responses
           where intake_id = t.intake_id
             and mid = 4042 
             and tid=1
             and qid=1
             and rid=21) as is_goal, 
             
       (select es.event_severity_id  
          from pat_pw_event_entry pe,
               stat_event_severity es
          where pe.event_severity_id = es.event_severity_id 
            and pe.patient_id = t.patient_id
            and pe.pw_event_module_id = t.pw_event_module_id
            and pe.event_date = 
             (select max(event_date) 
                from pat_pw_event_entry pe2
               where pe2.pw_event_module_id = t.pw_event_module_id)
            and rownum=1) as current_severity_id,
            
           (select tds.interpretation   
              from data_intake_score tds
              where tds.patient_id = t.patient_id
              and tds.intake_id = t.intake_id
              and tds.patient_id = t.patient_id 
              and tds.mid = t.mid 
              and tds.series = 0
              and rownum=1) as current_interpretation,

           (select es.event_status 
          from pat_pw_event_entry pe,
               stat_event_status es
          where pe.event_status_id = es.event_status_id
            and pe.patient_id = t.patient_id
            and pe.pw_event_module_id = t.pw_event_module_id
            and pe.event_date = 
             (select max(event_date) 
                from pat_pw_event_entry pe2
               where pe2.pw_event_module_id = t.pw_event_module_id)
            and rownum=1) as current_status,              
      
          (select pe.event_status_id  
          from pat_pw_event_entry pe,
               stat_event_status es
          where pe.event_status_id = es.event_status_id
            and pe.patient_id = t.patient_id
            and pe.pw_event_module_id = t.pw_event_module_id
            and pe.event_date = 
             (select max(event_date) 
                from pat_pw_event_entry pe2
               where pe2.pw_event_module_id = t.pw_event_module_id)
            and rownum=1) as current_status_id,
            
         (select es.event_severity  
          from pat_pw_event_entry pe,
               stat_event_severity es
          where pe.event_severity_id = es.event_severity_id 
            and pe.patient_id = t.patient_id
            and pe.pw_event_module_id = t.pw_event_module_id
            and pe.event_date = 
             (select max(event_date) 
                from pat_pw_event_entry pe2
               where pe2.pw_event_module_id = t.pw_event_module_id)
            and rownum=1) as current_severity,
            
        (select nvl(tt.status, 0) 
             from pat_pw_event tt 
           where tt.pat_pw_event_id = t.pat_pw_event_id) 
           as event_status,
                     
       PCK_REPORTS_PAT.GetCurrentIntakeScore(t.patient_id, t.mid) as current_score,
       PCK_REPORTS_PAT.GetPrevIntakeScore(t.mid, t.patient_id, t.intake_id) as prev_score       

 from  PAT_PW_EVENT_MODULE t,
       intake_module t2
       
where  t.patient_id = :PAT_ID
       and t2.mid = t.mid 
       and t.status = 2 
       and nvl(t.intake_id,-1) > 0 
       and t.intake_id in (select intake_id 
                             from data_intake_score 
                            where series=0)
 
       and t.date_completed = (select max(x.date_completed) 
                                 from PAT_PW_EVENT_MODULE x, 
                                      pat_pw_event x2
                                 where x.mid = t2.mid
                                   and x.patient_id = t.patient_id
                                   and x.pat_pw_event_id = x2.pat_pw_event_id 
                                   and x2.status = 2
                                 
                                   and   (select count(*)  
                                          from data_intake_responses
                                         where intake_id = x.intake_id
                                           and mid = 4042 
                                           and tid=1
                                           and qid=1
                                           and rid=21) = 0 
                                 
                                 )
                                 
     order by t.date_completed desc';
  
    open rs 
    for strSQL
    using pi_vPatientID;
    
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'Error retrieving trend data';

  end; 
  
 
/*gets all scorable modules for this patient and date range
with the 10 most recent columns nulled out for fill in later*/
procedure GetInstrumentsBaseRS( pi_vSessionID       in varchar2,
                                pi_vSessionClientIP in varchar2,
                                pi_nUserID          in number,
                                pi_vPatientID       in varchar2,
                                pi_dtFrom           in date,
                                pi_dtTo             in date,
                                po_nStatusCode      out number,
                                po_vStatusComment   out varchar2,
                                rs                  out RetRefCursor) 
is

strSQL       varchar2(4000) := '';

begin  

strSQL := 'select distinct(t.mid), 
                 case
                   when t3.acronym is null then 
                     case 
                       when length(t3.module) > 10 then trim(substr(t3.module,0,10)) || ''...''
                       else t3.module
                     end
                   else t3.acronym
                 end as short_name, 
                 t3.module, 
                 null as score_10,
                 null as score_9,
                 null as score_8,
                 null as score_7,
                 null as score_6,
                 null as score_5,
                 null as score_4,
                 null as score_3,
                 null as score_2,
                 null as score_1,
                 null as date_10,
                 null as date_9,
                 null as date_8,
                 null as date_7,
                 null as date_6,
                 null as date_5,
                 null as date_4,
                 null as date_3,
                 null as date_2,
                 null as date_1,
                 null as name_10,
                 null as name_9,
                 null as name_8,
                 null as name_7,
                 null as name_6,
                 null as name_5,
                 null as name_4,
                 null as name_3,
                 null as name_2,
                 null as name_1,
                 null as interpretation_10,
                 null as interpretation_9,
                 null as interpretation_8,
                 null as interpretation_7,
                 null as interpretation_6,
                 null as interpretation_5,
                 null as interpretation_4,
                 null as interpretation_3,
                 null as interpretation_2,
                 null as interpretation_1
            from data_intake t, data_intake_score t2, intake_module t3 
           where t.intake_id = t2.intake_id
             and t.mid = t3.mid 
             
              and t.intake_id in (select intake_id 
                         from pat_pw_event_module aa,
                              pat_pw_event aaa
                        where aa.pat_pw_event_id = aaa.pat_pw_event_id
                          and aaa.status = 2
                          
                          and ((select count(*)  
                                      from data_intake_responses
                                     where intake_id = aa.intake_id
                                       and mid = 4042 
                                       and tid=1
                                       and qid=1
                                       and rid=21) = 0) ) 
 

             and t.patient_id = :PATIENT_ID
              AND (trunc(t.complete_date) >= :FROM_DATE 
              AND trunc(t.complete_date) <= :TO_DATE)
             and t2.mid = t3.mid
             and t2.series = 0
             and t.intake_id in 
             (select intake_id from data_intake_score where series=0)
             order by short_name';
  
    open rs 
    for strSQL
    using pi_vPatientID,
          pi_dtFrom,
          pi_dtTo;
    
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'Error retrieving scored instruments';
  end;
             
  /*get a record set of all patients for the site*/
  procedure GetPatPopulationRS(pi_vSessionID       in varchar2,
                               pi_vSessionClientIP in varchar2,
                               pi_nUserID          in number,
                               pi_vKey             in varchar2,
                               po_nStatusCode      out number,
                               po_vStatusComment   out varchar2,
                               rs                  out RetRefCursor) 
  is
  
    strSQL       varchar2(4000);
    
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
    strSQL := 'select ';
    
    --patient id
    strSQL := strSQL || ' p.PATIENT_ID, ';
    
    --first name
    strSQL := strSQL || ' tbicds.fnc_utl_decstr(p.FIRST_NAME, 
              :pi_vKey, p.PATIENT_ID) as first_name, ';
    
    --mi          
    strSQL := strSQL || ' tbicds.fnc_utl_decstr(p.MI, 
              :pi_vKey, p.PATIENT_ID) as mi, ';
    
    --last name
    strSQL := strSQL || ' tbicds.fnc_utl_decstr(p.LAST_NAME, 
              :pi_vKey, p.PATIENT_ID) as last_name, ';
              
    --full_name
    strSQL := strSQL || '( tbicds.fnc_utl_decstr(p.FIRST_NAME, 
                        :pi_vKey, p.PATIENT_ID) || '' '' || ' 
                        || ' tbicds.fnc_utl_decstr(p.MI, 
                        :pi_vKey, p.PATIENT_ID) || '' '' || ' 
                        || ' tbicds.fnc_utl_decstr(p.LAST_NAME,
                        :pi_vKey, p.PATIENT_ID)) as full_name, ';
    
    --gender          
    strSQL := strSQL || ' tbicds.fnc_utl_decstr(p.GENDER, 
              :pi_vKey, p.PATIENT_ID) as gender, ';
    
    --dob          
    strSQL := strSQL || ' to_date(tbicds.fnc_utl_decstr(p.dob, 
              :pi_vKey, p.PATIENT_ID), ''MM/DD/YYYY'') as dob, ';
    
    --home phone  
    strSQL := strSQL || ' p.HOMEPHONE, ';
    
    --cell phone
    strSQL := strSQL || ' p.CELLPHONE, ';
    
    --work phone
    strSQL := strSQL || ' p.WORKPHONE, ';
    
    --email
    strSQL := strSQL || ' tbicds.fnc_utl_decstr(p.EMAIL, 
           :pi_vKey, p.PATIENT_ID) as email, ';
    
    --patient age
    strSQL := strSQL || ' trunc(months_between(SYSDATE, 
           to_date(tbicds.fnc_utl_decstr(p.dob, 
           :pi_vKey, p.PATIENT_ID), ''MM/DD/YYYY'')) / 12) 
           as patient_age ';
        
    strSQL := strSQL || ' from tbicds.patient_demographics p ';

    strSQL := strSQL || ' where ';
 
    --add only patients with events   
    strSQL := strSQL || '((select count(*) from pat_pw_event ppe ';
    strSQL := strSQL || ' where ppe.patient_id = p.patient_id) > 0) and ';
    
    --only patients with sites = users site     
    strSQL := strSQL || ' p.site_id in (';
        
    strSQL := strSQL || 'select site_id ';
    strSQL := strSQL || '  from tbicds.fx_user s ';
    strSQL := strSQL || ' where s.fx_user_id = :pi_nUserID ) ';
    
    strSQL := strSQL || ' order by 
              (tbicds.fnc_utl_decstr(p.LAST_NAME, 
              :pi_vKey, p.PATIENT_ID)) asc ';
  
  
    open rs for strSQL 
    using pi_vKey,
          pi_vKey,
          pi_vKey,
          pi_vKey,
          pi_vKey,
          pi_vKey,
          pi_vKey,
          pi_vKey,
          pi_vKey,
          pi_vKey,
          pi_nUserID,
          pi_vKey;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'Error retrieving population';
  end;


end PCK_REPORTS_PAT;
/
-------------------------------------------
--  Changed package body pck_reports_pi  --
-------------------------------------------
create or replace package body tbicds.PCK_REPORTS_PI is
/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

/*
Get population module series recordset
*/
procedure GetPopModuleSeriesRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      
      pi_nSiteID                in number,
      pi_nMID                   in number,
      
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is

     v_vSQL varchar2(4000) := '
      select distinct(series)  
      from report_population_module t,
           data_intake_score ds
      where t.fx_user_id = :USER_ID  
        and t.mid = :MID 
        and (t.site_id = :SITE_ID 
               or :SITE_ID = -1) 
            
       and( t.admission_intake_id = ds.intake_id 
         or t.discharge_intake_id = ds.intake_id
         or t.followup_intake_id = ds.intake_id)
      order by series';
        
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
    open rs 
      for v_vSQL
    using pi_nUserID,
          pi_nMID,
          pi_nSiteID,
          pi_nSiteID;
          
    commit;
   

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;

/*
Get populatuion module recordset
*/
procedure GetPopModuleRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vKey                   in varchar2,
   
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is

     v_vSQL varchar2(4000) := 'select t.*,
     
        tbicds.fnc_utl_decstr(t2.last_name, 
                            :KEY, 
                            t2.PATIENT_ID) as last_name,
                            
        tbicds.fnc_utl_decstr(t2.first_name, 
                            :KEY2, 
                            t2.PATIENT_ID) as first_name
                                     
         from REPORT_POPULATION_MODULE t,
              PATIENT_DEMOGRAPHICS t2
        where t.FX_USER_ID = :USERID
          and t2.patient_id = t.patient_id
         order by t.MID';
        
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
    open rs 
      for v_vSQL
    using pi_vKey,
          pi_vKey,
          pi_nUserID;
    commit;
   

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;

/*
Get population site recordset
*/
procedure GetPopSiteIDRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
     
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is

     v_vSQL varchar2(4000) := 'select distinct t.site_id 
                               from report_population t 
                               where t.fx_user_id = :USER_ID 
                               ';
        
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
    open rs 
      for v_vSQL
    using pi_nUserID;
    commit;
   

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;

/*
Get population module recordset
*/
procedure GetPopMIDRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
     
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is

     v_vSQL varchar2(4000) := 'select distinct t.mid  
                               from report_population_module t 
                               where t.fx_user_id = :USER_ID 
                               ';
        
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
    open rs 
      for v_vSQL
    using pi_nUserID;
    commit;
   

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;




/*gets population average scores*/
procedure GetPopScoreAvgRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is

     v_vSQL varchar2(4000) := 
'select s.site_name, m.module, 
        ds.mid, 
        t.site_id, 
        ds.series, 
        ds.description,
        round(avg(score),2) as average_score, 
        round(avg(los),2) as average_los,
        ''ADMISSION'' as score_type  
from report_population_module t,
     data_intake_score ds, 
     utl_site s, 
     intake_module m 
where t.admission_intake_id = ds.intake_id 
  and s.site_id = t.site_id 
  and m.mid = ds.mid 
  and t.fx_user_id = :UID1 
group by t.site_id, ds.mid, ds.series, ds.description, s.site_name, m.module 

union 

select  s.site_name, m.module, ds2.mid, t2.site_id, 
ds2.series, 
ds2.description,
round(avg(score),2) as average_score, 
round(avg(los),2) as average_los,
''DISCHARGE'' as score_type  
from report_population_module t2,
data_intake_score ds2,
 utl_site s, 
 intake_module m  
where t2.discharge_intake_id = ds2.intake_id
 and s.site_id = t2.site_id 
  and m.mid = ds2.mid 
and t2.fx_user_id = :UID2  
group by t2.site_id, ds2.mid, ds2.series, ds2.description, s.site_name, m.module 

union

select  s.site_name, m.module, ds3.mid, t3.site_id, 
ds3.series,
ds3.description,
round(avg(score),2) as average_score,
round(avg(los),2) as average_los, 
''FOLLOWUP'' as score_type  
from report_population_module t3,
data_intake_score ds3,
  utl_site s, 
     intake_module m 
where t3.followup_intake_id = ds3.intake_id
 and s.site_id = t3.site_id 
  and m.mid = ds3.mid 
and t3.fx_user_id = :UID3 
group by t3.site_id, ds3.mid, ds3.series, ds3.description, s.site_name, m.module 

order by  site_id, mid, series, score_type 
';

        
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
    open rs 
      for v_vSQL
    using pi_nUserID,
          pi_nUserID,
          pi_nUserID;
    commit;
   

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;


/*gets population scores for all sites*/
procedure GetPopScoreAvgALLRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_nExcludeSiteID         in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is

     v_vSQL varchar2(4000) := 
'select ds.mid, 
        ''All'' as site_name, 
        m.module,  
        -1 as site_id, 
        ds.series, 
        ds.description,
        round(avg(score),2) as average_score, 
        round(avg(los),2) as average_los,
        ''ADMISSION'' as score_type  
from report_population_module t,
data_intake_score ds,
     intake_module m 
where t.admission_intake_id = ds.intake_id
  and m.mid = ds.mid 
and t.fx_user_id = :UID1 
and t.site_id != :ExcludeSiteID
group by ds.mid, ds.series, ds.description, m.module 

union 

select ds2.mid, 
       ''All'' as site_name, 
       m.module,      
       -1 as site_id,    
ds2.series, 
ds2.description,
round(avg(score),2) as average_score, 
round(avg(los),2) as average_los,
''DISCHARGE'' as score_type  
from report_population_module t2,
data_intake_score ds2,
     intake_module m 
where t2.discharge_intake_id = ds2.intake_id
  and m.mid = ds2.mid 
and t2.fx_user_id = :UID2 
and t2.site_id <> :ExcludeSiteID 
group by ds2.mid, ds2.series, ds2.description, m.module 

union

select ds3.mid, 
       ''All'' as site_name, 
       m.module,
       -1 as site_id, 
ds3.series,
ds3.description,
round(avg(score),2) as average_score,
round(avg(los),2) as average_los, 
''FOLLOWUP'' as score_type  
from report_population_module t3,
data_intake_score ds3,
     intake_module m 
where t3.followup_intake_id = ds3.intake_id
  and m.mid = ds3.mid 
and t3.fx_user_id = :UID3 
and t3.site_id != :ExcludeSiteID
group by ds3.mid, ds3.series, ds3.description, m.module 

order by  mid, series, score_type 
';

        
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
    open rs 
      for v_vSQL
    using pi_nUserID,
          pi_nExcludeSiteID,
          pi_nUserID,
          pi_nExcludeSiteID,
          pi_nUserID,
          pi_nExcludeSiteID;
    commit;
   

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;


/*gets population scores*/
procedure GetPopScoreRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vKey                   in varchar2,
      
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is

     v_vSQL varchar2(4000) := '

select * from (         
select t.site_id, ds.*, ''ADMISSION'' as score_type, 

   tbicds.fnc_utl_decstr(p.last_name, 
                            :KEY, 
                            p.PATIENT_ID) as last_name,
                            
   tbicds.fnc_utl_decstr(p.first_name, 
                            :KEY2, 
                            p.PATIENT_ID) as first_name
  
from report_population_module t,
data_intake_score ds,
patient_demographics p
where t.admission_intake_id = ds.intake_id 
and t.patient_id = p.patient_id 
and t.fx_user_id = :UID1

union

select t2.site_id, ds2.*, ''DISCHARGE'' as score_type, 

   tbicds.fnc_utl_decstr(p.last_name, 
                            :KEY, 
                            p.PATIENT_ID) as last_name,
                            
   tbicds.fnc_utl_decstr(p.first_name, 
                            :KEY2, 
                            p.PATIENT_ID) as first_name
   
from report_population_module t2,
data_intake_score ds2,
patient_demographics p
where t2.discharge_intake_id = ds2.intake_id
and t2.patient_id = p.patient_id 
and t2.fx_user_id = :UID2


union

select t3.site_id, ds3.*, ''FOLLOWUP'' as score_type, 

   tbicds.fnc_utl_decstr(p.last_name, 
                            :KEY, 
                            p.PATIENT_ID) as last_name,
                            
   tbicds.fnc_utl_decstr(p.first_name, 
                            :KEY2, 
                            p.PATIENT_ID) as first_name
   
from report_population_module t3,
data_intake_score ds3,
patient_demographics p
where t3.followup_intake_id = ds3.intake_id 
and t3.patient_id = p.patient_id 
and t3.fx_user_id = :UID3
)
order by site_id, mid, series';

        
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
    open rs 
      for v_vSQL
    using
          pi_vKey, 
          pi_vKey,
          pi_nUserID,
          
          pi_vKey, 
          pi_vKey,
          pi_nUserID,
          
          pi_vKey, 
          pi_vKey,
          pi_nUserID;
    commit;
   

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;


/*loads module data to the temp table*/
procedure LoadPopModule (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_nMID                   in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2
      )
is

        
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --clear any old data in the population module table
    --from this module
    delete from report_population_module t 
    where t.mid = pi_nMID
      and t.fx_user_id = pi_nUserID;
    commit;
    
    --create records for the mid
    insert into report_population_module(patient_id,
                                         fx_user_id,
                                         initial_date,
                                         end_date,
                                         mid,
                                         admission_intake_id,
                                         discharge_intake_id,
                                         followup_intake_id,
                                         los,
                                         site_id) 
    select patient_id,
           fx_user_id,
           initial_date,
           end_date,
           pi_nMID,
           null,
           null,
           null,
           --null,
           --NUMTODSINTERVAL(end_date - initial_date, 'DAY'),
           trunc(end_date - initial_date),
           site_id                   
    from report_population pp
    where pp.fx_user_id = pi_nUserID;
    
    commit;   

    --set the admission intake id
    update report_population_module ta
    set ta.admission_intake_id = PCK_REPORTS.GetAdmissionIntakeID(ta.mid,
                                                      ta.patient_id,
                                                      ta.initial_date,
                                                      ta.end_date)
         
    where ta.fx_user_id = pi_nUserID
      and ta.mid = pi_nMID;
    commit;                                                     
                      
    --set the discharge intake id
    update report_population_module td 
       set  td.discharge_intake_id = PCK_REPORTS.GetDischargeIntakeID(td.mid,
                                                          td.patient_id,
                                                          td.initial_date,
                                                          td.end_date)                                            
                                                     
                                                     
    where td.fx_user_id = pi_nUserID
    and td.mid = pi_nMID;
    commit;                           
        
    
    --set the followup intake id
    update report_population_module tf 
       set  tf.followup_intake_id = PCK_REPORTS.GetFollowupIntakeID(tf.mid,
                                                        tf.patient_id,
                                                        tf.discharge_intake_id)                                            
                                                     
                                                     
    where tf.fx_user_id = pi_nUserID
    and tf.mid = pi_nMID;
    commit;   
                               
            
    --now loop and do something to report_population
    --FOR rec IN (SELECT *
    --              FROM report_population t
    --             where t.fx_user_id = pi_nUserID) 
    --LOOP
    --
    --         null;
    --
    --
    --END LOOP;
    

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;


/*loads a temp table with population matching criteria*/
procedure LoadPopulation (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vKey                   in varchar2,
      
      pi_dtFrom                 in date,      
      pi_dtTo                   in date,
      pi_nClinicalSetting       in number,
     
      pi_nRegionID              in number,
      pi_nSiteID                in number,
      pi_nCPATypeID             in number, --type
      
      pi_nImpairmentID          in number,
      pi_nInjuryID              in number,
      pi_vGender                in varchar2,
      pi_nMilStatusID           in number,
      pi_vSiteIDS               in varchar2,
      
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2
      )
is

     v_vSQL varchar2(4000) :=
      'insert into report_population(fx_user_id,
                                     patient_id,
                                     initial_date,
                                     end_date,
                                     site_id)
       select :UserID as fx_user_id,
              t.patient_id,
              t2.initial_date,
              t2.end_date,
              t.site_id
       from patient_demographics t,
            pat_treatment_program t2,
            pat_treatment t3
       where t2.patient_id = t.patient_id
       and t2.treatment_id = t3.treatment_id 
       and ( (:GENDER = ''-1'')
             or 
             ( tbicds.fnc_utl_decstr(t.gender, 
                                     :KEY, 
                                     t.PATIENT_ID) = :GENDER2
              )
            )
       
       and ( (:SITES = ''-1'')
             or
             ( 
               instr(:MATCH_SITES, '','' || t.site_id || '','' ) > 0
              )
            )

       and t2.end_date is not null
       and (      trunc(t2.end_date) >= trunc(:DTFROM)
              and trunc(t2.end_date) <= trunc(:DTEND)
              and ( (:CLINSETT = -1)
                      or
                    (t3.treatment_type_id = :CLINSETT2)
                   )
              
               and ( (:CPA_TYPE = ''-1'')
                   or
                   ( 
                      :CPA_TYPE2 = 
                         (select cpa_type_id  
                            from cpa cp  
                           where cp.cpa_id = t2.cpa_id )
                    )
                  ) 
              
              
              
            ) 
            
        and ( (:IMPAIRMENT1 = -1)
                or
                (
                  :IMPAIRMENT2 = PCK_REPORTS.GetImpairmentRID(t.patient_id, t2.end_date)                
                )
             )

       and ( (:INJURY1 = -1)
                or
                (
                  :INJURY2 = PCK_REPORTS.GetInjuryRID(t.patient_id, t2.end_date)                
                )
             )      
             
       and ( (:DUTYSTATUS1 = -1)
                or
                (
                  :DUTYSTATUS2 = t.duty_status_id                 
                )
             )           
       ';
        
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --delete current cached records for this user
    delete 
    from report_population t 
    where t.fx_user_id = pi_nUserID;
    commit;
    
    delete from report_population_module tm
    where tm.fx_user_id = pi_nUserID;
    commit;
    
    
    --execute the SQL
    EXECUTE IMMEDIATE v_vSQL
    USING pi_nUserID,
          pi_vGender,
          pi_vKey,
          pi_vGender,
          pi_vSiteIDS,
          pi_vSiteIDS,
          pi_dtFrom,
          pi_dtTo,
          pi_nClinicalSetting,
          pi_nClinicalSetting,
          pi_nCPATypeID,
          pi_nCPATypeID,
          pi_nImpairmentID,
          pi_nImpairmentID,
          --pi_dtTo,
          pi_nInjuryID,
          pi_nInjuryID,
          --pi_dtTo,
          pi_nMilStatusID,
          pi_nMilStatusID;
         
    
    commit;

--exception
  --  when others then
    --  po_nStatusCode    := 1;
     -- po_vStatusComment := '';
      
end;


end PCK_REPORTS_PI;
/
---------------------------------------------
--  Changed package body pck_reports_stat  --
---------------------------------------------
create or replace package body tbicds.PCK_REPORTS_STAT is
/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
  /*
  Create a new export request.
  */
  procedure CreateExportRequestRS(pi_vSessionID         in varchar2,
                                  pi_vSessionClientIP   in varchar2,
                                  pi_nUserID            in number,
                                  pi_vExportRequestName in varchar2,
                                  po_nStatusCode        out number,
                                  po_vStatusComment     out varchar2,
                                  rs                    out RetRefCursor)
  is

    v_seqRequestID   number;
    v_nRptNameExists number := 0;

  begin

    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';

    begin
      select count(*)
        into v_nRptNameExists
        from exp_statistical_rpt t
       where t.fx_user_id = pi_nUserID
         and t.report_name = pi_vExportRequestName;
    end;

    if v_nRptNameExists = 0 then
      --get a new request id
      select seqexpstatisticalrpt.nextval into v_seqRequestID from dual;

      --create the export request record...
      insert into exp_statistical_rpt(request_id,fx_user_id,report_name,status)
      values(
        v_seqRequestID,
        pi_nUserID,
        pi_vExportRequestName,
        0 --new request pending for definition
      );
      commit;
      
      open rs for
        select v_seqRequestID as REQUEST_ID from dual;
    else
      --raise exception
      po_nStatusCode    := 2;
      po_vStatusComment := 'Export request already exists.';
    end if;

  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_REPORTS_STAT.CreateExportRequest(): ' || sqlErrm;
  end;

  /*
  Get a list of the request of this user.
  */
  procedure GetMyRequestRS(pi_vSessionID       in varchar2,
                           pi_vSessionClientIP in varchar2,
                           pi_nUserID          in number,
                           po_nStatusCode      out number,
                           po_vStatusComment   out varchar2,
                           rs                  out RetRefCursor)
  is

  begin

    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';

    open rs for
      select
        t.request_id,
        t.report_name,
        t.status as status_code,
        case t.status
          when -1 then 'Error'
          when  0 then 'New (Pending for Execution)'
          when  1 then 'In Progress'
          when  2 then 'Ready for Download'
          when  3 then 'Canceled' 
        end as status_description,
        t.start_date as str_date,
        t.end_date as end_date
      from exp_statistical_rpt t
      where t.fx_user_id = pi_nUserID
      order by t.request_id desc;

  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_REPORTS_STAT.GetMyRequestRS(): ' || sqlErrm;
  end;

  /*
  Rename export request
  */
  procedure RenameExportRequest(pi_vSessionID            in varchar2,
                                pi_vSessionClientIP      in varchar2,
                                pi_nUserID               in number,
                                pi_nRequestID            in number,
                                pi_vNewExportRequestName in varchar2,
                                po_nStatusCode           out number,
                                po_vStatusComment        out varchar2)
  is

    v_nRptNameExists number := 0;
    v_nTargetExists  number := 0;

  begin

    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';

    --val 1: new export request name already exists?
    begin
      select count(*)
        into v_nRptNameExists
        from exp_statistical_rpt t
       where t.fx_user_id = pi_nUserID
         and t.report_name = pi_vNewExportRequestName;
    end;

    if v_nRptNameExists = 0 then
      --val 2: target request to be rename, exists?
      begin
        select count(*)
          into v_nTargetExists
          from exp_statistical_rpt t
         where t.fx_user_id = pi_nUserID
           and t.request_id = pi_nRequestID;
        end;

        if v_nTargetExists = 0 then
          --raise exception
          po_nStatusCode    := 3;
          po_vStatusComment := 'Export request not found.';

        else
          --rename
          update exp_statistical_rpt set
            report_name = pi_vNewExportRequestName
          where fx_user_id = pi_nUserID
            and request_id = pi_nRequestID;
          commit;
        end if;
    else
      --raise exception
      po_nStatusCode    := 2;
      po_vStatusComment := 'Export request already exists.';
    end if;

  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_REPORTS_STAT.RenameExportRequest(): ' || sqlErrm;
  end;

  /*
  Update export request
  */
  procedure UpdateExportRequest(pi_vSessionID       in varchar2,
                                pi_vSessionClientIP in varchar2,
                                pi_nUserID          in number,
                                pi_nRequestID       in number,
                                pi_vFilters         in varchar2,
                                pi_vDataFields      in varchar2,
                                po_nStatusCode      out number,
                                po_vStatusComment   out varchar2)
  is

    v_nTargetExists  number := 0;

  begin

    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';

    --val 1: target request exists?
    begin
      select count(*)
        into v_nTargetExists
        from exp_statistical_rpt t
       where t.fx_user_id = pi_nUserID
         and t.request_id = pi_nRequestID
         and t.status = 0; --Only New request can be updated
    end;

    if v_nTargetExists = 1 then
      --update filters and datafields
        update exp_statistical_rpt set
          filters = pi_vFilters,
          data_included = pi_vDataFields
        where fx_user_id = pi_nUserID
          and request_id = pi_nRequestID
          and status = 0; --Only New request can be updated
        commit;
    else
      --raise exception
      if v_nTargetExists = 0 then
        po_nStatusCode    := 2;
        po_vStatusComment := 'Request not found.';
      else
        po_nStatusCode    := 3;
        po_vStatusComment := 'Multiple request found with the same request ID.'; --this won't happend because it will be a primary key violation.
      end if;
    end if;

  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_REPORTS_STAT.UpdateExportRequest(): ' || sqlErrm;
  end;

  /*
  Get export request recordset
  */
  procedure GetExportRequestRS(pi_vSessionID       in varchar2,
                               pi_vSessionClientIP in varchar2,
                               pi_nUserID          in number,
                               pi_nRequestID       in number,
                               po_nStatusCode      out number,
                               po_vStatusComment   out varchar2,
                               rs                  out RetRefCursor)
  is

    v_nTargetExists  number := 0;

  begin

    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';

    --val 1: target request exists?
    begin
      select count(*)
        into v_nTargetExists
        from exp_statistical_rpt t
       where t.fx_user_id = pi_nUserID
         and t.request_id = pi_nRequestID;
    end;

    if v_nTargetExists = 1 then
      open rs for
        select t.report_name,
               t.filters,
               t.data_included
          from exp_statistical_rpt t
         where t.fx_user_id = pi_nUserID
           and t.request_id = pi_nRequestID;
    else
      --raise exception
      if v_nTargetExists = 0 then
        po_nStatusCode    := 2;
        po_vStatusComment := 'Request not found.';
      else
        po_nStatusCode    := 3;
        po_vStatusComment := 'Multiple request found with the same request ID.'; --this won't happend because it will be a primary key violation.
      end if;
    end if;

  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_REPORTS_STAT.GetExportRequestRS(): ' || sqlErrm;
  end;

  /*
  Save export request
  */
  procedure SaveAsExportRequest(pi_vSessionID         in varchar2,
                                pi_vSessionClientIP   in varchar2,
                                pi_nUserID            in number,
                                pi_vExportRequestName in varchar2,
                                pi_vFilters         in varchar2,
                                pi_vDataFields      in varchar2,
                                po_nStatusCode        out number,
                                po_vStatusComment     out varchar2)
  is

    v_seqRequestID   number;
    v_nRptNameExists number := 0;

  begin

    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';

    --val 1: target request exists?
    begin
      select count(*)
        into v_nRptNameExists
        from exp_statistical_rpt t
       where t.fx_user_id = pi_nUserID
         and t.report_name = pi_vExportRequestName;
    end;

    if v_nRptNameExists = 0 then
      --get a new request id
      select seqexpstatisticalrpt.nextval into v_seqRequestID from dual;

      --create the export request record...
      insert into exp_statistical_rpt(request_id,fx_user_id,report_name,status,filters,data_included)
      values(
        v_seqRequestID,
        pi_nUserID,
        pi_vExportRequestName,
        0, --new request pending for definition
        pi_vFilters,
        pi_vDataFields
      );
      commit;
    else
      --raise exception
      po_nStatusCode    := 2;
      po_vStatusComment := 'Export request already exists.';
    end if;

  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_REPORTS_STAT.SaveAsExportRequest(): ' || sqlErrm;
  end;
  
  /*
  Submit export request
  */
  procedure SubmitExportRequest(pi_vSessionID       in varchar2,
                                pi_vSessionClientIP in varchar2,
                                pi_nUserID          in number,
                                pi_vKey             in varchar2,
                                pi_nRequestID       in number,
                                pi_vFilters         in varchar2,
                                pi_vDataFields      in varchar2,
                                po_nStatusCode      out number,
                                po_vStatusComment   out varchar2)
  is

    v_nTargetExists  number := 0;

  begin

    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';

    --val 1: target request exists?
    begin
      select count(*)
        into v_nTargetExists
        from exp_statistical_rpt t
       where t.fx_user_id = pi_nUserID
         and t.request_id = pi_nRequestID
         and t.status = 0; --Only New request can be updated
    end;

    if v_nTargetExists = 1 then
      --update filters, datafields, status, and start_date
        update exp_statistical_rpt set
          filters = pi_vFilters,
          data_included = pi_vDataFields,
          status = 1, --In Progress
          start_date = sysdate
        where fx_user_id = pi_nUserID
          and request_id = pi_nRequestID
          and status = 0; --Only New request can be updated
        commit;
        
        --CALL CSV BUILDER PROCESS
        PCK_UTL_EXPORT_DATA.runExport (
          pi_vSessionID,
          pi_vSessionClientIP,
          pi_nUserID,
          pi_nRequestID,
          pi_vKey,
          po_nStatusCode,
          po_vStatusComment
        );

    else
      --raise exception
      if v_nTargetExists = 0 then
        po_nStatusCode    := 2;
        po_vStatusComment := 'Request not found.';
      else
        po_nStatusCode    := 3;
        po_vStatusComment := 'Multiple request found with the same request ID.'; --this won't happend because it will be a primary key violation.
      end if;
    end if;

  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_REPORTS_STAT.SubmitExportRequest(): ' || sqlErrm;
  end;
  
  /*
  Cancel export request
  */
  procedure CancelExportRequest(pi_vSessionID       in varchar2,
                                pi_vSessionClientIP in varchar2,
                                pi_nUserID          in number,
                                pi_nRequestID       in number,
                                po_nStatusCode      out number,
                                po_vStatusComment   out varchar2)
  is

    v_nTargetExists  number := 0;

  begin

    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';

    --val 1: target request exists?
    begin
      select count(*)
        into v_nTargetExists
        from exp_statistical_rpt t
       where t.fx_user_id = pi_nUserID
         and t.request_id = pi_nRequestID
         and t.status = 1; --Only In Progress request can be cancel
    end;

    if v_nTargetExists = 1 then
      --update status and end_date
        update exp_statistical_rpt set
          status = 3, --Canceled
          end_date = sysdate
        where fx_user_id = pi_nUserID
          and request_id = pi_nRequestID
          and status = 1; --Only In Progress request can be cancel
        commit;
        
        --STOP CSV BUILDER PROCESS???
        PCK_UTL_EXPORT_DATA.cancelExport (
          pi_vSessionID,
          pi_vSessionClientIP,
          pi_nUserID,
          pi_nRequestID,
          po_nStatusCode,
          po_vStatusComment
        );

    else
      --raise exception
      if v_nTargetExists = 0 then
        po_nStatusCode    := 2;
        po_vStatusComment := 'Request not found.';
      else
        po_nStatusCode    := 3;
        po_vStatusComment := 'Multiple request found with the same request ID.'; --this won't happend because it will be a primary key violation.
      end if;
    end if;

  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_REPORTS_STAT.CancelExportRequest(): ' || sqlErrm;
  end;
  
  /*
  Get export request CSV
  */
  procedure GetExportRequestCSVFileRS(pi_vSessionID       in varchar2,
                                      pi_vSessionClientIP in varchar2,
                                      pi_nUserID          in number,
                                      pi_nRequestID       in number,
                                      po_nStatusCode      out number,
                                      po_vStatusComment   out varchar2,
                                      rs                  out RetRefCursor)
  is

    v_nTargetExists  number := 0;

  begin

    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';

    --val 1: target request exists?
    begin
      select count(*)
        into v_nTargetExists
        from exp_statistical_rpt t
       where t.fx_user_id = pi_nUserID
         and t.request_id = pi_nRequestID
         and t.status = 2;
    end;

    if v_nTargetExists = 1 then
      open rs for
        select t.report_name,
               t.file_data
          from exp_statistical_rpt t
         where t.fx_user_id = pi_nUserID
           and t.request_id = pi_nRequestID
           and t.status = 2;
           
      --AUDIT
      insert into exp_statistical_rpt_audit(request_id,fx_user_id,request_download_date) 
      values(pi_nRequestID,
             pi_nUserID,
             sysdate);
      commit;
      
    else
      --raise exception
      if v_nTargetExists = 0 then
        po_nStatusCode    := 2;
        po_vStatusComment := 'Request not found.';
      else
        po_nStatusCode    := 3;
        po_vStatusComment := 'Multiple request found with the same request ID.'; --this won't happend because it will be a primary key violation.
      end if;
    end if;

  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_REPORTS_STAT.GetExportRequestCSVFileRS(): ' || sqlErrm;
  end;
  
  /*
  Submit new export request
  */
  procedure SubmitNewExportRequest(pi_vSessionID         in varchar2,
                                   pi_vSessionClientIP   in varchar2,
                                   pi_nUserID            in number,
                                   pi_vKey               in varchar2,
                                   pi_vExportRequestName in varchar2,
                                   pi_vFilters           in varchar2,
                                   pi_vDataFields        in varchar2,
                                   po_nStatusCode        out number,
                                   po_vStatusComment     out varchar2)
  is

    v_seqRequestID   number;
    v_nRptNameExists number := 0;

  begin

    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';

    begin
      select count(*)
        into v_nRptNameExists
        from exp_statistical_rpt t
       where t.fx_user_id = pi_nUserID
         and t.report_name = pi_vExportRequestName;
    end;

    if v_nRptNameExists = 0 then
      --get a new request id
      select seqexpstatisticalrpt.nextval into v_seqRequestID from dual;

      --create the export request record...
      insert into exp_statistical_rpt(request_id,fx_user_id,report_name,filters,data_included,status,start_date)
      values(
        v_seqRequestID,
        pi_nUserID,
        pi_vExportRequestName,
        pi_vFilters,
        pi_vDataFields,
        1, --In Progress
        sysdate
      );
      commit;
      
      --CALL CSV BUILDER PROCESS
      PCK_UTL_EXPORT_DATA.runExport (
        pi_vSessionID,
        pi_vSessionClientIP,
        pi_nUserID,
        v_seqRequestID,
        pi_vKey,
        po_nStatusCode,
        po_vStatusComment
      );
      
    else
      --raise exception
      po_nStatusCode    := 2;
      po_vStatusComment := 'Export request already exists.';
    end if;

  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_REPORTS_STAT.SubmitNewExportRequest(): ' || sqlErrm;
  end;

end PCK_REPORTS_STAT;
/
----------------------------------------
--  Changed package body pck_rpt_cde  --
----------------------------------------
create or replace package body tbicds.PCK_RPT_CDE is
/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
   /*get Patient Cde Value*/
   procedure getPatientCdeValue (
      pi_vPatientID                     in varchar2,
      pi_vCdeID                         in varchar2,
      pi_nIntakeID                      in number,
      pi_vKey                           in varchar2,
      po_vValue                        out varchar2
      )
   is
      v_vSql                               varchar2(4000);
      rd                                   cde_stat_map%rowtype;
      v_vValue                             varchar2(128);
   begin
      v_vSql := 'select * from cde_stat_map where cde_id = :P0';
      execute immediate v_vSql into rd using pi_vCdeID;
   
      -- case: cde map type = Question
      if (rd.cde_map_type_id = 1)
         or (rd.cde_map_type_id = 3)
         or (rd.cde_map_type_id = 5)
      then
         v_vSql := 'select t.'||rd.field_name||' '
                   ||'from '||rd.table_name||' t '
                   ||'where t.patient_id = :P0 '
                   ||'and t.intake_id = :P1 '
                   ||'and t.mid = :P2 '
                   ||'and t.tid = :P3 '
                   ||'and t.qid = :P4 '
                   ||'and t.rid in (select s.rid from intake_response s where s.mid = t.mid and s.tid = t.tid and s.qid = t.qid) '
                   ||'and rownum = 1 ';
         execute immediate v_vSql into v_vValue using pi_vPatientID, pi_nIntakeID, rd.intake_mid, rd.intake_tid, rd.intake_qid;

      -- case: cde map type = Response
      elsif (rd.cde_map_type_id = 2)
      then
         null;
         
      -- case: cde map type = Score
      elsif (rd.cde_map_type_id = 3)
      then
         null;
         
      -- case: cde map type = Table
      elsif (rd.cde_map_type_id = 4)
      then
         if (instr(','||c_vEncrytedCdeIDs||',', ','||pi_vCdeID||',') > 0)
         then
            v_vSql := 'select '||rd.field_name||' from '||rd.table_name||' where patient_id = :P0';
            execute immediate v_vSql into v_vValue using pi_vPatientID;
            v_vValue := tbicds.ic_utl_sec.decryptdata (v_vValue, pi_vKey, pi_vPatientID);

            --? need to verify
            --if (rd.field_name like 'GENDER')
            --then
            --   v_vSql := 'select item from stat_data_collection where collection_type = :P0 and collection_item_id = :P1';
            --   execute immediate v_vSql into v_vValue using '_GENDER', v_vValue;*\
            --end if;
            
         else
            v_vSql := 'select wm_concat(s.item) '
                      ||'from '||rd.table_name||' t, stat_data_collection s '
                      ||'where t.patient_id = :P0 '
                      ||'and s.collection_type = :P1 '
                      ||'and t.'||rd.field_name||' = s.collection_item_id ';
            execute immediate v_vSql into v_vValue using pi_vPatientID, '_'||replace(rd.field_name, '_ID');
            
         end if;

      -- case: cde map type = Scale
      elsif (rd.cde_map_type_id = 5)
      then
         null;
         
      end if;
      
      po_vValue := v_vValue;
      
   exception
      when others 
      then 
         null;
   end;
      
   /*set Patient Cde: exclude encrypted demographic data */
   procedure setPatientCde (
      pi_vPatientID                     in varchar2 default null
      )
   is
      v_vSql                               varchar2(32767);
      rc1                                  sys_refcursor;
      rc2                                  sys_refcursor;
      rd                                   typ_obj_rpt_cde_pat;
      v_nIndex                             number;
      v_vPatientID                         varchar2(50);
      v_vCdeID                             varchar2(30);
      v_nIntakeID                          number(5);
      v_vValue                             varchar2(128);
   begin
      rd := typ_obj_rpt_cde_pat();
      
      -- part 1: add patient with intake data
      v_vSql := 'select distinct t.patient_id, t.intake_id from data_intake t '
                ||'where complete = 1'
                ||'and not exists (select * from patient_cde_rpt s where s.patient_id = t.patient_id and s.intake_id = t.intake_id) '
                ||case when (pi_vPatientID is not null) then 'and t.patient_id = '''||pi_vPatientID||''' ' end;
      open rc1 for v_vSql;
      loop
         fetch rc1 into v_vPatientID, v_nIntakeID;
         exit when rc1%notfound;
         v_nIndex := 0;
         
         begin
            --v_vSql := 'delete from patient_cde_rpt where patient_id = :P0 and intake_id = :P1';
            --execute immediate v_vSql using v_vPatientID, v_nIntakeID;
            
            v_vSql := 'select cde_id from cde_stat_map order by cde_id';
            open rc2 for v_vSql;
            loop
               fetch rc2 into v_vCdeID;
               exit when rc2%notfound;
               v_nIndex := v_nIndex + 1;
               
               -- exclude encrypted demographic data
               if (instr(','||c_vEncrytedCdeIDs||',', ','||v_vCdeID||',') = 0)
               then
                  getPatientCdeValue (v_vPatientID, v_vCdeID, v_nIntakeID, null, v_vValue);
                  rd.setValue(v_nIndex, v_vValue);
               end if;
            end loop;
            close rc2;
                   
            v_vSql := 'insert into patient_cde_rpt values (:P0, :P1, :P2, :P3)';
            execute immediate v_vSql using v_vPatientID, v_nIntakeID, sysdate, rd;
            commit;
            
         --exception
           -- when others
           -- then
             --  rollback;
         end;
      end loop;
      close rc1;

      -- part 2 (optional): add patient with no intake data
      v_vSql := 'select t.patient_id from patient_demographics t '
                ||'where 1 = '||c_nIncludeNoIntake||' '
                ||'and not exists (select * from patient_cde_rpt s where s.patient_id = t.patient_id) '
                ||case when (pi_vPatientID is not null) then 'and t.patient_id = '''||pi_vPatientID||''' ' end;
      open rc1 for v_vSql;
      loop
         fetch rc1 into v_vPatientID;
         exit when rc1%notfound;
         v_nIndex := 0;
         
         begin
            v_vSql := 'delete from patient_cde_rpt where patient_id = :P0';
            execute immediate v_vSql using v_vPatientID;
            
            v_vSql := 'select cde_id from cde_stat_map order by cde_id';
            open rc2 for v_vSql;
            loop
               fetch rc2 into v_vCdeID;
               exit when rc2%notfound;
               v_nIndex := v_nIndex + 1;
               
               -- exclude encrypted demographic data
               if (instr(','||c_vEncrytedCdeIDs||',', ','||v_vCdeID||',') = 0)
               then
                  getPatientCdeValue (v_vPatientID, v_vCdeID, null, null, v_vValue);
                  rd.setValue(v_nIndex, v_vValue);
               end if;
            end loop;
            close rc2;
                   
            v_vSql := 'insert into patient_cde_rpt values (:P0, :P1, :P2, :P3)';
            execute immediate v_vSql using v_vPatientID, -1, sysdate, rd;
            commit;
            
         exception
            when others
            then
               rollback;
         end;
      end loop;
      close rc1;      
   end;
      
   /*tabel Patient Cde */
   function tblPatientCde (
      pi_vKey                           in varchar2,
      pi_vProviderID                    in varchar2,
      pi_dDateRange_Start               in date,
      pi_dDateRange_End                 in date
      ) return                             typ_tbl_rpt_cde_pat pipelined
   is
      v_vSql                               varchar2(32767);
      rc1                                  sys_refcursor;
      rc2                                  sys_refcursor;
      rd                                   typ_obj_rpt_cde_pat;
      v_nIndex                             number;
      v_vPatientID                         varchar2(50);
      v_vCdeID                             varchar2(30);
      v_nIntakeID                          number(5);
      v_vValue                             varchar2(128);
   begin
      rd := typ_obj_rpt_cde_pat();

      v_vSql := 'select distinct t.patient_id, t.intake_id from data_intake t where t.complete = 1 '
                ||case 
                  when (c_nShowLatestIntake = 1) then 
                     'where t.intake_id = (select max(s.intake_id) from data_intake s where s.patient_id = t.patient_id) '
                  end;
      open rc1 for v_vSql;
      loop
         fetch rc1 into v_vPatientID, v_nIntakeID;
         exit when rc1%notfound;
         v_nIndex := 0;
         
         begin
            v_vSql := 'select cde_id from cde_stat_map order by cde_id';
            open rc2 for v_vSql;
            loop
               fetch rc2 into v_vCdeID;
               exit when rc2%notfound;
               v_nIndex := v_nIndex + 1;
               
               getPatientCdeValue (v_vPatientID, v_vCdeID, v_nIntakeID, pi_vKey, v_vValue);
               rd.setValue(v_nIndex, v_vValue);
            end loop;
            close rc2;
            
            pipe row (rd);
         exception
            when others
            then
               null;
         end;
      end loop;
      close rc1;
            
      -- part 2 (optional): add patient with no intake data
      v_vSql := 'select t.patient_id from patient_demographics t '
                ||'where 1 = '||c_nIncludeNoIntake||' '
                ||'and not exists (select * from data_intake s where s.patient_id = t.patient_id) ';
      open rc1 for v_vSql;
      loop
         fetch rc1 into v_vPatientID;
         exit when rc1%notfound;
         v_nIndex := 0;
         
         begin
            v_vSql := 'select cde_id from cde_stat_map order by cde_id';
            open rc2 for v_vSql;
            loop
               fetch rc2 into v_vCdeID;
               exit when rc2%notfound;
               v_nIndex := v_nIndex + 1;
               
               getPatientCdeValue (v_vPatientID, v_vCdeID, null, pi_vKey, v_vValue);
               rd.setValue(v_nIndex, v_vValue);
            end loop;
            close rc2;

            pipe row (rd);
            
         exception
            when others
            then
               null;
         end;
      end loop;
      close rc1; 

      return;
   end;

   /*table Patient Cde cache, use patient_cde_rpt table*/
   function tblPatientCde_Cached (
      pi_vKey                           in varchar2,
      pi_vProviderID                    in varchar2,
      pi_dDateRange_Start               in date,
      pi_dDateRange_End                 in date
      ) return                             typ_tbl_rpt_cde_pat pipelined
   is
      rd                                   typ_obj_rpt_cde_pat;
      v_vSql                               varchar2(32767);
      rc1                                  sys_refcursor;
      rc2                                  sys_refcursor;
      v_vPatientID                         varchar2(50);
      v_nIntakeID                          number(5);
      v_dDateUpdated                       date;
      v_nIndex                             number;
      v_vCdeID                             varchar2(30);
      v_vValue                             varchar2(128);
   begin
      rd := typ_obj_rpt_cde_pat();

      v_vSql := 'select t.* '
                ||'from patient_cde_rpt t '
                ||case 
                  when (c_nShowLatestIntake = 1) then 
                     'where t.intake_id = (select max(s.intake_id) from patient_cde_rpt s where s.patient_id = t.patient_id) '
                  end;
      open rc1 for v_vSql;
      loop
         fetch rc1 into v_vPatientID, v_nIntakeID, v_dDateUpdated, rd;
         exit when rc1%notfound;
         v_nIndex := 0;
         
         v_vSql := 'select cde_id from cde_stat_map order by cde_id';
         open rc2 for v_vSql;
         loop
            fetch rc2 into v_vCdeID;
            exit when rc2%notfound;
            v_nIndex := v_nIndex + 1;
         
            -- add encrypted demographic data
            if (instr(','||c_vEncrytedCdeIDs||',', ','||v_vCdeID||',') > 0)
            then
               getPatientCdeValue (v_vPatientID, v_vCdeID, v_nIntakeID, pi_vKey, v_vValue);
               rd.setValue(v_nIndex, v_vValue);
            end if;
         end loop;
         close rc2;
         
         pipe row (rd);
      end loop;
      close rc1;
      
      return;
   end;
   
   /*Get Patient Cde recordset*/
   procedure GetPatientCdeRS (
      pi_vSessionID                     in varchar2,
      pi_vSessionClientIP               in varchar2,
      pi_nUserID                        in number,
      --pi_nReportID                      in number,
      pi_vKey                           in varchar2,
      pi_vProviderID                    in varchar2,
      pi_vDateRange_Start               in varchar2,
      pi_vDateRange_End                 in varchar2,
      po_nStatusCode                   out number,
      po_vStatusComment                out varchar2,
      rs                               out sys_refcursor
      )
   is
      v_vSql                               varchar2(32767);
      rc                                   sys_refcursor;
      v_vVariableName                      varchar2(128);
      v_dDateRange_Start                   date := to_date(nvl(pi_vDateRange_Start, '19000101'), 'YYYYMMDD');
      v_dDateRange_End                     date := to_date(nvl(pi_vDateRange_End, '40001231'), 'YYYYMMDD');
      v_nIndex                             number := 0;
   begin
      open rc for 'select s.variable_name from cde_stat_map l, cde_stat s where l.cde_id = s.cde_id order by l.cde_id';
      loop
         fetch rc into v_vVariableName;
         exit when rc%notfound;
         
         v_nIndex := v_nIndex + 1;
         v_vSql := v_vSql
                   ||case when (v_vSql is not null) then ',' end
                   ||'c'||v_nIndex||' "'||substr(trim(v_vVariableName),1,30)||'"';
      end loop;
      close rc;
      
      v_vSql := 'select '||v_vSql||' from table (pck_rpt_cde.tblPatientCde (:P0,:P1,:P2,:P3)) t';
      open rs for v_vSql using pi_vKey, pi_vProviderID,v_dDateRange_Start,v_dDateRange_End;
  
   exception
      when others
      then
         po_nStatusCode    := Pck_Utl_Common.c_nResultStatus_Error;
         po_vStatusComment := 'PCK_RPT_CDE.GetPatientCdeRS(): '||sqlCode||'; '||sqlErrm;
   end;


   /*Get Patient Cde Cached recordset*/
   procedure GetPatientCdeRS_Cached (
      pi_vSessionID                     in varchar2,
      pi_vSessionClientIP               in varchar2,
      pi_nUserID                        in number,
      --pi_nReportID                      in number,
      pi_vKey                           in varchar2,
      pi_vProviderID                    in varchar2,
      pi_vDateRange_Start               in varchar2,
      pi_vDateRange_End                 in varchar2,
      po_nStatusCode                   out number,
      po_vStatusComment                out varchar2,
      rs                               out sys_refcursor
      )
   is
      v_vSql                               varchar2(32767);
      rc                                   sys_refcursor;
      v_vVariableName                      varchar2(128);
      v_dDateRange_Start                   date := to_date(nvl(pi_vDateRange_Start, '19000101'), 'YYYYMMDD');
      v_dDateRange_End                     date := to_date(nvl(pi_vDateRange_End, '40001231'), 'YYYYMMDD');
      v_nIndex                             number := 0;
   begin
      --setPatientCde ();
      
      open rc for 'select s.variable_name from cde_stat_map l, cde_stat s where l.cde_id = s.cde_id order by l.cde_id';
      loop
         fetch rc into v_vVariableName;
         exit when rc%notfound;
         
         v_nIndex := v_nIndex + 1;
         v_vSql := v_vSql
                   ||case when (v_vSql is not null) then ',' end
                   ||'c'||v_nIndex||' "'||substr(trim(v_vVariableName),1,30)||'"';
      end loop;
      close rc;
      
      v_vSql := 'select '||v_vSql||' from table (pck_rpt_cde.tblPatientCde_Cached (:P0,:P1,:P2,:P3)) t';
      open rs for v_vSql using pi_vKey, pi_vProviderID,v_dDateRange_Start,v_dDateRange_End;
  
   exception
      when others
      then
         po_nStatusCode    := Pck_Utl_Common.c_nResultStatus_Error;
         po_vStatusComment := 'PCK_RPT_CDE.GetPatientCdeRS_Cached(): '||sqlCode||'; '||sqlErrm;
   end;


end;
/
-------------------------------------
--  Changed package body pck_stat  --
-------------------------------------
create or replace package body tbicds.PCK_STAT is
/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
  /*
  Queries and returns static data 
  recordset by collections. 
  */
  procedure GetDataCollectionRS(pi_vSessionID       in varchar2,
                             pi_vSessionClientIP in varchar2,
                             pi_nUserID          in number,
                             pi_vDataCollection  in varchar2,
                             po_nStatusCode      out number,
                             po_vStatusComment   out varchar2,
                             rs                  out RetRefCursor)
  is
  
    v_vSQL varchar2(32767) := '';
  
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
    open rs for
      select *
        from stat_data_collection t
       where t.collection_type = pi_vDataCollection
         and t.active = 1
       order by t.collection_item_id;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
  end;

end PCK_STAT;
/
------------------------------------------
--  Changed package body pck_system_id  --
------------------------------------------
create or replace package body tbicds.PCK_SYSTEM_ID is
/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
  /*This function will return a person id string*/
  function GetNewPersonID return varchar2 
  is
    v_vPatientID varchar2(72) := '';
    v_vPadding   varchar2(12) := '00000000';
  begin
    -- build the Patient ID
    v_vPatientID := v_vPatientID || c_vPatient;
    v_vPatientID := v_vPatientID || GenerateRandomString(6);
    v_vPatientID := v_vPatientID || GetDateTimeString;
    return v_vPatientID;
  end;

  /*This function will return a patient id string*/
  function GetNewPatientID(pi_vFirstName   in varchar2,
                           pi_vLastName    in varchar2,
                           pi_vDateOfBirth in varchar2,
                           pi_vGender      in varchar2,
                           pi_vSSN         in varchar2) return varchar2 
  is
  
    v_vPatientID varchar2(72) := '';
    v_vPadding   varchar2(12) := '00000000';
  
  begin
  
    -- build the Patient ID
    v_vPatientID := v_vPatientID || c_vPatient;
    v_vPatientID := v_vPatientID || GenerateRandomString(6);
    v_vPatientID := v_vPatientID || GetDateTimeString;
  
    return v_vPatientID;
  
  end;
  
  /*This function will return a provider id string*/
  function GetNewProviderID(pi_vFirstName   in varchar2,
                           pi_vLastName    in varchar2) return varchar2 is
  
    v_vProviderID varchar2(72) := '';
    v_vPadding   varchar2(12) := '00000000';
  
  begin
  
    -- build the Patient ID
    v_vProviderID := v_vProviderID || c_vProvider;
    v_vProviderID := v_vProviderID || GenerateRandomString(6);
    v_vProviderID := v_vProviderID || GetDateTimeString;
  
    return v_vProviderID;
  
  end;
  

  /*This function will return a provider id string*/
  function GetNewProviderID(pi_vFirstName in varchar2,
                            pi_vLastName  in varchar2,
                            pi_vNPI       in varchar2) return varchar2 
  is
  
    v_nPadLength number := 7;
    v_vPadding   varchar2(24) := '000000000000000000000000';
    v_vNPI       varchar2(24) := '';
    v_vNPISuffix varchar2(8) := '_NO_NPI';
  
    v_vProviderID varchar2(72) := '';
  
  begin
  
    --if  provider does not have NPI
    if ((pi_vNPI is null) OR (length(pi_vNPI) < 1)) then
      v_nPadLength := 14;
    else
      v_vNPI       := pi_vNPI;
      v_vNPISuffix := substr(v_vNPISuffix, -4);
    end if;
  
    v_vProviderID := v_vProviderID || c_vProvider || v_vNPISuffix;
    v_vProviderID := v_vProviderID || GenerateRandomString(6);
    v_vProviderID := v_vProviderID || GetDateTimeString;
    v_vProviderID := v_vProviderID ||
                     FromStringToNumber(substr(upper(pi_vFirstName ||
                                                     'AAAA'),
                                               1,
                                               4),
                                        2);
    v_vProviderID := v_vProviderID ||
                     FromStringToNumber(substr(upper(pi_vLastName || 'AAAA'),
                                               1,
                                               4),
                                        2);
    v_vProviderID := v_vProviderID || v_vNPI;
    v_vProviderID := v_vProviderID ||
                     substr(v_vPadding, (v_nPadLength * -1));
  
    return v_vProviderID;
  
  end;

  /* This function will return a contact patient id*/
  function GetNewContactPatientID(pi_vPatientID in varchar2) return varchar2 
  is
    v_vContactID varchar2(72) := '';
  begin
    v_vContactID := v_vContactID || c_vContact;
    v_vContactID := v_vContactID || substr(pi_vPatientID, 4);
    return v_vContactID;
  end;

  /*This function is used to return a numerical representation 
   of the alpha characters passed on.
   Where A=0 and Z=25
   The length of the returned value 
   for each character can be from 1 to 10 */
  function FromStringToNumber(pi_vString in varchar2, pi_nLength in number)
    return varchar2 
  is
  
    v_vResult  varchar2(32767) := '';
    v_vLetter  varchar2(1) := '';
    v_nCounter number;
    v_nASCII   number;
    v_nOffset  number := 65; --ASCII value for A is 65, we want the conversion starting at 0
    v_vPadding varchar2(10) := '0000000000';
  
  begin
  
    if length(pi_vString) > 0 then
      for v_nCounter in 1 .. length(pi_vString) loop
        v_vLetter := substr(upper(pi_vString), v_nCounter, 1);
        v_nASCII  := to_number(ic_utl_sec.VarcharToAscii(v_vLetter)) -
                     v_nOffset;
        v_vResult := v_vResult || substr(v_vPadding || to_char(v_nASCII),
                                         (pi_nLength * -1));
      
      end loop;
    end if;
    return v_vResult;
  end;

  /* This function is used to convert digits passed on to alpha characters
     Where 0 = A and 9 = J */
  function FromNumberToString(pi_vNumber in varchar2) return varchar2 
  
  is
  
    v_vResult  varchar2(32767) := '';
    v_vNumber  varchar2(1) := '';
    v_nNumber  number;
    v_nCounter number;
    v_nOffset  number := 65; --ASCII value for A is 65, we want the conversion starting at 0
  
  begin
  
    if length(pi_vNumber) > 0 then
      for v_nCounter in 1 .. length(pi_vNumber) loop
        v_vNumber := substr(upper(pi_vNumber), v_nCounter, 1);
        v_nNumber := to_number(v_vNumber) + v_nOffset;
        v_vResult := v_vResult || chr(v_nNumber);
      end loop;
    end if;
    return v_vResult;
  end;

  /* This function will generate a random alphanumeric characters string of N-Length*/
  function GenerateRandomString(pi_nLength in number) return varchar2 
  is
    v_vRandomChars raw(255);
    v_vResults     varchar2(255) := '';
  begin
    v_vRandomChars := dbms_crypto.randombytes(ceil(pi_nLength / 2));
    v_vResults     := v_vResults || v_vRandomChars;
    return v_vResults;
  end;

  /*
  This function will return a datetime string to the second resolution
  */
  function GetDateTimeString return varchar2 is
    v_vResults varchar2(24) := '';
  begin
    v_vResults := v_vResults || to_char(sysdate, 'mmddyyyyHHMMSS');
    return v_vResults;
  end;

end;
/
------------------------------------------------
--  Changed package body pck_system_settings  --
------------------------------------------------
create or replace package body tbicds.PCK_SYSTEM_SETTINGS is
  /* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
/*Get site recordset*/
   procedure GetSiteRS(pi_vSessionID       in varchar2,
                             pi_vSessionClientIP in varchar2,
                             pi_nUserID          in number,
                             po_nStatusCode      out number,
                             po_vStatusComment   out varchar2,
                             rs                  out RetRefCursor) 
   is
   
   begin
      po_nStatusCode    := 0;
      po_vStatusComment := null;
      
      open rs for 'select t.* from tbicds.Site t';
      
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_SYSTEM_SETTINGS.GetSiteRS(): ' || sqlErrm;
   end;

end;
/
-----------------------------------------
--  Changed package body pck_template  --
-----------------------------------------
create or replace package body tbicds.PCK_TEMPLATE is
/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
   
  /*get parsed template recordset*/ 
  procedure GetParsedTemplate2RS(pi_vSessionID       in varchar2,
                                 pi_vSessionClientIP in varchar2,
                                 pi_nUserID          in number,
                                 pi_vPatientID       in varchar2,
                                 pi_vEncounterID     in varchar2,
                                 pi_nTemplateID      in number,
                                 pi_vKey             in varchar2,
                                 po_nStatusCode      out number,
                                 po_vStatusComment   out varchar2,
                                 rs                  out RetRefCursor)
   is
      v_vSql          varchar2(4000);
      v_vTemplateText clob;
      rsTags          refCursor;
      rsFnTags        refCursor;
      v_recTags       tbicds.template_item%ROWTYPE;
      v_nPos          number;
      v_nPos2         number;
      v_vItemSQL      long;
      rsTagValue      refCursor;
      --v_vTagValue     varchar2(4000);
      v_vTagValue     clob;
      
      --Function tags
      v_vFnTag        varchar2(1000);
      v_nFnTagCount   number;
      v_nFnTagCtr     number;
      
      --Parameters. For the moment there is a limit of 3 parameters.
      type fnParams is varray(3) of varchar2(10);
      params fnParams := fnParams('', '', '');
   
      i number;
      p number; --parameter index

   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      v_vTemplateText   := '';
      v_nPos            := 0;
      v_nPos2           := 0;
      v_vItemSQL        := '';
      v_vTagValue       := '';
      v_vFnTag          := '';
  
      --get the tagged template text
      v_vSql := 'select template from tbicds.template where template_id = :P0';
      execute immediate v_vSql into v_vTemplateText using pi_nTemplateID;
      
      --open the recordset of all the possible tags
      open rsTags for 'select * from tbicds.template_item where description not like ''%(%)%''';
  
      --loop over items in the template_item table
      --and find and replace tags with values from the db
      LOOP
         v_recTags := null;
         FETCH rsTags INTO v_recTags;
         EXIT WHEN NOT rsTags%found;
         
         if v_recTags.description is not null then
            v_nPos := instr(v_vTemplateText, '[' || v_recTags.description || ']');
            
            if v_nPos != 0 then
               --format the sql to run for this tag
               v_vItemSQL := v_recTags.Item_Sql;
               v_vItemSQL := replace(v_vItemSQL, '~%s~', '''' || pi_vPatientID || '''');
               v_vItemSQL := replace(v_vItemSQL, '~%e~', '''' || pi_vEncounterID || '''');
               v_vItemSQL := replace(v_vItemSQL, '~%k~', '''' || pi_vKey || '''');
           
               --run the sql and get the value
               v_vTagValue := '';
               begin
                  open rsTagValue for v_vItemSQL;
                  FETCH rsTagValue INTO v_vTagValue;
                  close rsTagValue;
                
               exception
                  when others then
                     --error but keep processing the other tags
                     po_nStatusCode    := 1;
                     po_vStatusComment := po_vStatusComment || '<br>' || 'PCK_TEMPLATE.GetParsedTemplate2RS(): ' || sqlErrm;
                  
               end;
           
               v_vTemplateText := fnReplaceClob(v_vTemplateText, '[' || v_recTags.description || ']', v_vTagValue);
            end if;
         end if;
      END LOOP;
      CLOSE rsTags;
      
      
      --Function TAGs
      --open the recordset of all function tags
      open rsFnTags for 'select * from tbicds.template_item t where t.description like ''%(%)%''';
  
      --loop over the function tags and find and replace them with values from the db
      LOOP
         v_recTags := null;
         FETCH rsFnTags INTO v_recTags;
         EXIT WHEN NOT rsFnTags%found;
         
         if v_recTags.description is not null then
            v_nFnTagCount := REGEXP_COUNT(v_vTemplateText, replace(v_recTags.description,'()',''), 1, 'c');
--            v_vTemplateText := v_vTemplateText || to_char(v_nFnTagCount);
            for v_nFnTagCtr in 1 .. v_nFnTagCount
            loop
              --search for the function tag by using just the first part, e.g. "[fnName(" instead of "[fnName()]"
              --since they (the providers) could write anything between the parenthesis.
              v_nPos := instr(v_vTemplateText, '[' || replace(v_recTags.description,')',''));
              
              if v_nPos != 0 then
                 --there is one, so get the full fnTag they write, e.g. "[fnName(param1, param2)]"
                 v_nPos2 := instr(v_vTemplateText, ']', v_nPos);
                 v_vFnTag := substr(v_vTemplateText, v_nPos, v_nPos2 - v_nPos + 1); --full tag [fnName(param1, param2)]
                 
                 --Extract parameters from the fnTag (step 1 clear params variables, step 2 set parameter index & get the parameters
                 --clear params variables
                 for i in 1 .. params.count
                 loop
                   params(i) := '';
                 end loop;
                 --parameter index
                 p := 1;
                 --get the parameters
                 for i in instr(v_vFnTag, '(') + 1 .. length(v_vFnTag) - 2 -- Minus 2 to excluded the last two characters ")]" 
                 loop
                   if substr(v_vFnTag, i, 1) = ',' then
                     p := p + 1;
                   else
                     params(p) := params(p) || substr(v_vFnTag, i, 1);
                   end if;
                 end loop;
                 
                 --format the sql to run for this tag
                 v_vItemSQL := v_recTags.Item_Sql;
                 v_vItemSQL := replace(v_vItemSQL, '~%s~', '''' || pi_vPatientID || '''');
                 v_vItemSQL := replace(v_vItemSQL, '~%e~', '''' || pi_vEncounterID || '''');
                 v_vItemSQL := replace(v_vItemSQL, '~%k~', '''' || pi_vKey || '''');
                 
                 v_vItemSQL := replace(v_vItemSQL, '~%p1~', '''' || trim(params(1)) || '''');
                 v_vItemSQL := replace(v_vItemSQL, '~%p2~', '''' || trim(params(2)) || '''');
                 v_vItemSQL := replace(v_vItemSQL, '~%p3~', '''' || trim(params(3)) || '''');
             
                 --run the sql and get the value
                 v_vTagValue := '';
                 begin
                    open rsTagValue for v_vItemSQL;
                    FETCH rsTagValue INTO v_vTagValue;
                    close rsTagValue;
                  
                 exception
                    when others then
                       --error but keep processing the other tags
                       po_nStatusCode    := 1;
                       po_vStatusComment := po_vStatusComment || '<br>' || 'PCK_TEMPLATE.GetParsedTemplate2RS(): fnTag(x)' || sqlErrm;
                    
                 end;
             
                 v_vTemplateText := replace(v_vTemplateText, v_vFnTag, v_vTagValue);
              end if;
--                v_vTemplateText := v_vTemplateText || '.';
            end loop;
         end if;
--         v_vTemplateText := v_vTemplateText || ',';
      END LOOP;
      CLOSE rsFnTags;
--      v_vTemplateText := v_vTemplateText || ';';
      --open recordset
      open rs for select v_vTemplateText as template_text from dual;
  
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_TEMPLATE.GetParsedTemplate2RS(): ' || sqlErrm;
   end;

   /*
   Get template data tag recordset
   */
   procedure GetTemplateDataTagRS(pi_vSessionID       in varchar2,
                                 pi_vSessionClientIP in varchar2,
                                 pi_nUserID          in number,
                                 po_nStatusCode      out number,
                                 po_vStatusComment   out varchar2,
                                 rs                  out RetRefCursor)
   is
      v_vSql                               varchar2(4000);
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
  
      --open recordset
      v_vSql := 'select * from tbicds.template_item where active = 1 order by item_group_id';
      open rs for v_vSql;
  
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_TEMPLATE.GetTemplateDataTagRS(): ' || sqlErrm;
   end;

  /*
  Get template data tag group recordset
  */
  procedure GetTemplateDataTagGroupRS(pi_vSessionID       in varchar2,
                                      pi_vSessionClientIP in varchar2,
                                      pi_nUserID          in number,
                                      po_nStatusCode      out number,
                                      po_vStatusComment   out varchar2,
                                      rs                  out RetRefCursor)
   is
      v_vSql                               varchar2(4000);
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
  
      --open recordset
      v_vSql := 'select * from tbicds.template_item_group where active = 1 order by group_id ';
      open rs for v_vSql;
  
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_TEMPLATE.GetTemplateDataTagGroupRS(): ' || sqlErrm;
   end;

  /*
  Get template type recordset
  */
  procedure GetTemplateTypeRS(pi_vSessionID       in varchar2,
                              pi_vSessionClientIP in varchar2,
                              pi_nUserID          in number,
                              po_nStatusCode      out number,
                              po_vStatusComment   out varchar2,
                              rs                  out RetRefCursor)
   is
      v_vSql                               varchar2(4000);
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      --open recordset
      v_vSql := 'select * from tbicds.template_type where active = 1 order by type_id';
      open rs for v_vSql;
      
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_TEMPLATE.GetTemplateTypeRS(): ' || sqlErrm;
   end;

  /*
  Get template recordset
  */
  procedure GetTemplateRS(pi_vSessionID       in varchar2,
                          pi_vSessionClientIP in varchar2,
                          pi_nUserID          in number,
                          po_nStatusCode      out number,
                          po_vStatusComment   out varchar2,
                          rs                  out RetRefCursor)
   is
      v_vSql                               varchar2(4000);
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      --open recordset
      v_vSql := 'select t.*, tt.description as template_type '
                || 'from tbicds.template t, tbicds.template_type tt '
                || 'where t.type_id in (select type_id from tbicds.template_type where active = 1) '
                || 'and t.active = 1 '
                || 'and t.type_id = tt.type_id '
                || 'order by t.type_id ';
      open rs for v_vSql;
      
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_TEMPLATE.GetTemplateRS(): ' || sqlErrm;
   end;

  /*
  Get the templates of TypeID = {1 = Subjective, 2 = Objective, 
  3 = Assessment/Plan, 4 = Outcomes}
  */
  procedure GetTemplateRS(pi_vSessionID       in varchar2,
                          pi_vSessionClientIP in varchar2,
                          pi_nUserID          in number,
                          pi_nTypeID          in number,
                          po_nStatusCode      out number,
                          po_vStatusComment   out varchar2,
                          rs                  out RetRefCursor)
   is
      v_vSql                               varchar2(4000);
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      --open recordset
      v_vSql := 'select t.* '
                || 'from tbicds.template t '
                || 'where t.type_id = ' || pi_nTypeID || ' '
                || 'and t.active = 1 '
                || 'order by t.description';
      open rs for v_vSql;
      
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_TEMPLATE.GetTemplateRS(): ' || sqlErrm;
   end;
   
   /*
   Update a template
   */
   procedure UpdateTemplate(pi_vSessionID       in varchar2,
                           pi_vSessionClientIP in varchar2,
                           pi_nUserID          in number,
                           pi_nTemplateID      in number,
                           pi_nGroupID         in number,
                           pi_vTemplateName    in varchar2,
                           pi_vTemplateText    in clob,
                           po_nStatusCode      out number,
                           po_vStatusComment   out varchar2)
   is
      v_vSql                               varchar2(4000);
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      v_vSql := 'update tbicds.template set '
                || 'type_id = :P0, description = :P1, template = :P2 '
                || 'where template_id = :P3';
      execute immediate v_vSql using pi_nGroupID, pi_vTemplateName, pi_vTemplateText, pi_nTemplateID; 
      commit;

   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_TEMPLATE.UpdateTemplate(): ' || sqlErrm;
   end;

   /*
   Insert a template
   */
   procedure InsertTemplate(pi_vSessionID       in varchar2,
                           pi_vSessionClientIP in varchar2,
                           pi_nUserID          in number,
                           pi_nSOAPsectID      in number,
                           pi_vTemplateName    in varchar2,
                           pi_vTemplateText    in clob,
                           pi_nTempGroupID     in number,
                           po_nTemplateID      out number,
                           po_nStatusCode      out number,
                           po_vStatusComment   out varchar2)
   is
      v_vSql                               varchar2(4000);
   begin
      v_vSql := 'select tbicds.seqTemplateID.Nextval from dual';
      execute immediate v_vSql into po_nTemplateID;
       
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      v_vSql := 'insert into tbicds.template ('
                || 'template_id, type_id, description, template, creator_id, '
                || 'created_date, active, template_group_id) '
                || 'values (:P0, :P1, :P2, :P3, :P4, :P5, :P6, :P7)';
      execute immediate v_vSql using
         po_nTemplateID, pi_nSOAPsectID, pi_vTemplateName, pi_vTemplateText, pi_nUserID,
         sysdate, 1, pi_nTempGroupID;
      commit;

   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_TEMPLATE.UpdateTemplate(): ' || sqlErrm;
   end;

   /*
   Discontinue a template
   */
   procedure DiscontinueTemplate(pi_vSessionID       in varchar2,
                                pi_vSessionClientIP in varchar2,
                                pi_nUserID          in number,
                                pi_nTemplateID      in number,
                                po_nStatusCode      out number,
                                po_vStatusComment   out varchar2)
   is
      v_vSql                               varchar2(4000);
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      v_vSql := 'update tbicds.template set active = 0 where template_id = :P0';
      execute immediate v_vSql using pi_nTemplateID;
      commit;
   
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_TEMPLATE.DiscontinueTemplate(): ' || sqlErrm;
   end;

   /*Insert Template Group*/
   procedure InsertTemplateGroup(pi_vSessionID       in varchar2,
                             pi_vSessionClientIP in varchar2,
                             pi_nUserID          in number,
                             --
                             pi_vTemplateGrpName in varchar2,
                             pi_vComments        in varchar2,
                             --
                             po_nTemplateGrpID out number,
                             po_nStatusCode    out number,
                             po_vStatusComment out varchar2)
   is
      v_vSql                               varchar2(4000);
      v_nTemplateGrpID number;
   begin
      v_vSql := 'select tbicds.seqtemplategrpid.Nextval from dual';
      execute immediate v_vSql into v_nTemplateGrpID;
      
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      v_vSql := 'insert into tbicds.template_group ('
                || 'template_group_id, group_name, comments, active, created_by, '
                || 'last_updated, last_updated_by) '
                || 'values (:P0, :P1, :P2, :P3, :P4, :P5, :P6) ';
      execute immediate v_vSql using
         v_nTemplateGrpID,pi_vTemplateGrpName, pi_vComments, 1, pi_nUserID,
         sysdate, pi_nUserID;
      commit;
      
      po_nTemplateGrpID := v_nTemplateGrpID;
   
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_TEMPLATE.InsertTemplateGroup(): ' || sqlErrm;
         po_nTemplateGrpID := -1;
   end;

   /*Update Template Group*/
   procedure UpdateTemplateGroup(pi_vSessionID       in varchar2,
                             pi_vSessionClientIP in varchar2,
                             pi_nUserID          in number,
                             --
                             pi_nTemplateGrpID   in number,
                             pi_vTemplateGrpName in varchar2,
                             pi_vComments        in varchar2,
                             --
                             po_nStatusCode    out number,
                             po_vStatusComment out varchar2)
   is
      v_vSql                               varchar2(4000);
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      v_vSql := 'update tbicds.template_group t set '
                || 'group_name = :P0, '
                || 'comments = :P1, '
                || 'last_updated = sysdate, '
                || 'last_updated_by = :P2 '
                || 'where t.template_group_id = :P3 ';
      execute immediate v_vSql using pi_vTemplateGrpName, pi_vComments, pi_nUserID, pi_nTemplateGrpID;
      commit;
   
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_TEMPLATE.UpdateTemplateGroup(): ' || sqlErrm;
   end;

   /*Discontinue Template Group*/
   procedure DiscontinueTemplateGroup(pi_vSessionID       in varchar2,
                                  pi_vSessionClientIP in varchar2,
                                  pi_nUserID          in number,
                                  --
                                  pi_nTemplateGrpID in number,
                                  --
                                  po_nStatusCode    out number,
                                  po_vStatusComment out varchar2)
   is
      v_vSql                               varchar2(4000);
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      v_vSql := 'update tbicds.template_group set '
                || 'active = 0, last_updated = sysdate, last_updated_by = :P0 '
                || 'where template_group_id = :P1';
      execute immediate v_vSql using pi_nUserID, pi_nTemplateGrpID;
      commit;
      
      --also discontinue templates associated to the group
      v_vSql := 'update tbicds.template set active = 0 where TEMPLATE_GROUP_ID = :P0';
      execute immediate v_vSql using pi_nTemplateGrpID;
      commit;
      
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_TEMPLATE.DiscontinueTemplateGroup(): ' || sqlErrm;
   end;

   /*Get Template Groups recordset*/
   procedure GetTemplateGroupsRS(pi_vSessionID       in varchar2,
                                pi_vSessionClientIP in varchar2,
                                pi_nUserID          in number,
                                po_nStatusCode      out number,
                                po_vStatusComment   out varchar2,
                                rs                  out RetRefCursor) is
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      --open recordset
      open rs for
         'select * from tbicds.template_group t where t.active = 1';
   
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_TEMPLATE.GetTemplateGroupsRS(): ' || sqlErrm;
   end;

   /*Get Group Templates*/
   procedure GetGroupTemplatesRS(pi_vSessionID       in varchar2,
                             pi_vSessionClientIP in varchar2,
                             pi_nUserID          in number,
                             
                             pi_nGroupID in number,
                             
                             po_nStatusCode    out number,
                             po_vStatusComment out varchar2,
                             rs                out RetRefCursor)
   is
      v_vSql                               varchar2(4000);
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      --open recordset
      v_vSql := 'select t.*, tt.description as template_type '
                || 'from tbicds.template t, tbicds.template_type tt '
                || 'where t.type_id in (select type_id from tbicds.template_type where active = 1) '
                || 'and t.active = 1 '
                || 'and t.type_id = tt.type_id '
                || 'and t.template_group_id = :P0 '
                || 'order by t.type_id, t.template_group_id';
      open rs for v_vSql using pi_nGroupID;
      
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_TEMPLATE.GetGroupTemplatesRS(): ' || sqlErrm;
   end;

   /*Get parsed template text*/
   function fnGetParsedTemplateText(pi_vPatientID    in varchar2,
                                   pi_vKey          in varchar2,
                                   pi_vTemplateText in varchar2) return clob 
   is
      v_vTemplateText clob;
      rsTags     refCursor;
      v_recTags  tbicds.template_item%ROWTYPE;
      v_nPos     number;
      v_vItemSQL long;
      rsTagValue  refCursor;
      v_vTagValue varchar2(4000);
   begin
      v_vTemplateText := '';
      v_nPos          := 0;
      v_vItemSQL      := '';
      v_vTagValue     := '';
      
      --get the tagged template text
      v_vTemplateText := pi_vTemplateText;
      
      --open the recordset of all the possible tags
      open rsTags for 'select * from tbicds.template_item';
      --loop over items in the template_item table
      --and find and replace tags with values from the db
      LOOP
         v_recTags := null;
         FETCH rsTags INTO v_recTags;
         EXIT WHEN NOT rsTags%found;
         
         if v_recTags.description is not null then
            v_nPos := instr(v_vTemplateText, '[' || v_recTags.description || ']');
            
            if v_nPos != 0 then
               --format the sql to run for this tag
               v_vItemSQL := v_recTags.Item_Sql;
               v_vItemSQL := replace(v_vItemSQL, '~%s~', '''' || pi_vPatientID || '''');
               v_vItemSQL := replace(v_vItemSQL, '~%k~', '''' || pi_vKey || '''');
               
               --run the sql and get the value
               v_vTagValue := '';
               begin
                  open rsTagValue for v_vItemSQL;
                  FETCH rsTagValue INTO v_vTagValue;
                  close rsTagValue;
               end;
               
               v_vTemplateText := replace(v_vTemplateText, '[' || v_recTags.description || ']', v_vTagValue);
            end if;
         end if;
      END LOOP;
      CLOSE rsTags;
      
      return v_vTemplateText;
   
   end;
   
   /*replace pieces in a  clob*/
   function fnReplaceClob (pi_source in clob
                          ,pi_search in varchar2
                          ,pi_replace in clob) return clob 
   is
   l_pos pls_integer;
   begin
        l_pos := instr(pi_source, pi_search);
        if l_pos > 0 then
           return substr(pi_source, 1, l_pos-1) || pi_replace || substr(pi_source, l_pos + length(pi_search));
           end if;
        return pi_source;
    end;
end;
/
-------------------------------------
--  Changed package body pck_user  --
-------------------------------------
create or replace package body tbicds.PCK_USER is
/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
   /*get login user record set*/
   procedure GetLoginUserRS (
      pi_vSessionID              in varchar2,
      pi_vSessionClientIP        in varchar2,
      pi_nUserID                 in number,
      pi_vKey                    in varchar2,
      pi_nFXUserID               in number,
      po_nStatusCode             out number,
      po_vStatusComment          out varchar2,
      rs                         out RetRefCursor)
   is
      v_vSql                               varchar2(4000);
      v_nTemp         number;
      v_nCount        number;
      v_nPatUserType  number := 32768;
      v_nRovUserTypes  number := 59;
   begin
      v_nTemp := 0;
      po_nStatusCode := 0;--0 = success
      po_vStatusComment := '';
      v_nCount := 0;

      v_vSql := 'select count(*) '
                || 'from tbicds.fx_user t1, tbicds.fx_user_rights t2 '
                || 'where t2.fx_user_id = t1.fx_user_id '
                || 'and bitand(t2.user_type, :P0) > 0 '
                || 'and t1.fx_user_id = :P1 ';
      execute immediate v_vSql into v_nCount using v_nRovUserTypes, pi_nFXUserID;
      
      --open recordset
      if v_nCount > 0 then
         --check for user account
         v_vSql := 'select t1.fx_user_id, t1.date_last_login, t1.last_login_ip, t1.last_flogin_date, t1.last_flogin_ip, '
                   || 't1.flogin_attempts, t3.User_Type, t3.user_rights, t3.read_only, t2.dims_id, '
                   || 't2.provider_id, '
                   --less than or equal to zero means we are expired!
                   || 'floor(60 - (trunc(sysdate) - t1.date_password_changed)) as days_till_expiration, '
                   || 't2.name '
                   || 'from tbicds.fx_user t1, tbicds.app_user t2, tbicds.fx_user_rights t3 '
                   || 'where t2.fx_user_id = t1.fx_user_id '
                   || 'and t3.fx_user_id = t1.fx_user_id '
                   || 'and t1.fx_user_id = :P0 ';
         open rs for v_vSql using pi_nFXUserID;
      else
         --is a patient account
         v_vSql := 'select t1.fx_user_id, t1.date_last_login, t1.last_login_ip, t1.last_flogin_date, t1.last_flogin_ip, '
                    || 't1.flogin_attempts, :P0 as User_Type, 0 as user_rights, 0 as read_only, 0 as dims_id, '
                    || ''''' as provider_id, '
                    --less than or equal to zero means we are expired!
                    || 'floor(60 - (trunc(sysdate) - t1.date_password_changed)) as days_till_expiration, '
                    || '(tbicds.fnc_utl_decstr(t2.FIRST_NAME, :P1, t2.PATIENT_ID)||'' ''||tbicds.fnc_utl_decstr(t2.LAST_NAME, :P2, t2.PATIENT_ID)) as name '
                    || 'from tbicds.fx_user t1, tbicds.patient_demographics t2 '
                    || 'where t2.fx_user_id = t1.fx_user_id '
                    || 'and t1.fx_user_id = :P3 ';
         open rs for v_vSql using v_nPatUserType, pi_vKey, pi_vKey, pi_nFXUserID;
       end if;

   exception
      when others
      then
         po_nStatusCode := 1;
         po_vStatusComment := '421 - An error occurred while retrieving user infromation, Please contact your system administrator.';
   end;

end;
/
-------------------------------------------
--  Changed package body pck_user_admin  --
-------------------------------------------
create or replace package body tbicds.PCK_USER_ADMIN is
/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
   /*
   get a record set of users back that match criteria
   */
   procedure GetUserLookupRS(pi_vSessionID       in varchar2,
                            pi_vSessionClientIP in varchar2,
                            pi_nUserID          in number,
                            pi_vDMISID          in varchar2,
                            po_nStatusCode      out number,
                            po_vStatusComment   out varchar2,
                            rs                  out RetRefCursor)
   is
      v_vSql                               varchar2(4000);
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';  
   
      --open recordset
      v_vSql := 'SELECT distinct * '
                || 'FROM tbicds.app_user s '
                || 'WHERE DIMS_ID = :P0 '
                || 'ORDER BY upper(NAME) asc, ENTRY_DATE desc ';
      open rs for v_vSql using pi_vDMISID;
   
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_USER_ADMIN.getUserLookupRS(): ' || sqlErrm;
   end;

   /*
   get a record set of users back that match criteria
   */
   procedure GetUserLookupBySearchRS(pi_vSessionID       in varchar2,
                                 pi_vSessionClientIP in varchar2,
                                 pi_nUserID          in number,
                                 pi_vSearchValue     in varchar2,
                                 po_nStatusCode      out number,
                                 po_vStatusComment   out varchar2,
                                 rs                  out RetRefCursor)
   is
      v_vSql                               varchar2(4000);
      strSQL       varchar2(300);
      strSelectSQL varchar2(300);
      v_bHQRights     boolean;
      v_bMAJCOMRights boolean;
      v_vDMISID       varchar(50);
      v_nMAJCOMID     number;
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      v_vSql := 'select dims_id from tbicds.app_user where fx_user_id = :P0';
      execute immediate v_vSql into v_vDMISID using pi_nUserID;
      
      v_vSql := 'select majcom_id from tbicds.stat_dims_base where dims_id = :P0';
      execute immediate v_vSql into v_nMAJCOMID using v_vDMISID;
      
      --open recordset
      v_vSql := 'select * from tbicds.app_user s '
                || 'where UPPER(s.name) like :P0 '
                || 'order by s.dims_id, upper(s.name) asc, s.entry_date desc';
      open rs for v_vSql using UPPER('%'||pi_vSearchValue||'%');
      return;
   
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_USER_ADMIN.getUserLookupBySearchRS(): ' || sqlErrm;
   end;

   /*
   Get user recordset
   */
   procedure GetSuatUserRS(pi_vSessionID       in varchar2,
                          pi_vSessionClientIP in varchar2,
                          pi_nUserID          in number,
                          pi_vProviderID      in varchar2,
                          po_nStatusCode      out number,
                          po_vStatusComment   out varchar2,
                          rs                  out RetRefCursor)
   is
      v_vSql                               varchar2(4000);
      v_vDMISID varchar(50);
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      v_vSql := 'select dims_id from tbicds.app_user where provider_id = :P0';
      execute immediate v_vSql into v_vDMISID using pi_vProviderID;
      
      --open recordset
      v_vSql := 'select user_type, name, rank, military_service_id, title, '
                || 'unit, corps, squadron, phone, email, '
                || 'dims_id, r.user_rights, locked '
                || 'from tbicds.app_user t, tbicds.fx_user_rights r '
                || 'where provider_id = :P0 '
                || 'and r.fx_user_id = t.fx_user_id '
                || 'and dims_id = :P1 ';
      open rs for v_vSql using pi_vProviderID, v_vDMISID;
   
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_USER_ADMIN.GetSuatUserRS(): ' || sqlErrm;
   end;

   /*
   Get user name recordset
   */
   procedure GetSuatUserNameRS(pi_vSessionID       in varchar2,
                        pi_vSessionClientIP in varchar2,
                        pi_nUserID          in number,
                        pi_nFXUserID        in number,
                        po_nStatusCode      out number,
                        po_vStatusComment   out varchar2,
                        rs                  out RetRefCursor)
   is
      v_vSql                               varchar2(4000);
      v_vDMISID varchar(50);
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      --open recordset
      v_vSql := 'select user_type, name, rank, military_service_id, title, '
                || 'unit, corps, squadron, phone, email, '
                || 'dims_id, r.user_rights, locked, t.graph_pref '
                || 'from tbicds.app_user t, tbicds.fx_user_rights r '
                || 'where t.fx_user_id = :P0 '
                || 'and r.fx_user_id = t.fx_user_id ';
      open rs for v_vSql using pi_nFXUserID;
      
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_USER_ADMIN.GetSuatUserNameRS(): ' || sqlErrm;
   end;

   /*
   Get facility information recordset
   */
   procedure GetFacilityInfoRS(pi_vSessionID       in varchar2,
                           pi_vSessionClientIP in varchar2,
                           pi_nUserID          in number,
                           po_nStatusCode      out number,
                           po_vStatusComment   out varchar2,
                           rs                  out RetRefCursor) is
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      --open recordset
      open rs for
         'select * from tbicds.site t';
   
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_USER_ADMIN.GetFacilityInfoRS(): ' || sqlErrm;
   end;

   /*
   Insert a facility
   */
   procedure InsertFacilityInfo(pi_vSessionID       in varchar2,
                            pi_vSessionClientIP in varchar2,
                            pi_nUserID          in number,
                            pi_vSiteID          in varchar2,
                            pi_vSiteName        in varchar2,
                            pi_vSiteAddress1    in varchar2,
                            pi_vSiteCity        in varchar2,
                            pi_vSiteState       in varchar2,
                            pi_vSitePostalCode  in varchar2,
                            po_nStatusCode      out number,
                            po_vStatusComment   out varchar2)
   is
      v_vSql                               varchar2(4000);
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      v_vSql := 'insert into tbicds.site ('
                || 'site_id, site_name, site_address_1, site_city, site_state, site_postal_code) '
                || 'values (:P0, :P1, :P2, :P3, :P4, :P5) ';
      execute immediate v_vSql using
         pi_vSiteID, pi_vSiteName, pi_vSiteAddress1, pi_vSiteCity, pi_vSiteState, pi_vSitePostalCode;
      commit;
   
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_User_Admin.InserFacilityInfo(): ' || sqlErrm;
   end;

   /*
   Update a facility
   */
   procedure UpdateFacilityInfo(pi_vSessionID       in varchar2,
                            pi_vSessionClientIP in varchar2,
                            pi_nUserID          in number,
                            pi_vSiteID          in varchar2,
                            pi_vSiteName        in varchar2,
                            pi_vSiteAddress1    in varchar2,
                            pi_vSiteCity        in varchar2,
                            pi_vSiteState       in varchar2,
                            pi_vSitePostalCode  in varchar2,
                            po_nStatusCode      out number,
                            po_vStatusComment   out varchar2)
   is
      v_vSql                               varchar2(4000);
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      v_vSql := 'update tbicds.site set '
                || 'site_id = :P0, '
                || 'site_name = :P1, '
                || 'site_address_1 = :P2, '
                || 'site_city = :P3, '
                || 'site_state = :P4, '
                || 'site_postal_code = :P5 ';
      execute immediate v_vSql using
         pi_vSiteID, pi_vSiteName, pi_vSiteAddress1, pi_vSiteCity, pi_vSiteState, pi_vSitePostalCode; 
      commit;
   
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_USER_ADMIN.UpdateFacilityInfo(): ' || sqlErrm;
   end;

   /*
   Update graph preference
   */
   procedure UpdateGraphPref(pi_vSessionID       in varchar2,
                         pi_vSessionClientIP in varchar2,
                         pi_nUserID          in number,
                         pi_nGraphOpt        in varchar2,
                         po_nStatusCode      out number,
                         po_vStatusComment   out varchar2)
   is
      v_vSql                               varchar2(4000);
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      v_vSql := 'update tbicds.app_user t set t.graph_pref = :P0 where t.fx_user_id = :P1 ';
      execute immediate v_vSql using pi_nGraphOpt, pi_nUserID; 
      commit;
   
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_USER_ADMIN.UpdateGraphPref(): ' || sqlErrm;
   end;

   /*
   Get graph preference
   */
   procedure GetGraphPref(pi_vSessionID       in varchar2,
                      pi_vSessionClientIP in varchar2,
                      pi_nUserID          in number,
                      po_nStatusCode      out number,
                      po_vStatusComment   out varchar2,
                      rs                  out RetRefCursor)
   is
      v_vSql                               varchar2(4000);
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      v_vSql := 'select * from tbicds.app_user t where t.fx_user_id = :P0';
      open rs for v_vSql using pi_nUserID;
      
   exception
      when others then
         po_nStatusCode    := 1;
         po_vStatusComment := 'PCK_USER_ADMIN.GetGraphPref(): ' || sqlErrm;
   end;

end;
/
----------------------------------------------
--  Changed package body pck_user_calendar  --
----------------------------------------------
CREATE OR REPLACE PACKAGE body tbicds.PCK_USER_CALENDAR
IS
/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
/* Get all events recordset */
PROCEDURE GetAllEventsRS(
    pi_vSessionID       IN VARCHAR2,
    pi_vSessionClientIP IN VARCHAR2,
    pi_nUserID          IN NUMBER,
    rs OUT PCK_COMMON.refCursor,
    po_nStatusCode OUT NUMBER,
    po_vStatusComment OUT VARCHAR2)
is
  v_vSQL VARCHAR2(32767);
BEGIN
  -- reset status parameters
  po_nStatusCode    := 0;
  po_vStatusComment := '';
  --define sql statement string
  --open cursor
  OPEN rs FOR SELECT * FROM dev_calendar t;
EXCEPTION
WHEN OTHERS THEN
  po_nStatusCode    := 1;
  po_vStatusComment := '';
END;

/* Update event by event_id */
PROCEDURE UpdateEvent(
    pi_vSessionID       IN VARCHAR2,
    pi_vSessionClientIP IN VARCHAR2,
    pi_nUserID          IN NUMBER,
    pi_nEventID         IN NUMBER,
    pi_nCalendarID      IN NUMBER,
    pi_vTitle           IN VARCHAR2,
    pi_vStartDate       IN VARCHAR2,
    pi_vEndDate         IN VARCHAR2,
    pi_vLocation        IN VARCHAR2,
    pi_vNotes           IN VARCHAR2,
    pi_vReminder        IN VARCHAR2,
    pi_vUrl             IN VARCHAR2,
    pi_nAllDay          IN NUMBER,
    po_nStatusCode OUT NUMBER,
    po_vStatusComment OUT VARCHAR2)
is
  dtStartDate DATE := NULL;
  dtEndDate   DATE := NULL;
BEGIN
  -- reset status parameters
  po_nStatusCode          := 0;
  po_vStatusComment       := '';
  IF LENGTH(pi_vStartDate) > 0 THEN
    dtStartDate           := to_date(pi_vStartDate, 'MM/DD/YYYY HH:MI:SS AM');
  END IF;
  IF LENGTH(pi_vEndDate) > 0 THEN
    dtEndDate           := to_date(pi_vEndDate, 'MM/DD/YYYY HH:MI:SS AM');
  END IF;
  UPDATE dev_calendar t
  SET t.title      = pi_vTitle,
    t.start_date   = dtStartDate,
    t.end_date     = dtEndDate,
    t.calendar_id  = pi_nCalendarID,
    t.is_all_day   = pi_nAllDay,
    t.location     = pi_vLocation,
    t.notes        = pi_vNotes,
    t.reminder     = pi_vReminder,
    t.url          = pi_vUrl
  WHERE t.event_id = pi_nEventID;
  COMMIT;
EXCEPTION
WHEN OTHERS THEN
  po_nStatusCode    := 1;
  po_vStatusComment := '';
END;

/* Insert event */
PROCEDURE InsertEvent(
    pi_vSessionID       IN VARCHAR2,
    pi_vSessionClientIP IN VARCHAR2,
    pi_nUserID          IN NUMBER,
    --pi_nEventID         IN NUMBER,
    pi_nCalendarID      IN NUMBER,
    pi_vTitle           IN VARCHAR2,
    pi_vStartDate       IN VARCHAR2,
    pi_vEndDate         IN VARCHAR2,
    pi_vLocation        IN VARCHAR2,
    pi_vNotes           IN VARCHAR2,
    pi_vReminder        IN VARCHAR2,
    pi_vUrl             IN VARCHAR2,
    pi_nAllDay          IN NUMBER,
    po_nStatusCode OUT NUMBER,
    po_vStatusComment OUT VARCHAR2)
is
  dtStartDate DATE := NULL;
  dtEndDate   DATE := NULL;
BEGIN
  -- reset status parameters
  po_nStatusCode          := 0;
  po_vStatusComment       := '';
  IF LENGTH(pi_vStartDate) > 0 THEN
    dtStartDate           := to_date(pi_vStartDate, 'MM/DD/YYYY HH:MI:SS AM');
  END IF;
  IF LENGTH(pi_vEndDate) > 0 THEN
    dtEndDate           := to_date(pi_vEndDate, 'MM/DD/YYYY HH:MI:SS AM');
  END IF;
  INSERT
  INTO DEV_CALENDAR
    (
      CALENDAR_ID,
      END_DATE,
      IS_ALL_DAY,
      LOCATION,
      NOTES,
      REMINDER,
      START_DATE,
      TITLE,
      URL,
      PATIENT_ID,
      PROVIDER_ID
    )
    VALUES
    (
      pi_nCalendarID,
      dtEndDate,
      pi_nAllDay,
      pi_vLocation,
      pi_vNotes,
      pi_vReminder,
      dtStartDate,
      pi_vTitle,
      pi_vUrl,
      '',
      ''
    );
  COMMIT;
EXCEPTION
WHEN OTHERS THEN
  po_nStatusCode    := 1;
  po_vStatusComment := '';
END;

/* Get all calendars recordset */
PROCEDURE GetAllCalendarsRS
  (
    pi_vSessionID       IN VARCHAR2,
    pi_vSessionClientIP IN VARCHAR2,
    pi_nUserID          IN NUMBER,
    rs OUT PCK_COMMON.refCursor,
    po_nStatusCode OUT NUMBER,
    po_vStatusComment OUT VARCHAR2
  )
is
  v_vSQL VARCHAR2(32767);
BEGIN
  -- reset status parameters
  po_nStatusCode    := 0;
  po_vStatusComment := '';
  --define sql statement string
  --open cursor
  OPEN rs FOR SELECT * FROM dev_stat_calendar t WHERE t.active = 1;
EXCEPTION
WHEN OTHERS THEN
  po_nStatusCode    := 1;
  po_vStatusComment := '';
END;

END PCK_USER_CALENDAR;
/
------------------------------------------------
--  Changed package body pck_utl_export_data  --
------------------------------------------------
create or replace package body tbicds.PCK_UTL_EXPORT_DATA is
/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/   
   /*get static data item*/
   function demoValue_STAT (
      pi_vVariableName                  in varchar2,
      pi_vVariableValue                 in varchar2
      ) return                             varchar2
   is
      v_vValue                             varchar2(4000);
      v_vSql                               varchar2(4000);
   begin
      v_vSql := 'select item from stat_data_collection '
                ||'where collection_type = ''_'||pi_vVariableName||''' and collection_item_id = :P';
      execute immediate v_vSql into v_vValue using pi_vVariableValue;
      return v_vValue;
      
   exception
      when others 
      then 
         return null;
   end;

   /*Get patient data with static data*/
   function demoValue_TBL (
      pi_vVariableName                  in varchar2,
      pi_vPatientID                     in varchar2
      ) return                             varchar2
   is
      v_vValue                             varchar2(4000);
      v_vSql                               varchar2(4000); 
   begin
      v_vSql := 'select wm_concat(s.item) '
                ||'from patient_'||pi_vVariableName||' t, stat_data_collection s '
                ||'where t.patient_id = :P '
                ||'and s.collection_type = ''_'||pi_vVariableName||''' '
                ||'and t.'||pi_vVariableName||'_ID = s.collection_item_id'; 
      execute immediate v_vSql into v_vValue using pi_vPatientID;
      return v_vValue;
      
   exception
      when others 
      then 
         return null;
   end;

   /*Get socioeconomic data*/
   function demoValue_SE (
      pi_vVariableName                  in varchar2,
      pi_vPatientID                     in varchar2
      ) return                             varchar2
   is
      v_vValue                             varchar2(4000);
      v_vSql                               varchar2(4000); 
   begin
      v_vSql := 'select wm_concat(s.item) '
                ||'from patient_socioeconomic t, stat_data_collection s '
                ||'where t.patient_id = :P '
                ||'and s.collection_type = ''_'||pi_vVariableName||''' '
                ||'and t.'||pi_vVariableName||'_ID = s.collection_item_id';
      execute immediate v_vSql into v_vValue using pi_vPatientID;
      return v_vValue;
      
   exception
      when others 
      then 
         return null;
   end;
   
   /*Get last response value*/
   function latestResponseValue (
      pi_vPatientID                     in varchar2,
      pi_nMID                           in number,
      pi_nTID                           in number,
      pi_nQID                           in number
      ) return                             varchar2
   is
      v_vSql                               varchar2(4000);
      v_vValue                             varchar2(32767);
   begin
      v_vSql := 'select response_value '
                ||'from data_intake_responses t '
                ||'where patient_id = :P and mid = :M and tid = :T and qid = :Q '
                ||'and intake_id = ('
                ||'select max(intake_id) from data_intake_responses s '
                ||'where s.patient_id = t.patient_id and s.mid = t.mid and s.tid = t.tid and s.qid = t.qid) ';
      execute immediate v_vSql into v_vValue using pi_vPatientID, pi_nMID, pi_nTID, pi_nQID;

      return v_vValue;
      
   exception
      when others 
      then 
         return null;
   end;
      
   /*Get last radio responcse value*/
   function latestResponseValue_Radio (
      pi_vPatientID                     in varchar2,
      pi_nMID                           in number,
      pi_nTID                           in number,
      pi_nQID                           in number
      ) return                             varchar2
   is
      v_vSql                               varchar2(4000);
      v_vSql_SkipShow                      varchar2(4000);
      v_vValue                             varchar2(32767);
      v_nRID                               number;
      v_nTID                               number;
      v_nQID                               number;
      v_vSkipShow                          varchar2(128);
   begin
      v_vSql := 'select response_value, rid '
                ||'from data_intake_responses t '
                ||'where patient_id = :P and mid = :M and tid = :T and qid = :Q '
                ||'and intake_id = ('
                ||'select max(intake_id) from data_intake_responses s '
                ||'where s.patient_id = t.patient_id and s.mid = t.mid and s.tid = t.tid and s.qid = t.qid) ';
      execute immediate v_vSql into v_vValue, v_nRID using pi_vPatientID, pi_nMID, pi_nTID, pi_nQID;

      if (regexp_like (v_vValue, 'other', 'i'))
      then
         v_vSql_SkipShow := 'select skip_show from intake_response where mid = :M and tid = :T and qid = :Q and rid = :R';
         execute immediate v_vSql_SkipShow into v_vSkipShow using pi_nMID, pi_nTID, pi_nQID, v_nRID;
         
         v_nTID := to_number(substr(regexp_substr(v_vSkipShow, 'TID[[:digit:]]+'), 4));
         v_nQID := to_number(substr(regexp_substr(v_vSkipShow, 'QID[[:digit:]]+'), 4));
         
         execute immediate v_vSql into v_vValue, v_nRID using pi_vPatientID, pi_nMID, v_nTID, v_nQID;
      end if;

      return v_vValue;
      
   exception
      when others 
      then 
         return null;
   end;

   /*Get demographic variables*/
   function getDemoVariables (
      pi_vDataIncluded                  in varchar2,
      pi_vKey                           in varchar2
      ) return                             varchar2
   is
   
      v_vVariableList                      varchar2(32767);
      v_vVariable                          varchar2(128);
      v_vValue                             varchar2(4000);

      -- addVariable()
      procedure addVariable (
         pi_vDataIncluded                  in varchar2,
         pi_vVariable                      in varchar2,
         pi_vValue                         in varchar2,
         pio_vVariableList             in out varchar2
         )
      is
      begin
         if (instr(pi_vDataIncluded,','||pi_vVariable||',') > 0 or pi_vVariable = 'PATIENT_ID')
         then
            pio_vVariableList := pio_vVariableList||','||pi_vValue||' '||pi_vVariable;
         elsif (c_nShowNotIncluded = 1)
         then
            pio_vVariableList := pio_vVariableList||','||'null '||pi_vVariable;
         end if;
      end;
   begin
      v_vVariable := 'PATIENT_ID';
      v_vValue := 'D.PATIENT_ID';
      addVariable(pi_vDataIncluded, v_vVariable, v_vValue, v_vVariableList);
      
      /*v_vVariable := 'DATE_COMPLETED';
      v_vValue := 'I.DATE_COMPLETED';
      addVariable(pi_vDataIncluded, v_vVariable, v_vValue, v_vVariableList);*/

      v_vVariable := 'CITY';
      v_vValue := v_vVariable;
      addVariable(pi_vDataIncluded, v_vVariable, v_vValue, v_vVariableList);

      v_vVariable := 'STATE';
      v_vValue := 'PCK_UTL_EXPORT_DATA.demoValue_STAT('''||'STATES'||''',d.'||v_vVariable||'_ID)';
      addVariable(pi_vDataIncluded, v_vVariable, v_vValue, v_vVariableList);
      
      v_vVariable := 'POSTAL_CODE';
      v_vValue := v_vVariable;
      addVariable(pi_vDataIncluded, v_vVariable, v_vValue, v_vVariableList);
      
      v_vVariable := 'DOB';
      v_vValue := 'ic_utl_sec.decryptdata('||v_vVariable||','''||pi_vKey||''',d.patient_id)';
      addVariable(pi_vDataIncluded, v_vVariable, v_vValue, v_vVariableList);
      
      v_vVariable := 'GENDER';
      v_vValue := 'ic_utl_sec.decryptdata('||v_vVariable||','''||pi_vKey||''',d.patient_id)';
      addVariable(pi_vDataIncluded, v_vVariable, v_vValue, v_vVariableList);
      
      v_vVariable := 'DUTY_STATUS';
      v_vValue := 'PCK_UTL_EXPORT_DATA.demoValue_STAT('''||v_vVariable||''',d.'||v_vVariable||'_ID)';
      addVariable(pi_vDataIncluded, v_vVariable, v_vValue, v_vVariableList);

      v_vVariable := 'PREFERRED_LANGUAGE';
      v_vValue := 'PCK_UTL_EXPORT_DATA.demoValue_STAT('''||v_vVariable||''',d.'||v_vVariable||'_ID)';
      addVariable(pi_vDataIncluded, v_vVariable, v_vValue, v_vVariableList);

      v_vVariable := 'ETHNICITY';
      v_vValue := 'PCK_UTL_EXPORT_DATA.demoValue_TBL('''||v_vVariable||''',d.patient_id)';
      addVariable(pi_vDataIncluded, v_vVariable, v_vValue, v_vVariableList);

      v_vVariable := 'RACE';
      v_vValue := 'PCK_UTL_EXPORT_DATA.demoValue_TBL('''||v_vVariable||''',d.patient_id)';
      addVariable(pi_vDataIncluded, v_vVariable, v_vValue, v_vVariableList);

      v_vVariable := 'HAND_PREFERENCE';
      v_vValue := 'PCK_UTL_EXPORT_DATA.demoValue_STAT('''||v_vVariable||''',d.'||v_vVariable||'_ID)';
      addVariable(pi_vDataIncluded, v_vVariable, v_vValue, v_vVariableList);

      v_vVariable := 'HIGHEST_GRADE_LEVEL';
      v_vValue := 'PCK_UTL_EXPORT_DATA.demoValue_SE('''||'HIGHEST_GRADE'||''',d.patient_id)';
      addVariable(pi_vDataIncluded, v_vVariable, v_vValue, v_vVariableList);

      v_vVariable := 'HIGHEST_DEGREE_OBTAINED';
      v_vValue := 'PCK_UTL_EXPORT_DATA.demoValue_SE('''||'HIGHEST_DEGREE'||''',d.patient_id)';
      addVariable(pi_vDataIncluded, v_vVariable, v_vValue, v_vVariableList);

      v_vVariable := 'MARITAL_STATUS';
      v_vValue := 'PCK_UTL_EXPORT_DATA.demoValue_SE('''||v_vVariable||''',d.patient_id)';
      addVariable(pi_vDataIncluded, v_vVariable, v_vValue, v_vVariableList);
      
      v_vVariable := 'EMPLOYMENT_STATUS';
      v_vValue := 'PCK_UTL_EXPORT_DATA.demoValue_SE('''||v_vVariable||''',d.patient_id)';
      addVariable(pi_vDataIncluded, v_vVariable, v_vValue, v_vVariableList);

      v_vVariable := 'JOB_CLASS_CAT';
      v_vValue := 'PCK_UTL_EXPORT_DATA.demoValue_SE('''||'JOB_CLASSIFICATION'||''',d.patient_id)';
      addVariable(pi_vDataIncluded, v_vVariable, v_vValue, v_vVariableList);
      
      v_vVariable := 'PRIMARY_IMP';
      v_vValue := 'PCK_UTL_EXPORT_DATA.latestResponseValue_Radio(d.patient_id, 3000, 1, 1)';
      addVariable(pi_vDataIncluded, v_vVariable, v_vValue, v_vVariableList);

      v_vVariable := 'PRIMARY_IMP_DATE';
      v_vValue := 'PCK_UTL_EXPORT_DATA.latestResponseValue(d.patient_id, 3000, 1, 3)';
      addVariable(pi_vDataIncluded, v_vVariable, v_vValue, v_vVariableList);

      v_vVariable := 'MCH_INJURY';
      v_vValue := 'PCK_UTL_EXPORT_DATA.latestResponseValue_Radio(d.patient_id, 3000, 1, 4)';
      addVariable(pi_vDataIncluded, v_vVariable, v_vValue, v_vVariableList);

      v_vVariable := 'COMORBIDITY';
      v_vValue := 'PCK_UTL_EXPORT_DATA.latestResponseValue(d.patient_id, 3000, 1, 6)';
      addVariable(pi_vDataIncluded, v_vVariable, v_vValue, v_vVariableList);

      return v_vVariableList||' ';

   exception
      when others
      then
         return null;
   end;
   
   /*get where clause*/
   function getWhereclause (
      pi_vFilters                       in varchar2
      ) return                             varchar2
   is
      v_vWhereClause                       varchar2(4000);
      v_vDateFormat_Filter                 varchar2(30) := 'yyyymmdd';
      v_vTemp                              varchar2(4000);
      v_vFilter                            varchar2(4000);
      v_vValue                             varchar2(128);
      v_nPos                               number;
      v_bOutpatient                        boolean := false;                
      v_bInpatient                         boolean := false;                
      v_vClinicalStt                       varchar2(3);
      v_nProgram                           number := -1;
      v_nRegion                            number := -1;
      v_nSite                              number := -1;
   begin
      -- set where clause using filters
      v_vTemp := lower(pi_vFilters)||',';
      while (v_vTemp is not null)
      loop
         v_nPos := instr(v_vTemp, ',');
         v_vFilter := substr(v_vTemp, 1, v_nPos-1);
         v_vTemp := substr(v_vTemp, v_nPos+1);
         
         if (v_vFilter like 'start_date%')
         then
            v_vValue := regexp_substr(v_vFilter, '[[:digit:]]+');
            v_vFilter := 'trunc(i.date_completed) >= to_date('''||v_vValue||''','''||v_vDateFormat_Filter||''')';
         
         elsif (v_vFilter like 'end_date%')
         then
            v_vValue := regexp_substr(v_vFilter, '[[:digit:]]+');
            v_vFilter := 'trunc(i.date_completed) <= to_date('''||v_vValue||''','''||v_vDateFormat_Filter||''')';

         elsif (v_vFilter like 'region%')
         then
            v_vValue := regexp_substr(v_vFilter, '[[:digit:]]+');
            v_nRegion := v_vValue;
            v_vFilter := 'i.region_id = '||v_vValue;
         
         elsif (v_vFilter like 'site%')
         then
            v_vValue := regexp_substr(v_vFilter, '[[:digit:]]+');
            v_nSite := v_vValue;
            v_vFilter := 'i.site_id = '||v_vValue;
         
         elsif (v_vFilter like 'outpatient%')
         then
            v_vValue := regexp_substr(v_vFilter, '[[:digit:]]+');
            v_bOutpatient := (v_vValue = '1');
            v_vFilter := null;
            
         elsif (v_vFilter like 'inpatient%')
         then
            v_vValue := regexp_substr(v_vFilter, '[[:digit:]]+');
            v_bInpatient := (v_vValue = '1');
            v_vFilter := null;

         elsif (v_vFilter like 'program%')
         then
            v_vValue := regexp_substr(v_vFilter, '[[:digit:]]+');
            v_nProgram := v_vValue;
            v_vFilter := null;
         else
            v_vFilter := null;
         end if;
         
         if (v_vFilter is not null)
         then
            v_vWhereClause := v_vWhereClause||'and '||v_vFilter||' ';
         end if;
      end loop;                
      
      if (v_bOutpatient and v_bInpatient) or
         (not v_bOutpatient and not v_bInpatient)
      then
        v_vClinicalStt := '1,2';
      elsif v_bOutpatient and not v_bInpatient
      then
        v_vClinicalStt := '1';
      elsif not v_bOutpatient and v_bInpatient
      then
        v_vClinicalStt := '2';
      end if;
      
      --Program filter
      v_vWhereClause := v_vWhereClause      
                        ||'and exists(select 1 from pat_treatment_program t '
                        ||'where t.patient_id = d.patient_id '
                        ||'  and t.treatment_id in(select treatment_id '
                                                ||'from pat_treatment t1 '
                                                ||'where t1.patient_id = d.patient_id '
                                                ||'  and t1.treatment_type_id in('||v_vClinicalStt||')'
                                                ||'  and t1.region_id='||v_nRegion
                                                ||'  and t1.site_id='||v_nSite||') '
                        ||'  and t.cpa_id = (select cpa_id '
                                          ||'from CPA t1 '
                                          ||'where t1.region_id='||v_nRegion
                                          ||'  and t1.site_id='||v_nSite
                                          ||'  and t1.cpa_type_id='||v_nProgram||'))';
 
      
      --if (v_bOutpatient and not v_bInpatient)
      --then
      --   v_vWhereClause := v_vWhereClause
      --                     ||'and exists (select * from pat_treatment s '
      --                     ||'where s.treatment_type_id = 1 and s.patient_id = i.patient_id) ';
    --  
      --elsif (not v_bOutpatient and v_bInpatient)
      --then
        -- v_vWhereClause := v_vWhereClause
          --                 ||'and exists (select * from pat_treatment s '
            --               ||'where s.treatment_type_id = 2 and s.patient_id = i.patient_id) ';
     -- end if;
      
      return v_vWhereClause;

   exception
      when others
      then
         return null;
   end;

   /*Get response value*/
   function responseValue (
      pi_vPatientID                     in varchar2,
      pi_nIntakeID                      in number,
      pi_nMID                           in number,
      pi_nTID                           in number,
      pi_nQID                           in number,
      pi_nRID                           in number
      ) return                             varchar2
   is
      v_exNoModule                         exception;
      v_nExists                            number;
      v_vSql                               varchar2(4000);
      v_nDisplayType                       number;
      v_vValue                             varchar2(4000);
   begin
   
      begin
        v_vSql := 'select 1 from data_intake_responses '
                  ||'where patient_id = :P and intake_id = :I and mid = :M and rownum = 1 ';  
        execute immediate v_vSql into v_nExists using pi_vPatientID, pi_nIntakeID, pi_nMID;
      exception
        when no_data_found
        then
           v_nExists := 0;
           raise v_exNoModule;
        when others
        then
           v_nExists := 0;
      end;
   
   
      v_vSql := 'select response_value from data_intake_responses '
                ||'where patient_id = :P and intake_id = :I and mid = :M and tid = :T and qid = :Q and rid = :R and rownum = 1 ';
      execute immediate v_vSql into v_vValue using pi_vPatientID, pi_nIntakeID, pi_nMID, pi_nTID, pi_nQID, pi_nRID;
   
      v_vSql := 'select display_type from intake_response where mid = :M and tid = :T and qid = :Q and rid = :R and rownum = 1';
      execute immediate v_vSql into v_nDisplayType using pi_nMID, pi_nTID, pi_nQID, pi_nRID;
      
      if (v_nDisplayType not in (3,4,22))
      then
         v_vValue := '1';
      end if;
      
      return v_vValue;
      
   exception
      when v_exNoModule
      then
         return ''; -- return blank if no module has been taken
      when no_data_found 
      then 
         return '0';
      when others
      then 
         return sqlerrm;
   end;
            
   /*generate CSV data*/
   procedure generateCsv (
      pi_nRequestID                     in number,
      pi_vKey                           in varchar2
      )
   is
      v_vSql                               varchar2(32767);
      rd                                   exp_statistical_rpt%rowtype;                                   
      v_vDataIncluded                      varchar2(4000);
      rc                                   sys_refcursor;
      v_nCurID                             number;
      v_nColumnCount                       number := 0;
      v_sDescTab                           dbms_sql.desc_tab;
      v_vColumnValue                       varchar2(4000);
      v_nColumnValue                       number;
      v_dColumnValue                       date;
      v_vDateFormat                        varchar2(30) := 'YYYY/MM/DD HH24:MI:SS';
      v_vDelimiter                         varchar2(5) := ',';
      v_lData                              clob;
      v_nColumnIndex_PatientID             number := 0;
      v_nColumnIndex_IntakeID              number := 0;
      v_vPatientID                         varchar2(60);
      v_nIntakeID                          number;
      v_nCurrentMID                        number;
      v_vBuffer                            varchar2(32767);
      v_nLastRownum                        number;
      v_nFilterByMID                       number := 0;
      
      v_vMsg                               varchar2(4000);
         
      procedure appendToClob (
         pio_lData                     in out clob,
         pio_vBuffer                   in out varchar2,
         pi_vText                          in varchar2
         )
      is
      begin
         if (length(pio_vBuffer)+length(pi_vText) >= 32767)
         then
            pio_lData := pio_lData||pio_vBuffer||pi_vText;
            pio_vBuffer := null;
         else
            pio_vBuffer := pio_vBuffer||pi_vText;
         end if;
      end;
   begin
      -- get parameters
      v_vSql := 'select * from exp_statistical_rpt where request_id = :P0';
      execute immediate v_vSql into rd using pi_nRequestID;
      v_vDataIncluded := ','||upper(rd.data_included)||',';

      v_vSql := 'select 1 from dual where exists(select mid from intake_module t where active=1 and instr('''||v_vDataIncluded||''',t.MID) > 0)';
      begin
        execute immediate v_vSql into v_nFilterByMID;
      exception
        when others then
          v_nFilterByMID :=0;
      end;
      
      -- construct sql
      if v_nFilterByMID = 1 then
        v_vSql := 'select i.PATIENT_ID as PAT_ID, i.INTAKE_ID '
                  ||getDemoVariables(v_vDataIncluded, pi_vKey)
                  ||'from patient_demographics d, pat_pw_event_module i, pat_pw_event e '
                  ||'where d.patient_id = i.patient_id '
                  ||'and e.pat_pw_event_id = i.pat_pw_event_id and e.status = 2 '
                  ||'and exists (select * from data_intake r where r.patient_id = i.patient_id and r.intake_id = i.intake_id and r.mid = i.mid) '
                  ||'and case when instr('''||v_vDataIncluded||''',i.MID) > 0 then 1 else 0 end = 1 '
                  ||getWhereclause (rd.filters);
                  
        if (c_nShowLatestIntakeOnly = 1) 
        then
           v_vSql := v_vSql||'and i.intake_id = (select max(s.intake_id) from pat_pw_event_module s where s.patient_id = i.patient_id '
                     ||replace(getWhereclause (rd.filters), ' i.', ' s.')||') ';
        end if;
      else
        v_vSql := 'select i.PATIENT_ID as PAT_ID, i.INTAKE_ID '
                  ||getDemoVariables(v_vDataIncluded, pi_vKey)
                  ||'from patient_demographics d, pat_pw_event_module i, pat_pw_event e '
                  ||'where d.patient_id = i.patient_id '
                  ||'and e.pat_pw_event_id = i.pat_pw_event_id and e.status = 2 '
                  ||'and exists (select * from data_intake r where r.patient_id = i.patient_id and r.intake_id = i.intake_id and r.mid = i.mid) '
                  ||'and i.intake_id = (select max(s.intake_id) from pat_pw_event_module s where s.patient_id = i.patient_id '
                  ||replace(getWhereclause (rd.filters), ' i.', ' s.')||') '
                  ||getWhereclause (rd.filters);
      end if;            
      
      v_vSql := v_vSql||'order by i.patient_id, i.intake_id ';
      
      -- switch from native dynamic SQL to dbms_sql package
      open rc for v_vSql;
      v_nCurID := dbms_sql.to_cursor_number (rc);
      dbms_sql.describe_columns (v_nCurID, v_nColumnCount, v_sDescTab);

      -- define columns and set header in csv
      for i in 1..v_nColumnCount
      loop
         -- set column index for patient_id and intake_id
         if (v_sDescTab(i).col_name = 'PAT_ID')
         then
            v_nColumnIndex_PatientID := i;
         elsif (v_sDescTab(i).col_name = 'INTAKE_ID')
         then
            v_nColumnIndex_IntakeID := i;
         end if;
         
         -- define columns 
         if (v_sDescTab(i).col_type = 2)
         then
            dbms_sql.define_column (v_nCurID, i, v_nColumnValue);
         elsif (v_sDescTab(i).col_type = 12)
         then
            dbms_sql.define_column (v_nCurID, i, v_dColumnValue);
         else
            dbms_sql.define_column (v_nCurID, i, v_vColumnValue, 4000);
         end if;
            
         -- set column name header
         if (v_sDescTab(i).col_name not in ('PAT_ID','INTAKE_ID'))
         then
            appendToClob (v_lData, v_vBuffer, '"'||v_sDescTab(i).col_name||'"'||v_vDelimiter);
         end if;
      end loop;

      -- get the last rownum to 
      v_vSql := 'select max(rn) from vw_utl_rpt_intake_response '
                || case when (c_nShowNotIncluded != 1) then 'where instr('''||v_vDataIncluded||''','',''||mid||'','') >= 1' end;
      execute immediate v_vSql into v_nLastRownum;
      
      -- add instrument data column names
      v_nCurrentMID := 0;
      for r in (select * from vw_utl_rpt_intake_response
                 where instr(v_vDataIncluded,','||mid||',') >= case when (c_nShowNotIncluded = 1) then 0 else 1 end)
      loop
         if (v_nCurrentMID != r.mid)
         then
            v_nCurrentMID := r.mid;
            appendToClob (v_lData, v_vBuffer, '"MID'||to_char(r.mid)||'_INSTRUMENT_NAME"'||v_vDelimiter);
         end if;
         
         v_vColumnValue := '"MID'||to_char(r.mid)||'T'||to_char(r.tid)||'Q'||to_char(r.qid)||'R'||to_char(r.rid)||'"';
         appendToClob (v_lData, v_vBuffer, v_vColumnValue||case when (r.rn != v_nLastRownum) then v_vDelimiter end);
      end loop;

      -- add column name header to the export clob
      appendToClob (v_lData, v_vBuffer, chr(13));

      --------------------------------------------------
      -- add data
      --------------------------------------------------
      -- Fetch rows with dbms_sql package.
      while (dbms_sql.fetch_rows (v_nCurID) > 0)
      loop
         -- demo column values and bind
         for i in 1 .. v_nColumnCount 
         loop
            -- set buffer with data
            if (i not in (v_nColumnIndex_PatientID, v_nColumnIndex_IntakeID)) 
            then
               if (v_sDescTab(i).col_type = 2)
               then
                  dbms_sql.column_value (v_nCurID, i, v_nColumnValue);
                  appendToClob (v_lData, v_vBuffer, v_nColumnValue||v_vDelimiter);
               elsif (v_sDescTab(i).col_type = 12)
               then
                  dbms_sql.column_value (v_nCurID, i, v_dColumnValue);
                  appendToClob (v_lData, v_vBuffer, '"'||to_char(v_dColumnValue, v_vDateFormat)||'"'||v_vDelimiter);
               else
                  dbms_sql.column_value (v_nCurID, i, v_vColumnValue);
                  appendToClob (v_lData, v_vBuffer, '"'||v_vColumnValue||'"'||v_vDelimiter);
               end if;
            end if;
         end loop;
         
         -- set patient_id and intake_id
         dbms_sql.column_value (v_nCurID, v_nColumnIndex_PatientID, v_vPatientID);
         dbms_sql.column_value (v_nCurID, v_nColumnIndex_IntakeID, v_nIntakeID);
         
         -- instrument data using patient_id and intake_id
         v_nCurrentMID := 0;
         for r in (select * from vw_utl_rpt_intake_response
                    where instr(v_vDataIncluded,','||mid||',') >= case when (c_nShowNotIncluded = 1) then 0 else 1 end)
         loop
            if (v_nCurrentMID != r.mid)
            then
               v_nCurrentMID := r.mid;
               appendToClob (v_lData, v_vBuffer, '"'||r.module_desc||'"'||v_vDelimiter);
            end if;
            
            -- get intake response value
            if (instr(v_vDataIncluded,','||r.mid||',') > 0)
            then
               v_vColumnValue := responseValue (v_vPatientID, v_nIntakeID, r.mid, r.tid, r.qid, r.rid);
            else
               v_vColumnValue := null;
            end if;

            v_vColumnValue := replace(v_vColumnValue, '"', '""');
            appendToClob (v_lData, v_vBuffer, '"'||v_vColumnValue||'"'||case when (r.rn != v_nLastRownum) then v_vDelimiter end);
         end loop;
         
         -- add row data to the export clob
         appendToClob (v_lData, v_vBuffer, chr(13));
      end loop;

      -- add remaining text
      v_lData := v_lData||v_vBuffer;

      -- add data
      v_vSql := 'update exp_statistical_rpt set status = 2, end_date = sysdate, file_data = :P0 where request_id = :P1 and status = 1';
      execute immediate v_vSql using v_lData, pi_nRequestID;
      commit;

      begin dbms_sql.close_cursor (v_nCurID); exception when others then null; end;
      begin close rc; exception when others then null; end;
      
   exception
      when others
      then
        v_vMsg := sqlerrm;
        
         -- log job failed (-1)
         v_vSql := 'update exp_statistical_rpt set status = -1, end_date = sysdate, status_comment = :P0 where request_id = :P1';
         execute immediate v_vSql using v_vMsg, pi_nRequestID;
         commit;
   end;

   /*Run export*/
   procedure runExport (
      pi_vSessionID                     in varchar2,
      pi_vSessionClientIP               in varchar2,
      pi_nUserID                        in number,
      pi_nRequestID                     in number,
      pi_vKey                           in varchar2,
      po_nStatusCode                   out number,
      po_vStatusComment                out varchar2
      )
   is
      v_nJobID                             number;
      v_vSql                               varchar2(4000);
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';
      
      v_vSql := 'Pck_Utl_Export_Data.generateCsv('||pi_nRequestID||','''||pi_vKey||''');';
      sys.dbms_job.submit(job => v_nJobID, what => v_vSql, next_date => sysdate);
      commit;
      
   exception
      when others 
      then
         po_nStatusCode := 1;
         po_vStatusComment := 'PCK_UTL_EXPORT_DATA.runExport(): '||sqlErrm;
   end;
   
   /*Cancel export*/
   procedure cancelExport (
      pi_vSessionID                     in varchar2,
      pi_vSessionClientIP               in varchar2,
      pi_nUserID                        in number,
      pi_nRequestID                     in number,
      po_nStatusCode                   out number,
      po_vStatusComment                out varchar2
      )
   is
      v_vSql                               varchar2(4000);
   begin
      po_nStatusCode    := 0; --0 = success
      po_vStatusComment := '';

      -- set status
      v_vSql := 'update exp_statistical_rpt set status = 3 where request_id = :P1 and status = 1';
      execute immediate v_vSql using pi_nRequestID;
      commit;
      
   exception
      when no_data_found 
      then
         po_nStatusCode := 1;
         po_vStatusComment := 'PCK_UTL_EXPORT_DATA.cancelExport(): '||'Export request does not exist!';
      when others 
      then
         po_nStatusCode := 1;
         po_vStatusComment := 'PCK_UTL_EXPORT_DATA.cancelExport(): '||sqlErrm;
   end;

end;
/
-------------------------------------
--  Changed package body pck_xfer  --
-------------------------------------
CREATE OR REPLACE PACKAGE BODY tbicds.PCK_XFER IS
/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

/*transfer a patient admission to the central database*/
procedure XferPatientVisit(
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_nXferSystemID          in number,
      pi_nRegionID              in number,
      pi_nSiteID                in number,
      pi_vDFN                   in varchar2,
      
      pi_vVisitID               in number,
      pi_nVisitLocationID       in number,
      pi_vVisitLocationName     in varchar2,
      pi_vVisitTimeStamp        in varchar2,
      pi_vVisitStatus           in varchar2,           
      pi_vVisitType             in varchar2,               
      
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2)
  is

    v_vSQLInsert constant varchar2(4000) :=
       'insert into
        patient_visit( REGION_ID,
                       SITE_ID,
                       DFN,
                          
                       VISIT_ID,
                       VISIT_LOCATION_ID,
                       VISIT_LOCATION_NAME,
                       VISIT_TIMESTAMP,
                       VISIT_STATUS,
                       VISIT_TYPE,
                       VISIT_DATETIME
                          )
          values(:REGION_ID,
                 :SITE_ID,
                 :DFN,
                 
                 :VISIT_ID,
                 :VISIT_LOCATION_ID,
                 :VISIT_LOCATION_NAME,
                 :VISIT_TIMESTAMP,
                 :VISIT_STATUS,
                 :VISIT_TYPE,
                 :VISIT_DATETIME)';

     --todo:
     v_vSQLUpdate constant varchar2(4000) := '';
     
     v_vSQLCount varchar2(4000) := '';
     v_nCount number := 0;

  begin

     v_nCount := 0;
     po_nStatusCode    := 0;
     po_vStatusComment := '';
     
     --check that a record exisits
     select count(*) into v_nCount 
     from patient_visit 
    WHERE region_id =  pi_nRegionID
     and site_id = pi_nSiteID
     and DFN = pi_vDFN
     and VISIT_LOCATION_ID = pi_nVisitLocationID
     and VISIT_TIMESTAMP = pi_vVisitTimeStamp;
          
     --insert if the record is not there
     if (v_nCount < 1) then

        --execute the sql with bind vars
        EXECUTE IMMEDIATE v_vSQLInsert
        USING pi_nRegionID,
              pi_nSiteID,
              pi_vDFN,
              
              pi_vVisitID,
              pi_nVisitLocationID,
              pi_vVisitLocationName,
              pi_vVisitTimeStamp,
              pi_vVisitStatus,           
              pi_vVisitType,
              to_date(pi_vVisitTimeStamp, 'yyyymmdd.hh24miss');   
                 
        commit;

      else

        --no update just insert
        commit;

      end if;

exception
    when others then
      po_nStatusCode    := PCK_COMMON.c_nStatus_Error;
      po_vStatusComment := '';

end;


/*transfer a patient admission to the central database*/
procedure XferPatientAdmission(
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_nXferSystemID          in number,
      pi_nRegionID              in number,
      pi_nSiteID                in number,
      pi_vDFN                   in varchar2,
      
      pi_nAdmitLocationID       in number,
      pi_vAdmitLocationName     in varchar2,
      pi_vAdmitType             in varchar2,
      pi_vAdmitTimeStamp        in varchar2,
      pi_vDischargeTimeStamp   in varchar2,                          
      
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2)
  is

    v_vSQLInsert constant varchar2(4000) :=
       'insert into
        patient_admission( REGION_ID,
                           SITE_ID,
                           DFN,
                          
                           ADMIT_LOCATION_ID,
                           ADMIT_LOCATION_NAME,
                           ADMIT_TYPE,
                           ADMIT_TIMESTAMP,
                           ADMIT_DISCHARGE_TIMESTAMP,
                           ADMIT_DATETIME
                          )
          values(:REGION_ID,
                 :SITE_ID,
                 :DFN,
                 
                 :ADMIT_LOCATION_ID,
                 :ADMIT_LOCATION_NAME,
                 :ADMIT_TYPE,
                 :ADMIT_TIMESTAMP,
                 :ADMIT_DISCHARGE_TIMESTAMP,
                 :ADMIT_DATETIME)';

     --todo:
     v_vSQLUpdate constant varchar2(4000) := '';
    

     v_vSQLCount varchar2(4000) := '';
     v_nCount number := 0;

  begin

     v_nCount := 0;
     po_nStatusCode    := 0;
     po_vStatusComment := '';
     
     --check that a record exisits
     select count(*) into v_nCount 
     from patient_admission 
     WHERE region_id = pi_nRegionID 
      and site_id = pi_nSiteID 
      and DFN = pi_vDFN 
      and ADMIT_LOCATION_ID = pi_nAdmitLocationID 
      and ADMIT_TIMESTAMP = pi_vAdmitTimeStamp; 
     
     --insert if the record is not there
     if (v_nCount < 1) then

        --execute the sql with bind vars
        EXECUTE IMMEDIATE v_vSQLInsert
        USING pi_nRegionID,
              pi_nSiteID,
              pi_vDFN,
              
              pi_nAdmitLocationID,
              pi_vAdmitLocationName,
              pi_vAdmitType,
              pi_vAdmitTimeStamp,
              pi_vDischargeTimeStamp,
              to_date(pi_vAdmitTimeStamp, 'yyyymmdd.hh24miss');  
                 
        commit;

      else

        --execute the sql with bind vars
        --todo:
        --EXECUTE IMMEDIATE v_vSQLUpdate
        --USING pi_vRegionName,
        --      pi_nXferSystemID,
        --      pi_nRegionID;
        commit;

      end if;

exception
    when others then
      po_nStatusCode    := PCK_COMMON.c_nStatus_Error;
      po_vStatusComment := '';

end;

/*transfers a patient consult to the central database*/
procedure XferPatientConsult(
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_nXferSystemID          in number,
      pi_nRegionID              in number,
      pi_nSiteID                in number,
      pi_vDFN                   in varchar2,
      
      pi_vConsultID             in varchar2,
      pi_vConsultTimeStamp      in varchar2,
      pi_vConsultStatus         in varchar2,
      pi_vConsultTitle          in varchar2,
      pi_vConsultText           in varchar2,                          
      
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2)
  is

    v_vSQLInsert constant varchar2(4000) :=
         'insert into
          patient_consult( REGION_ID,
                           SITE_ID,
                           DFN,
                          
                           CONSULT_ID,
                           CONSULT_TIMESTAMP,
                           CONSULT_STATUS,
                           CONSULT_TITLE,
                           CONSULT_TEXT,
                           CONSULT_DATETIME
                          )
          values(:REGION_ID,
                 :SITE_ID,
                 :DFN,
                 
                 :CONSULT_ID,
                 :CONSULT_TIMESTAMP,
                 :CONSULT_STATUS,
                 :CONSULT_TITLE,
                 :CONSULT_TEXT,
                 :CONSULT_DATETIME)';

     --todo:
     v_vSQLUpdate constant varchar2(4000) := '';
     
     v_vSQLCount varchar2(4000) := '';
     v_nCount number := 0;

  begin

     v_nCount := 0;
     po_nStatusCode    := 0;
     po_vStatusComment := '';
     
     --check that a record exisits
     select count(*) into v_nCount  
     from patient_consult 
     WHERE region_id = pi_nRegionID 
      and site_id = pi_nSiteID 
      and DFN = pi_vDFN 
      and consult_id = pi_vConsultID;
     
     --insert if the record is not there
     if (v_nCount < 1) then

        --execute the sql with bind vars
        EXECUTE IMMEDIATE v_vSQLInsert
        USING pi_nRegionID,
              pi_nSiteID,
              pi_vDFN,
              
              pi_vConsultID,
              pi_vConsultTimeStamp,
              pi_vConsultStatus,
              pi_vConsultTitle,
              pi_vConsultText,
              to_date(pi_vConsultTimeStamp, 'yyyymmdd.hh24miss');                 
        commit;

      else

        --execute the sql with bind vars
        --todo:
        --EXECUTE IMMEDIATE v_vSQLUpdate
        --USING pi_vRegionName,
        --      pi_nXferSystemID,
        --      pi_nRegionID;
        commit;

      end if;

exception
    when others then
      po_nStatusCode    := PCK_COMMON.c_nStatus_Error;
      po_vStatusComment := '';

end;

/*transfers a patient appointment to the database*/
procedure XferPatientAppointment(
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_nXferSystemID          in number,
      pi_nRegionID              in number,
      pi_nSiteID                in number,
      pi_vAppointmentID         in varchar2,
      pi_vDFN                   in varchar2,
      pi_nApptClinicID          in number,
      pi_nApptSiteID            in number,
      pi_vApptCurrentStatus     in varchar2,
      pi_vApptPurpose           in varchar2,
      pi_vApptStatus            in varchar2,
      pi_vApptText              in varchar2,
      pi_vApptTimeStamp         in varchar2,
      pi_vApptTitle             in varchar2,
      pi_vApptType              in varchar2,
      pi_vApptVisitID           in varchar2,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2)
  is

    v_vSQLInsert constant varchar2(4000) :=
         'insert into
          patient_appointment( REGION_ID,
                               SITE_ID,
                               APPT_ID,
                               DFN,
                               APPT_CLINIC_ID,
                               APPT_SITE_ID,
                               APPT_CURRENT_STATUS,
                               APPT_PURPOSE,
                               APPT_STATUS,
                               APPT_TEXT,
                               APPT_TIMESTAMP,
                               APPT_TITLE,
                               APPT_TYPE,
                               APPT_VISIT_ID,
                               APPT_DATETIME
                             )
          values(:REGION_ID,
                 :SITE_ID,
                 :APPT_ID,
                 :DFN,
                 :APPT_CLINIC_ID,
                 :APPT_SITE_ID,
                 :APPT_CURRENT_STATUS,
                 :APPT_PURPOSE,
                 :APPT_STATUS,
                 :APPT_TEXT,
                 :APPT_TIMESTAMP,
                 :APPT_TITLE,
                 :APPT_TYPE,
                 :APPT_VISIT_ID,
                 :APPT_DATETIME)';

     --todo:
     v_vSQLUpdate constant varchar2(4000) := '';
     
     v_vSQLCount varchar2(4000) := '';
     v_nCount number := 0;

  begin

     v_nCount := 0;
     po_nStatusCode    := 0;
     po_vStatusComment := '';
     
     --check that a record exisits
     select count(*) into v_nCount  
     from patient_appointment 
     WHERE region_id = pi_nRegionID 
      and site_id = pi_nSiteID 
      and DFN = pi_vDFN 
      and appt_id = pi_vAppointmentID;     
  
     --insert if the record is not there
     if (v_nCount < 1) then

        --execute the sql with bind vars
        EXECUTE IMMEDIATE v_vSQLInsert
        USING pi_nRegionID,
              pi_nSiteID,
              pi_vAppointmentID,
              pi_vDFN,
              pi_nApptClinicID,
              pi_nApptSiteID,
              pi_vApptCurrentStatus,
              pi_vApptPurpose,
              pi_vApptStatus,
              pi_vApptText,
              pi_vApptTimeStamp,
              pi_vApptTitle,
              pi_vApptType,
              pi_vApptVisitID,
              to_date(pi_vApptTimeStamp, 'yyyymmdd.hh24miss');
                 
        commit;

      else

        --execute the sql with bind vars
        --todo:
        --EXECUTE IMMEDIATE v_vSQLUpdate
        --USING pi_vRegionName,
        --      pi_nXferSystemID,
        --      pi_nRegionID;
        commit;

      end if;

exception
    when others then
      po_nStatusCode    := PCK_COMMON.c_nStatus_Error;
      po_vStatusComment := '';

end;

/*
transfers a clinic to the database
*/
procedure XferClinic(
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_nXferSystemID          in number,
      pi_nRegionID              in number,
      pi_nSiteID                in number,
      pi_nClinicID              in number,
      pi_vClinicLabel           in varchar2,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2)
  is

    v_vSQLInsert constant varchar2(4000) :=
         'insert into
          tbicds.utl_Clinic(Clinic_id,
                               Clinic_label,
                               xfer_system_id,
                               xfer_date,
                               region_id,
                               site_id
                          )
          values(:Clinic_ID,
                 :Clinic_LABEL,
                 :XFER_SYSTEM_ID,
                 sysdate,
                 :REGION_ID,
                 :SITE_ID)';

     v_vSQLUpdate constant varchar2(4000) :=
         'update tbicds.utl_Clinic
          set Clinic_label = :Clinic_LABEL,
              xfer_system_id = :XFER_SYSTEM_ID,
              xfer_date = sysdate
          where Clinic_id = :Clinic_ID
           and region_id = :REGION_ID
           and site_id = :SITE_ID';

     v_vSQLCount varchar2(4000) := '';
     v_nCount number := 0;

  begin

     --error messages
     v_nCount := 0;
     po_nStatusCode    := 0;
     po_vStatusComment := '';
     
     --check that a record exisits
     select count(*) into v_nCount 
     from tbicds.utl_Clinic 
     WHERE clinic_id = pi_nClinicID 
      and region_id = pi_nRegionID 
      and site_id = pi_nSiteID;

     --insert if the record is not there
     if (v_nCount < 1) then

        --execute the sql with bind vars
        EXECUTE IMMEDIATE v_vSQLInsert
        USING pi_nClinicID,
              pi_vClinicLabel,
              pi_nXferSystemID,
              pi_nRegionID,
              pi_nSiteID;
        commit;

      else

        --execute the sql with bind vars
        EXECUTE IMMEDIATE v_vSQLUpdate
        USING pi_vClinicLabel,
              pi_nXferSystemID,
              pi_nClinicID,
              pi_nRegionID,
              pi_nSiteID;

        commit;

      end if;

exception
    when others then
      po_nStatusCode    := PCK_COMMON.c_nStatus_Error;
      po_vStatusComment := 'Error transferring clinic';
      
end;

/*Transfers a note title from an external source such as MDWS to the database
*/
procedure XferNoteTitle(
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_nXferSystemID          in number,
      pi_nRegionID              in number,
      pi_nSiteID                in number,
      pi_nNoteTitleTag          in number,
      pi_vNoteTitleLabel        in varchar2,
      pi_nIsConsult             in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2)
  is

    v_vSQLInsert constant varchar2(4000) :=
         'insert into
          tbicds.utl_note_title(note_title_tag,
                               note_title_label,
                               xfer_system_id,
                               xfer_date,
                               region_id,
                               site_id,
                               is_consult
                          )
          values(:note_title_tag,
                 :NOTE_TITLE_LABEL,
                 :XFER_SYSTEM_ID,
                 sysdate,
                 :REGION_ID,
                 :SITE_ID,
                 :IS_CONSULT)';

     v_vSQLUpdate constant varchar2(4000) :=
         'update tbicds.utl_note_title
          set note_title_tag = :NOTE_TITLE_TAG,
              xfer_system_id = :XFER_SYSTEM_ID,
              xfer_date = sysdate,
              is_consult = :IS_CONSULT
          where note_title_label = :NOTE_TITLE_LABEL
          and  region_id = :REGION_ID
          and  site_id = :SITE_ID';

     v_vSQLCount varchar2(4000) := '';
     v_nCount number := 0;

  begin

     v_nCount := 0;
     po_nStatusCode    := 0;
     po_vStatusComment := '';
     
     --check that a record exisits
     select count(*) into v_nCount 
     from tbicds.utl_note_title
     WHERE note_title_label = pi_vNoteTitleLabel
      and site_id = pi_nSiteID
      and region_id = pi_nRegionID;
     
     --insert if the record is not there, otherwise update
     if (v_nCount < 1) then

        --execute the sql with bind vars
        EXECUTE IMMEDIATE v_vSQLInsert
        USING pi_nNoteTitleTag,
              pi_vNoteTitleLabel,
              pi_nXferSystemID,
              pi_nRegionID,
              pi_nSiteID,
              pi_nIsConsult;
        commit;

      else

        --execute the sql with bind vars
        EXECUTE IMMEDIATE v_vSQLUpdate
        USING pi_nNoteTitleTag,
              pi_nXferSystemID,
              pi_nIsConsult,
              pi_vNoteTitleLabel,
              pi_nRegionID,
              pi_nSiteID;
        commit;

      end if;

exception
    when others then
      po_nStatusCode    := PCK_COMMON.c_nStatus_Error;
      po_vStatusComment := 'Error transferring note title';
     
end;

/*
Transfers a region from an external source such as MDWS to the database
*/
procedure XferRegion(
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_nXferSystemID          in number,
      pi_nRegionID              in number,
      pi_vRegionName            in varchar2,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2)
  is

    v_vSQLInsert constant varchar2(4000) :=
         'insert into
          utl_region( region_id,
                             region_name,
                             xfer_system_id,
                             xfer_date
                          )
          values(:region_id,
                 :region_name,
                 :xfer_system_id,
                 sysdate)';

     v_vSQLUpdate constant varchar2(4000) :=
         'update utl_region
          set region_name = :region_name,
              xfer_system_id = :XFER_SYSTEM_ID,
              xfer_date = sysdate
          where region_id = :region_id';

     v_vSQLCount varchar2(4000) := '';
     v_nCount number := 0;

  begin

     v_nCount := 0;
     po_nStatusCode    := 0;
     po_vStatusComment := '';
     
     --check that a record exisits
     select count(*) into v_nCount 
     from utl_region  
     WHERE region_id = pi_nRegionID;
     
     --insert if the record is not there
     if (v_nCount < 1) then

        --execute the sql with bind vars
        EXECUTE IMMEDIATE v_vSQLInsert
        USING pi_nRegionID,
              pi_vRegionName,
              pi_nXferSystemID;
        commit;

      else

        --execute the sql with bind vars
        EXECUTE IMMEDIATE v_vSQLUpdate
        USING pi_vRegionName,
              pi_nXferSystemID,
              pi_nRegionID;
        commit;

      end if;

exception
    when others then
      po_nStatusCode    := PCK_COMMON.c_nStatus_Error;
      po_vStatusComment := '';

end;

/*
Transfers a site from an external source such as MDWS to the database
*/
procedure XferSite(
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_nXferSystemID          in number,
      pi_nRegionID              in number,
      pi_nSiteID                in number,
      pi_vSiteName            in varchar2,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2)
  is

    v_vSQLInsert constant varchar2(4000) :=
         'insert into
          utl_site( region_id,
                           site_id,
                           site_name,
                           xfer_system_id,
                           xfer_date
                          )
          values(:region_id,
                 :site_id,
                 :site_name,
                 :xfer_system_id,
                 sysdate)';

     v_vSQLUpdate constant varchar2(4000) :=
         'update utl_site
          set site_name = :site_name,
              xfer_system_id = :XFER_SYSTEM_ID,
              xfer_date = sysdate
          where region_id = :region_id
            and site_id = :site_id';

     v_vSQLCount varchar2(4000) := '';
     v_nCount number := 0;

  begin

     v_nCount := 0;
     po_nStatusCode    := 0;
     po_vStatusComment := '';
     
     --check that a record exisits
     select count(*) into v_nCount 
     from utl_site 
     WHERE region_id = pi_nRegionID 
      AND site_id = pi_nSiteID;

     --insert if the record is not there
     if (v_nCount < 1) then

        --execute the sql with bind vars
        EXECUTE IMMEDIATE v_vSQLInsert
        USING pi_nRegionID,
              pi_nSiteID,
              pi_vSiteName,
              pi_nXferSystemID;
        commit;

      else

        --execute the sql with bind vars
        EXECUTE IMMEDIATE v_vSQLUpdate
        USING pi_vSiteName,
              pi_nXferSystemID,
              pi_nRegionID,
              pi_nSiteID;
        commit;

      end if;

exception
    when others then
      po_nStatusCode    := PCK_COMMON.c_nStatus_Error;
      po_vStatusComment := '';
 
end;


/*
Transfers a user from an external source such as MDWS to the database
*/
procedure XferUser(
      pi_vSessionID           in varchar2,
      pi_vSessionClientIP     in varchar2,
      pi_nUserID              in number,
      pi_nXferSystemID        in number,
      pi_vDUZ                 in varchar2,
      pi_vLastName            in varchar2,
      pi_vFirstName           in varchar2,
      pi_vFirstLastName       in varchar2, 
      pi_vGreeting            in varchar2,
      pi_vTitle               in varchar2,
      pi_nRegionID            in number,
      pi_nSiteID              in number,
      pi_vUserClass           in varchar2,
      po_nUserID              out number,
      po_nStatusCode          out number,
      po_vStatusComment       out varchar2)
 is

    v_vSQLFXUserInsert constant varchar2(4000) :=
         'insert into
          fx_user( fx_user_id,
                   duz,
                   region_id,
                   site_id,
                   greeting,
                   xfer_system_id,
                   xfer_date)
          values(:fx_user_id,
                 :duz,
                 :region_id,
                 :site_id,
                 :greeting,
                 :xfer_system_id,
                 sysdate)';
      
      --insert statement for app_user table
      --todo: work out DMIS
      v_vSQLSuatUserInsert constant varchar2(4000) :=
         'insert into
          app_user( email,
                     uidpwd,
                     rank,
                     name,
                     title,
                     provider_id,
                     military_service_id,
                     corps,
                     unit,
                     squadron,
                     phone,
                     dims_id,
                     entry_date,
                     locked,
                     must_change_password,
                     fx_user_id,
                     supervisor_id,
                     graph_pref,
                     xfer_system_id,
                     xfer_date)
          values('''',
                 ''N/A'',
                 ''N/A'',
                 :name,
                 :title,
                 :provider_id,
                 0,
                 ''N/A'',
                 ''N/A'',
                 ''N/A'',
                 '''',
                 ''0000'', 
                 sysdate,
                 0,
                 0,
                 :fx_user_id,
                 ''N/A'',
                 0,
                 :xfer_system_id,
                 sysdate)';

     --fx_user update
     v_vSQLFXUserUpdate constant varchar2(4000) :=
         'update fx_user
          set duz = :duz,
              region_id = :region_id,
              site_id = :site_id,
              greeting = :greeting,
              xfer_system_id = :xfer_system_id,
              xfer_date =  sysdate
          where fx_user_id = :fx_user_id';

     --app_user update
     v_vSQLSuatUserUpdate constant varchar2(4000) :=
         'update app_user
          set name = :name,
              title = :title,
              xfer_system_id = :XFER_SYSTEM_ID,
              xfer_date = sysdate
          where fx_user_id = :fx_user_id';
          
     v_nCount number := 0;
     v_nFXUserID number := 0;
    
  begin

     po_nStatusCode    := 0;
     po_vStatusComment := '';
     
     --check that a record exisits
     select count(*) into v_nCount
     from fx_user t
     where t.region_id = pi_nRegionID
     and t.site_id = pi_nSiteID
     and t.duz = pi_vDUZ;
     
     --insert if the record is not there
     if (v_nCount < 1) then
        
        --get a new fx_user_id for this user
        select seqfxuserid.nextval into v_nFXUserID from dual;

        --execute fx_user insert sql with bind vars
        EXECUTE IMMEDIATE v_vSQLFXUserInsert
        USING v_nFXUserID,
              pi_vDUZ,
              pi_nRegionID,
              pi_nSiteID,
              pi_vGreeting,
              pi_nXferSystemID;
        
        --execute the app_user insert sql with bind vars
        EXECUTE IMMEDIATE v_vSQLSuatUserInsert
        USING pi_vFirstLastName,
              pi_vTitle,
              PCK_SYSTEM_ID.GetNewProviderID(pi_vFirstName,
                                             pi_vLastName),
              v_nFXUserID,
              pi_nXferSystemID;
                      
        --load user rights, todo: research this some may 
        --want to pass the rights in?
        insert into fx_user_rights(fx_user_id,
                                   user_rights,
                                   read_only,
                                   user_type)
        values( v_nFXUserID,             
                65204351,
                0,
                1);
        
        commit;
        --keep the user id
        po_nUserID := v_nFXUserID;

      else
        
        --get the fx_user_id for the update
        select fx_user_id into v_nFXUserID
        from fx_user t
        where t.region_id = pi_nRegionID
        and t.site_id = pi_nSiteID
        and t.duz = pi_vDUZ;

        --execute the fx_user sql with bind vars 
        EXECUTE IMMEDIATE v_vSQLFXUserUpdate
        USING pi_vDUZ,
              pi_nRegionID,
              pi_nSiteID,
              pi_vGreeting,
              pi_nXferSystemID,
              v_nFXUserID;
        
        --execute the app_user sql with bind vars        
        EXECUTE IMMEDIATE v_vSQLSuatUserUpdate
        USING pi_vFirstLastName,
              pi_vTitle,
              pi_nXferSystemID,
              v_nFXUserID;
        
        commit;
     
        --keep the user id
        po_nUserID := v_nFXUserID;
        
      end if;

exception
    when others then
      rollback;
      po_nStatusCode    := PCK_COMMON.c_nStatus_Error;
      po_vStatusComment := '';
 
end;


/*Transfers a patient from an external source such as MDWS to the database
*/
procedure XferPatient (   pi_vSessionID        in varchar2,
                          pi_vSessionClientIP  in varchar2,
                          pi_nUserID           in number,
                          pi_nXferSystemID     in number,
                          pi_vKey              in varchar2,
                          pi_nRegionID         in number,
                          pi_nSiteID           in number,
                          pi_vMDWSPatientID              in varchar2,
                          pi_vSSN              in varchar2,
                          pi_dtDOB             in date,
                          pi_vFirstName        in varchar2,
                          pi_vFullName         in varchar2,
                          pi_vLastName         in varchar2,
                          pi_vMI               in varchar2,
                          pi_nSex              in number,
                          pi_vHomeAddr1        in varchar2,
                          pi_vHomeAddr2        in varchar2,
                          pi_vHomeCity         in varchar2,
                          pi_vHomeState        in varchar2,
                          pi_vHomeZip          in varchar2,
                          pi_vHomePhone        in varchar2,
                          po_vPatientID        out varchar2,
                          po_nStatusCode       out number,
                          po_vStatusComment    out varchar2
                       )
is

   v_nRelationshipID number := 0;
   v_nCount number := 0;
   v_vSQLCount varchar2(2000) := '';
   v_vSex varchar2(20) := '';
   v_vProviderID varchar2(255) := '';
   
   --get the patient id and encounter id from an sp call
   v_vPatientID varchar2(500) := '';
   v_vEncounterID varchar2(500) := '';
   
begin
  
    po_vPatientID := '';
    po_nStatusCode    := 0;
    po_vStatusComment := '';
    v_nCount := 0;
    v_vSQLCount := '';
    v_vSex := 'U';
    v_vProviderID := '';
    v_nRelationshipID := 0;

    --get count
    SELECT count(*) into v_nCount 
      FROM patient_demographics 
     WHERE DFN = pi_vMDWSPatientID
       and region_id = pi_nRegionID
       and site_id = pi_nSiteID;

    --translate gender
    if(pi_nSex = 1) then
      v_vSex := 'M';
    end if;
    if(pi_nSex = 2) then
      v_vSex := 'F';
    end if;

    --default the provider to the person logged in
    select t.provider_id into v_vProviderID
    from app_user t
    where t.fx_user_id = pi_nuserid;

    if(v_nCount < 1) then
    
        --get a new patient id by calling the PCK_SYSTEM_ID package 
        v_vPatientID := PCK_SYSTEM_ID.GetNewPatientID(pi_vFirstName,
                                                      pi_vLastName,
                                                      to_char(pi_dtdob,'mm/dd/yyyy'),
                                                      v_vSex,
                                                      pi_vSSN);
                                                      
                                                      

        --insert new record into the patient demographics table
        insert into patient_demographics( patient_id,
                                          dfn,
                                          region_id,
                                          site_id,
                                          first_name,
                                          last_name,
                                          mi,
                                          ssn,
                                          gender,
                                          dob,
                                          provider_id)
        values
        (
           upper(v_vPatientID),
           pi_vMDWSPatientID,
           pi_nRegionID,
           pi_nSiteID,
           fnc_utl_encstr(upper(pi_vFirstName), pi_vKey, upper(v_vPatientID)),
           fnc_utl_encstr(upper(pi_vLastName), pi_vKey, upper(v_vPatientID)),
           fnc_utl_encstr(upper(pi_vMI), pi_vKey, upper(v_vPatientID)),
           fnc_utl_encstr(upper(pi_vSSN), pi_vKey, upper(v_vPatientID)),
           fnc_utl_encstr(v_vSex, pi_vKey, upper(v_vPatientID)),
           fnc_utl_encstr(to_char(pi_dtdob,'mm/dd/yyyy'), pi_vKey, upper(v_vPatientID)),
           v_vProviderID
        );
        commit;
        
        --pass the patient id back to the caller
        po_vPatientID := v_vPatientID;                        

        --Create Initial Patient Sponsor Record Needed By Assessments --Assessments can only to Updates
        /*insert into patient_sponsor
          (patient_id, relationship_id, last_updated, last_updated_by)
        values
          (v_vPatientID, v_nRelationshipID, sysdate, pi_nUserID);
        commit;*/

        --Create Initial Emergency Contact Record Needed By Assessments --Assessments can only to Updates
        insert into patient_emergency_contact
          (patient_id, relationship_id, last_updated, last_updated_by)
        values
          (v_vPatientID, v_nRelationshipID, sysdate, pi_nUserID);
        commit;

        --insert a new treatment record
 --       insert into treatment
 --         (treatment_id,
 --          patient_id,
 --          initial_visit_date,
 --          last_updated,
 --          last_updated_by)
 --       values
 --         (1, v_vPatientID, sysdate, sysdate, pi_nUserID);
 --       commit;

        --add all the events
        /*pck_patient_events.addallevents(pi_vSessionID,
                                        pi_vSessionClientIP,
                                        pi_nUserID,
                                        v_vPatientID,
                                        po_nStatusCode,
                                        po_vStatusComment);*/

        --insert patient step
        /*PCK_PATIENT_TX_STEP.InsertPatientStep(pi_vSessionID,
                                              pi_vSessionClientIP,
                                              pi_nUserID,
                                              v_vPatientID,
                                              0,
                                              po_nStatusCode,
                                              po_vStatusComment);*/

       --assign assessments
       /*PCK_INTAKE.AssignInitialAssessments(pi_vSessionID,
                                              pi_vSessionClientIP,
                                              pi_nUserID,
                                              v_vPatientID,
                                              po_nStatusCode,
                                              po_vStatusComment);*/
   else
                                              
       select t.patient_id into v_vPatientID 
       from patient_demographics t   
       where t.region_id = pi_nRegionID 
       and t.site_id = pi_nSiteID 
       and t.dfn = pi_vMDWSPatientID;
   
        --pass the patient id back to the caller
        po_vPatientID := v_vPatientID;    
        
        --todo: not updating the patients record at this time                                                                                
        null;

   end if;

exception
    when others then
      po_nStatusCode    := PCK_COMMON.c_nStatus_Error;
      po_vStatusComment := '';
end;
      
END;
/

create or replace package tbicds.PCK_INSTRUMENT_RESPONSES
AUTHID CURRENT_USER 
is

/* Copyright 2016 Intellica Corporation.  

This software is protected by FAR Subpart 27.4 - Rights in Data and Copyrights and 
international treaties.  The software was produced by Intellica Corporation of 
San Antonio, Texas for the Veterans Administration (VA) under Contract Number 
VA118-14-C-0015, Project Number TAC-16-28335 and Project Title, 
'Traumatic Brain Injury Clinical Decision Support (TBI CDS) Implementation'.  
Contract dates: 8 May 2014 - 4 January 2016.  This software was finalized 
and uploaded to the VA's Open Source Electronic Health Record Alliance (OSEHRA) 
on 31 December 2015.  Unauthorized reproduction or distribution of this software 
or any portion of it may result in severe civil and criminal penalties and will 
be prosecuted to the maximum possible extent of the law.

For licensing information contact:  info@intellicacorp.com 
*/

  function fnGetExportScoreValue(pi_vDataValue  in varchar2,
                                 pi_vStatFilter in varchar2) return varchar2;
                                    
  procedure InsertInstrumentResponse(pi_vSessionID       in varchar2,
                                     pi_vSessionClientIP in varchar2,
                                     pi_nUserID          in number,
                                     
                                     pi_vPatientID     in varchar2,
                                     pi_nIntakeID      in number,
                                     pi_nMID           in number,
                                     pi_nTID           in number,
                                     pi_nQID           in number,
                                     pi_nRID           in number,
                                     pi_nScoreValue    in number,
                                     pi_vResponseValue in varchar2,

                                     po_nStatusCode    out number,
                                     po_vStatusComment out varchar2);

  procedure GetInstrumentResponsesRS(pi_vSessionID       in varchar2,
                                     pi_vSessionClientIP in varchar2,
                                     pi_nUserID          in number,
                                     
                                     pi_vPatientID      in varchar2,
                                     --pi_nSiteID         in number,
                                     --pi_nClinicalProgID in number,
                                     --pi_nPathwayID      in number,
                                     pi_nMID            in number,
                                     pi_nIntakeID       in number,
                                     
                                     rs                out PCK_COMMON.refCursor,
                                     po_nStatusCode    out number,
                                     po_vStatusComment out varchar2);
                                     
 procedure GetMergedInstrumentResponsesRS(pi_vSessionID       in varchar2,
                                     pi_vSessionClientIP in varchar2,
                                     pi_nUserID          in number,
                                     
                                     pi_vPatientID      in varchar2,
                                     pi_nMID            in number,
                                     pi_nIntakeID       in number,
                                     
                                     rs                out PCK_COMMON.refCursor,
                                     po_nStatusCode    out number,
                                     po_vStatusComment out varchar2);

  PROCEDURE GetIntakeLogicVarRS(pi_vSessionID       in varchar2,
                                pi_vSessionClientIP in varchar2,
                                pi_nUserID          in number,
                                pi_vPatientID       in varchar2,
                                pi_vKey             in varchar2,
                                pi_nMID             in number,
                                rs                  out PCK_COMMON.refCursor,
                                po_nStatusCode      out number,
                                po_vStatusComment   out varchar2);

  procedure GetScoreLogicRS(pi_vSessionID       in varchar2,
                            pi_vSessionClientIP in varchar2,
                            pi_nUserID          in number,
                            pi_nMID             in number,
                            rs                  out PCK_COMMON.refCursor,
                            po_nStatusCode      out number,
                            po_vStatusComment   out varchar2);

  PROCEDURE GetPatientInstrumentsRS(pi_vSessionID       IN VARCHAR2,
                                    pi_vSessionClientIP IN VARCHAR2,
                                    pi_nUserID          IN NUMBER,
                                    pi_vPatientID       IN VARCHAR2,
                                    rs                  OUT PCK_COMMON.refCursor,
                                    po_nStatusCode      OUT NUMBER,
                                    po_vStatusComment   OUT VARCHAR2);

 procedure RemoveAllResponses(pi_vSessionID       in varchar2,
                              pi_vSessionClientIP in varchar2,
                              pi_nUserID          in number,
                              pi_vPatientID       in varchar2,
                              pi_nMID             in number,
                              pi_nIntakeID        in number,
                              po_nStatusCode      out number,
                              po_vStatusComment   out varchar2);
                                                                   
 procedure RemovePrevResponses(pi_vSessionID       in varchar2,
                               pi_vSessionClientIP in varchar2,
                               pi_nUserID          in number,
                               pi_vPatientID       in varchar2,
                               pi_nMID             in number,
                               pi_nIntakeID        in number,
                               pi_vResponses       in varchar2,
                               po_nStatusCode      out number,
                               po_vStatusComment   out varchar2); 
                               
 procedure RemoveResponse(pi_vSessionID       in varchar2,
                          pi_vSessionClientIP in varchar2,
                          pi_nUserID          in number,
                          pi_vPatientID       in varchar2,
                          pi_nMID             in number,
                          pi_nIntakeID        in number,
                          pi_nRID             in number,
                          po_nStatusCode      out number,
                          po_vStatusComment   out varchar2);
                         
  procedure InsertInstrumentScore(pi_vSessionID       in varchar2,
                                 pi_vSessionClientIP in varchar2,
                                 pi_nUserID          in number,
                                     
                                 pi_vPatientID       in varchar2,
                                 pi_nIntakeID        in number,
                                 pi_nMID             in number,
                                 pi_nSeriesID        in number,
                                 pi_nScore           in number,
                                 pi_vInterpret       in varchar2,
                                     
                                 po_nStatusCode      out number,
                                 po_vStatusComment   out varchar2);
                                 
 procedure InsertInstrumentScore(pi_vSessionID       in varchar2,
                                 pi_vSessionClientIP in varchar2,
                                 pi_nUserID          in number,
                                     
                                 pi_vPatientID       in varchar2,
                                 pi_nIntakeID        in number,
                                 pi_nMID             in number,
                                 pi_nSeriesID        in number,
                                 pi_nScore           in number,
                                 pi_vInterpret       in varchar2,
                                 pi_vDescription     in varchar2,
                                     
                                 po_nStatusCode      out number,
                                 po_vStatusComment   out varchar2);
                                 
 procedure InsertInstrumentScore(pi_vSessionID       in varchar2,
                                 pi_vSessionClientIP in varchar2,
                                 pi_nUserID          in number,
                                     
                                 pi_vPatientID       in varchar2,
                                 pi_nIntakeID        in number,
                                 pi_nMID             in number,
                                 pi_nSeriesID        in number,
                                 pi_nScore           in number,
                                 pi_vInterpret       in varchar2,
                                 pi_vDescription     in varchar2,
                                 pi_nSeverity        in number,
                                     
                                 po_nStatusCode      out number,
                                 po_vStatusComment   out varchar2);
                                 
   procedure DeleteInstrumentScore(pi_vSessionID       in varchar2,
                                   pi_vSessionClientIP  in varchar2,
                                   pi_nUserID           in number,
                                       
                                   pi_vPatientID        in varchar2,
                                   pi_nIntakeID         in number,
                                   pi_nMID              in number,
                                       
                                   po_nStatusCode       out number,
                                   po_vStatusComment    out varchar2);

  procedure GetInstrumentScoresRS(pi_vSessionID       in varchar2,
                                  pi_vSessionClientIP in varchar2,
                                  pi_nUserID          in number,
                                       
                                  pi_vPatientID       in varchar2,
                                  pi_nMID             in number,
                                  pi_nIntakeID        in number,
                                  pi_nFilter          in number,
                                       
                                  rs                  out PCK_COMMON.refCursor,
                                  po_nStatusCode      out number,
                                  po_vStatusComment   out varchar2);
                                  
  procedure GetInstrumentScoresRS(pi_vSessionID       in varchar2,
                                  pi_vSessionClientIP in varchar2,
                                  pi_nUserID          in number,
                                       
                                  pi_vPatientID      in varchar2,
                                  pi_nMID            in number,
                                  pi_nIntakeID       in number,
                                       
                                  rs                out PCK_COMMON.refCursor,
                                  po_nStatusCode    out number,
                                  po_vStatusComment out varchar2);
                                   
  procedure GetInstrumentScoresRS(pi_vSessionID       in varchar2,
                                  pi_vSessionClientIP in varchar2,
                                  pi_nUserID          in number,
                                       
                                  pi_vPatientID      in varchar2,
                                  pi_nMID            in number,
                                       
                                  rs                out PCK_COMMON.refCursor,
                                  po_nStatusCode    out number,
                                  po_vStatusComment out varchar2);
                                 
end PCK_INSTRUMENT_RESPONSES;
/

create or replace package tbicds.PCK_INTAKE AUTHID CURRENT_USER is

/* Copyright 2016 Intellica Corporation.  

This software is protected by FAR Subpart 27.4 - Rights in Data and Copyrights and 
international treaties.  The software was produced by Intellica Corporation of 
San Antonio, Texas for the Veterans Administration (VA) under Contract Number 
VA118-14-C-0015, Project Number TAC-16-28335 and Project Title, 
'Traumatic Brain Injury Clinical Decision Support (TBI CDS) Implementation'.  
Contract dates: 8 May 2014 - 4 January 2016.  This software was finalized 
and uploaded to the VA's Open Source Electronic Health Record Alliance (OSEHRA) 
on 31 December 2015.  Unauthorized reproduction or distribution of this software 
or any portion of it may result in severe civil and criminal penalties and will 
be prosecuted to the maximum possible extent of the law.

For licensing information contact:  info@intellicacorp.com 
*/

  --custom to return recordsets
  type RetRefCursor is ref cursor;


 /*****
  Delete Instrument 
  *****/
  procedure DeleteInstrument(pi_vSessionID       in varchar2,
                             pi_vSessionClientIP  in varchar2,
                             pi_nUserID           in number,
                                     
                             pi_vPatientID        in varchar2,
                             pi_nIntakeID         in number,
                             pi_nMID              in number,
                             pi_nPWEventModuleID  in number,
                                     
                             po_nStatusCode       out number,
                             po_vStatusComment    out varchar2);

/*get rs of modules that are scoreable*/

procedure GetAllScorableModuleRS(pi_vSessionID       in varchar2,
                            pi_vSessionClientIP in varchar2,
                            pi_nUserID          in number,
                            po_nStatusCode      out number,
                            po_vStatusComment   out varchar2,
                            rs                  out RetRefCursor);
                             
  
  /*get module type*/
  procedure GetModuleType(pi_vSessionID       in varchar2,
                          pi_vSessionClientIP in varchar2,
                          pi_nUserID          in number,
                          pi_nMID             in number,
                          po_nModuleType      out number,
                          po_nStatusCode      out number,
                          po_vStatusComment   out varchar2);
                        
  /*get intake modules by group id*/
  procedure GetModuleGroupMIDRS(pi_vSessionID       in varchar2,
                                pi_vSessionClientIP in varchar2,
                                pi_nUserID          in number,
                                pi_nModuleGroupID   in number,
                                po_nStatusCode      out number,
                                po_vStatusComment   out varchar2,
                                rs                  out RetRefCursor);

  /*get intake modules by group id and perform an inner search*/
  procedure GetModuleGroupMIDRS(pi_vSessionID       in varchar2,
                                pi_vSessionClientIP in varchar2,
                                pi_nUserID          in number,
                                pi_nModuleGroupID   in number,
                                pi_vSearch          in varchar2,
                                po_nStatusCode      out number,
                                po_vStatusComment   out varchar2,
                                rs                  out RetRefCursor);
                                
  /*get module groups by group type id*/
  procedure GetModuleGroupRS(pi_vSessionID       in varchar2,
                             pi_vSessionClientIP in varchar2,
                             pi_nUserID          in number,
                             pi_nGroupTypeID     in number,
                             po_nStatusCode      out number,
                             po_vStatusComment   out varchar2,
                             rs                  out RetRefCursor);

  /*get module group types such as domain and clinical setting*/
  procedure GetModuleGroupTypeRS(pi_vSessionID       in varchar2,
                                 pi_vSessionClientIP in varchar2,
                                 pi_nUserID          in number,
                                 po_nStatusCode      out number,
                                 po_vStatusComment   out varchar2,
                                 rs                  out RetRefCursor);

  procedure GetResponseLoadRS(pi_vSessionID       in varchar2,
                              pi_vSessionClientIP in varchar2,
                              pi_nUserID          in number,
                              pi_vLoadTable       in varchar2,
                              pi_vLoadField       in varchar2,
                              pi_vLoadFilter      in varchar2,
                              po_nStatusCode      out number,
                              po_vStatusComment   out varchar2,
                              rs                  out RetRefCursor);

  procedure GetIntakeModulesRS(pi_vSessionID       in varchar2,
                               pi_vSessionClientIP in varchar2,
                               pi_nUserID          in number,
                               po_nStatusCode      out number,
                               po_vStatusComment   out varchar2,
                               rs                  out RetRefCursor);

  procedure GetModuleGroupRS(pi_vSessionID       in varchar2,
                             pi_vSessionClientIP in varchar2,
                             pi_nUserID          in number,
                             po_nStatusCode      out number,
                             po_vStatusComment   out varchar2,
                             rs                  out RetRefCursor);

  procedure GetModulesListRS(pi_vSessionID       in varchar2,
                             pi_vSessionClientIP in varchar2,
                             pi_nUserID          in number,
                             po_nStatusCode      out number,
                             po_vStatusComment   out varchar2,
                             rs                  out RetRefCursor);

  procedure StartModule(pi_vSessionID       in varchar2,
                           pi_vSessionClientIP in varchar2,
                           pi_nUserID          in number,
                           
                           pi_vPatientID in varchar2,
                           pi_nMID       in number,
                           pi_nGroupID   in number,
                           pi_nIntakeID  in number,
                           
                           po_nStatusCode    out number,
                           po_vStatusComment out varchar2);
                           
  -- *****************************************************
  -- MARK MODULE COMPLETE
  procedure CompleteModule(pi_vSessionID       in varchar2,
                           pi_vSessionClientIP in varchar2,
                           pi_nUserID          in number,
                           
                           pi_vPatientID in varchar2,
                           pi_nMID       in number,
                           pi_nGroupID   in number,
                           pi_nIntakeID  in number,
                           
                           po_nStatusCode    out number,
                           po_vStatusComment out varchar2);

  -- *****************************************************
  -- INSERT ENCOUNTER INTAKE 
  

  -- *****************************************************
  -- Insert Encounter Intake Score


/*get rs of modules matching search criteria*/
procedure GetAllModuleRS(pi_vSessionID       in varchar2,
                            pi_vSessionClientIP in varchar2,
                            pi_nUserID          in number,
                            po_nStatusCode      out number,
                            po_vStatusComment   out varchar2,
                            rs                  out RetRefCursor);
  

/*get rs of modules matching search criteria*/
procedure GetModuleSearchRS(pi_vSessionID       in varchar2,
                            pi_vSessionClientIP in varchar2,
                            pi_nUserID          in number,
                            pi_vSearch          in varchar2,
                            po_nStatusCode      out number,
                            po_vStatusComment   out varchar2,
                            rs                  out RetRefCursor);

PROCEDURE GetScoreDataStringRS(pi_vSessionID       in varchar2,
                                 pi_vSessionClientIP in varchar2,
                                 pi_nUserID          in number,
                                 pi_vPatientID       in varchar2,
                                 po_nStatusCode      out number,
                                 po_vStatusComment   out varchar2,
                                 rs                  out RetRefCursor);
                                      
procedure GetNextMIDIntakeIDRS(pi_vSessionID       in varchar2,
                             pi_vSessionClientIP   in varchar2,
                             pi_nUserID            in number,
                             pi_vPatientID          in varchar2,
                             pi_nMID                in number,
                             po_nStatusCode      out number,
                             po_vStatusComment   out varchar2,
                             rs                  out RetRefCursor) ;

end;
/

create or replace package tbicds.PCK_QUESTIONNAIRES
AUTHID CURRENT_USER 
is

/* Copyright 2016 Intellica Corporation.  

This software is protected by FAR Subpart 27.4 - Rights in Data and Copyrights and 
international treaties.  The software was produced by Intellica Corporation of 
San Antonio, Texas for the Veterans Administration (VA) under Contract Number 
VA118-14-C-0015, Project Number TAC-16-28335 and Project Title, 
'Traumatic Brain Injury Clinical Decision Support (TBI CDS) Implementation'.  
Contract dates: 8 May 2014 - 4 January 2016.  This software was finalized 
and uploaded to the VA's Open Source Electronic Health Record Alliance (OSEHRA) 
on 31 December 2015.  Unauthorized reproduction or distribution of this software 
or any portion of it may result in severe civil and criminal penalties and will 
be prosecuted to the maximum possible extent of the law.

For licensing information contact:  info@intellicacorp.com 
*/

  type RetRefCursor is ref cursor;

  procedure GetModuleRS(pi_vSessionID       in varchar2,
                        pi_vSessionClientIP in varchar2,
                        pi_nUserID          in number,
                        pi_nMID             in number,
                        po_nStatusCode      out number,
                        po_vStatusComment   out varchar2,
                        rs                  out RetRefCursor);

  procedure GetModuleTopicRS(pi_vSessionID       in varchar2,
                             pi_vSessionClientIP in varchar2,
                             pi_nUserID          in number,
                             pi_nMID             in number,
                             po_nStatusCode      out number,
                             po_vStatusComment   out varchar2,
                             rs                  out RetRefCursor);

  procedure GetQuestionRS(pi_vSessionID       in varchar2,
                          pi_vSessionClientIP in varchar2,
                          pi_nUserID          in number,
                          pi_nMID             in number,
                          pi_nTID             in number,
                          po_nStatusCode      out number,
                          po_vStatusComment   out varchar2,
                          rs                  out RetRefCursor);

  procedure GetResponseRS(pi_vSessionID       in varchar2,
                          pi_vSessionClientIP in varchar2,
                          pi_nUserID          in number,
                          pi_nMID             in number,
                          pi_nTID             in number,
                          pi_nQID             in number,
                          po_nStatusCode      out number,
                          po_vStatusComment   out varchar2,
                          rs                  out RetRefCursor);

  procedure GetSkipPatternRS(pi_vSessionID       in varchar2,
                             pi_vSessionClientIP in varchar2,
                             pi_nUserID          in number,
                             pi_nMID             in number,
                             po_nStatusCode      out number,
                             po_vStatusComment   out varchar2,
                             rs                  out RetRefCursor);

  procedure GetMaskRS(pi_vSessionID       in varchar2,
                      pi_vSessionClientIP in varchar2,
                      pi_nUserID          in number,
                      pi_nMID             in number,
                      po_nStatusCode      out number,
                      po_vStatusComment   out varchar2,
                      rs                  out RetRefCursor);

  procedure GetStatData(pi_vSessionID       in varchar2,
                        pi_vSessionClientIP in varchar2,
                        pi_nUserID          in number,
                        pi_nMID             in number,
                        pi_nTID             in number,
                        pi_nQID             in number,
                        pi_nRID             in number,
                        po_nStatusCode      out number,
                        po_vStatusComment   out varchar2,
                        rs                  out RetRefCursor);
                        
  procedure GetNextModuleRS(pi_vSessionID       in varchar2,
                          pi_vSessionClientIP in varchar2,
                          pi_nUserID          in number,
                          pi_vPatientID       in varchar2,
                          pi_vSiteID          in varchar2,
                          po_nStatusCode      out number,
                          po_vStatusComment   out varchar2,
                          rs                  out RetRefCursor);
                          
  /* gets a new intake_id for the module */
  procedure GetNewIntakeID(pi_vSessionID       in varchar2,
                      pi_vSessionClientIP in varchar2,
                      pi_nUserID          in number,
                      po_nStatusCode      out number,
                      po_vStatusComment   out varchar2,
                      rs                  out RetRefCursor);

end PCK_QUESTIONNAIRES;
/

create or replace package body tbicds.PCK_INSTRUMENT_RESPONSES is

/* Copyright 2016 Intellica Corporation.  

This software is protected by FAR Subpart 27.4 - Rights in Data and Copyrights and 
international treaties.  The software was produced by Intellica Corporation of 
San Antonio, Texas for the Veterans Administration (VA) under Contract Number 
VA118-14-C-0015, Project Number TAC-16-28335 and Project Title, 
'Traumatic Brain Injury Clinical Decision Support (TBI CDS) Implementation'.  
Contract dates: 8 May 2014 - 4 January 2016.  This software was finalized 
and uploaded to the VA's Open Source Electronic Health Record Alliance (OSEHRA) 
on 31 December 2015.  Unauthorized reproduction or distribution of this software 
or any portion of it may result in severe civil and criminal penalties and will 
be prosecuted to the maximum possible extent of the law.

For licensing information contact:  info@intellicacorp.com 
*/

  /*get an export score value given the data and a filter*/
  function fnGetExportScoreValue(pi_vDataValue  in varchar2,
                                 pi_vStatFilter in varchar2) return varchar2
  is
    v_rs              PCK_COMMON.refCursor;
    v_vSQL            varchar2(32767) := '';
    po_vResponseValue varchar2(32767) := '';

  begin
  
    v_vSQL := v_vSQL || ' select t.score_value ';
    v_vSQL := v_vSQL || '   from INTAKE_STATIC_DATA t ';
    v_vSQL := v_vSQL || '  where t.active = 1 ';
    v_vSQL := v_vSQL || '    and t.data_value = ''' || pi_vDataValue || '''';
    v_vSQL := v_vSQL || '    and ';
    v_vSQL := v_vSQL || pi_vStatFilter;
  
    open v_rs for v_vSQL;
    loop
      fetch v_rs
        into  po_vResponseValue;

      exit when v_rs%notfound;
    end loop;
    close v_rs;
    
    
    return po_vResponseValue;
  
  exception
    when others then
      return '';
  end;
  
  /* Write instrument responses to the database. */
  procedure InsertInstrumentResponse(pi_vSessionID       in varchar2,
                                     pi_vSessionClientIP in varchar2,
                                     pi_nUserID          in number,
                                     
                                     pi_vPatientID     in varchar2,
                                     pi_nIntakeID      in number,
                                     pi_nMID           in number,
                                     pi_nTID           in number,
                                     pi_nQID           in number,
                                     pi_nRID           in number,
                                     pi_nScoreValue    in number,
                                     pi_vResponseValue in varchar2,
                                     
                                     po_nStatusCode    out number,
                                     po_vStatusComment out varchar2)
  
   is
    v_vSQL               varchar2(4000);
    v_nResponseType      number := null;
    v_dtResponseDateTime date := sysdate;
    v_vIdentifier        varchar2(24) := null;
  
  begin
    po_nStatusCode    := PCK_COMMON.c_nResultStatus_Success;
    po_vStatusComment := '';
    
    --get identifier for the response
    begin
      select identifier
        into v_vIdentifier
        from intake_response t
       where t.mid = pi_nMID
         and t.tid = pi_nTID
         and t.qid = pi_nQID
         and t.rid = pi_nRID;
    exception 
      when others then
      v_vIdentifier := null;     
    end;
  
    v_vSQL := v_vSQL || ' insert into DATA_INTAKE_RESPONSES ';
    v_vSQL := v_vSQL || '  (PATIENT_ID, ';
    v_vSQL := v_vSQL || '   INTAKE_ID, ';
    v_vSQL := v_vSQL || '   RID, ';
    v_vSQL := v_vSQL || '   MID, ';
    v_vSQL := v_vSQL || '   TID, ';
    v_vSQL := v_vSQL || '   QID, ';
    v_vSQL := v_vSQL || '   RESPONSE_TYPE, ';
    v_vSQL := v_vSQL || '   RESPONSE_VALUE, ';
    v_vSQL := v_vSQL || '   SCORE_VALUE, ';
    v_vSQL := v_vSQL || '   RESPONSE_DATETIME, ';
    v_vSQL := v_vSQL || '   IDENTIFIER) ';
    v_vSQL := v_vSQL || ' values ';
    v_vSQL := v_vSQL || '   (:V_PATIENT_ID, ';
    v_vSQL := v_vSQL || '   :V_INTAKE_ID, ';
    v_vSQL := v_vSQL || '   :V_RID, ';
    v_vSQL := v_vSQL || '   :V_MID, ';
    v_vSQL := v_vSQL || '   :V_TID, ';
    v_vSQL := v_vSQL || '   :V_QID, ';
    v_vSQL := v_vSQL || '   :V_RESPONSE_TYPE, ';
    v_vSQL := v_vSQL || '   :V_RESPONSE_VALUE, ';
    v_vSQL := v_vSQL || '   :V_SCORE_VALUE, ';
    v_vSQL := v_vSQL || '   :V_RESPONSE_DATETIME, ';
    v_vSQL := v_vSQL || '   :v_vIDENTIFIER) ';
  
    --get response type from intake_response table
    begin
      select t.response_type
        into v_nResponseType
        from intake_response t
       where t.mid = pi_nMID
         and t.tid = pi_nTID
         and t.qid = pi_nQID
         and t.rid = pi_nRID;
    exception
      when others then
        v_nResponseType := null;
    end;
  
    execute immediate v_vSQL
      using pi_vPatientID, 
            pi_nIntakeID, 
            pi_nRID, 
            pi_nMID, 
            pi_nTID, 
            pi_nQID, 
            v_nResponseType, 
            pi_vResponseValue, 
            pi_nScoreValue, 
            v_dtResponseDateTime,
            v_vIdentifier;

    --AUDIT TRAIL
    v_vSQL := replace(v_vSQL, 'DATA_INTAKE_RESPONSES', 'DATA_INTAKE_RESPONSES_AUDIT');
    execute immediate v_vSQL
      using pi_vPatientID, 
            pi_nIntakeID, 
            pi_nRID, 
            pi_nMID, 
            pi_nTID, 
            pi_nQID, 
            v_nResponseType, 
            pi_vResponseValue, 
            pi_nScoreValue, 
            v_dtResponseDateTime,
            v_vIdentifier;
              
    commit;
  
  exception
    when others then
      po_nStatusCode    := PCK_COMMON.c_nResultStatus_Error;
      po_vStatusComment := Sqlerrm;
  end;

  /* Get instruments responses by MID */
  procedure GetInstrumentResponsesRS(pi_vSessionID       in varchar2,
                                     pi_vSessionClientIP in varchar2,
                                     pi_nUserID          in number,
                                     
                                     pi_vPatientID      in varchar2,
                                     --pi_nSiteID         in number,
                                     --pi_nClinicalProgID in number,
                                     --pi_nPathwayID      in number,
                                     pi_nMID            in number,
                                     pi_nIntakeID       in number,
                                     
                                     rs                out PCK_COMMON.refCursor,
                                     po_nStatusCode    out number,
                                     po_vStatusComment out varchar2) 
   is
  
    v_vSQL          varchar2(4000);
    v_nLastIntakeID number := 0;
  
  begin
    po_nStatusCode    := 0;
    po_vStatusComment := '';
  
    --v_vSQL := v_vSQL || '		select 	dr.*, ';
    v_vSQL := v_vSQL || 'select dr.PATIENT_ID,dr.INTAKE_ID,dr.RID,dr.MID,dr.TID,dr.QID,';
    v_vSQL := v_vSQL || '       dr.RESPONSE_TYPE,dr.RESPONSE_VALUE,ir.LABEL_POS,';
    v_vSQL := v_vSQL || '       case';
    v_vSQL := v_vSQL || '         when ir.display_type not in(4,22) and dr.SCORE_VALUE=0 and ir.score_value is null then ''''';
    v_vSQL := v_vSQL || '         when ir.display_type in(4,22) and dr.SCORE_VALUE=0 and ir.score_value is null and ir.stat_load_filter is null then ''''';
    v_vSQL := v_vSQL || '         when ir.display_type in(4,22) and dr.SCORE_VALUE=0 and ir.score_value is null and ir.stat_load_filter is not null then';
    v_vSQL := v_vSQL || '           pck_instrument_responses.fnGetExportScoreValue(dr.RESPONSE_VALUE, ir.stat_load_filter)';
    v_vSQL := v_vSQL || '         else to_char(dr.score_value) ';
    v_vSQL := v_vSQL || '       end as SCORE_VALUE,';
    v_vSQL := v_vSQL || '       dr.RESPONSE_DATETIME,dr.RESPONSE_TIME,dr.INTAKE_GROUP_ID,dr.IDENTIFIER,';
    v_vSQL := v_vSQL || '				im.module, ';
    v_vSQL := v_vSQL || '				it.topic, ';
    v_vSQL := v_vSQL || '				iq.question, ';
    v_vSQL := v_vSQL || '				ir.response as static_response, ';
    v_vSQL := v_vSQL || '				ir.display_type, ';
    v_vSQL := v_vSQL || '				ir.unit, ';
    v_vSQL := v_vSQL || '				di.complete_date ';
    v_vSQL := v_vSQL || '		from 	data_intake_responses dr, ';
    v_vSQL := v_vSQL || '				data_intake di, ';
    v_vSQL := v_vSQL || '				intake_module im, ';
    v_vSQL := v_vSQL || '				intake_topic it, ';
    v_vSQL := v_vSQL || '				intake_question iq, ';
    v_vSQL := v_vSQL || '				intake_response ir ';
  
    v_vSQL := v_vSQL || '		where 	dr.patient_id = :PATIENT_ID ';
    v_vSQL := v_vSQL || '		and 	dr.mid = :MID ';
    v_vSQL := v_vSQL || '		and 	dr.intake_id = :INTAKE_ID ';
    
    --data_intake
    v_vSQL := v_vSQL || '		and di.patient_id = dr.patient_id';
    v_vSQL := v_vSQL || '		and di.intake_id = dr.intake_id';
    v_vSQL := v_vSQL || '		and di.mid = dr.mid';
  
    --intake_module
    v_vSQL := v_vSQL || '		and 	dr.mid = im.mid ';
  
    --intake_topic
    v_vSQL := v_vSQL || '		and 	dr.mid = it.mid ';
    v_vSQL := v_vSQL || '		and 	dr.tid = it.tid ';
  
    --intake_question
    v_vSQL := v_vSQL || '		and 	dr.mid = iq.mid ';
    v_vSQL := v_vSQL || '		and 	dr.tid = iq.tid ';
    v_vSQL := v_vSQL || '		and 	dr.qid = iq.qid ';
  
    --intake_response
    v_vSQL := v_vSQL || '		and 	dr.mid = ir.mid ';
    v_vSQL := v_vSQL || '		and 	dr.tid = ir.tid ';
    v_vSQL := v_vSQL || '		and 	dr.qid = ir.qid ';
    v_vSQL := v_vSQL || '		and 	dr.rid = ir.rid ';
  
    v_vSQL := v_vSQL || '		order by dr.mid, ';
    v_vSQL := v_vSQL || '				dr.tid, ';
    v_vSQL := v_vSQL || '				dr.qid, ';
    v_vSQL := v_vSQL || '				dr.rid ';
  
    -- get lats intake_id for the instrument
    begin
    
      select max(t.intake_id)
        into v_nLastIntakeID
        from data_intake_responses t
       where t.patient_id = pi_vPatientID
         and t.mid = pi_nMID;
    
    exception
      when others then
        v_nLastIntakeID := 0;
    end;
  
    --open the cursor
    open rs for v_vSQL
      using pi_vPatientID, pi_nMID, pi_nIntakeID;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
  end;
  
  /* Get merged instruments responses */
  procedure GetMergedInstrumentResponsesRS(pi_vSessionID       in varchar2,
                                     pi_vSessionClientIP in varchar2,
                                     pi_nUserID          in number,
                                     
                                     pi_vPatientID      in varchar2,
                                     pi_nMID            in number,
                                     pi_nIntakeID       in number,
                                     
                                     rs                out PCK_COMMON.refCursor,
                                     po_nStatusCode    out number,
                                     po_vStatusComment out varchar2) 
  is
  
  begin
    po_nStatusCode    := 0;
    po_vStatusComment := '';
  
    --open recordset
    open rs for
    select *
  from (select r.mid,
               r.tid,
               r.qid,
               r.rid,
               r.identifier,
               r.response_value,
               r.score_value,
               r.response_type,
               1 as is_selected
          from data_intake_responses r
         where r.patient_id = pi_vPatientID
           and r.mid = pi_nMID
           and r.intake_id = pi_nIntakeID
        
        union
        
        select ir.mid,
               ir.tid,
               ir.qid,
               ir.rid,
               ir.identifier,
               '' as response_value,
               to_number(ir.score_value),
               ir.response_type,
               0 as is_selected
          from intake_response ir
         where ir.mid = pi_nMID
           and ir.rid not in (select r.rid
                                from data_intake_responses r
                               where r.patient_id = pi_vPatientID
                                 and r.mid = pi_nMID
                                 and r.intake_id = pi_nIntakeID)
        
        ) a
 order by mid, tid, qid, rid;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
  end;

  /* Returns a recordset with the resolved intake logic variables*/
  PROCEDURE GetIntakeLogicVarRS(pi_vSessionID       in varchar2,
                                pi_vSessionClientIP in varchar2,
                                pi_nUserID          in number,
                                pi_vPatientID       in varchar2,
                                pi_vKey             in varchar2,
                                pi_nMID             in number,
                                rs                  out PCK_COMMON.refCursor,
                                po_nStatusCode      out number,
                                po_vStatusComment   out varchar2) 
   is
  
    v_vSQL     VARCHAR2(32767) := '';
    v_vQuery   VARCHAR2(4000);
    v_count    NUMBER := 0;
    v_varvalue VARCHAR2(24);
  
  BEGIN
  
    po_nStatusCode    := PCK_COMMON.c_nResultStatus_Success;
    po_vStatusComment := '';
  
    FOR rec IN (SELECT *
                  FROM INTAKE_LOGICVAR_SQL t
                 where t.var_id in (select var_id
                                      from intake_module_variables v
                                     where v.mid = pi_nMID)) LOOP
      IF v_count > 0 THEN
        v_vSQL := v_vSQL || ' union ';
      END IF;
      v_vQuery := REPLACE(rec.LOAD_SQL,
                          '_PATIENT_ID',
                          '''' || pi_vPatientID || '''');
      v_vQuery := REPLACE(v_vQuery, '_ENCRYPT_KEY', '''' || pi_vKey || '''');
      v_vQuery := REPLACE(v_vQuery, '_MID', pi_nMID);
      BEGIN
        EXECUTE immediate v_vQuery
          INTO v_varvalue;
      EXCEPTION
        WHEN OTHERS THEN
          v_varvalue := '';
      END;
      v_vSQL  := v_vSQL || 'select ''' || rec.VAR_ID || ''' as VAR_ID, ''' ||
                 rec.IDENTIFIER || ''' as IDENTIFIER, ''' || v_varvalue ||
                 ''' as VAR_VALUE from dual';
      v_count := v_count + 1;
    END LOOP;
    OPEN rs FOR v_vSQL;
  
  exception
    when others then
      po_nStatusCode    := PCK_COMMON.c_nResultStatus_Error;
      po_vStatusComment := '';
  end;

  /*Get the score logic for the module*/
  procedure GetScoreLogicRS(pi_vSessionID       in varchar2,
                            pi_vSessionClientIP in varchar2,
                            pi_nUserID          in number,
                            pi_nMID             in number,
                            rs                  out PCK_COMMON.refCursor,
                            po_nStatusCode      out number,
                            po_vStatusComment   out varchar2) 
  is
  
    v_vSQL varchar2(4000);
  
  begin
    po_nStatusCode    := PCK_COMMON.c_nResultStatus_Success;
    po_vStatusComment := '';
  
    v_vSQL := v_vSQL || '  select mid, score_logic ';
    v_vSQL := v_vSQL || '    from intake_module ';
    v_vSQL := v_vSQL || '   where active = 1 ';
    v_vSQL := v_vSQL || '     and mid = :MID ';
  
    --open the cursor
    open rs for v_vSQL
      using pi_nMID;
  
  exception
    when others then
      po_nStatusCode    := PCK_COMMON.c_nResultStatus_Error;
      po_vStatusComment := '';
  end;

  /*get instruments for a patient*/
  PROCEDURE GetPatientInstrumentsRS(pi_vSessionID       IN VARCHAR2,
                                    pi_vSessionClientIP IN VARCHAR2,
                                    pi_nUserID          IN NUMBER,
                                    pi_vPatientID       IN VARCHAR2,
                                    rs                  OUT PCK_COMMON.refCursor,
                                    po_nStatusCode      OUT NUMBER,
                                    po_vStatusComment   OUT VARCHAR2) 
  is
  
  BEGIN
    po_nStatusCode    := 0;
    po_vStatusComment := '';
    --open the cursor
    OPEN rs FOR
    
      SELECT 0 AS status_id,
             'Unknown' AS status,
             t.patient_id,
             t.intake_id,
             t.mid,
             m.module,
             t.complete_date AS date_completed,
             t.score,
             '' AS interpretation,
             DECODE(t.complete, 0, 'No', 1, 'Yes') AS completed
        FROM data_intake t, intake_module m
       WHERE t.mid = m.mid
         AND t.patient_id = pi_vPatientID;
  
  EXCEPTION
    WHEN OTHERS THEN
      po_nStatusCode    := 1;
      po_vStatusComment := '';
  END;
 
 /*****
 Remove ALL responses from previous time submitted 
 *****/
 procedure RemoveAllResponses(pi_vSessionID       in varchar2,
                              pi_vSessionClientIP in varchar2,
                              pi_nUserID          in number,
                              pi_vPatientID       in varchar2,
                              pi_nMID             in number,
                              pi_nIntakeID        in number,
                              po_nStatusCode      out number,
                              po_vStatusComment   out varchar2) 
 is
 
   v_vSQL varchar2(1000) := '';
 
 begin
   po_nStatusCode    := 0;
   po_vStatusComment := '';
   
   v_vSQL := v_vSQL || '  delete from data_intake_responses ';
   v_vSQL := v_vSQL || '    where patient_id = :pi_vPatientID ';
   v_vSQL := v_vSQL || '      and mid = :pi_nMID ';
   v_vSQL := v_vSQL || '      and intake_id = :pi_nIntakeID';
   
   execute immediate v_vSQL using pi_vPatientID, pi_nMID, pi_nIntakeID; 
   commit;
 
 exception
   when others then
     po_nStatusCode    := 1;
     po_vStatusComment := '';
 end;
 
 /*****
 Remove responses from previous time submitted
 not present in a new submittal of the instrument 
 *****/
 procedure RemovePrevResponses(pi_vSessionID       in varchar2,
                               pi_vSessionClientIP in varchar2,
                               pi_nUserID          in number,
                               pi_vPatientID       in varchar2,
                               pi_nMID             in number,
                               pi_nIntakeID        in number,
                               pi_vResponses       in varchar2,
                               po_nStatusCode      out number,
                               po_vStatusComment   out varchar2) 
 is
 
   v_vSQL varchar2(1000) := '';
 
 begin
   po_nStatusCode    := 0;
   po_vStatusComment := '';
   
   v_vSQL := v_vSQL || '  delete from data_intake_responses ';
   v_vSQL := v_vSQL || '    where patient_id = :pi_vPatientID ';
   v_vSQL := v_vSQL || '      and mid = :pi_nMID ';
   v_vSQL := v_vSQL || '      and intake_id = :pi_nIntakeID ';
   v_vSQL := v_vSQL || '      and rid not in (' || pi_vResponses || ') '; 
   
   execute immediate v_vSQL using pi_vPatientID, pi_nMID, pi_nIntakeID; 
   commit;
 
 exception
   when others then
     po_nStatusCode    := 1;
     po_vStatusComment := '';
 end;
 
 /*remove a response from an intake*/
 procedure RemoveResponse(pi_vSessionID       in varchar2,
                         pi_vSessionClientIP in varchar2,
                         pi_nUserID          in number,
                         pi_vPatientID       in varchar2,
                         pi_nMID             in number,
                         pi_nIntakeID        in number,
                         pi_nRID             in number,
                         po_nStatusCode      out number,
                         po_vStatusComment   out varchar2) 
 is
 
   v_vSQL varchar2(1000) := '';
 
 begin
   po_nStatusCode    := 0;
   po_vStatusComment := '';
   
   v_vSQL := v_vSQL || '  delete from data_intake_responses ';
   v_vSQL := v_vSQL || '    where patient_id =  :pi_vPatientID ';
   v_vSQL := v_vSQL || '      and mid = :pi_nMID ';
   v_vSQL := v_vSQL || '      and intake_id = :pi_nIntakeID ';
   v_vSQL := v_vSQL || '      and rid = :pi_nRID'; 
   
   execute immediate v_vSQL using pi_vPatientID, pi_nMID, pi_nIntakeID, pi_nRID; 
   commit;
 
 exception
   when others then
     po_nStatusCode    := 1;
     po_vStatusComment := '';
 end;
 
 /*****  
 Inserts Instruments Scores
 *****/
 procedure InsertInstrumentScore(pi_vSessionID       in varchar2,
                                 pi_vSessionClientIP in varchar2,
                                 pi_nUserID          in number,
                                     
                                 pi_vPatientID       in varchar2,
                                 pi_nIntakeID        in number,
                                 pi_nMID             in number,
                                 pi_nSeriesID        in number,
                                 pi_nScore           in number,
                                 pi_vInterpret       in varchar2,
                                     
                                 po_nStatusCode      out number,
                                 po_vStatusComment   out varchar2)
  
   is
    v_vSQL  varchar2(4000) := '';
  
  begin
    po_nStatusCode    := PCK_COMMON.c_nResultStatus_Success;
    po_vStatusComment := '';
  
    v_vSQL := v_vSQL || '    insert ';
    v_vSQL := v_vSQL || '       into data_intake_score s ';
    v_vSQL := v_vSQL || '         (patient_id, '; 
    v_vSQL := v_vSQL || '         mid, '; 
    v_vSQL := v_vSQL || '         intake_id, '; 
    v_vSQL := v_vSQL || '         series, '; 
    v_vSQL := v_vSQL || '         score, '; 
    v_vSQL := v_vSQL || '         interpretation) ';
    v_vSQL := v_vSQL || '       values ';
    v_vSQL := v_vSQL || '         (:PATIENT_ID, '; 
    v_vSQL := v_vSQL || '         :MID, '; 
    v_vSQL := v_vSQL || '         :INTAKE_ID, '; 
    v_vSQL := v_vSQL || '         :SERIES_ID, '; 
    v_vSQL := v_vSQL || '         :SCORE, '; 
    v_vSQL := v_vSQL || '         :INTERPRETATION) ';
  
    
  execute immediate v_vSQL
      using pi_vPatientID, 
      pi_nMID, 
      pi_nIntakeID, 
      pi_nSeriesID, 
      pi_nScore, 
      pi_vInterpret; 
      
  --AUDIT TRAIL
  v_vSQL := replace(v_vSQL, 'data_intake_score', 'data_intake_score_audit');
  execute immediate v_vSQL
      using pi_vPatientID, 
      pi_nMID, 
      pi_nIntakeID, 
      pi_nSeriesID, 
      pi_nScore, 
      pi_vInterpret;
  
    commit;
  
  exception
    when others then
      po_nStatusCode    := PCK_COMMON.c_nResultStatus_Error;
      po_vStatusComment := '';
  end;
  
  /*Insert instrument score*/
  procedure InsertInstrumentScore(pi_vSessionID       in varchar2,
                                 pi_vSessionClientIP in varchar2,
                                 pi_nUserID          in number,
                                     
                                 pi_vPatientID       in varchar2,
                                 pi_nIntakeID        in number,
                                 pi_nMID             in number,
                                 pi_nSeriesID        in number,
                                 pi_nScore           in number,
                                 pi_vInterpret       in varchar2,
                                 pi_vDescription     in varchar2,
                                     
                                 po_nStatusCode      out number,
                                 po_vStatusComment   out varchar2)
  
   is
    v_vSQL  varchar2(4000) := '';
  
  begin
    po_nStatusCode    := PCK_COMMON.c_nResultStatus_Success;
    po_vStatusComment := '';
  
    v_vSQL := v_vSQL || '    insert ';
    v_vSQL := v_vSQL || '       into data_intake_score s ';
    v_vSQL := v_vSQL || '         (patient_id, '; 
    v_vSQL := v_vSQL || '         mid, '; 
    v_vSQL := v_vSQL || '         intake_id, '; 
    v_vSQL := v_vSQL || '         series, '; 
    v_vSQL := v_vSQL || '         score, '; 
    v_vSQL := v_vSQL || '         interpretation, ';
    v_vSQL := v_vSQL || '         description) ';
    v_vSQL := v_vSQL || '       values ';
    v_vSQL := v_vSQL || '         (:PATIENT_ID, '; 
    v_vSQL := v_vSQL || '         :MID, '; 
    v_vSQL := v_vSQL || '         :INTAKE_ID, '; 
    v_vSQL := v_vSQL || '         :SERIES_ID, '; 
    v_vSQL := v_vSQL || '         :SCORE, '; 
    v_vSQL := v_vSQL || '         :INTERPRETATION, ';
    v_vSQL := v_vSQL || '         :DESCRIPTION) ';
  
    
  execute immediate v_vSQL
      using pi_vPatientID, 
      pi_nMID, 
      pi_nIntakeID, 
      pi_nSeriesID, 
      pi_nScore, 
      pi_vInterpret,
      pi_vDescription; 
  
  --AUDIT TRAIL
  v_vSQL := replace(v_vSQL, 'data_intake_score', 'data_intake_score_audit');
  execute immediate v_vSQL
      using pi_vPatientID, 
      pi_nMID, 
      pi_nIntakeID, 
      pi_nSeriesID, 
      pi_nScore, 
      pi_vInterpret,
      pi_vDescription;
  
    commit;
  
  exception
    when others then
      po_nStatusCode    := PCK_COMMON.c_nResultStatus_Error;
      po_vStatusComment := '';
  end;
  
  /*Insert instrument score*/
  procedure InsertInstrumentScore(pi_vSessionID       in varchar2,
                                 pi_vSessionClientIP in varchar2,
                                 pi_nUserID          in number,
                                     
                                 pi_vPatientID       in varchar2,
                                 pi_nIntakeID        in number,
                                 pi_nMID             in number,
                                 pi_nSeriesID        in number,
                                 pi_nScore           in number,
                                 pi_vInterpret       in varchar2,
                                 pi_vDescription     in varchar2,
                                 pi_nSeverity        in number,
                                     
                                 po_nStatusCode      out number,
                                 po_vStatusComment   out varchar2)
  
   is
    v_vSQL  varchar2(4000) := '';
  
  begin
    po_nStatusCode    := PCK_COMMON.c_nResultStatus_Success;
    po_vStatusComment := '';
  
    v_vSQL := v_vSQL || '    insert ';
    v_vSQL := v_vSQL || '       into data_intake_score s ';
    v_vSQL := v_vSQL || '         (patient_id, '; 
    v_vSQL := v_vSQL || '         mid, '; 
    v_vSQL := v_vSQL || '         intake_id, '; 
    v_vSQL := v_vSQL || '         series, '; 
    v_vSQL := v_vSQL || '         score, '; 
    v_vSQL := v_vSQL || '         interpretation, ';
    v_vSQL := v_vSQL || '         description, ';
    v_vSQL := v_vSQL || '         severity) ';
    v_vSQL := v_vSQL || '       values ';
    v_vSQL := v_vSQL || '         (:PATIENT_ID, '; 
    v_vSQL := v_vSQL || '         :MID, '; 
    v_vSQL := v_vSQL || '         :INTAKE_ID, '; 
    v_vSQL := v_vSQL || '         :SERIES_ID, '; 
    v_vSQL := v_vSQL || '         :SCORE, '; 
    v_vSQL := v_vSQL || '         :INTERPRETATION, ';
    v_vSQL := v_vSQL || '         :DESCRIPTION, ';
    v_vSQL := v_vSQL || '         :SEVERITY) ';
  
    
  execute immediate v_vSQL
      using pi_vPatientID, 
      pi_nMID, 
      pi_nIntakeID, 
      pi_nSeriesID, 
      pi_nScore, 
      pi_vInterpret,
      pi_vDescription,
      pi_nSeverity; 
  
  --AUDIT TRAIL
  v_vSQL := replace(v_vSQL, 'data_intake_score', 'data_intake_score_audit');
  execute immediate v_vSQL
      using pi_vPatientID, 
      pi_nMID, 
      pi_nIntakeID, 
      pi_nSeriesID, 
      pi_nScore, 
      pi_vInterpret,
      pi_vDescription,
      pi_nSeverity; 
  
    commit;
  
  exception
    when others then
      po_nStatusCode    := PCK_COMMON.c_nResultStatus_Error;
      po_vStatusComment := '';
  end;
  
  /*****
  Delete Instrument Scores
  *****/
  procedure DeleteInstrumentScore(pi_vSessionID       in varchar2,
                                 pi_vSessionClientIP  in varchar2,
                                 pi_nUserID           in number,
                                     
                                 pi_vPatientID        in varchar2,
                                 pi_nIntakeID         in number,
                                 pi_nMID              in number,
                                     
                                 po_nStatusCode       out number,
                                 po_vStatusComment    out varchar2)
  
   is
    v_vSQL  varchar2(4000) := '';
  
  begin
    po_nStatusCode    := PCK_COMMON.c_nResultStatus_Success;
    po_vStatusComment := '';
  
    v_vSQL := v_vSQL || ' delete ';
    v_vSQL := v_vSQL || '   from data_intake_score d ';
    v_vSQL := v_vSQL || '  where d.patient_id = :PATIENT_ID ';
    v_vSQL := v_vSQL || '    and d.mid = :MID ';
    v_vSQL := v_vSQL || '    and d.intake_id = :INTAKE_ID ';
  
    
  execute immediate v_vSQL
      using pi_vPatientID, 
      pi_nMID, 
      pi_nIntakeID; 
  
    commit;
  
  exception
    when others then
      po_nStatusCode    := PCK_COMMON.c_nResultStatus_Error;
      po_vStatusComment := '';
  end;

  /*****
  Gets recordset of instrument score and apply filter
  *****/
  procedure GetInstrumentScoresRS(pi_vSessionID       in varchar2,
                                  pi_vSessionClientIP in varchar2,
                                  pi_nUserID          in number,
                                       
                                  pi_vPatientID       in varchar2,
                                  pi_nMID             in number,
                                  pi_nIntakeID        in number,
                                  pi_nFilter          in number,
                                       
                                  rs                  out PCK_COMMON.refCursor,
                                  po_nStatusCode      out number,
                                  po_vStatusComment   out varchar2) 
 is
    v_vSQL          varchar2(4000);
  
  begin
    po_nStatusCode    := 0;
    po_vStatusComment := '';

 
    v_vSQL := v_vSQL || ' select * ';
    v_vSQL := v_vSQL || '   from (select t.*, ';
    v_vSQL := v_vSQL || '                im.module, ';
    v_vSQL := v_vSQL || '                m.date_completed ';
    v_vSQL := v_vSQL || '           from data_intake_score t, '; 
    v_vSQL := v_vSQL || '                pat_pw_event_module m, '; 
    v_vSQL := v_vSQL || '                intake_module im ';
    v_vSQL := v_vSQL || '          where t.patient_id = :PATIENT_ID ';
    v_vSQL := v_vSQL || '            and t.mid = :MID ';
    v_vSQL := v_vSQL || '            and t.patient_id = m.patient_id ';
    v_vSQL := v_vSQL || '            and t.mid = m.mid ';
    v_vSQL := v_vSQL || '            and t.intake_id = m.intake_id ';
    v_vSQL := v_vSQL || '            and t.mid = im.mid(+) ';
    
    --exclude FIM goal scores, they are not real scores!
    if pi_nMID = 4042 then
    
      v_vSQL := v_vSQL || ' and ((select rid ';
      v_vSQL := v_vSQL || '         from data_intake_responses ';
      v_vSQL := v_vSQL || '        where intake_id = t.intake_id ';
      v_vSQL := v_vSQL || '          and tid=1 ';
      v_vSQL := v_vSQL || '          and qid=1 ) != 21) ';
    
    end if;                
    
    --apply filter
    case
      when pi_nFilter = 0 then v_vSQL := v_vSQL || ' ';
      when pi_nFilter = 1 then v_vSQL := v_vSQL || ' and t.intake_id <= ' || pi_nIntakeID;
      when pi_nFilter = 2 then v_vSQL := v_vSQL || ' and t.intake_id = ' || pi_nIntakeID;
      when pi_nFilter = 3 then v_vSQL := v_vSQL || ' and m.status = 2 and t.intake_id <= ' || pi_nIntakeID;
    end case;
    
    v_vSQL := v_vSQL || '            ) a ';
    v_vSQL := v_vSQL || '  order by a.mid, a.series, date_completed, intake_id ';
    
    --open the cursor
    open rs for v_vSQL
      using pi_vPatientID, pi_nMID;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
  end;
  
  /*****
  Gets recordset of instrument score
  *****/
  procedure GetInstrumentScoresRS(pi_vSessionID       in varchar2,
                                 pi_vSessionClientIP in varchar2,
                                 pi_nUserID          in number,
                                     
                                 pi_vPatientID      in varchar2,
                                 pi_nMID            in number,
                                 pi_nIntakeID       in number,
                                     
                                 rs                out PCK_COMMON.refCursor,
                                 po_nStatusCode    out number,
                                 po_vStatusComment out varchar2) 
   is
  
    v_vSQL          varchar2(4000);
    v_nLastIntakeID number := 0;
  
  begin
    po_nStatusCode    := 0;
    po_vStatusComment := '';
  
    v_vSQL := v_vSQL || ' select t.* ';
    v_vSQL := v_vSQL || '   from DATA_INTAKE_SCORE t ';
    v_vSQL := v_vSQL || '    where t.patient_id = :PATIENT_ID ';
    v_vSQL := v_vSQL || '    and t.mid = :MID ';
    v_vSQL := v_vSQL || '    and t.intake_id = :INTAKE_ID ';
    v_vSQL := v_vSQL || '  order by t.series ';
  

    --open the cursor
    open rs for v_vSQL
      using pi_vPatientID, pi_nMID, pi_nIntakeID;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
  end;
  
/*****
 Gets recordset of all instrument score
*****/
  
  procedure GetInstrumentScoresRS(pi_vSessionID       in varchar2,
                                 pi_vSessionClientIP in varchar2,
                                 pi_nUserID          in number,
                                     
                                 pi_vPatientID      in varchar2,
                                 pi_nMID            in number,
                                     
                                 rs                out PCK_COMMON.refCursor,
                                 po_nStatusCode    out number,
                                 po_vStatusComment out varchar2) 
  is
  
    v_vSQL          varchar2(4000);
  
  begin
    po_nStatusCode    := 0;
    po_vStatusComment := '';

 
    v_vSQL := v_vSQL || ' select * ';
    v_vSQL := v_vSQL || '   from (select t.*, ';
    v_vSQL := v_vSQL || '                im.module, ';
    v_vSQL := v_vSQL || '                m.date_completed ';
    v_vSQL := v_vSQL || '           from data_intake_score t, '; 
    v_vSQL := v_vSQL || '                pat_pw_event_module m, '; 
    v_vSQL := v_vSQL || '                intake_module im ';
    v_vSQL := v_vSQL || '          where t.patient_id = :PATIENT_ID ';
    v_vSQL := v_vSQL || '            and t.mid = :MID ';
    v_vSQL := v_vSQL || '            and t.patient_id = m.patient_id ';
    v_vSQL := v_vSQL || '            and t.mid = m.mid ';
    v_vSQL := v_vSQL || '            and t.intake_id = m.intake_id ';
    v_vSQL := v_vSQL || '            and t.mid = im.mid(+)) a ';
    v_vSQL := v_vSQL || '  order by a.mid, a.series, date_completed, intake_id ';
      
    --open the cursor
    open rs for v_vSQL
      using pi_vPatientID, pi_nMID;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
  end;

end PCK_INSTRUMENT_RESPONSES;
/

create or replace package body tbicds.PCK_INTAKE is

/* Copyright 2016 Intellica Corporation.  

This software is protected by FAR Subpart 27.4 - Rights in Data and Copyrights and 
international treaties.  The software was produced by Intellica Corporation of 
San Antonio, Texas for the Veterans Administration (VA) under Contract Number 
VA118-14-C-0015, Project Number TAC-16-28335 and Project Title, 
'Traumatic Brain Injury Clinical Decision Support (TBI CDS) Implementation'.  
Contract dates: 8 May 2014 - 4 January 2016.  This software was finalized 
and uploaded to the VA's Open Source Electronic Health Record Alliance (OSEHRA) 
on 31 December 2015.  Unauthorized reproduction or distribution of this software 
or any portion of it may result in severe civil and criminal penalties and will 
be prosecuted to the maximum possible extent of the law.

For licensing information contact:  info@intellicacorp.com 
*/

  /*****
  Delete Instrument 
  *****/
  procedure DeleteInstrument(pi_vSessionID       in varchar2,
                             pi_vSessionClientIP  in varchar2,
                             pi_nUserID           in number,
                                     
                             pi_vPatientID        in varchar2,
                             pi_nIntakeID         in number,
                             pi_nMID              in number,
                             pi_nPWEventModuleID  in number,
                                     
                             po_nStatusCode       out number,
                             po_vStatusComment    out varchar2)
  
   is
    v_vSQL  varchar2(4000) := '';
  
  begin
    po_nStatusCode    := PCK_COMMON.c_nResultStatus_Success;
    po_vStatusComment := '';
  
    v_vSQL := v_vSQL || ' delete ';
    v_vSQL := v_vSQL || '   from data_intake d ';
    v_vSQL := v_vSQL || '  where d.patient_id = :PATIENT_ID ';
    v_vSQL := v_vSQL || '    and d.mid = :MID ';
    v_vSQL := v_vSQL || '    and d.intake_id = :INTAKE_ID ';
  
    --delete intake, cascade del will cleanup children
    execute immediate v_vSQL
    using pi_vPatientID, 
          pi_nMID, 
          pi_nIntakeID; 
    commit;
  
    --update the patient_pw_event to reset the tree leaf
    update pat_pw_event_module t 
    set  t.status = 0,
         t.date_started = null,
         t.date_completed = null,
         t.completed_by = null
    where t.patient_id = pi_vPatientID 
    and t.pw_event_module_id = pi_nPWEventModuleID;
    commit;
    
  exception
    when others then
      po_nStatusCode    := PCK_COMMON.c_nResultStatus_Error;
      po_vStatusComment := '';
  end;
  
/*get module type*/
procedure GetModuleType(pi_vSessionID       in varchar2,
                        pi_vSessionClientIP in varchar2,
                        pi_nUserID          in number,
                        pi_nMID             in number,
                        po_nModuleType      out number,
                        po_nStatusCode      out number,
                        po_vStatusComment   out varchar2) 
  is
  
  v_nModuleType number := -1;
  
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
    begin
      select m.module_type
        into v_nModuleType
      from tbicds.intake_module m
      where m.active=1
        and m.mid = pi_nMID;
    exception
      when others then
        v_nModuleType := -1;
    end;
                
    po_nModuleType := v_nModuleType;
    
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_INTAKE.GetModuleType(): ' || sqlErrm;
  end;
  
/*get rs of modules matching search criteria*/
procedure GetAllModuleRS(pi_vSessionID       in varchar2,
                            pi_vSessionClientIP in varchar2,
                            pi_nUserID          in number,
                            po_nStatusCode      out number,
                            po_vStatusComment   out varchar2,
                            rs                  out RetRefCursor) 
  is
  
  v_vSQL varchar2(4000) := '';
  
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
    v_vSQL := 'select s.mid, trim(s.acronym || '' '' || s.module) as module, s.description, s.module_alt_lang, s.module_for from tbicds.intake_module s '
                || 'where s.active=1 '
                || '  and s.module_type=0 '
                || 'order by s.module asc';
                    
    open rs for v_vSQL;
    
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_INTAKE.GetAllModuleRS(): ' || sqlErrm;
  end;


/*get rs of modules that are scoreable*/
procedure GetAllScorableModuleRS(pi_vSessionID       in varchar2,
                            pi_vSessionClientIP in varchar2,
                            pi_nUserID          in number,
                            po_nStatusCode      out number,
                            po_vStatusComment   out varchar2,
                            rs                  out RetRefCursor) 
  is
  
  v_vSQL varchar2(4000) := '';
  
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
    v_vSQL := 'select * from tbicds.intake_module s '
                || 'where s.active=1 '
                || '  and s.module_type=0 '
                || '  and s.mid in (select mid from intake_module_description where scorable =1) '
                || 'order by s.module asc';
    
    open rs for v_vSQL;
    
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_INTAKE.GetAllScorableModuleRS(): ' || sqlErrm;
  end;


/*get rs of modules matching search criteria*/
procedure GetModuleSearchRS(pi_vSessionID       in varchar2,
                            pi_vSessionClientIP in varchar2,
                            pi_nUserID          in number,
                            pi_vSearch          in varchar2,
                            po_nStatusCode      out number,
                            po_vStatusComment   out varchar2,
                            rs                  out RetRefCursor) 
  is
  
  v_vSQL varchar2(4000) := '';
  
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
    v_vSQL := 'select s.mid, trim(s.acronym || '' '' || s.module) as module, s.description, s.module_alt_lang, s.module_for from tbicds.intake_module s '
                || 'where s.active=1 and s.module_type=0 and UPPER(s.acronym) || '' '' || UPPER(s.module) like :P0 '
                || 'order by s.module asc';
    
    open rs for 
    v_vSQL using UPPER('%'||pi_vSearch||'%');
   
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_INTAKE.GetModuleSearchRS(): ' || sqlErrm;
  end;

  /*US:5966
  get intake modules by group id*/
  procedure GetModuleGroupMIDRS(pi_vSessionID       in varchar2,
                                pi_vSessionClientIP in varchar2,
                                pi_nUserID          in number,
                                pi_nModuleGroupID   in number,
                                po_nStatusCode      out number,
                                po_vStatusComment   out varchar2,
                                rs                  out RetRefCursor) 
  is
  
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
    --open recordset
    open rs for
      select t.mid, trim(t.acronym || ' ' || t.module) as module, t.description, t.module_alt_lang, t.module_for, 
             (select count(*) 
              from data_intake_score dis
              where dis.mid = t.mid) as score_count
        from intake_module t, intake_module_group_mid t2
       where t.mid = t2.mid
         and (
                   t2.module_group_id = pi_nModuleGroupID
                   or
                   pi_nModuleGroupID = -1
             )
         
       order by t2.sort_order;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_INTAKE.GetIntakeModulesRS(): ' || sqlErrm;
  end;
  
  /*US:5966
  get intake modules by group id and perform an inner search*/
  procedure GetModuleGroupMIDRS(pi_vSessionID       in varchar2,
                                pi_vSessionClientIP in varchar2,
                                pi_nUserID          in number,
                                pi_nModuleGroupID   in number,
                                pi_vSearch          in varchar2,
                                po_nStatusCode      out number,
                                po_vStatusComment   out varchar2,
                                rs                  out RetRefCursor) 
  is
  
  v_vSQL varchar2(4000) := '';
  
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
    v_vSQL := 'select t.mid, trim(t.acronym || '' '' || t.module) as module, t.description, t.module_alt_lang,' 
              || '(select count(*) from data_intake_score dis where dis.mid = t.mid) as score_count '
              || 'from intake_module t, intake_module_group_mid t2 ' 
              || 'where t.mid = t2.mid and t2.module_group_id = :P0 '
              || 'and t.active = 1 and t.module_type=0 and UPPER(t.acronym) || '' '' || UPPER(t.module) like :P1 '
              || 'order by t2.sort_order';
              
    --open recordset
    open rs for 
      v_vSQL 
    using pi_nModuleGroupID,
          UPPER('%'||pi_vSearch||'%');
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_INTAKE.GetIntakeModulesRS(): ' || sqlErrm;
  end;

  /*get module groups by group type id*/
  procedure GetModuleGroupRS(pi_vSessionID       in varchar2,
                             pi_vSessionClientIP in varchar2,
                             pi_nUserID          in number,
                             pi_nGroupTypeID     in number,
                             po_nStatusCode      out number,
                             po_vStatusComment   out varchar2,
                             rs                  out RetRefCursor) 
  is
  
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
    --open recordset
    if pi_nGroupTypeID != -1 then
    
      open rs for
      select *
        from intake_module_group t
       where t.module_group_type_id = pi_nGroupTypeID
       order by sort_order;
    
    else
    
       open rs for
       select -1 as MODULE_GROUP_ID,
             'All' as MODULE_GROUP_DESCR,
             1 as SORT_ORDER,
             'All' as DESCRIPTION,
             -1 as EVENT_ID,
             1 as ACTIVE,
             0 as STAT_MODALITY_ID,
             -1 as MODULE_GROUP_TYPE_ID
      from dual;
      
      end if;
              
      
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_INTAKE.GetIntakeModulesRS(): ' || sqlErrm;
  end;

  /*get module group types such as domain and clinical setting*/
  procedure GetModuleGroupTypeRS(pi_vSessionID       in varchar2,
                                 pi_vSessionClientIP in varchar2,
                                 pi_nUserID          in number,
                                 po_nStatusCode      out number,
                                 po_vStatusComment   out varchar2,
                                 rs                  out RetRefCursor)
  is
  
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
    --open recordset
    open rs for
    
      select i.*
        from tbicds.intake_module_group_type i
       where i.active = 1
       order by sort_order;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_INTAKE.GetIntakeModulesRS(): ' || sqlErrm;
  end;

  /*get resposne load recordset*/
  procedure GetResponseLoadRS(pi_vSessionID       in varchar2,
                              pi_vSessionClientIP in varchar2,
                              pi_nUserID          in number,
                              pi_vLoadTable       in varchar2,
                              pi_vLoadField       in varchar2,
                              pi_vLoadFilter      in varchar2,
                              po_nStatusCode      out number,
                              po_vStatusComment   out varchar2,
                              rs                  out RetRefCursor) 
  is
  
    strSQL long;
  
  begin
  
    strSQL            := '';
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
    strSQL := strSQL || 'SELECT ' || pi_vLoadField;
    strSQL := strSQL || ' FROM ' || case
                when (lower(pi_vLoadTable) not like 'tbicds.%') then
                 'tbicds.'
              end || pi_vLoadTable;
  
    if length(pi_vLoadFilter) > 2 then
      strSQL := strSQL || ' ' || pi_vLoadFilter;
    end if;
  
    --open recordset
    open rs for strSQL;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_INTAKE.GetResponseLoadRS(): ' || sqlErrm;
  end;

  /*get intake module recordset*/
  procedure GetIntakeModulesRS(pi_vSessionID       in varchar2,
                               pi_vSessionClientIP in varchar2,
                               pi_nUserID          in number,
                               po_nStatusCode      out number,
                               po_vStatusComment   out varchar2,
                               rs                  out RetRefCursor) 
  is
  
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
    --open recordset
    open rs for
    
      select i.*
        from tbicds.intake_module i
       where i.active = 1
      --and i.module_for = 1
        and i.module_type = 0
       order by sort_order;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_INTAKE.GetIntakeModulesRS(): ' || sqlErrm;
  end;

  /*Get module group recordset*/
  procedure GetModuleGroupRS(pi_vSessionID       in varchar2,
                             pi_vSessionClientIP in varchar2,
                             pi_nUserID          in number,
                             po_nStatusCode      out number,
                             po_vStatusComment   out varchar2,
                             rs                  out RetRefCursor) 
  is
  
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
    --open recordset
    open rs for
      select *
        from tbicds.intake_module_group t
       where t.active = 1
       order by t.module_group_id;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_INTAKE.GetModuleGroupRS(): ' || sqlErrm;
  end;

  /*Get module list recordset*/
  procedure GetModulesListRS(pi_vSessionID       in varchar2,
                             pi_vSessionClientIP in varchar2,
                             pi_nUserID          in number,
                             po_nStatusCode      out number,
                             po_vStatusComment   out varchar2,
                             rs                  out RetRefCursor) 
  is
  
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
    --open recordset
    open rs for
      select m.module_group_id,
             m.mid,
             m.sort_order,
             m2.module,
             m2.description
        from (select imgm.*, img.module_group_descr
                from tbicds.intake_module_group_mid imgm,
                     tbicds.intake_module_group     img,
                     tbicds.intake_module           im
               where img.module_group_id = imgm.module_group_id
                 and im.mid = imgm.mid
                 and im.active = 1
                 and im.module_type = 0) m
        left join (select * from tbicds.intake_module im where im.active = 1 and im.module_type = 0) m2
          on m2.mid = m.mid
       order by m.module_group_id, m.sort_order;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_INTAKE.GetModulesListRS(): ' || sqlErrm;
  end;

  /*start the module*/
  procedure StartModule(pi_vSessionID       in varchar2,
                           pi_vSessionClientIP in varchar2,
                           pi_nUserID          in number,
                           
                           pi_vPatientID in varchar2,
                           pi_nMID       in number,
                           pi_nGroupID   in number,
                           pi_nIntakeID  in number,
                           
                           po_nStatusCode    out number,
                           po_vStatusComment out varchar2) 
  is
  
  v_dtSysDate date := null;
  v_nExists   number := 0;
  
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
    
    v_dtSysDate := sysdate;   
    
    begin
      select 1 
        into v_nExists
      from data_intake
      where patient_id = pi_vPatientID
        and intake_id = pi_nIntakeID
        and mid = pi_nMID;
    exception
      when others then
      v_nExists := 0;
    end;
    
    if v_nExists = 0 then
       --insert...    
       insert into data_intake
       (patient_id,
       intake_id,
       mid,
       start_date)
       values
       (pi_vPatientID,
       pi_nIntakeID,
       pi_nMID,
       v_dtSysDate);
       commit;
    else
      --update...
      update data_intake set
       start_date = v_dtSysDate
      where patient_id = pi_vPatientID
        and intake_id = pi_nIntakeID
        and mid = pi_nMID;
      commit;
    end if;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_INTAKE.StartModule(): ' || sqlErrm;
  end;
  
  /*Mark module complete*/
  procedure CompleteModule(pi_vSessionID       in varchar2,
                           pi_vSessionClientIP in varchar2,
                           pi_nUserID          in number,
                           
                           pi_vPatientID in varchar2,
                           pi_nMID       in number,
                           pi_nGroupID   in number,
                           pi_nIntakeID  in number,
                           
                           po_nStatusCode    out number,
                           po_vStatusComment out varchar2) 
  is
  
  v_dtSysDate date := null;
  
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
    
    v_dtSysDate := sysdate;   
      
    --update...
       update data_intake set
         complete = 1,
         complete_date = v_dtSysDate
       where patient_id = pi_vPatientID
         and intake_id = pi_nIntakeID
         and mid = pi_nMID;
       
    --AUDIT TRAIL
    update data_intake_responses_audit set complete_date = v_dtSysDate
    where patient_id = pi_vPatientID
      and mid = pi_nMID
      and intake_id = pi_nIntakeID
      and complete_date is null;
      
    update data_intake_score_audit set complete_date = v_dtSysDate
    where patient_id = pi_vPatientID
      and mid = pi_nMID
      and intake_id = pi_nIntakeID
      and complete_date is null;
       
    commit;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_INTAKE.CompleteModule(): ' || sqlErrm;
  end;


  /*Get score data as a string*/
  PROCEDURE GetScoreDataStringRS(pi_vSessionID       in varchar2,
                                 pi_vSessionClientIP in varchar2,
                                 pi_nUserID          in number,
                                 pi_vPatientID       in varchar2,
                                 po_nStatusCode      out number,
                                 po_vStatusComment   out varchar2,
                                 rs                  out RetRefCursor)
  
   is
  
    v_vPatientID  VARCHAR2(50) := pi_vPatientID;
    v_nEncTypeID  NUMBER := 99;
    v_nMaxSeries  NUMBER := 1;
    v_nCurrSeries NUMBER := 1;
    v_nCurrMID    NUMBER := 0;
    v_dtRespDate  DATE := null;
    v_vLabel      VARCHAR2(32767) := NULL;
    v_vDATA       VARCHAR2(32767) := '';
    curEnc        RetRefCursor;
   -- CURSOR curMID IS
   --   SELECT DISTINCT mid
   --     FROM tbicds.encounter_intake_score s
   --    WHERE s.encounter_id IN
   --          (SELECT encounter_id
   --             FROM tbicds.encounter e
   --            WHERE e.patient_id = v_vPatientID
   --              AND e.encounter_type_id = v_nEncTypeID)
   --    ORDER BY mid;
  BEGIN
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
    -- open the string
    v_vDATA := v_vDATA || '[';
  /*  FOR recMID IN curMID LOOP
      BEGIN
        SELECT MAX(series)
          INTO v_nMaxSeries
          FROM tbicds.encounter_intake_score
         WHERE mid = recMID.mid
           AND encounter_id IN
               (SELECT encounter_id
                  FROM tbicds.encounter e
                 WHERE e.patient_id = v_vPatientID
                   AND e.encounter_type_id = v_nEncTypeID);
      EXCEPTION
        WHEN OTHERS THEN
          v_nMaxSeries := 1;
      END;
      -- write segment: {"mid": ####, "mid_data": [
      v_vDATA := v_vDATA || '{"mid": ' || TO_CHAR(recMID.mid) ||
                 ', "mid_data": [';
      FOR n IN 1 .. v_nMaxSeries LOOP
        v_nCurrSeries := n;
        v_vDATA       := v_vDATA || '{"data": [';
        FOR recEnc IN (SELECT t1.*, t2.encounter_date
                         FROM tbicds.encounter_intake_score t1,
                              tbicds.encounter              t2
                        WHERE t2.encounter_id = t1.encounter_id
                          AND mid = recMID.mid
                          AND series = n
                          AND t2.encounter_id IN
                              (SELECT DISTINCT encounter_id
                                 FROM tbicds.encounter
                                WHERE encounter_type_id = v_nEncTypeID
                                  AND patient_id = v_vPatientID)
                        ORDER BY t2.encounter_date, t1.encounter_intake_id) LOOP
          --get the date of the assessment not the encounter
          begin
            select max(r.response_datetime)
              into v_dtRespDate
              from tbicds.encounter_intake_responses r
             where r.encounter_id = recEnc.Encounter_Id
               and r.mid = recEnc.mid
               and r.encounter_intake_id = recEnc.Encounter_Intake_Id;
          exception
            when others then
              v_dtRespDate := recEnc.Encounter_Date;
          end;
        
          --write the POINT data
          v_vDATA := v_vDATA || '["' || TO_CHAR(v_dtRespDate, 'mm/dd/yyyy') ||
                     '", "' || TO_CHAR(recEnc.score) || '"],';
          IF (recMID.mid IN (3016, 3020)) THEN
            IF recEnc.interpret IS NOT NULL THEN
              v_vLabel := recEnc.interpret;
            END IF;
          END IF;
        END LOOP;
        v_vDATA := SUBSTR(v_vDATA, 1, LENGTH(v_vDATA) - 1);
        v_vDATA := v_vDATA || ']';
        IF (v_vLabel IS NOT NULL OR LENGTH(v_vLabel) > 0) THEN
          v_vDATA  := v_vDATA || ', "label": "' || v_vLabel || '" ';
          v_vLabel := null;
        END IF;
        v_vDATA := v_vDATA || '},';
      END LOOP;
      -- close the string here
      v_vDATA := SUBSTR(v_vDATA, 1, LENGTH(v_vDATA) - 1);
      v_vDATA := v_vDATA || ']},';
    END LOOP;
    -- ******************************
    -- END OF LOOPS
    if LENGTH(v_vDATA) > 1 then
      v_vDATA := SUBSTR(v_vDATA, 1, LENGTH(v_vDATA) - 1);
    end if;
    v_vDATA := v_vDATA || ']';
    --dbms_output.put_line(v_vDATA);
  
    OPEN rs FOR
      SELECT v_vDATA AS mid_data FROM dual;*/
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_INTAKE.GetScoreDataStringRS(): ' || sqlErrm;
  END;
  
  /*****
  Gets next module intake_id
  *****/
  procedure GetNextMIDIntakeIDRS(pi_vSessionID       in varchar2,
                             pi_vSessionClientIP   in varchar2,
                             pi_nUserID            in number,
                             pi_vPatientID          in varchar2,
                             pi_nMID                in number,
                             po_nStatusCode      out number,
                             po_vStatusComment   out varchar2,
                             rs                  out RetRefCursor) 
  is
  v_nIntakeID number;
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
    
    -- v_nIntakeID := fngetlastintakeid(pi_vPatientID, pi_nMID) + 1;
    select seqintakeid.nextval into v_nIntakeID from dual;  
  
    --open recordset
    open rs for
      select v_nIntakeID as intake_id
        from dual;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
  end;

end;
/

create or replace package body tbicds.PCK_QUESTIONNAIRES is

/* Copyright 2016 Intellica Corporation.  

This software is protected by FAR Subpart 27.4 - Rights in Data and Copyrights and 
international treaties.  The software was produced by Intellica Corporation of 
San Antonio, Texas for the Veterans Administration (VA) under Contract Number 
VA118-14-C-0015, Project Number TAC-16-28335 and Project Title, 
'Traumatic Brain Injury Clinical Decision Support (TBI CDS) Implementation'.  
Contract dates: 8 May 2014 - 4 January 2016.  This software was finalized 
and uploaded to the VA's Open Source Electronic Health Record Alliance (OSEHRA) 
on 31 December 2015.  Unauthorized reproduction or distribution of this software 
or any portion of it may result in severe civil and criminal penalties and will 
be prosecuted to the maximum possible extent of the law.

For licensing information contact:  info@intellicacorp.com 
*/

  /*Gets and returns a recordset from INTAKE_MODULE for the passed in module id.*/
  procedure GetModuleRS(pi_vSessionID       in varchar2,
                        pi_vSessionClientIP in varchar2,
                        pi_nUserID          in number,
                        pi_nMID             in number,
                        po_nStatusCode      out number,
                        po_vStatusComment   out varchar2,
                        rs                  out RetRefCursor) 
 is
  
    v_vSQL varchar2(32767) := '';
  
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
    v_vSQL := v_vSQL || ' select * ';
    v_vSQL := v_vSQL || '   from intake_module t ';
    v_vSQL := v_vSQL || '  where t.active = 1 ';
    v_vSQL := v_vSQL || '    and t.mid = :MID ';
  
    open rs for v_vSQL
      using pi_nMID;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
  end;

  /*Gets and returns a recordset from INTAKE_TOPIC for the passed in module id.*/
  procedure GetModuleTopicRS(pi_vSessionID       in varchar2,
                             pi_vSessionClientIP in varchar2,
                             pi_nUserID          in number,
                             pi_nMID             in number,
                             po_nStatusCode      out number,
                             po_vStatusComment   out varchar2,
                             rs                  out RetRefCursor) 
 is
  
    v_vSQL varchar2(32767) := '';
  
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
    v_vSQL := v_vSQL || ' select * ';
    v_vSQL := v_vSQL || '   from intake_topic t ';
    v_vSQL := v_vSQL || '  where t.active = 1 ';
    v_vSQL := v_vSQL || '    and t.mid = :MID ';
    v_vSQL := v_vSQL || '  order by t.tid';
  
    open rs for v_vSQL
      using pi_nMID;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
  end;

  /*Gets and returns a recordset of questions from INTAKE_QUESTION
  for the passed in module id, topic id.*/
  procedure GetQuestionRS(pi_vSessionID       in varchar2,
                          pi_vSessionClientIP in varchar2,
                          pi_nUserID          in number,
                          pi_nMID             in number,
                          pi_nTID             in number,
                          po_nStatusCode      out number,
                          po_vStatusComment   out varchar2,
                          rs                  out RetRefCursor) 
 is
  
    v_vSQL varchar2(32767) := '';
  
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
    v_vSQL := v_vSQL || ' select * ';
    v_vSQL := v_vSQL || '   from intake_question t ';
    v_vSQL := v_vSQL || '  where t.active = 1 ';
    v_vSQL := v_vSQL || '    and t.mid = :MID ';
    v_vSQL := v_vSQL || '    and t.tid = :TID ';
    v_vSQL := v_vSQL || '  order by t.mid, t.tid, t.qid ';
  
    open rs for v_vSQL
      using pi_nMID, pi_nTID;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
  end;

  /*Gets and returns a recordset of responses from INTAKE_RESPONSE
  for the passed in module id, topic id, question id.*/
  procedure GetResponseRS(pi_vSessionID       in varchar2,
                          pi_vSessionClientIP in varchar2,
                          pi_nUserID          in number,
                          pi_nMID             in number,
                          pi_nTID             in number,
                          pi_nQID             in number,
                          po_nStatusCode      out number,
                          po_vStatusComment   out varchar2,
                          rs                  out RetRefCursor) 
 is
  
    v_vSQL varchar2(32767) := '';
  
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
    v_vSQL := v_vSQL || ' select t.*, ';
    v_vSQL := v_vSQL || '        REGEXP_REPLACE(t.response, ''<.*?>'') as response_plain, ';
    v_vSQL := v_vSQL || '        REGEXP_REPLACE(REGEXP_REPLACE(t.response, ''<.*?>''), '','', ''**"**'') as response_checkbox ';
    v_vSQL := v_vSQL || '   from intake_response t ';
    v_vSQL := v_vSQL || '  where t.active = 1 ';
    v_vSQL := v_vSQL || '    and t.mid = :MID ';
    v_vSQL := v_vSQL || '    and t.tid = :TID ';
    v_vSQL := v_vSQL || '    and t.qid = :QID ';
    v_vSQL := v_vSQL || '  order by t.mid, t.tid, t.qid, t.rid ';
  
    open rs for v_vSQL
      using pi_nMID, pi_nTID, pi_nQID;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
  end;

  /*Gets and returns a recordset of responses that have skip rules
  for the passed in module id.*/
  procedure GetSkipPatternRS(pi_vSessionID       in varchar2,
                             pi_vSessionClientIP in varchar2,
                             pi_nUserID          in number,
                             pi_nMID             in number,
                             po_nStatusCode      out number,
                             po_vStatusComment   out varchar2,
                             rs                  out RetRefCursor) 
  is
  
    v_vSQL varchar2(32767) := '';
  
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
    v_vSQL := v_vSQL || ' select t.* ';
    v_vSQL := v_vSQL || '   from INTAKE_RESPONSE t ';
    v_vSQL := v_vSQL || '  where t.mid = :MID ';
    v_vSQL := v_vSQL || '    and t.active = 1 ';
    v_vSQL := v_vSQL ||
              '    and (t.skip_show is not null or t.skip_hide is not null) ';
    v_vSQL := v_vSQL || '  order by t.rid ';
  
    open rs for v_vSQL
      using pi_nMID;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
  end;

  /*Gets and returns a recordset of responses (textboxes) that have masks
  for the passed in module id.*/
  procedure GetMaskRS(pi_vSessionID       in varchar2,
                      pi_vSessionClientIP in varchar2,
                      pi_nUserID          in number,
                      pi_nMID             in number,
                      po_nStatusCode      out number,
                      po_vStatusComment   out varchar2,
                      rs                  out RetRefCursor) 
 is
  
    v_vSQL varchar2(32767) := '';
  
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
    v_vSQL := v_vSQL || ' select t.* ';
    v_vSQL := v_vSQL || '   from INTAKE_RESPONSE t ';
    v_vSQL := v_vSQL || '  where t.mid = :MID ';
    v_vSQL := v_vSQL || '    and t.active = 1 ';
    v_vSQL := v_vSQL || '    and t.mask is not null ';
    v_vSQL := v_vSQL || '  order by t.rid ';
  
    open rs for v_vSQL
      using pi_nMID;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
  end;

  /*Gets and returns a recordset from intake_static_data table to populate 
  responses of type combo*/
  procedure GetStatData(pi_vSessionID       in varchar2,
                        pi_vSessionClientIP in varchar2,
                        pi_nUserID          in number,
                        pi_nMID             in number,
                        pi_nTID             in number,
                        pi_nQID             in number,
                        pi_nRID             in number,
                        po_nStatusCode      out number,
                        po_vStatusComment   out varchar2,
                        rs                  out RetRefCursor) 
 is
  
    v_vSQL        varchar2(32767) := '';
    v_vSQL_FILTER varchar2(32767) := '';
  
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
    begin
      select t.stat_load_filter
        into v_vSQL_FILTER
        from intake_response t
       where t.mid = pi_nMID
         and t.tid = pi_nTID
         and t.qid = pi_nQID
         and t.rid = pi_nRID;
    exception
      when others then
        v_vSQL_FILTER := '';
    end;
  
    v_vSQL := v_vSQL || ' select t.* ';
    v_vSQL := v_vSQL || '   from INTAKE_STATIC_DATA t ';
    v_vSQL := v_vSQL || '  where t.active = 1 ';
    v_vSQL := v_vSQL || '    and ';
    v_vSQL := v_vSQL || v_vSQL_FILTER;
  
    open rs for v_vSQL;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
  end;

  /*Get the next undone assigned module for the patient. */
  procedure GetNextModuleRS(pi_vSessionID       in varchar2,
                          pi_vSessionClientIP in varchar2,
                          pi_nUserID          in number,
                          pi_vPatientID       in varchar2,
                          pi_vSiteID          in varchar2,
                          po_nStatusCode      out number,
                          po_vStatusComment   out varchar2,
                          rs                  out RetRefCursor) 
  is
  
    v_vSQL varchar2(32767) := '';
  
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
    v_vSQL := v_vSQL || ' select * from (';
    v_vSQL := v_vSQL || ' select t.*, m.sort_order ';
    v_vSQL := v_vSQL || '   from patient_module t, intake_module_group_mid m ';
    v_vSQL := v_vSQL || '  where t.patient_id = :PATIENT_ID ';
    v_vSQL := v_vSQL || '    and t.status = 0 ';
    v_vSQL := v_vSQL || '    and t.mid = m.mid ';
    v_vSQL := v_vSQL || '    and t.module_group_id = m.module_group_id ';
    v_vSQL := v_vSQL || '  order by m.sort_order ';
    v_vSQL := v_vSQL || ' ) ';
    v_vSQL := v_vSQL || ' where ROWNUM < 2 ';
  
    open rs for v_vSQL
      using pi_vPatientID;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
  end;
  
  /* gets a new intake_id for the module */
  procedure GetNewIntakeID(pi_vSessionID       in varchar2,
                      pi_vSessionClientIP in varchar2,
                      pi_nUserID          in number,
                      po_nStatusCode      out number,
                      po_vStatusComment   out varchar2,
                      rs                  out RetRefCursor) 
 is
 
   v_seqintakeid number;
 
 begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
    select seqintakeid.nextval into v_seqintakeid from dual;
  
    open rs for 
      select v_seqintakeid as intake_id from dual;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
  end;

end PCK_QUESTIONNAIRES;
/



commit;
/

exec dbms_utility.compile_schema('TBICDS');
/

set feedback on
set define on

